/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.z;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.parser.util.ParseException;
import net.sourceforge.czt.parser.z.ParseUtils;
import net.sourceforge.czt.session.FileSource;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.session.SectionManager;
import net.sourceforge.czt.session.Source;
import net.sourceforge.czt.typecheck.z.TypeChecker;
import net.sourceforge.czt.z.ast.ZFactory;
import net.sourceforge.czt.z.impl.ZFactoryImpl;

public class TypeCheckUtils {
    protected TypeCheckUtils() {
    }

    public static List typecheck(Term term, SectionInfo sectInfo, Markup markup) {
        return TypeCheckUtils.typecheck(term, sectInfo, markup, false);
    }

    public static List typecheck(Term term, SectionInfo sectInfo, Markup markup, boolean useBeforeDecl) {
        TypeCheckUtils utils = new TypeCheckUtils();
        return utils.lTypecheck(term, sectInfo, markup, useBeforeDecl);
    }

    protected List lTypecheck(Term term, SectionInfo sectInfo, Markup markup) {
        return this.lTypecheck(term, sectInfo, markup, false);
    }

    protected List lTypecheck(Term term, SectionInfo sectInfo, Markup markup, boolean useBeforeDecl) {
        ZFactoryImpl zFactory = new ZFactoryImpl();
        TypeChecker typeChecker = new TypeChecker((ZFactory)zFactory, sectInfo, markup, useBeforeDecl);
        typeChecker.visitTerm(term);
        return typeChecker.errors();
    }

    protected Term parse(Source src, SectionInfo sectInfo) throws IOException, ParseException {
        return ParseUtils.parse((Source)src, (SectionInfo)sectInfo);
    }

    protected Term parse(String file, SectionInfo sectInfo) throws IOException, ParseException {
        return ParseUtils.parse((String)file, (SectionInfo)sectInfo);
    }

    protected String name() {
        return "zedtypecheck";
    }

    protected void printUsage() {
        System.err.println("usage: " + this.name() + " [-sdt] filename ...");
        System.err.println("flags: -s     syntax check only");
        System.err.println("       -d     allow use before declaration");
        System.err.println("       -t     print global type declarations");
        System.exit(0);
    }

    protected void run(String[] args) throws IOException {
        if (args.length == 0) {
            this.printUsage();
        }
        ArrayList<String> files = new ArrayList<String>();
        boolean syntaxOnly = false;
        boolean useBeforeDecl = false;
        boolean printTypes = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                block8: for (int j = 1; j < args[i].length(); ++j) {
                    switch (args[i].charAt(j)) {
                        case 's': {
                            syntaxOnly = true;
                            continue block8;
                        }
                        case 'd': {
                            useBeforeDecl = true;
                            continue block8;
                        }
                        case 't': {
                            printTypes = true;
                            continue block8;
                        }
                        default: {
                            this.printUsage();
                        }
                    }
                }
                continue;
            }
            files.add(args[i]);
        }
        int result = 0;
        SectionManager manager = new SectionManager();
        for (String file : files) {
            Term term = null;
            Markup markup = ParseUtils.getMarkup((String)file);
            try {
                if (markup == null) {
                    FileSource src = new FileSource(file);
                    term = this.parse((Source)src, (SectionInfo)manager);
                } else {
                    term = this.parse(file, (SectionInfo)manager);
                }
            }
            catch (ParseException exception) {
                exception.printErrorList();
            }
            if (term == null || syntaxOnly) continue;
            List errors = this.lTypecheck(term, (SectionInfo)manager, markup, useBeforeDecl);
            for (Object next : errors) {
                System.out.println(next);
                System.out.println();
                result = -1;
            }
            if (!printTypes) continue;
            System.err.println("Type printing not implemented yet. Sorry!");
        }
        System.exit(result);
    }

    public static void main(String[] args) throws IOException {
        TypeCheckUtils utils = new TypeCheckUtils();
        utils.run(args);
    }
}

