/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.z;

import java.util.Collection;
import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.typecheck.z.Checker;
import net.sourceforge.czt.typecheck.z.ErrorMessage;
import net.sourceforge.czt.typecheck.z.TypeChecker;
import net.sourceforge.czt.typecheck.z.impl.UnknownType;
import net.sourceforge.czt.typecheck.z.impl.VariableSignature;
import net.sourceforge.czt.typecheck.z.impl.VariableType;
import net.sourceforge.czt.typecheck.z.util.GlobalDefs;
import net.sourceforge.czt.typecheck.z.util.ParameterAnn;
import net.sourceforge.czt.typecheck.z.util.UResult;
import net.sourceforge.czt.typecheck.z.util.UndeclaredAnn;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.BindExpr;
import net.sourceforge.czt.z.ast.BindSelExpr;
import net.sourceforge.czt.z.ast.CompExpr;
import net.sourceforge.czt.z.ast.CondExpr;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.DecorExpr;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.GenericType;
import net.sourceforge.czt.z.ast.GivenType;
import net.sourceforge.czt.z.ast.HideExpr;
import net.sourceforge.czt.z.ast.LambdaExpr;
import net.sourceforge.czt.z.ast.LetExpr;
import net.sourceforge.czt.z.ast.MuExpr;
import net.sourceforge.czt.z.ast.NameExprPair;
import net.sourceforge.czt.z.ast.NameNamePair;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.NegExpr;
import net.sourceforge.czt.z.ast.NextStroke;
import net.sourceforge.czt.z.ast.NumExpr;
import net.sourceforge.czt.z.ast.OutStroke;
import net.sourceforge.czt.z.ast.PipeExpr;
import net.sourceforge.czt.z.ast.PowerExpr;
import net.sourceforge.czt.z.ast.PowerType;
import net.sourceforge.czt.z.ast.PreExpr;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.ProdExpr;
import net.sourceforge.czt.z.ast.ProdType;
import net.sourceforge.czt.z.ast.ProjExpr;
import net.sourceforge.czt.z.ast.Qnt1Expr;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.RenameExpr;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.SchExpr2;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.SchemaType;
import net.sourceforge.czt.z.ast.SetCompExpr;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.Stroke;
import net.sourceforge.czt.z.ast.ThetaExpr;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.TupleSelExpr;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.Type2;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.z.visitor.ApplExprVisitor;
import net.sourceforge.czt.z.visitor.BindExprVisitor;
import net.sourceforge.czt.z.visitor.BindSelExprVisitor;
import net.sourceforge.czt.z.visitor.CompExprVisitor;
import net.sourceforge.czt.z.visitor.CondExprVisitor;
import net.sourceforge.czt.z.visitor.DecorExprVisitor;
import net.sourceforge.czt.z.visitor.HideExprVisitor;
import net.sourceforge.czt.z.visitor.LambdaExprVisitor;
import net.sourceforge.czt.z.visitor.LetExprVisitor;
import net.sourceforge.czt.z.visitor.MuExprVisitor;
import net.sourceforge.czt.z.visitor.NegExprVisitor;
import net.sourceforge.czt.z.visitor.NumExprVisitor;
import net.sourceforge.czt.z.visitor.PipeExprVisitor;
import net.sourceforge.czt.z.visitor.PowerExprVisitor;
import net.sourceforge.czt.z.visitor.PreExprVisitor;
import net.sourceforge.czt.z.visitor.ProdExprVisitor;
import net.sourceforge.czt.z.visitor.ProjExprVisitor;
import net.sourceforge.czt.z.visitor.Qnt1ExprVisitor;
import net.sourceforge.czt.z.visitor.RefExprVisitor;
import net.sourceforge.czt.z.visitor.RenameExprVisitor;
import net.sourceforge.czt.z.visitor.SchExpr2Visitor;
import net.sourceforge.czt.z.visitor.SchExprVisitor;
import net.sourceforge.czt.z.visitor.SchTextVisitor;
import net.sourceforge.czt.z.visitor.SetCompExprVisitor;
import net.sourceforge.czt.z.visitor.SetExprVisitor;
import net.sourceforge.czt.z.visitor.ThetaExprVisitor;
import net.sourceforge.czt.z.visitor.TupleExprVisitor;
import net.sourceforge.czt.z.visitor.TupleSelExprVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprChecker
extends Checker
implements SchTextVisitor,
RefExprVisitor,
PowerExprVisitor,
ProdExprVisitor,
SetExprVisitor,
SetCompExprVisitor,
NumExprVisitor,
SchExprVisitor,
TupleExprVisitor,
TupleSelExprVisitor,
Qnt1ExprVisitor,
LambdaExprVisitor,
MuExprVisitor,
LetExprVisitor,
SchExpr2Visitor,
NegExprVisitor,
CondExprVisitor,
CompExprVisitor,
PipeExprVisitor,
HideExprVisitor,
ProjExprVisitor,
PreExprVisitor,
ApplExprVisitor,
ThetaExprVisitor,
DecorExprVisitor,
RenameExprVisitor,
BindSelExprVisitor,
BindExprVisitor {
    public ExprChecker(TypeChecker typeChecker) {
        super(typeChecker);
    }

    public Object visitSchText(SchText schText) {
        UResult solved;
        List<NameTypePair> pairs = GlobalDefs.list();
        ListTerm decls = schText.getDecl();
        for (Decl decl : decls) {
            pairs.addAll((List)decl.accept((Visitor)this.declChecker()));
        }
        this.typeEnv().add(pairs);
        Pred pred = schText.getPred();
        if (pred != null && (solved = (UResult)((Object)pred.accept((Visitor)this.predChecker()))) == GlobalDefs.PARTIAL) {
            pred.accept((Visitor)this.predChecker());
        }
        this.checkForDuplicates(pairs, null);
        Signature signature = this.factory().createSignature(pairs);
        this.addSignatureAnn((TermA)schText, signature);
        return signature;
    }

    public Object visitRefExpr(RefExpr refExpr) {
        RefName refName = refExpr.getRefName();
        Type type = this.exprChecker().getType(refName);
        if (!GlobalDefs.containsObject(this.paraErrors(), refExpr)) {
            this.paraErrors().add(refExpr);
        }
        Object undecAnn = refName.getAnn(UndeclaredAnn.class);
        ParameterAnn pAnn = (ParameterAnn)refExpr.getAnn(ParameterAnn.class);
        ListTerm exprs = refExpr.getExpr();
        if (type instanceof GenericType && !this.isPending()) {
            GenericType genericType = (GenericType)type;
            if (exprs.size() == 0) {
                List<VariableType> instantiations = GlobalDefs.list();
                this.unificationEnv().enterScope();
                ListTerm declNames = genericType.getName();
                for (DeclName declName : declNames) {
                    VariableType vType = this.factory().createVariableType();
                    this.unificationEnv().addGenName(declName, vType);
                    instantiations.add(vType);
                }
                type = (GenericType)this.exprChecker().instantiate((Type)genericType);
                if (pAnn != null) {
                    GlobalDefs.removeAnn((TermA)refExpr, pAnn);
                }
                pAnn = new ParameterAnn(instantiations);
                GlobalDefs.addAnn((TermA)refExpr, pAnn);
                GlobalDefs.addAnn((TermA)refName, pAnn);
                this.unificationEnv().exitScope();
            } else {
                ListTerm names = genericType.getName();
                if (names.size() == exprs.size()) {
                    List<Type2> instantiations = GlobalDefs.list();
                    this.unificationEnv().enterScope();
                    for (int i = 0; i < names.size(); ++i) {
                        DeclName declName = (DeclName)names.get(i);
                        Expr expr = (Expr)exprs.get(i);
                        Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
                        PowerType vPowerType = this.factory().createPowerType();
                        UResult unified = this.unify((Type2)vPowerType, exprType);
                        if (unified == GlobalDefs.FAIL) {
                            Object[] params = new Object[]{expr, exprType};
                            this.error((TermA)refExpr, ErrorMessage.NON_SET_IN_INSTANTIATION, params);
                            continue;
                        }
                        Type2 substType = vPowerType.getType();
                        this.unificationEnv().addGenName(declName, substType);
                        instantiations.add(substType);
                    }
                    type = (GenericType)this.exprChecker().instantiate((Type)genericType);
                    if (pAnn != null) {
                        GlobalDefs.removeAnn((TermA)refExpr, pAnn);
                    }
                    pAnn = new ParameterAnn(instantiations);
                    this.unificationEnv().exitScope();
                } else {
                    Object[] params = new Object[]{refExpr.getRefName(), names.size()};
                    this.error((TermA)refExpr, ErrorMessage.PARAMETER_MISMATCH, params);
                }
            }
        } else if (undecAnn != null) {
            assert (type instanceof UnknownType);
            UnknownType uType = (UnknownType)type;
            uType.setRefName(refName);
            for (Expr expr : exprs) {
                Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
                PowerType vPowerType = this.factory().createPowerType();
                UnknownType baseType = this.factory().createUnknownType();
                UResult unified = this.unify((Type2)vPowerType, exprType);
                if (unified != GlobalDefs.FAIL) {
                    baseType = vPowerType.getType();
                }
                uType.getType().add((Type2)baseType);
            }
        } else if (!(type instanceof GenericType) && exprs.size() > 0) {
            Object[] params = new Object[]{refExpr.getRefName(), 0};
            this.error((TermA)refExpr, ErrorMessage.PARAMETER_MISMATCH, params);
        }
        this.addTypeAnn((TermA)refExpr, type);
        Type2 result = GlobalDefs.unwrapType(type);
        return result;
    }

    public Object visitPowerExpr(PowerExpr powerExpr) {
        UnknownType type = this.factory().createUnknownType();
        Expr expr = powerExpr.getExpr();
        Type2 innerType = (Type2)expr.accept((Visitor)this.exprChecker());
        PowerType vPowerType = this.factory().createPowerType();
        UResult unified = this.unify((Type2)vPowerType, innerType);
        if (unified == GlobalDefs.FAIL) {
            Object[] params = new Object[]{powerExpr, innerType};
            this.error((TermA)powerExpr, ErrorMessage.NON_SET_IN_POWEREXPR, params);
        } else {
            type = this.factory().createPowerType(innerType);
        }
        this.addTypeAnn((TermA)powerExpr, (Type)type);
        return type;
    }

    public Object visitProdExpr(ProdExpr prodExpr) {
        List<Type2> types = GlobalDefs.list();
        ListTerm exprs = prodExpr.getExpr();
        int position = 1;
        for (Expr expr : exprs) {
            Type2 nestedType = (Type2)expr.accept((Visitor)this.exprChecker());
            PowerType vPowerType = this.factory().createPowerType();
            UResult unified = this.unify((Type2)vPowerType, nestedType);
            if (unified == GlobalDefs.FAIL) {
                Object[] params = new Object[]{prodExpr, position, nestedType};
                this.error((TermA)prodExpr, ErrorMessage.NON_SET_IN_PRODEXPR, params);
            }
            types.add(vPowerType.getType());
            ++position;
        }
        ProdType prodType = this.factory().createProdType(types);
        PowerType type = this.factory().createPowerType((Type2)prodType);
        this.addTypeAnn((TermA)prodExpr, (Type)type);
        return type;
    }

    public Object visitSetExpr(SetExpr setExpr) {
        ListTerm exprs = setExpr.getExpr();
        Type2 innerType = null;
        Type2 annType = this.getType2FromAnns((TermA)setExpr);
        if (annType instanceof PowerType && !GlobalDefs.instanceOf(GlobalDefs.powerType(annType).getType(), UnknownType.class)) {
            innerType = GlobalDefs.powerType(annType).getType();
        }
        for (Expr expr : exprs) {
            Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
            if (innerType == null) {
                innerType = exprType;
                continue;
            }
            if (this.unify(innerType, exprType) != GlobalDefs.FAIL) continue;
            Object[] params = new Object[]{setExpr, exprType, innerType};
            this.error((TermA)setExpr, ErrorMessage.TYPE_MISMATCH_IN_SET_EXPR, params);
        }
        if (innerType == null) {
            innerType = this.factory().createVariableType();
        }
        if (GlobalDefs.resolve(innerType) instanceof VariableType && !GlobalDefs.containsObject(this.paraErrors(), setExpr)) {
            this.paraErrors().add(setExpr);
        }
        PowerType type = this.factory().createPowerType(innerType);
        this.addTypeAnn((TermA)setExpr, (Type)type);
        return type;
    }

    public Object visitNumExpr(NumExpr numExpr) {
        DeclName declName = this.factory().createDeclName(ZString.ARITHMOS, GlobalDefs.list(), null);
        GivenType type = this.factory().createGivenType(declName);
        this.addTypeAnn((TermA)numExpr, (Type)type);
        return type;
    }

    public Object visitSchExpr(SchExpr schExpr) {
        this.typeEnv().enterScope();
        SchText schText = schExpr.getSchText();
        Signature signature = (Signature)schText.accept((Visitor)this.exprChecker());
        this.typeEnv().exitScope();
        SchemaType schemaType = this.factory().createSchemaType(signature);
        PowerType type = this.factory().createPowerType((Type2)schemaType);
        this.addTypeAnn((TermA)schExpr, (Type)type);
        return type;
    }

    public Object visitSetCompExpr(SetCompExpr setCompExpr) {
        UnknownType type = this.factory().createUnknownType();
        this.typeEnv().enterScope();
        SchText schText = setCompExpr.getSchText();
        Signature signature = (Signature)schText.accept((Visitor)this.exprChecker());
        Expr expr = setCompExpr.getExpr();
        List<Type2> types = GlobalDefs.list();
        ListTerm pairs = signature.getNameTypePair();
        for (NameTypePair pair : pairs) {
            Type nextType = pair.getType();
            types.add(GlobalDefs.unwrapType(nextType));
        }
        if (expr == null) {
            if (types.size() == 1) {
                Type2 innerType = (Type2)types.get(0);
                type = this.factory().createPowerType(innerType);
            } else if (types.size() > 1) {
                ProdType prodType = this.factory().createProdType(types);
                type = this.factory().createPowerType((Type2)prodType);
            }
        } else {
            Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
            type = this.factory().createPowerType(exprType);
        }
        this.typeEnv().exitScope();
        this.addTypeAnn((TermA)setCompExpr, (Type)type);
        return type;
    }

    public Object visitTupleExpr(TupleExpr tupleExpr) {
        List<Type> types = GlobalDefs.list();
        ListTerm exprs = tupleExpr.getExpr();
        for (Expr expr : exprs) {
            Type innerType = (Type)expr.accept((Visitor)this.exprChecker());
            types.add(innerType);
        }
        ProdType type = this.factory().createProdType(types);
        this.addTypeAnn((TermA)tupleExpr, (Type)type);
        return type;
    }

    public Object visitTupleSelExpr(TupleSelExpr tupleSelExpr) {
        UnknownType type = this.factory().createUnknownType();
        Expr expr = tupleSelExpr.getExpr();
        Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
        Type2 resolved = GlobalDefs.resolve(exprType);
        if (resolved instanceof ProdType) {
            ProdType prodType = (ProdType)resolved;
            int select = tupleSelExpr.getSelect();
            if (select > prodType.getType().size() || select < 1) {
                Object[] params = new Object[]{tupleSelExpr, prodType.getType().size()};
                this.error((TermA)tupleSelExpr, ErrorMessage.INDEX_ERROR_IN_TUPLESELEXPR, params);
            } else {
                type = (Type2)prodType.getType().get(select - 1);
            }
        } else if (!GlobalDefs.instanceOf(resolved, VariableType.class)) {
            Object[] params = new Object[]{tupleSelExpr, exprType};
            this.error((TermA)tupleSelExpr, ErrorMessage.NON_PRODTYPE_IN_TUPLESELEXPR, params);
        }
        this.addTypeAnn((TermA)tupleSelExpr, (Type)type);
        return type;
    }

    public Object visitQnt1Expr(Qnt1Expr qnt1Expr) {
        UnknownType type = this.factory().createUnknownType();
        this.typeEnv().enterScope();
        SchText schText = qnt1Expr.getSchText();
        Signature signature = (Signature)schText.accept((Visitor)this.exprChecker());
        Expr expr = qnt1Expr.getExpr();
        Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
        this.typeEnv().exitScope();
        SchemaType vSchemaType = this.factory().createSchemaType();
        PowerType vPowerType = this.factory().createPowerType((Type2)vSchemaType);
        UResult unified = this.unify((Type2)vPowerType, exprType);
        if (unified == GlobalDefs.FAIL) {
            Object[] params = new Object[]{expr, exprType};
            this.error((TermA)expr, ErrorMessage.NON_SCHEXPR_IN_QNT1EXPR, params);
        } else {
            SchemaType schemaType = (SchemaType)vPowerType.getType();
            Signature exprSignature = schemaType.getSignature();
            VariableSignature thisSignature = this.factory().createVariableSignature();
            if (!GlobalDefs.instanceOf(exprSignature, VariableSignature.class)) {
                List<NameTypePair> newPairs = GlobalDefs.list(signature.getNameTypePair());
                newPairs.addAll((Collection<NameTypePair>)exprSignature.getNameTypePair());
                this.checkForDuplicates(newPairs, (TermA)qnt1Expr);
                thisSignature = this.schemaHide(schemaType.getSignature(), signature);
            }
            SchemaType thisSchemaType = this.factory().createSchemaType(thisSignature);
            type = this.factory().createPowerType((Type2)thisSchemaType);
        }
        this.addTypeAnn((TermA)qnt1Expr, (Type)type);
        return type;
    }

    public Object visitLambdaExpr(LambdaExpr lambdaExpr) {
        UnknownType type = this.factory().createUnknownType();
        this.typeEnv().enterScope();
        SchText schText = lambdaExpr.getSchText();
        Signature signature = (Signature)schText.accept((Visitor)this.exprChecker());
        Expr expr = lambdaExpr.getExpr();
        Type exprType = (Type)expr.accept((Visitor)this.exprChecker());
        this.typeEnv().exitScope();
        ProdType charTuple = null;
        ListTerm pairs = signature.getNameTypePair();
        if (pairs.size() > 1) {
            List<Type2> charTupleList = GlobalDefs.list();
            for (NameTypePair pair : pairs) {
                charTupleList.add(GlobalDefs.unwrapType(pair.getType()));
            }
            charTuple = this.factory().createProdType(charTupleList);
        } else if (pairs.size() == 1) {
            NameTypePair pair = (NameTypePair)pairs.get(0);
            charTuple = GlobalDefs.unwrapType(pair.getType());
        }
        if (charTuple != null) {
            ProdType prodType = this.factory().createProdType(GlobalDefs.list(charTuple, exprType));
            type = this.factory().createPowerType((Type2)prodType);
        }
        this.addTypeAnn((TermA)lambdaExpr, (Type)type);
        return type;
    }

    public Object visitMuExpr(MuExpr muExpr) {
        UnknownType type = this.factory().createUnknownType();
        this.typeEnv().enterScope();
        SchText schText = muExpr.getSchText();
        Signature signature = (Signature)schText.accept((Visitor)this.exprChecker());
        Expr expr = muExpr.getExpr();
        if (expr != null) {
            type = (Type2)expr.accept((Visitor)this.exprChecker());
        } else {
            List<Type2> types = GlobalDefs.list();
            ListTerm pairs = signature.getNameTypePair();
            for (NameTypePair pair : pairs) {
                Type2 nextType = GlobalDefs.unwrapType(pair.getType());
                types.add(nextType);
            }
            type = types.size() > 1 ? this.factory().createProdType(types) : (Type2)types.get(0);
        }
        this.typeEnv().exitScope();
        this.addTypeAnn((TermA)muExpr, (Type)type);
        return type;
    }

    public Object visitLetExpr(LetExpr letExpr) {
        this.typeEnv().enterScope();
        SchText schText = letExpr.getSchText();
        schText.accept((Visitor)this.exprChecker());
        Expr expr = letExpr.getExpr();
        Type2 type = (Type2)expr.accept((Visitor)this.exprChecker());
        this.typeEnv().exitScope();
        this.addTypeAnn((TermA)letExpr, (Type)type);
        return type;
    }

    public Object visitSchExpr2(SchExpr2 schExpr2) {
        Object[] params;
        UnknownType type = this.factory().createUnknownType();
        Expr leftExpr = schExpr2.getLeftExpr();
        Expr rightExpr = schExpr2.getRightExpr();
        Type2 leftType = (Type2)leftExpr.accept((Visitor)this.exprChecker());
        Type2 rightType = (Type2)rightExpr.accept((Visitor)this.exprChecker());
        SchemaType vLeftSchema = this.factory().createSchemaType();
        PowerType vLeftPower = this.factory().createPowerType((Type2)vLeftSchema);
        SchemaType vRightSchema = this.factory().createSchemaType();
        PowerType vRightPower = this.factory().createPowerType((Type2)vRightSchema);
        UResult lUnified = this.unify((Type2)vLeftPower, leftType);
        UResult rUnified = this.unify((Type2)vRightPower, rightType);
        if (lUnified == GlobalDefs.FAIL) {
            params = new Object[]{schExpr2, leftType};
            this.error((TermA)schExpr2, ErrorMessage.NON_SCHEXPR_IN_SCHEXPR2, params);
        }
        if (rUnified == GlobalDefs.FAIL) {
            params = new Object[]{schExpr2, rightType};
            this.error((TermA)schExpr2, ErrorMessage.NON_SCHEXPR_IN_SCHEXPR2, params);
        }
        if (lUnified != GlobalDefs.FAIL && rUnified != GlobalDefs.FAIL) {
            Signature leftSig = GlobalDefs.schemaType(vLeftPower.getType()).getSignature();
            Signature rightSig = GlobalDefs.schemaType(vRightPower.getType()).getSignature();
            VariableSignature signature = this.factory().createVariableSignature();
            if (!GlobalDefs.instanceOf(leftSig, VariableSignature.class) && !GlobalDefs.instanceOf(rightSig, VariableSignature.class)) {
                List<NameTypePair> newPairs = GlobalDefs.list(leftSig.getNameTypePair());
                newPairs.addAll((Collection<NameTypePair>)rightSig.getNameTypePair());
                this.checkForDuplicates(newPairs, (TermA)schExpr2);
                signature = this.factory().createSignature(newPairs);
            }
            SchemaType schemaType = this.factory().createSchemaType(signature);
            type = this.factory().createPowerType((Type2)schemaType);
        }
        this.addTypeAnn((TermA)schExpr2, (Type)type);
        return type;
    }

    public Object visitNegExpr(NegExpr negExpr) {
        Expr expr = negExpr.getExpr();
        Type2 type = (Type2)expr.accept((Visitor)this.exprChecker());
        this.addTypeAnn((TermA)negExpr, (Type)type);
        return type;
    }

    public Object visitCondExpr(CondExpr condExpr) {
        Type2 rightType;
        UnknownType type = this.factory().createUnknownType();
        Pred pred = condExpr.getPred();
        UResult solved = (UResult)((Object)pred.accept((Visitor)this.predChecker()));
        if (solved == GlobalDefs.PARTIAL) {
            pred.accept((Visitor)this.predChecker());
        }
        Expr leftExpr = condExpr.getLeftExpr();
        Expr rightExpr = condExpr.getRightExpr();
        Type2 leftType = (Type2)leftExpr.accept((Visitor)this.exprChecker());
        UResult unified = this.unify(leftType, rightType = (Type2)rightExpr.accept((Visitor)this.exprChecker()));
        if (unified == GlobalDefs.FAIL) {
            Object[] params = new Object[]{condExpr, leftType, rightType};
            this.error((TermA)condExpr, ErrorMessage.TYPE_MISMATCH_IN_CONDEXPR, params);
        } else {
            type = leftType;
        }
        this.addTypeAnn((TermA)condExpr, (Type)type);
        return type;
    }

    public Object visitCompExpr(CompExpr compExpr) {
        Object[] params;
        UnknownType type = this.factory().createUnknownType();
        Expr leftExpr = compExpr.getLeftExpr();
        Expr rightExpr = compExpr.getRightExpr();
        Type2 leftType = (Type2)leftExpr.accept((Visitor)this.exprChecker());
        Type2 rightType = (Type2)rightExpr.accept((Visitor)this.exprChecker());
        SchemaType vLeftSchema = this.factory().createSchemaType();
        PowerType vLeftPower = this.factory().createPowerType((Type2)vLeftSchema);
        SchemaType vRightSchema = this.factory().createSchemaType();
        PowerType vRightPower = this.factory().createPowerType((Type2)vRightSchema);
        UResult lUnified = this.unify((Type2)vLeftPower, leftType);
        UResult rUnified = this.unify((Type2)vRightPower, rightType);
        if (lUnified == GlobalDefs.FAIL) {
            params = new Object[]{compExpr, leftType};
            this.error((TermA)compExpr, ErrorMessage.NON_SCHEXPR_IN_SCHEXPR2, params);
        }
        if (rUnified == GlobalDefs.FAIL) {
            params = new Object[]{compExpr, rightType};
            this.error((TermA)compExpr, ErrorMessage.NON_SCHEXPR_IN_SCHEXPR2, params);
        }
        if (lUnified != GlobalDefs.FAIL && rUnified != GlobalDefs.FAIL) {
            SchemaType schemaType = this.factory().createSchemaType();
            Signature lSig = GlobalDefs.schemaType(vLeftPower.getType()).getSignature();
            Signature rSig = GlobalDefs.schemaType(vRightPower.getType()).getSignature();
            if (!GlobalDefs.instanceOf(lSig, VariableSignature.class) && !GlobalDefs.instanceOf(rSig, VariableSignature.class)) {
                String errorMessage = ErrorMessage.TYPE_MISMATCH_IN_COMPEXPR.toString();
                Signature signature = this.createCompSig(lSig, rSig, (TermA)compExpr, errorMessage);
                this.checkForDuplicates((List<NameTypePair>)signature.getNameTypePair(), (TermA)compExpr);
                schemaType.setSignature(signature);
            }
            type = this.factory().createPowerType((Type2)schemaType);
        }
        this.addTypeAnn((TermA)compExpr, (Type)type);
        return type;
    }

    public Object visitPipeExpr(PipeExpr pipeExpr) {
        Object[] params;
        UnknownType type = this.factory().createUnknownType();
        Expr leftExpr = pipeExpr.getLeftExpr();
        Expr rightExpr = pipeExpr.getRightExpr();
        Type2 leftType = (Type2)leftExpr.accept((Visitor)this.exprChecker());
        Type2 rightType = (Type2)rightExpr.accept((Visitor)this.exprChecker());
        SchemaType vLeftSchema = this.factory().createSchemaType();
        PowerType vLeftPower = this.factory().createPowerType((Type2)vLeftSchema);
        SchemaType vRightSchema = this.factory().createSchemaType();
        PowerType vRightPower = this.factory().createPowerType((Type2)vRightSchema);
        UResult lUnified = this.unify((Type2)vLeftPower, leftType);
        UResult rUnified = this.unify((Type2)vRightPower, rightType);
        if (lUnified == GlobalDefs.FAIL) {
            params = new Object[]{pipeExpr, leftType};
            this.error((TermA)pipeExpr, ErrorMessage.NON_SCHEXPR_IN_SCHEXPR2, params);
        }
        if (rUnified == GlobalDefs.FAIL) {
            params = new Object[]{pipeExpr, rightType};
            this.error((TermA)pipeExpr, ErrorMessage.NON_SCHEXPR_IN_SCHEXPR2, params);
        }
        if (lUnified != GlobalDefs.FAIL && rUnified != GlobalDefs.FAIL) {
            SchemaType schemaType = this.factory().createSchemaType();
            Signature lSig = GlobalDefs.schemaType(vLeftPower.getType()).getSignature();
            Signature rSig = GlobalDefs.schemaType(vRightPower.getType()).getSignature();
            if (!GlobalDefs.instanceOf(lSig, VariableSignature.class) && !GlobalDefs.instanceOf(rSig, VariableSignature.class)) {
                String errorMessage = ErrorMessage.TYPE_MISMATCH_IN_PIPEEXPR.toString();
                Signature signature = this.createPipeSig(lSig, rSig, (TermA)pipeExpr, errorMessage);
                this.checkForDuplicates((List<NameTypePair>)signature.getNameTypePair(), (TermA)pipeExpr);
                schemaType.setSignature(signature);
            }
            type = this.factory().createPowerType((Type2)schemaType);
        }
        this.addTypeAnn((TermA)pipeExpr, (Type)type);
        return type;
    }

    public Object visitHideExpr(HideExpr hideExpr) {
        UnknownType type = this.factory().createUnknownType();
        Expr expr = hideExpr.getExpr();
        Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
        SchemaType vSchemaType = this.factory().createSchemaType();
        PowerType vPowerType = this.factory().createPowerType((Type2)vSchemaType);
        UResult unified = this.unify((Type2)vPowerType, exprType);
        if (unified == GlobalDefs.FAIL) {
            Object[] params = new Object[]{hideExpr, exprType};
            this.error((TermA)hideExpr, ErrorMessage.NON_SCHEXPR_IN_HIDE_EXPR, params);
        } else {
            SchemaType schemaType = (SchemaType)vPowerType.getType();
            Signature signature = schemaType.getSignature();
            SchemaType hideSchemaType = this.factory().createSchemaType();
            if (!GlobalDefs.instanceOf(signature, VariableSignature.class)) {
                Signature hideSig = this.createHideSig(signature, (List<RefName>)hideExpr.getName(), (TermA)hideExpr);
                this.checkForDuplicates((List<NameTypePair>)hideSig.getNameTypePair(), (TermA)hideExpr);
                hideSchemaType.setSignature(hideSig);
            }
            type = this.factory().createPowerType((Type2)hideSchemaType);
        }
        this.addTypeAnn((TermA)hideExpr, (Type)type);
        return type;
    }

    public Object visitProjExpr(ProjExpr projExpr) {
        this.visitSchExpr2((SchExpr2)projExpr);
        Type2 type = this.getType2FromAnns((TermA)projExpr.getRightExpr());
        this.addTypeAnn((TermA)projExpr, (Type)type);
        return type;
    }

    public Object visitPreExpr(PreExpr preExpr) {
        UnknownType type = this.factory().createUnknownType();
        Expr expr = preExpr.getExpr();
        Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
        SchemaType vSchemaType = this.factory().createSchemaType();
        PowerType vPowerType = this.factory().createPowerType((Type2)vSchemaType);
        UResult unified = this.unify((Type2)vPowerType, exprType);
        if (unified == GlobalDefs.FAIL) {
            Object[] params = new Object[]{preExpr, exprType};
            this.error((TermA)preExpr, ErrorMessage.NON_SCHEXPR_IN_PREEXPR, params);
        } else {
            SchemaType preSchemaType = GlobalDefs.schemaType(vPowerType.getType());
            Signature preSignature = preSchemaType.getSignature();
            SchemaType schemaType = this.factory().createSchemaType();
            if (!GlobalDefs.instanceOf(preSignature, VariableSignature.class)) {
                ListTerm oldPairs = preSchemaType.getSignature().getNameTypePair();
                NextStroke nextStroke = this.factory().createNextStroke();
                OutStroke outStroke = this.factory().createOutStroke();
                List<NameTypePair> newPairs = GlobalDefs.list();
                for (NameTypePair oldPair : oldPairs) {
                    ListTerm strokes = oldPair.getName().getStroke();
                    int size = strokes.size();
                    if (size != 0 && (size <= 0 || ((Stroke)strokes.get(size - 1)).equals(nextStroke) || ((Stroke)strokes.get(size - 1)).equals(outStroke))) continue;
                    newPairs.add(oldPair);
                }
                Signature signature = this.factory().createSignature(newPairs);
                schemaType.setSignature(signature);
            }
            type = this.factory().createPowerType((Type2)schemaType);
        }
        this.addTypeAnn((TermA)preExpr, (Type)type);
        return type;
    }

    public Object visitApplExpr(ApplExpr applExpr) {
        UnknownType type = this.factory().createUnknownType();
        Expr funcExpr = applExpr.getLeftExpr();
        Expr argExpr = applExpr.getRightExpr();
        Type2 funcType = (Type2)funcExpr.accept((Visitor)this.exprChecker());
        Type2 argType = (Type2)argExpr.accept((Visitor)this.exprChecker());
        VariableType domType = this.factory().createVariableType();
        VariableType ranType = this.factory().createVariableType();
        ProdType vProdType = this.factory().createProdType(GlobalDefs.list(domType, ranType));
        PowerType vPowerType = this.factory().createPowerType((Type2)vProdType);
        UResult unified = this.unify((Type2)vPowerType, funcType);
        if (unified == GlobalDefs.FAIL) {
            Object[] params = new Object[]{applExpr, funcType};
            this.error((TermA)applExpr, ErrorMessage.NON_FUNCTION_IN_APPLEXPR, params);
        } else {
            unified = this.unify(GlobalDefs.resolve(domType), argType);
            if (unified == GlobalDefs.FAIL) {
                Object[] params = new Object[]{applExpr, GlobalDefs.resolve(domType), argType};
                this.error((TermA)applExpr, ErrorMessage.TYPE_MISMATCH_IN_APPLEXPR, params);
            } else {
                type = GlobalDefs.resolve(ranType);
            }
        }
        this.addTypeAnn((TermA)applExpr, (Type)type);
        return type;
    }

    public Object visitThetaExpr(ThetaExpr thetaExpr) {
        UnknownType type = this.factory().createUnknownType();
        Expr expr = thetaExpr.getExpr();
        Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
        SchemaType vSchemaType = this.factory().createSchemaType();
        PowerType vPowerType = this.factory().createPowerType((Type2)vSchemaType);
        UResult unified = this.unify((Type2)vPowerType, exprType);
        if (unified == GlobalDefs.FAIL) {
            Object[] params = new Object[]{thetaExpr, exprType};
            this.error((TermA)thetaExpr, ErrorMessage.NON_SCHEXPR_IN_THETAEXPR, params);
        } else {
            SchemaType schemaType = (SchemaType)vPowerType.getType();
            Signature signature = schemaType.getSignature();
            if (!GlobalDefs.instanceOf(signature, VariableSignature.class)) {
                ListTerm pairs = signature.getNameTypePair();
                for (NameTypePair pair : pairs) {
                    RefName name = this.factory().createRefName(pair.getName());
                    name.getStroke().addAll((Collection)thetaExpr.getStroke());
                    Type envType = this.getType(name);
                    Object undecAnn = name.getAnn(UndeclaredAnn.class);
                    if (undecAnn != null) {
                        pair.getName().getAnns().add(undecAnn);
                        if (!GlobalDefs.containsObject(this.paraErrors(), thetaExpr)) {
                            this.paraErrors().add(thetaExpr);
                        }
                    }
                    if (envType instanceof GenericType) {
                        Object[] params = new Object[]{name, thetaExpr, exprType};
                        this.error((TermA)thetaExpr, ErrorMessage.GENERICTYPE_IN_THETAEXPR, params);
                        continue;
                    }
                    Type2 envType2 = (Type2)envType;
                    Type2 pairType2 = GlobalDefs.unwrapType(pair.getType());
                    unified = this.unify(envType2, pairType2);
                    if (unified != GlobalDefs.FAIL) continue;
                    Object[] params = new Object[]{name, thetaExpr, envType2, pairType2};
                    this.error((TermA)thetaExpr, ErrorMessage.TYPE_MISMATCH_IN_THETAEXPR, params);
                }
            }
            type = vPowerType.getType();
        }
        this.addTypeAnn((TermA)thetaExpr, (Type)type);
        return type;
    }

    public Object visitDecorExpr(DecorExpr decorExpr) {
        UnknownType type = this.factory().createUnknownType();
        Expr expr = decorExpr.getExpr();
        Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
        SchemaType vSchemaType = this.factory().createSchemaType();
        PowerType vPowerType = this.factory().createPowerType((Type2)vSchemaType);
        UResult unified = this.unify((Type2)vPowerType, exprType);
        if (unified == GlobalDefs.FAIL) {
            Object[] params = new Object[]{decorExpr, exprType};
            this.error((TermA)decorExpr, ErrorMessage.NON_SCHEXPR_IN_DECOREXPR, params);
        } else {
            SchemaType schemaType = (SchemaType)vPowerType.getType();
            Signature signature = schemaType.getSignature();
            SchemaType decorSchemaType = this.factory().createSchemaType();
            if (!GlobalDefs.instanceOf(signature, VariableSignature.class)) {
                decorSchemaType = this.decorate(schemaType, GlobalDefs.list(decorExpr.getStroke()));
            }
            type = this.factory().createPowerType((Type2)decorSchemaType);
        }
        this.addTypeAnn((TermA)decorExpr, (Type)type);
        return type;
    }

    public Object visitRenameExpr(RenameExpr renameExpr) {
        UnknownType type = this.factory().createUnknownType();
        Expr expr = renameExpr.getExpr();
        Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
        SchemaType vSchemaType = this.factory().createSchemaType();
        PowerType vPowerType = this.factory().createPowerType((Type2)vSchemaType);
        UResult unified = this.unify((Type2)vPowerType, exprType);
        if (unified == GlobalDefs.FAIL) {
            Object[] params = new Object[]{renameExpr, exprType};
            this.error((TermA)renameExpr, ErrorMessage.NON_SCHEXPR_IN_RENAMEEXPR, params);
        } else {
            SchemaType schemaType = GlobalDefs.schemaType(vPowerType.getType());
            Signature signature = schemaType.getSignature();
            SchemaType newSchemaType = this.factory().createSchemaType();
            if (!GlobalDefs.instanceOf(signature, VariableSignature.class)) {
                String errorMessage = ErrorMessage.DUPLICATE_NAME_IN_RENAMEEXPR.toString();
                ListTerm namePairs = renameExpr.getNameNamePair();
                Signature newSig = this.createRenameSig(signature, (List<NameNamePair>)namePairs, (TermA)renameExpr, errorMessage);
                this.checkForDuplicates((List<NameTypePair>)newSig.getNameTypePair(), (TermA)renameExpr);
                newSchemaType.setSignature(newSig);
            }
            type = this.factory().createPowerType((Type2)newSchemaType);
        }
        this.addTypeAnn((TermA)renameExpr, (Type)type);
        return type;
    }

    public Object visitBindSelExpr(BindSelExpr bindSelExpr) {
        UnknownType type = this.factory().createUnknownType();
        Expr expr = bindSelExpr.getExpr();
        Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
        SchemaType vSchemaType = this.factory().createSchemaType();
        UResult unified = this.unify((Type2)vSchemaType, exprType);
        if (unified == GlobalDefs.FAIL) {
            Object[] params = new Object[]{bindSelExpr, exprType};
            this.error((TermA)bindSelExpr, ErrorMessage.NON_BINDING_IN_BINDSELEXPR, params);
        } else {
            RefName selectName = bindSelExpr.getName();
            Signature signature = vSchemaType.getSignature();
            if (!GlobalDefs.instanceOf(signature, VariableSignature.class)) {
                NameTypePair pair = this.findNameTypePair(selectName, signature);
                if (pair == null) {
                    Object[] params = new Object[]{bindSelExpr};
                    this.error((TermA)selectName, ErrorMessage.NON_EXISTENT_SELECTION, params);
                } else {
                    type = GlobalDefs.unwrapType(pair.getType());
                }
            }
        }
        type = this.resolveUnknownType((Type2)type);
        this.addTypeAnn((TermA)bindSelExpr, (Type)type);
        return type;
    }

    public Object visitBindExpr(BindExpr bindExpr) {
        List<DeclName> names = GlobalDefs.list();
        List<NameTypePair> pairs = GlobalDefs.list();
        ListTerm nameExprPairs = bindExpr.getNameExprPair();
        for (NameExprPair nameExprPair : nameExprPairs) {
            DeclName declName = nameExprPair.getName();
            if (names.contains(declName)) {
                Object[] params = new Object[]{declName};
                this.error((TermA)bindExpr, ErrorMessage.DUPLICATE_IN_BINDEXPR, params);
                continue;
            }
            Expr expr = nameExprPair.getExpr();
            Type exprType = (Type)expr.accept((Visitor)this.exprChecker());
            NameTypePair nameTypePair = this.factory().createNameTypePair(declName, exprType);
            pairs.add(nameTypePair);
            names.add(declName);
        }
        Signature signature = this.factory().createSignature(pairs);
        SchemaType type = this.factory().createSchemaType(signature);
        this.addTypeAnn((TermA)bindExpr, (Type)type);
        return type;
    }

    protected SchemaType decorate(SchemaType schemaType, List<Stroke> stroke) {
        List<NameTypePair> nameTypePairs = GlobalDefs.list();
        ListTerm pairs = schemaType.getSignature().getNameTypePair();
        for (NameTypePair oldPair : pairs) {
            DeclName oldName = oldPair.getName();
            List<Stroke> strokes = GlobalDefs.list(oldName.getStroke());
            strokes.addAll(stroke);
            DeclName newName = this.factory().createDeclName(oldName.getWord(), strokes, null);
            NameTypePair newPair = this.factory().createNameTypePair(newName, oldPair.getType());
            nameTypePairs.add(newPair);
        }
        Signature newSignature = this.factory().createSignature(nameTypePairs);
        SchemaType result = this.factory().createSchemaType(newSignature);
        return result;
    }

    protected Signature schemaHide(Signature lSig, Signature rSig) {
        List<NameTypePair> pairs = GlobalDefs.list();
        ListTerm lPairs = lSig.getNameTypePair();
        for (NameTypePair lPair : lPairs) {
            NameTypePair rPair = this.findNameTypePair(lPair.getName(), rSig);
            if (rPair != null) continue;
            pairs.add(lPair);
        }
        Signature result = this.factory().createSignature(pairs);
        return result;
    }

    protected Signature schemaHide(Signature lSig, List<RefName> names) {
        List<NameTypePair> pairs = GlobalDefs.list();
        ListTerm oldPairs = lSig.getNameTypePair();
        for (NameTypePair pair : oldPairs) {
            RefName refName = this.factory().createRefName(pair.getName().getWord(), (List)pair.getName().getStroke(), null);
            if (names.contains(refName)) continue;
            pairs.add(pair);
        }
        Signature signature = this.factory().createSignature(pairs);
        return signature;
    }
}

