/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.z;

import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.print.z.PrintUtils;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.typecheck.z.ErrorMessage;
import net.sourceforge.czt.typecheck.z.util.CarrierSet;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.LocAnn;
import net.sourceforge.czt.z.ast.Type;

public class ErrorAnn {
    private static String RESOURCE_NAME = "net.sourceforge.czt.typecheck.z.TypeCheckResources";
    private static ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(RESOURCE_NAME);
    protected String errorMessage_;
    protected Object[] params_;
    protected String sectName_;
    protected SectionInfo sectInfo_;
    protected LocAnn locAnn_;
    protected TermA termA_;
    protected Markup markup_;

    public ErrorAnn(String errorMessage, Object[] params, SectionInfo sectInfo, String sectName, LocAnn locAnn, Markup markup) {
        this(errorMessage, params, sectInfo, sectName, locAnn, null, markup);
    }

    public ErrorAnn(String errorMessage, Object[] params, SectionInfo sectInfo, String sectName, LocAnn locAnn, TermA termA, Markup markup) {
        this.errorMessage_ = errorMessage;
        this.params_ = params;
        this.sectInfo_ = sectInfo;
        this.sectName_ = new String(sectName);
        this.locAnn_ = locAnn;
        this.termA_ = termA;
        this.markup_ = markup;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage_ = errorMessage.toString();
    }

    public String getErrorMessage() {
        return this.errorMessage_;
    }

    public int getLine() {
        if (this.locAnn_ != null) {
            return this.locAnn_.getLine();
        }
        return -1;
    }

    public int getColumn() {
        if (this.locAnn_ != null) {
            return this.locAnn_.getCol();
        }
        return -1;
    }

    public String getSource() {
        if (this.locAnn_ != null) {
            return this.locAnn_.getLoc();
        }
        return null;
    }

    public void setTerm(TermA termA) {
        this.termA_ = termA;
    }

    public TermA getTerm() {
        return this.termA_;
    }

    public void setMarkup(Markup markup) {
        this.markup_ = markup;
    }

    public Markup getMarkup() {
        return this.markup_;
    }

    public String toString() {
        String result = new String();
        String localised = null;
        String[] args = null;
        if (this.locAnn_ != null) {
            Integer lineNr = this.locAnn_.getLine();
            String source = this.locAnn_.getLoc();
            localised = RESOURCE_BUNDLE.getString(ErrorMessage.ERROR_FILE_LINE.toString());
            args = new String[]{source, lineNr.toString()};
        } else {
            localised = RESOURCE_BUNDLE.getString(ErrorMessage.NO_LOCATION.toString());
            args = new String[]{};
        }
        MessageFormat form = new MessageFormat(localised);
        result = result + form.format(args) + ": ";
        String[] formatted = new String[this.params_.length];
        for (int i = 0; i < this.params_.length; ++i) {
            formatted[i] = this.format(this.params_[i], this.sectInfo_, this.sectName_);
        }
        localised = RESOURCE_BUNDLE.getString(this.errorMessage_.toString());
        form = new MessageFormat(localised);
        result = result + form.format(formatted);
        return result;
    }

    protected String format(Object object, SectionInfo sectInfo, String sectName) {
        if (object instanceof Term) {
            try {
                Term term = (Term)((Term)object).accept((Visitor)this.getCarrierSet());
                StringWriter writer = new StringWriter();
                this.print(term, writer, sectInfo, sectName, this.markup_);
                return writer.toString();
            }
            catch (Exception e) {
                String message = "Cannot be printed";
                if (object instanceof Type) {
                    message = object.toString();
                }
                return message;
            }
        }
        if (object != null) {
            return object.toString();
        }
        return "Cannot be printed";
    }

    protected CarrierSet getCarrierSet() {
        return new CarrierSet(true);
    }

    protected void print(Term term, Writer writer, SectionInfo sectInfo, String sectName, Markup markup) {
        PrintUtils.print((Term)term, (Writer)writer, (SectionInfo)sectInfo, (String)sectName, (Markup)this.markup_);
    }
}

