/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.oz;

import java.util.Collection;
import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.oz.ast.ClassPolyType;
import net.sourceforge.czt.oz.ast.ClassRef;
import net.sourceforge.czt.oz.ast.ClassRefType;
import net.sourceforge.czt.oz.ast.ClassSig;
import net.sourceforge.czt.oz.ast.ClassType;
import net.sourceforge.czt.oz.ast.ClassUnionExpr;
import net.sourceforge.czt.oz.ast.ClassUnionType;
import net.sourceforge.czt.oz.ast.ContainmentExpr;
import net.sourceforge.czt.oz.ast.NameSignaturePair;
import net.sourceforge.czt.oz.ast.PolyExpr;
import net.sourceforge.czt.oz.ast.PredExpr;
import net.sourceforge.czt.oz.visitor.ClassUnionExprVisitor;
import net.sourceforge.czt.oz.visitor.ContainmentExprVisitor;
import net.sourceforge.czt.oz.visitor.PolyExprVisitor;
import net.sourceforge.czt.oz.visitor.PredExprVisitor;
import net.sourceforge.czt.typecheck.oz.Checker;
import net.sourceforge.czt.typecheck.oz.ErrorMessage;
import net.sourceforge.czt.typecheck.oz.TypeChecker;
import net.sourceforge.czt.typecheck.oz.impl.VariableClassSig;
import net.sourceforge.czt.typecheck.oz.util.GlobalDefs;
import net.sourceforge.czt.typecheck.z.impl.UnknownType;
import net.sourceforge.czt.typecheck.z.impl.VariableType;
import net.sourceforge.czt.typecheck.z.util.ParameterAnn;
import net.sourceforge.czt.typecheck.z.util.UResult;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.BindSelExpr;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.GenericType;
import net.sourceforge.czt.z.ast.NameSectTypeTriple;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.PowerType;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.RenameExpr;
import net.sourceforge.czt.z.ast.SchemaType;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.Type2;
import net.sourceforge.czt.z.visitor.BindSelExprVisitor;
import net.sourceforge.czt.z.visitor.RenameExprVisitor;

public class ExprChecker
extends Checker
implements ClassUnionExprVisitor,
PolyExprVisitor,
ContainmentExprVisitor,
PredExprVisitor,
BindSelExprVisitor,
RenameExprVisitor {
    protected net.sourceforge.czt.typecheck.z.ExprChecker zExprChecker_;

    public ExprChecker(TypeChecker typeChecker) {
        super(typeChecker);
        this.zExprChecker_ = new net.sourceforge.czt.typecheck.z.ExprChecker(typeChecker);
    }

    public Object visitTerm(Term term) {
        return term.accept((Visitor)this.zExprChecker_);
    }

    public Object visitClassUnionExpr(ClassUnionExpr classUnionExpr) {
        Object[] params;
        UnknownType type = this.factory().createUnknownType();
        Expr lExpr = classUnionExpr.getLeftExpr();
        Expr rExpr = classUnionExpr.getRightExpr();
        Type2 lType = (Type2)lExpr.accept((Visitor)this);
        Type2 rType = (Type2)rExpr.accept((Visitor)this);
        PowerType vlPowerType = this.factory().createPowerType();
        PowerType vrPowerType = this.factory().createPowerType();
        UResult lUnified = this.strongUnify((Type2)vlPowerType, lType);
        UResult rUnified = this.strongUnify((Type2)vrPowerType, rType);
        if (!(net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(vlPowerType.getType(), ClassRefType.class) || net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(vlPowerType.getType(), ClassUnionType.class) || net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(vlPowerType.getType(), VariableType.class))) {
            params = new Object[]{classUnionExpr, lType};
            this.error((TermA)classUnionExpr, ErrorMessage.NON_CLASS_IN_CLASSUNIONEXPR, params);
        }
        if (!(net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(vrPowerType.getType(), ClassRefType.class) || net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(vrPowerType.getType(), ClassUnionType.class) || net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(vrPowerType.getType(), UnknownType.class) || net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(vrPowerType.getType(), VariableType.class))) {
            params = new Object[]{classUnionExpr, rType};
            this.error((TermA)classUnionExpr, ErrorMessage.NON_CLASS_IN_CLASSUNIONEXPR, params);
        }
        if (vlPowerType.getType() instanceof ClassType && vrPowerType.getType() instanceof ClassType) {
            ClassType lClassType = (ClassType)vlPowerType.getType();
            ClassType rClassType = (ClassType)vrPowerType.getType();
            ClassSig lcSig = lClassType.getClassSig();
            ClassSig rcSig = rClassType.getClassSig();
            VariableClassSig cSig = this.factory().createVariableClassSig();
            if (!net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(lcSig, VariableClassSig.class) && !net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(rcSig, VariableClassSig.class)) {
                Type2 unioned = this.unionClasses(classUnionExpr, (Type2)lClassType, (Type2)rClassType);
                type = this.factory().createPowerType(unioned);
            }
        }
        this.addTypeAnn((TermA)classUnionExpr, (Type)type);
        return type;
    }

    public Object visitPolyExpr(PolyExpr polyExpr) {
        ClassRefType classRefType;
        ClassSig cSig;
        UnknownType type = this.factory().createUnknownType();
        Expr expr = polyExpr.getExpr();
        Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
        PowerType vPowerType = this.factory().createPowerType();
        UResult unified = this.strongUnify((Type2)vPowerType, exprType);
        if (!net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(vPowerType.getType(), ClassRefType.class) && !net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(vPowerType.getType(), VariableType.class)) {
            Object[] params = new Object[]{polyExpr, exprType};
            this.error((TermA)polyExpr, ErrorMessage.NON_REF_IN_POLYEXPR, params);
        } else if (vPowerType.getType() instanceof ClassRefType && !net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(cSig = (classRefType = (ClassRefType)vPowerType.getType()).getClassSig(), VariableClassSig.class)) {
            ClassRef cRef = classRefType.getThisClass();
            List<ClassRef> subClasses = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list(cRef);
            List<NameSectTypeTriple> triples = this.sectTypeEnv().getNameSectTypeTriple();
            for (NameSectTypeTriple triple : triples) {
                int subSize;
                ClassRefType subClass;
                Type2 nextType = net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType(triple.getType());
                if (!GlobalDefs.isPowerClassRefType(nextType) || !GlobalDefs.contains((List<ClassRef>)(subClass = (ClassRefType)net.sourceforge.czt.typecheck.z.util.GlobalDefs.powerType(nextType).getType()).getSuperClass(), cRef)) continue;
                int superSize = cRef.getType2().size();
                if (superSize != (subSize = subClass.getThisClass().getType2().size())) {
                    Object[] params = new Object[]{cRef.getRefName(), superSize, subClass.getThisClass().getRefName(), subSize};
                    this.error((TermA)polyExpr, ErrorMessage.PARAMETER_MISMATCH_IN_POLYEXPR, params);
                }
                ClassSig subCSig = subClass.getClassSig();
                ListTerm superAttrs = cSig.getAttribute();
                ListTerm subAttrs = subCSig.getAttribute();
                this.checkVisibility(classRefType, subClass, (List<NameTypePair>)superAttrs, (List<NameTypePair>)subAttrs, polyExpr);
                ListTerm superState = cSig.getState().getNameTypePair();
                ListTerm subState = subCSig.getState().getNameTypePair();
                this.checkVisibility(classRefType, subClass, (List<NameTypePair>)superState, (List<NameTypePair>)subState, polyExpr);
                ListTerm superOps = cSig.getOperation();
                ListTerm subOps = subCSig.getOperation();
                this.checkOpVisibility(classRefType, subClass, (List<NameSignaturePair>)superOps, (List<NameSignaturePair>)subOps, polyExpr);
                ClassRef subCRef = this.factory().createClassRef();
                subCRef.setRefName(subClass.getThisClass().getRefName());
                subCRef.getType2().addAll((Collection)cRef.getType2());
                subCRef.getNameNamePair().addAll((Collection)cRef.getNameNamePair());
                if (GlobalDefs.contains(subClasses, subCRef)) continue;
                subClasses.add(subCRef);
            }
            ClassSig polySig = this.factory().createClassSig(subClasses, cSig.getState(), (List)cSig.getAttribute(), (List)cSig.getOperation());
            ClassPolyType polyClass = this.factory().createClassPolyType(polySig, classRefType.getThisClass());
            type = this.factory().createPowerType((Type2)polyClass);
        }
        this.addTypeAnn((TermA)polyExpr, (Type)type);
        return type;
    }

    public Object visitContainmentExpr(ContainmentExpr containmentExpr) {
        UnknownType type = this.factory().createUnknownType();
        Expr expr = containmentExpr.getExpr();
        Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
        PowerType vPowerType = this.factory().createPowerType();
        UResult unified = this.strongUnify((Type2)vPowerType, exprType);
        if (!net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(vPowerType.getType(), ClassRefType.class) && !net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(vPowerType.getType(), VariableType.class)) {
            Object[] params = new Object[]{containmentExpr, exprType};
            this.error((TermA)containmentExpr, ErrorMessage.NON_REF_IN_CONTAINMENTEXPR, params);
        } else if (vPowerType.getType() instanceof ClassRefType) {
            type = exprType;
        }
        this.addTypeAnn((TermA)containmentExpr, (Type)type);
        return type;
    }

    public Object visitPredExpr(PredExpr predExpr) {
        UnknownType type = this.factory().createUnknownType();
        Pred pred = predExpr.getPred();
        UResult solved = (UResult)((Object)pred.accept((Visitor)this.predChecker()));
        if (solved == net.sourceforge.czt.typecheck.z.util.GlobalDefs.SUCC) {
            type = this.factory().createBoolType();
        }
        this.addTypeAnn((TermA)predExpr, (Type)type);
        return type;
    }

    public Object visitBindSelExpr(BindSelExpr bindSelExpr) {
        UnknownType type = this.factory().createUnknownType();
        Expr expr = bindSelExpr.getExpr();
        Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
        if (!net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(exprType = this.resolveClassType(exprType), VariableType.class)) {
            if (exprType instanceof SchemaType) {
                type = (Type2)this.zExprChecker_.visitBindSelExpr(bindSelExpr);
            } else if (exprType instanceof ClassType) {
                ClassType classType = (ClassType)exprType;
                ClassSig classSig = classType.getClassSig();
                RefName selectName = bindSelExpr.getName();
                if (!net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(classSig, VariableClassSig.class)) {
                    Object[] params;
                    Signature signature = classSig.getState();
                    NameTypePair pair = this.findNameTypePair(selectName, signature);
                    if (pair == null) {
                        ListTerm pairs = classSig.getAttribute();
                        pair = this.findNameTypePair(selectName, (List<NameTypePair>)pairs);
                    }
                    if (pair == null) {
                        params = new Object[]{bindSelExpr};
                        this.error((TermA)selectName, ErrorMessage.NON_EXISTENT_SELECTION, params);
                    } else {
                        type = pair.getType();
                    }
                    if (pair != null && !GlobalDefs.isVisible(selectName, exprType)) {
                        params = new Object[]{selectName, bindSelExpr};
                        this.error((TermA)bindSelExpr, ErrorMessage.NON_VISIBLE_NAME_IN_SELEXPR, params);
                    }
                }
            } else {
                Object[] params = new Object[]{bindSelExpr, exprType};
                this.error((TermA)bindSelExpr, ErrorMessage.NON_BINDING_IN_BINDSELEXPR, params);
            }
        }
        if (type instanceof Type2) {
            type = this.resolveUnknownType((Type2)type);
        } else if (type instanceof GenericType) {
            GenericType gType = (GenericType)type;
            List<VariableType> instantiations = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list();
            ParameterAnn pAnn = (ParameterAnn)bindSelExpr.getAnn(ParameterAnn.class);
            this.unificationEnv().enterScope();
            ListTerm declNames = gType.getName();
            for (DeclName declName : declNames) {
                VariableType vType = this.factory().createVariableType();
                this.unificationEnv().addGenName(declName, vType);
                instantiations.add(vType);
            }
            type = (GenericType)this.instantiate((Type)gType);
            if (pAnn != null) {
                net.sourceforge.czt.typecheck.z.util.GlobalDefs.removeAnn((TermA)bindSelExpr, pAnn);
            }
            pAnn = new ParameterAnn(instantiations);
            net.sourceforge.czt.typecheck.z.util.GlobalDefs.addAnn((TermA)bindSelExpr, pAnn);
            this.unificationEnv().exitScope();
            if (!net.sourceforge.czt.typecheck.z.util.GlobalDefs.containsObject(this.paraErrors(), bindSelExpr)) {
                this.paraErrors().add(bindSelExpr);
            }
        }
        this.addTypeAnn((TermA)bindSelExpr, (Type)type);
        Type2 result = net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType((Type)type);
        return result;
    }

    public Object visitRenameExpr(RenameExpr renameExpr) {
        UnknownType type = this.factory().createUnknownType();
        Expr expr = renameExpr.getExpr();
        Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
        PowerType vPowerType = this.factory().createPowerType();
        UResult unified = this.strongUnify((Type2)vPowerType, exprType);
        if (unified == net.sourceforge.czt.typecheck.z.util.GlobalDefs.FAIL) {
            Object[] params = new Object[]{renameExpr, exprType};
            this.error((TermA)renameExpr, ErrorMessage.NON_SCHEXPR_IN_RENAMEEXPR, params);
        } else if (!net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(vPowerType.getType(), VariableType.class)) {
            if (vPowerType.getType() instanceof ClassRefType) {
                ClassRefType classRefType = (ClassRefType)vPowerType.getType();
                ClassSig classSig = classRefType.getClassSig();
                if (!net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(classSig, VariableClassSig.class)) {
                    String errorMessage = ErrorMessage.DUPLICATE_NAME_IN_RENAMEEXPR.toString();
                    ClassSig renameClassSig = this.createRenameClassSig(classSig, renameExpr, errorMessage);
                    ClassRef renameThisClass = this.rename(classRefType.getThisClass(), renameExpr);
                    List<DeclName> renamePrimary = this.renamePrimary((List<DeclName>)classRefType.getPrimary(), renameExpr);
                    ClassRefType newRefType = this.factory().createClassRefType(renameClassSig, renameThisClass, (List)classRefType.getSuperClass(), classRefType.getVisibilityList(), renamePrimary);
                    type = this.factory().createPowerType((Type2)newRefType);
                }
            } else if (vPowerType.getType() instanceof SchemaType) {
                type = (Type2)this.zExprChecker_.visitRenameExpr(renameExpr);
            } else {
                Object[] params = new Object[]{renameExpr, exprType};
                this.error((TermA)renameExpr, ErrorMessage.NON_SCHEXPR_IN_RENAMEEXPR, params);
            }
        }
        this.addTypeAnn((TermA)renameExpr, (Type)type);
        return type;
    }
}

