/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.oz;

import java.io.Writer;
import java.util.Collection;
import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.oz.ast.AnonOpExpr;
import net.sourceforge.czt.oz.ast.ClassPara;
import net.sourceforge.czt.oz.ast.ClassPolyType;
import net.sourceforge.czt.oz.ast.ClassRef;
import net.sourceforge.czt.oz.ast.ClassRefType;
import net.sourceforge.czt.oz.ast.ClassSig;
import net.sourceforge.czt.oz.ast.ClassType;
import net.sourceforge.czt.oz.ast.ClassUnionExpr;
import net.sourceforge.czt.oz.ast.ClassUnionType;
import net.sourceforge.czt.oz.ast.ConjOpExpr;
import net.sourceforge.czt.oz.ast.NameSignaturePair;
import net.sourceforge.czt.oz.ast.OpExpr;
import net.sourceforge.czt.oz.ast.OpText;
import net.sourceforge.czt.oz.ast.PolyExpr;
import net.sourceforge.czt.print.oz.PrintUtils;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.typecheck.oz.ErrorAnn;
import net.sourceforge.czt.typecheck.oz.ErrorMessage;
import net.sourceforge.czt.typecheck.oz.TypeCheckUtils;
import net.sourceforge.czt.typecheck.oz.TypeChecker;
import net.sourceforge.czt.typecheck.oz.impl.Factory;
import net.sourceforge.czt.typecheck.oz.impl.VariableClassSig;
import net.sourceforge.czt.typecheck.oz.util.CarrierSet;
import net.sourceforge.czt.typecheck.oz.util.GlobalDefs;
import net.sourceforge.czt.typecheck.oz.util.UnificationEnv;
import net.sourceforge.czt.typecheck.z.impl.UnknownType;
import net.sourceforge.czt.typecheck.z.util.TypeEnv;
import net.sourceforge.czt.typecheck.z.util.UResult;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.AndPred;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.GenericType;
import net.sourceforge.czt.z.ast.InStroke;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.NameNamePair;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.OutStroke;
import net.sourceforge.czt.z.ast.PowerType;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.RenameExpr;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.Type2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Checker
extends net.sourceforge.czt.typecheck.z.Checker {
    protected TypeChecker typeChecker_;

    public Checker(TypeChecker typeChecker) {
        super(typeChecker);
        this.typeChecker_ = typeChecker;
    }

    @Override
    protected Factory factory() {
        return this.typeChecker_.ozFactory_;
    }

    protected Checker opExprChecker() {
        return this.typeChecker_.opExprChecker_;
    }

    protected TypeEnv downcastEnv() {
        return this.typeChecker_.downcastEnv_;
    }

    protected DeclName className() {
        return this.typeChecker_.classPara_.getName();
    }

    protected ClassPara classPara() {
        return this.typeChecker_.classPara_;
    }

    protected void setClassPara(ClassPara classPara) {
        this.typeChecker_.classPara_ = classPara;
    }

    protected List<DeclName> primary() {
        return this.typeChecker_.primary_;
    }

    protected void resetPrimary() {
        this.typeChecker_.primary_.clear();
    }

    @Override
    protected List typecheck(TermA termA, SectionInfo sectInfo) {
        return TypeCheckUtils.typecheck((Term)termA, sectInfo, this.markup());
    }

    protected void error(TermA termA, ErrorMessage error, Object[] params) {
        ErrorAnn errorAnn = this.errorAnn(termA, error, params);
        this.error(termA, errorAnn);
    }

    @Override
    protected void error(TermA termA, net.sourceforge.czt.typecheck.z.ErrorMessage error, Object[] params) {
        ErrorAnn errorAnn = this.errorAnn(termA, error.toString(), params);
        this.error(termA, errorAnn);
    }

    protected ErrorAnn errorAnn(TermA termA, ErrorMessage error, Object[] params) {
        ErrorAnn errorAnn = new ErrorAnn(error.toString(), params, this.sectInfo(), this.sectName(), this.nearestLocAnn(termA), this.markup());
        return errorAnn;
    }

    @Override
    protected ErrorAnn errorAnn(TermA termA, String error, Object[] params) {
        ErrorAnn errorAnn = new ErrorAnn(error, params, this.sectInfo(), this.sectName(), this.nearestLocAnn(termA), this.markup());
        return errorAnn;
    }

    protected UResult strongUnify(Type2 typeA, Type2 typeB) {
        UnificationEnv unificationEnv = (UnificationEnv)this.unificationEnv();
        return unificationEnv.strongUnify(typeA, typeB);
    }

    protected UResult weakUnify(Type2 typeA, Type2 typeB) {
        UnificationEnv unificationEnv = (UnificationEnv)this.unificationEnv();
        return unificationEnv.weakUnify(typeA, typeB);
    }

    @Override
    protected Type getType(RefName name) {
        Type type = this.downcastEnv().getType(name);
        if (type instanceof UnknownType || type instanceof UnknownType && net.sourceforge.czt.typecheck.z.util.GlobalDefs.unknownType(type).getRefName() != null) {
            type = super.getType(name);
        }
        return type;
    }

    protected void traverseForDowncasts(Pred pred) {
        MemPred memPred;
        boolean mixfix;
        if (pred instanceof AndPred) {
            AndPred andPred = (AndPred)pred;
            Pred leftPred = andPred.getLeftPred();
            Pred rightPred = andPred.getRightPred();
            this.traverseForDowncasts(leftPred);
            this.traverseForDowncasts(rightPred);
        } else if (pred instanceof MemPred && !(mixfix = (memPred = (MemPred)pred).getMixfix().booleanValue())) {
            memPred.accept((Visitor)this.predChecker());
        }
    }

    protected void traverseForDowncasts(OpExpr opExpr) {
        if (opExpr instanceof ConjOpExpr) {
            ConjOpExpr conjOpExpr = (ConjOpExpr)opExpr;
            OpExpr leftOpExpr = conjOpExpr.getLeftOpExpr();
            OpExpr rightOpExpr = conjOpExpr.getRightOpExpr();
            this.traverseForDowncasts(leftOpExpr);
            this.traverseForDowncasts(rightOpExpr);
        } else if (opExpr instanceof AnonOpExpr) {
            AnonOpExpr anonOpExpr = (AnonOpExpr)opExpr;
            OpText opText = anonOpExpr.getOpText();
            SchText schText = opText.getSchText();
            List<NameTypePair> pairs = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list();
            ListTerm decls = schText.getDecl();
            for (Decl decl : decls) {
                pairs.addAll((List)decl.accept((Visitor)this.declChecker()));
            }
            this.downcastEnv().enterScope();
            for (NameTypePair pair : pairs) {
                this.downcastEnv().add(pair.getName(), pair.getType());
            }
            this.traverseForDowncasts(schText.getPred());
            this.downcastEnv().exitScope();
        }
    }

    protected void inheritFeature(List<NameTypePair> source, List<NameTypePair> target, Expr expr) {
        for (NameTypePair pair : source) {
            DeclName sourceName = pair.getName();
            NameTypePair existing = this.findNameTypePair(sourceName, target);
            if (existing != null) {
                Type2 existingType;
                Type2 sourceType = net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType(pair.getType());
                UResult unified = this.unify(sourceType, existingType = net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType(existing.getType()));
                if (unified != net.sourceforge.czt.typecheck.z.util.GlobalDefs.FAIL) continue;
                Object[] params = new Object[]{sourceName, sourceType, existingType};
                this.error((TermA)expr, ErrorMessage.INCOMPATIBLE_INHERIT, params);
                continue;
            }
            this.typeEnv().add(pair);
            target.add(pair);
        }
    }

    protected void inheritOps(List<NameSignaturePair> source, List<NameSignaturePair> target, Expr expr) {
        for (NameSignaturePair pair : source) {
            DeclName sourceName = pair.getName();
            NameSignaturePair existing = this.findNameSigPair(sourceName, target);
            if (existing != null) {
                Signature existingSignature;
                Signature sourceSignature = pair.getSignature();
                UResult unified = this.unify(sourceSignature, existingSignature = existing.getSignature());
                if (unified != net.sourceforge.czt.typecheck.z.util.GlobalDefs.FAIL) continue;
                Object[] params = new Object[]{sourceName, sourceSignature, existingSignature};
                this.error((TermA)expr, ErrorMessage.INCOMPATIBLE_OP_INHERIT, params);
                continue;
            }
            target.add(pair);
        }
    }

    protected ClassRefType getSelfType() {
        RefName refName = this.factory().createRefName("self", net.sourceforge.czt.typecheck.z.util.GlobalDefs.list(), null);
        RefExpr refExpr = this.factory().createRefExpr(refName, net.sourceforge.czt.typecheck.z.util.GlobalDefs.list(), Boolean.FALSE);
        Type2 selfType = (Type2)refExpr.accept((Visitor)this.exprChecker());
        assert (selfType instanceof ClassRefType);
        ClassRefType result = (ClassRefType)selfType;
        return result;
    }

    protected ClassSig getSelfSig() {
        ClassRefType classType = this.getSelfType();
        ClassSig result = classType.getClassSig();
        return result;
    }

    protected boolean isSelfExpr(Expr expr) {
        boolean result = false;
        if (expr instanceof RefExpr) {
            RefExpr refExpr = (RefExpr)expr;
            RefName refName = refExpr.getRefName();
            result = refName.getWord().equals("self") && refName.getStroke().size() == 0;
        }
        return result;
    }

    protected Signature intersect(Signature sigA, Signature sigB) {
        Signature signature = this.factory().createSignature();
        ListTerm pairsA = sigA.getNameTypePair();
        ListTerm pairsB = sigB.getNameTypePair();
        for (NameTypePair pairA : pairsA) {
            NameTypePair pairB = this.findNameTypePair(pairA.getName(), sigB);
            if (pairB == null) continue;
            signature.getNameTypePair().add((Object)pairA);
            signature.getNameTypePair().add((Object)pairB);
        }
        return signature;
    }

    protected void merge(ClassSig newSig, ClassSig oldSig, TermA termA) {
        ListTerm attrDecls = newSig.getAttribute();
        attrDecls.addAll(oldSig.getAttribute());
        this.checkForDuplicates((List<NameTypePair>)attrDecls, termA, ErrorMessage.INCOMPATIBLE_OVERRIDING);
        ListTerm stateDecls = newSig.getState().getNameTypePair();
        stateDecls.addAll(oldSig.getState().getNameTypePair());
        this.checkForDuplicates((List<NameTypePair>)stateDecls, termA, ErrorMessage.INCOMPATIBLE_OVERRIDING);
        ListTerm newPairs = newSig.getOperation();
        for (NameSignaturePair newPair : newPairs) {
            DeclName declName = newPair.getName();
            NameSignaturePair oldPair = this.findNameSigPair(declName, (List<NameSignaturePair>)oldSig.getOperation());
            if (oldPair == null) {
                newSig.getOperation().add((Object)newPair);
                continue;
            }
            UResult unified = this.unify(oldPair.getSignature(), newPair.getSignature());
            if (unified != net.sourceforge.czt.typecheck.z.util.GlobalDefs.FAIL) continue;
            Object[] params = new Object[]{declName, termA};
            this.error((TermA)declName, ErrorMessage.INCOMPATIBLE_OVERRIDING, params);
        }
    }

    protected void addOperation(NameSignaturePair op, ClassSig cSig) {
        ListTerm ops = cSig.getOperation();
        DeclName opName = op.getName();
        NameSignaturePair existing = this.findOperation(opName, cSig);
        if (existing != null) {
            List<NameTypePair> pairs = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list(op.getSignature().getNameTypePair());
            pairs.addAll((Collection<NameTypePair>)existing.getSignature().getNameTypePair());
            this.checkForDuplicates(pairs, (TermA)opName, ErrorMessage.INCOMPATIBLE_OP_OVERRIDING);
            Signature newSig = this.factory().createSignature(pairs);
            NameSignaturePair newPair = this.factory().createNameSignaturePair(opName, newSig);
            cSig.getOperation().remove((Object)existing);
            cSig.getOperation().add((Object)newPair);
        } else {
            cSig.getOperation().add((Object)op);
        }
    }

    protected void checkForDuplicates(List<NameTypePair> pairs, TermA termA, ErrorMessage error) {
        this.checkForDuplicates(pairs, termA, error.toString());
    }

    protected void checkForDuplicates(List<DeclName> declNames) {
        for (int i = 0; i < declNames.size(); ++i) {
            DeclName first = declNames.get(i);
            for (int j = i + 1; j < declNames.size(); ++j) {
                DeclName second = declNames.get(j);
                if (!first.equals(second)) continue;
                Object[] params = new Object[]{second, this.className()};
                this.error((TermA)second, ErrorMessage.REDECLARED_NAME_IN_CLASSPARA, params);
            }
        }
    }

    protected void checkForDuplicates(ClassSig cSig, TermA termA, ErrorMessage errorMessage) {
        List<DeclName> decls = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list(this.className());
        ListTerm attrDecls = cSig.getAttribute();
        for (NameTypePair pair : attrDecls) {
            decls.add(pair.getName());
        }
        Signature stateSig = cSig.getState();
        ListTerm stateDecls = stateSig.getNameTypePair();
        for (NameTypePair pair : stateDecls) {
            decls.add(pair.getName());
        }
        ListTerm opDecls = cSig.getOperation();
        for (NameSignaturePair pair : opDecls) {
            decls.add(pair.getName());
        }
        for (int i = 0; i < decls.size(); ++i) {
            DeclName first = decls.get(i);
            for (int j = i + 1; j < decls.size(); ++j) {
                DeclName second = decls.get(j);
                if (!first.equals(second)) continue;
                Object[] params = new Object[]{first, termA};
                this.error((TermA)first, errorMessage, params);
            }
        }
    }

    protected void checkVisibility(ClassRefType superClass, ClassRefType subClass, List<NameTypePair> superPairs, List<NameTypePair> subPairs, PolyExpr polyExpr) {
        for (NameTypePair superPair : superPairs) {
            NameTypePair subPair;
            RefName superName = this.factory().createRefName(superPair.getName());
            if (!GlobalDefs.isVisible(superName, (Type2)superClass) || (subPair = this.findNameTypePair(superName, subPairs)) != null && GlobalDefs.isVisible(superName, (Type2)subClass)) continue;
            Object[] params = new Object[]{subClass.getThisClass().getRefName(), superName, superClass.getThisClass().getRefName(), polyExpr};
            this.error((TermA)polyExpr, ErrorMessage.NON_VISIBLE_FEATURE_IN_POLYEXPR, params);
        }
    }

    protected void checkOpVisibility(ClassRefType superClass, ClassRefType subClass, List<NameSignaturePair> superPairs, List<NameSignaturePair> subPairs, PolyExpr polyExpr) {
        for (NameSignaturePair superPair : superPairs) {
            Signature subSig;
            Signature superSig;
            UResult unified;
            RefName superName = this.factory().createRefName(superPair.getName());
            if (!GlobalDefs.isVisible(superName, (Type2)superClass)) continue;
            NameSignaturePair subPair = this.findNameSigPair(superName, subPairs);
            if (subPair == null || !GlobalDefs.isVisible(superName, (Type2)subClass)) {
                Object[] params = new Object[]{subClass.getThisClass().getRefName(), superName, superClass.getThisClass().getRefName(), polyExpr};
                this.error((TermA)polyExpr, ErrorMessage.NON_VISIBLE_FEATURE_IN_POLYEXPR, params);
                continue;
            }
            if (subPair == null || (unified = this.unify(superSig = superPair.getSignature(), subSig = subPair.getSignature())) != net.sourceforge.czt.typecheck.z.util.GlobalDefs.FAIL) continue;
            Object[] params = new Object[]{superName, polyExpr, subClass.getThisClass().getRefName(), superClass.getThisClass().getRefName(), superSig, subSig};
            this.error((TermA)polyExpr, ErrorMessage.INCOMPATIBLE_OP_IN_POLYEXPR, params);
        }
    }

    protected Signature createPloSig(Signature lSig, Signature rSig, TermA termA, String errorMessage) {
        List b3Pairs = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list(lSig.getNameTypePair());
        List b4Pairs = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list(rSig.getNameTypePair());
        ListTerm rPairs = rSig.getNameTypePair();
        for (NameTypePair rPair : rPairs) {
            Type2 rType;
            DeclName rName = rPair.getName();
            List<OutStroke> strokes = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list(rName.getStroke());
            int size = strokes.size();
            if (size <= 0 || !(strokes.get(size - 1) instanceof InStroke)) continue;
            OutStroke out = this.factory().createOutStroke();
            strokes.set(size - 1, out);
            DeclName sName = this.factory().createDeclName(rName.getWord(), strokes, null);
            NameTypePair foundPair = this.findNameTypePair(sName, lSig);
            if (foundPair == null) continue;
            Type2 fType = net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType(foundPair.getType());
            UResult unified = this.unify(fType, rType = net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType(rPair.getType()));
            if (unified == net.sourceforge.czt.typecheck.z.util.GlobalDefs.FAIL) {
                Object[] params = new Object[]{termA, sName, fType, rName, rType};
                this.error(termA, errorMessage, params);
            }
            b4Pairs.remove(rPair);
        }
        b3Pairs.addAll(b4Pairs);
        Signature result = this.factory().createSignature(b3Pairs);
        return result;
    }

    protected List<NameSignaturePair> renameOps(List<NameSignaturePair> ops, List<NameNamePair> namePairs) {
        List<NameSignaturePair> newPairs = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list();
        for (NameSignaturePair pair : ops) {
            NameNamePair namePair = this.findNameNamePair(pair.getName(), namePairs);
            if (namePair != null) {
                DeclName newName = namePair.getNewName();
                NameSignaturePair newPair = this.factory().createNameSignaturePair(newName, pair.getSignature());
                newPairs.add(newPair);
                continue;
            }
            newPairs.add(pair);
        }
        return newPairs;
    }

    protected List<DeclName> renamePrimary(List<DeclName> primaryNames, RenameExpr renameExpr) {
        List<DeclName> newPrimaryNames = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list();
        ListTerm pairs = renameExpr.getNameNamePair();
        for (DeclName primaryName : primaryNames) {
            NameNamePair pair = this.findNameNamePair(primaryName, (List<NameNamePair>)pairs);
            if (pair == null) {
                newPrimaryNames.add(primaryName);
                continue;
            }
            newPrimaryNames.add(pair.getNewName());
        }
        return newPrimaryNames;
    }

    protected ClassSig createRenameClassSig(ClassSig cSig, RenameExpr renameExpr, String errorMessage) {
        ListTerm namePairs = renameExpr.getNameNamePair();
        this.checkForDuplicateRenames((List<NameNamePair>)namePairs, (TermA)renameExpr, errorMessage);
        ListTerm attrs = cSig.getAttribute();
        Signature attrSig = this.factory().createSignature((List)attrs);
        Signature newAttrSig = this.rename(attrSig, (List<NameNamePair>)namePairs);
        ListTerm newAttrs = newAttrSig.getNameTypePair();
        Signature state = cSig.getState();
        Signature newState = this.rename(state, (List<NameNamePair>)namePairs);
        ListTerm ops = cSig.getOperation();
        List<NameSignaturePair> newOps = this.renameOps((List<NameSignaturePair>)ops, (List<NameNamePair>)namePairs);
        ClassSig result = this.factory().createClassSig((List)cSig.getClasses(), newState, (List)newAttrs, newOps);
        this.checkForDuplicates(result, (TermA)renameExpr, ErrorMessage.REDECLARED_NAME_IN_RENAMEEXPR);
        return result;
    }

    @Override
    protected Type2 instantiate(Type2 type, List<Type2> preTypes) {
        UnknownType result = this.factory().createUnknownType();
        if (type instanceof ClassType) {
            ClassRef classRef;
            ClassType classType = (ClassType)type;
            ClassSig cSig = classType.getClassSig();
            if (!net.sourceforge.czt.typecheck.z.util.GlobalDefs.containsObject(preTypes, classType)) {
                preTypes.add((Type2)classType);
            }
            ClassSig newCSig = null;
            if (!(cSig instanceof VariableClassSig)) {
                Signature state = cSig.getState();
                Signature newState = null;
                if (state != null) {
                    newState = this.instantiate(state, preTypes);
                }
                ListTerm attrs = cSig.getAttribute();
                List<NameTypePair> newAttrs = this.instantiatePairs((List<NameTypePair>)attrs, preTypes);
                ListTerm ops = cSig.getOperation();
                List<NameSignaturePair> newOps = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list();
                for (NameSignaturePair pair : ops) {
                    Signature signature = this.instantiate(pair.getSignature(), preTypes);
                    NameSignaturePair newPair = this.factory().createNameSignaturePair(pair.getName(), signature);
                    newOps.add(newPair);
                }
                ListTerm classRefs = cSig.getClasses();
                List<ClassRef> newClassRefs = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list();
                for (ClassRef classRef2 : classRefs) {
                    List<Type2> types = this.instantiateTypes((List<Type2>)classRef2.getType2(), preTypes);
                    ClassRef newClassRef = this.factory().createClassRef(classRef2.getRefName(), types, net.sourceforge.czt.typecheck.z.util.GlobalDefs.list());
                    newClassRefs.add(newClassRef);
                }
                newCSig = this.factory().createClassSig(newClassRefs, newState, newAttrs, newOps);
            }
            if (type instanceof ClassRefType) {
                ClassRefType classRefType = (ClassRefType)type;
                classRef = this.instantiate(classRefType.getThisClass(), preTypes);
                result = this.factory().createClassRefType(newCSig, classRef, (List)classRefType.getSuperClass(), classRefType.getVisibilityList(), (List)classRefType.getPrimary());
            } else if (type instanceof ClassPolyType) {
                ClassPolyType classPolyType = (ClassPolyType)type;
                classRef = this.instantiate(classPolyType.getRootClass(), preTypes);
                result = this.factory().createClassPolyType(newCSig, classRef);
            } else {
                ClassUnionType classUnionType = (ClassUnionType)type;
                result = this.factory().createClassUnionType(newCSig);
            }
        } else {
            result = super.instantiate(type, preTypes);
        }
        return result;
    }

    protected ClassRef instantiate(ClassRef classRef, List<Type2> preTypes) {
        List<Type2> types = this.instantiateTypes((List<Type2>)classRef.getType2(), preTypes);
        ClassRef result = this.factory().createClassRef(classRef.getRefName(), types, net.sourceforge.czt.typecheck.z.util.GlobalDefs.list());
        return result;
    }

    protected List<ClassRef> getClasses(Type2 type) {
        List<ClassRef> classes = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list();
        if (type instanceof ClassType) {
            ClassType classType = (ClassType)type;
            classes = this.getClasses(classType.getClassSig());
        }
        return classes;
    }

    protected List<ClassRef> getClasses(ClassSig cSig) {
        ListTerm classes = cSig.getClasses();
        return classes;
    }

    protected NameTypePair findAttribute(DeclName declName, ClassSig cSig) {
        NameTypePair result = this.findNameTypePair(declName, (List<NameTypePair>)cSig.getAttribute());
        return result;
    }

    protected NameTypePair findStateDecl(DeclName declName, ClassSig cSig) {
        ListTerm decls = cSig.getState().getNameTypePair();
        NameTypePair result = this.findNameTypePair(declName, (List<NameTypePair>)decls);
        return result;
    }

    protected NameSignaturePair findOperation(DeclName declName, ClassSig cSig) {
        NameSignaturePair result = this.findNameSigPair(declName, (List<NameSignaturePair>)cSig.getOperation());
        return result;
    }

    protected NameSignaturePair findOperation(RefName refName, ClassSig cSig) {
        DeclName declName = this.factory().createDeclName(refName);
        NameSignaturePair result = this.findOperation(declName, cSig);
        return result;
    }

    protected NameSignaturePair findNameSigPair(RefName refName, List<NameSignaturePair> pairs) {
        DeclName declName = this.factory().createDeclName(refName);
        NameSignaturePair result = this.findNameSigPair(declName, pairs);
        return result;
    }

    protected NameSignaturePair findNameSigPair(DeclName declName, List<NameSignaturePair> pairs) {
        NameSignaturePair result = null;
        for (NameSignaturePair pair : pairs) {
            if (!declName.equals(pair.getName())) continue;
            result = pair;
            break;
        }
        return result;
    }

    protected ClassRef findRef(RefName refName, List<ClassRef> classRefs) {
        ClassRef result = null;
        for (ClassRef classRef : classRefs) {
            if (!refName.equals(classRef.getRefName())) continue;
            result = classRef;
        }
        return result;
    }

    @Override
    protected Type2 resolveUnknownType(Type2 type) {
        Type2 result = type;
        if (this.sectTypeEnv().getSecondTime() && type instanceof UnknownType) {
            UnknownType uType = (UnknownType)type;
            Type2 resolved = super.resolveUnknownType((Type2)uType);
            result = this.renameClassType(resolved, uType.getPairs());
        }
        return result;
    }

    protected Type2 renameClassType(Type2 type, List<NameNamePair> pairs) {
        Type2 result = type;
        if (type instanceof ClassType && pairs.size() > 0) {
            ClassType classType = (ClassType)type;
            ClassSig cSig = classType.getClassSig();
            ListTerm attrs = cSig.getAttribute();
            Signature attrSig = this.factory().createSignature((List)attrs);
            Signature newAttrSig = this.rename(attrSig, pairs);
            ListTerm newAttrs = newAttrSig.getNameTypePair();
            Signature state = cSig.getState();
            Signature newState = this.rename(state, pairs);
            ListTerm ops = cSig.getOperation();
            List<NameSignaturePair> newOps = this.renameOps((List<NameSignaturePair>)ops, pairs);
            ClassSig newCSig = this.factory().createClassSig((List)cSig.getClasses(), newState, (List)newAttrs, newOps);
            result = (Type2)classType.create(result.getChildren());
            ((ClassType)result).setClassSig(newCSig);
        }
        return result;
    }

    protected Type2 lookupClass(ClassRef classRef) {
        UnknownType result = this.factory().createUnknownType();
        Type refType = this.getType(classRef.getRefName());
        if (refType instanceof GenericType) {
            ListTerm names = net.sourceforge.czt.typecheck.z.util.GlobalDefs.genericType(refType).getName();
            ListTerm types = classRef.getType2();
            if (names.size() == types.size()) {
                Type newType;
                this.unificationEnv().enterScope();
                for (int i = 0; i < names.size(); ++i) {
                    this.unificationEnv().addGenName((DeclName)names.get(i), (Type2)types.get(i));
                }
                refType = newType = this.instantiate(refType);
                this.unificationEnv().exitScope();
            }
        }
        if (net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType(refType) instanceof PowerType) {
            PowerType powerType = (PowerType)net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType(refType);
            result = this.renameClassType(powerType.getType(), (List<NameNamePair>)classRef.getNameNamePair());
        }
        return result;
    }

    protected Type2 unionClasses(ClassUnionExpr classUnionExpr, Type2 lType, Type2 rType) {
        UnknownType result = this.factory().createUnknownType();
        if (lType instanceof ClassType && rType instanceof ClassType) {
            ClassType lClassType = (ClassType)lType;
            ClassType rClassType = (ClassType)rType;
            ClassSig lcSig = lClassType.getClassSig();
            ClassSig rcSig = rClassType.getClassSig();
            List classes = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list();
            Signature state = this.factory().createSignature();
            List<NameTypePair> attrs = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list();
            List<NameSignaturePair> ops = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list();
            ListTerm lsPairs = lcSig.getState().getNameTypePair();
            ListTerm rsPairs = rcSig.getState().getNameTypePair();
            for (NameTypePair lPair : lsPairs) {
                NameTypePair rPair = this.findNameTypePair(lPair.getName(), (List<NameTypePair>)rsPairs);
                if (rPair == null) continue;
                state.getNameTypePair().add((Object)lPair);
                state.getNameTypePair().add((Object)rPair);
            }
            if (classUnionExpr != null) {
                this.checkForDuplicates((List<NameTypePair>)state.getNameTypePair(), (TermA)classUnionExpr, ErrorMessage.INCOMPATIBLE_FEATURE_IN_CLASSUNIONEXPR);
            }
            ListTerm laPairs = lcSig.getAttribute();
            ListTerm raPairs = rcSig.getAttribute();
            for (NameTypePair lPair : laPairs) {
                NameTypePair rPair = this.findNameTypePair(lPair.getName(), (List<NameTypePair>)raPairs);
                if (rPair == null) continue;
                attrs.add(lPair);
                attrs.add(rPair);
            }
            if (classUnionExpr != null) {
                this.checkForDuplicates(attrs, (TermA)classUnionExpr, ErrorMessage.INCOMPATIBLE_FEATURE_IN_CLASSUNIONEXPR);
            }
            ListTerm loPairs = lcSig.getOperation();
            ListTerm roPairs = rcSig.getOperation();
            for (NameSignaturePair lPair : loPairs) {
                Signature rSig;
                DeclName lName = lPair.getName();
                NameSignaturePair rPair = this.findOperation(lName, rcSig);
                if (rPair == null) continue;
                Signature lSig = lPair.getSignature();
                UResult unified = this.unify(lSig, rSig = rPair.getSignature());
                if (unified == net.sourceforge.czt.typecheck.z.util.GlobalDefs.FAIL && classUnionExpr != null) {
                    Object[] params = new Object[]{lName, classUnionExpr, lSig, rSig};
                    this.error((TermA)lName, ErrorMessage.INCOMPATIBLE_OP_IN_CLASSUNIONEXPR, params);
                    continue;
                }
                ops.add(lPair);
            }
            classes.addAll(lcSig.getClasses());
            classes.addAll(rcSig.getClasses());
            ClassSig cSig = this.factory().createClassSig(classes, state, attrs, ops);
            result = this.factory().createClassUnionType(cSig);
        }
        return result;
    }

    protected Type2 resolveClassType(Type2 type) {
        Type2 result = type;
        if (type instanceof ClassUnionType && this.sectTypeEnv().getSecondTime()) {
            ClassUnionType cuType = (ClassUnionType)type;
            ClassSig cSig = cuType.getClassSig();
            ListTerm classes = cSig.getClasses();
            assert (classes.size() > 1);
            Type2 firstType = this.lookupClass((ClassRef)classes.get(0));
            Type2 secondType = this.lookupClass((ClassRef)classes.get(1));
            Type2 unioned = this.unionClasses(null, firstType, secondType);
            for (int i = 2; i < classes.size(); ++i) {
                Type2 nextType = this.lookupClass((ClassRef)classes.get(0));
                unioned = this.unionClasses(null, unioned, nextType);
            }
            result = unioned;
        } else if (type instanceof ClassType && this.sectTypeEnv().getSecondTime()) {
            ClassRef classRef = null;
            if (type instanceof ClassRefType) {
                ClassRefType classRefType = (ClassRefType)type;
                classRef = classRefType.getThisClass();
            } else if (type instanceof ClassPolyType) {
                ClassPolyType classPolyType = (ClassPolyType)type;
                classRef = classPolyType.getRootClass();
            }
            result = this.lookupClass(classRef);
        }
        return result;
    }

    protected ClassRef rename(ClassRef classRef, RenameExpr renameExpr) {
        ListTerm cfPairs = classRef.getNameNamePair();
        ListTerm rnPairs = renameExpr.getNameNamePair();
        List<NameNamePair> newPairs = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list();
        for (NameNamePair rnPair : rnPairs) {
            NameNamePair cfPair = this.findNameNamePair(rnPair.getNewName(), (List<NameNamePair>)cfPairs);
            if (cfPair == null) {
                newPairs.add(rnPair);
                continue;
            }
            NameNamePair newPair = this.factory().createNameNamePair(cfPair.getOldName(), rnPair.getNewName());
        }
        ClassRef result = this.factory().createClassRef(classRef.getRefName(), (List)classRef.getType2(), newPairs);
        return result;
    }

    @Override
    protected CarrierSet getCarrierSet() {
        return new CarrierSet(true);
    }

    @Override
    protected void print(Term term, Writer writer, SectionInfo sectInfo, String sectName, Markup markup) {
        PrintUtils.print((Term)term, (Writer)writer, (SectionInfo)sectInfo, (String)sectName, (Markup)this.markup());
    }

    @Override
    public String toString(Type type) {
        String result = new String();
        if (net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType(type) instanceof PowerType && net.sourceforge.czt.typecheck.z.util.GlobalDefs.powerType(net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType(type)).getType() instanceof ClassRefType) {
            ClassRefType ctype = (ClassRefType)net.sourceforge.czt.typecheck.z.util.GlobalDefs.powerType(net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType(type)).getType();
            result = "P " + this.classRefTypeToString(ctype);
        } else if (type instanceof ClassRefType) {
            ClassRefType ctype = (ClassRefType)type;
            result = this.classRefTypeToString(ctype);
        } else {
            result = type.toString();
        }
        return result;
    }

    public String classRefTypeToString(ClassRefType ctype) {
        NameTypePair pair;
        String result = new String();
        RefName className = ctype.getThisClass().getRefName();
        result = result + "(CLASS " + className + "\n";
        ClassSig csig = ctype.getClassSig();
        result = result + "\tATTR(" + className + ")\n";
        for (Object o : csig.getAttribute()) {
            pair = (NameTypePair)o;
            result = result + "\t\t" + pair.getName() + " : " + pair.getType() + "\n";
        }
        result = result + "\tSTATE(" + className + ")\n";
        for (Object o : csig.getState().getNameTypePair()) {
            pair = (NameTypePair)o;
            result = result + "\t\t" + pair.getName() + " : " + this.toString(pair.getType()) + "\n";
        }
        result = result + "\tOPS(" + className + ")\n";
        for (Object o : csig.getOperation()) {
            NameSignaturePair p = (NameSignaturePair)o;
            result = result + "\t\t" + p.getName() + " : " + p.getSignature();
        }
        result = result + ")";
        return result;
    }
}

