/*
 * Decompiled with CFR 0.152.
 */
package phw.util;

public class ComplexDouble
implements Cloneable {
    private double real;
    private double imag;

    public ComplexDouble(double d, double d2) {
        this.real = d;
        this.imag = d2;
    }

    public ComplexDouble add(ComplexDouble complexDouble) {
        this.real += complexDouble.real;
        this.imag += complexDouble.imag;
        return this;
    }

    public ComplexDouble addImag(double d) {
        this.imag += d;
        return this;
    }

    public ComplexDouble addReal(double d) {
        this.real += d;
        return this;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println(String.valueOf(String.valueOf(cloneNotSupportedException)) + " -- can't be happening !!!");
        }
        return object;
    }

    public ComplexDouble div(ComplexDouble complexDouble) {
        double d = complexDouble.real * complexDouble.real + complexDouble.imag * complexDouble.imag;
        double d2 = (this.real * complexDouble.real + this.imag * complexDouble.imag) / d;
        this.imag = (this.imag * complexDouble.real - this.real * complexDouble.imag) / d;
        this.real = d2;
        return this;
    }

    public double getImag() {
        return this.imag;
    }

    public double getReal() {
        return this.real;
    }

    public double modulus() {
        return Math.sqrt(this.real * this.real + this.imag * this.imag);
    }

    public double modulusSquared() {
        return this.real * this.real + this.imag * this.imag;
    }

    public ComplexDouble mult(ComplexDouble complexDouble) {
        double d = this.real * complexDouble.real - this.imag * complexDouble.imag;
        this.imag = this.imag * complexDouble.real + this.real * complexDouble.imag;
        this.real = d;
        return this;
    }

    public ComplexDouble scale(double d) {
        this.real *= d;
        this.imag *= d;
        return this;
    }

    public ComplexDouble set(double d, double d2) {
        this.real = d;
        this.imag = d2;
        return this;
    }

    public ComplexDouble set(ComplexDouble complexDouble) {
        this.real = complexDouble.real;
        this.imag = complexDouble.imag;
        return this;
    }

    public ComplexDouble setImag(double d) {
        this.imag = d;
        return this;
    }

    public ComplexDouble setReal(double d) {
        this.real = d;
        return this;
    }

    public ComplexDouble sub(ComplexDouble complexDouble) {
        this.real -= complexDouble.real;
        this.imag -= complexDouble.imag;
        return this;
    }
}

