/*
 * Decompiled with CFR 0.152.
 */
package jcircus.visitor;

import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import jcircus.environment.ChanInfoEnv;
import jcircus.environment.ChanSyncEnv;
import jcircus.environment.ChanUseEnv;
import jcircus.environment.Environment;
import jcircus.environment.NameTypeEnv;
import jcircus.environment.ProcChanEnv;
import jcircus.environment.ProcChanUseEnv;
import jcircus.exceptions.ChannelNotDefinedExceptionForProcess;
import jcircus.exceptions.InvalidParameterException;
import jcircus.exceptions.InvalidSubTypeException;
import jcircus.exceptions.JCircusException;
import jcircus.exceptions.UnrecoveredErrorException;
import jcircus.exceptions.VelocityException;
import jcircus.exceptions.VisitingMethodNotDefinedException;
import jcircus.util.ChanSync;
import jcircus.util.ChanUse;
import jcircus.util.CircusType;
import jcircus.util.Error;
import jcircus.util.ErrorMessage;
import jcircus.util.MathToolkitConstants;
import jcircus.util.NameType;
import jcircus.util.SignatureExpression;
import jcircus.util.Util;
import jcircus.visitor.TranslatorVisitorInterface;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.circus.ast.ActionD;
import net.sourceforge.czt.circus.ast.ActionIte;
import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.AssignmentCommand;
import net.sourceforge.czt.circus.ast.BasicNameSet;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.CallProcess;
import net.sourceforge.czt.circus.ast.CallType;
import net.sourceforge.czt.circus.ast.ChaosAction;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.DotField;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.ExtChoiceProcess;
import net.sourceforge.czt.circus.ast.Field;
import net.sourceforge.czt.circus.ast.GuardedAction;
import net.sourceforge.czt.circus.ast.HideProcess;
import net.sourceforge.czt.circus.ast.IfGuardedCommand;
import net.sourceforge.czt.circus.ast.InputField;
import net.sourceforge.czt.circus.ast.IntChoiceAction;
import net.sourceforge.czt.circus.ast.IntChoiceActionIte;
import net.sourceforge.czt.circus.ast.IntChoiceProcess;
import net.sourceforge.czt.circus.ast.IntChoiceProcessIte;
import net.sourceforge.czt.circus.ast.MuAction;
import net.sourceforge.czt.circus.ast.NameSet;
import net.sourceforge.czt.circus.ast.OutputField;
import net.sourceforge.czt.circus.ast.ParAction;
import net.sourceforge.czt.circus.ast.ParProcess;
import net.sourceforge.czt.circus.ast.ParProcessIte;
import net.sourceforge.czt.circus.ast.ParamAction;
import net.sourceforge.czt.circus.ast.ParamProcess;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.Process2;
import net.sourceforge.czt.circus.ast.ProcessIte;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circus.ast.RenameProcess;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.SeqActionIte;
import net.sourceforge.czt.circus.ast.SeqProcess;
import net.sourceforge.czt.circus.ast.SeqProcessIte;
import net.sourceforge.czt.circus.ast.SkipAction;
import net.sourceforge.czt.circus.ast.StopAction;
import net.sourceforge.czt.circus.ast.VarDeclCommand;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.AndPred;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.Box;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ExprPred;
import net.sourceforge.czt.z.ast.FalsePred;
import net.sourceforge.czt.z.ast.IffPred;
import net.sourceforge.czt.z.ast.ImpliesPred;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.NegPred;
import net.sourceforge.czt.z.ast.NumExpr;
import net.sourceforge.czt.z.ast.Op;
import net.sourceforge.czt.z.ast.OrPred;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.PowerExpr;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.ProdExpr;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.TruePred;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.util.Factory;
import net.sourceforge.czt.z.util.ZString;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslatorVisitor
implements TranslatorVisitorInterface {
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final int MIN = 0;
    private static final int MAX = 1;
    private static final int DECL_SCHEMA = 1;
    private static final int DECL_AXDEF = 2;
    private boolean externalChoice_ = false;
    private DeclName currentProcess_ = null;
    private DeclName currentAction_ = null;
    private Environment environment_;
    private String currentMuActionName_;
    private int index_ = -1;
    private int newIndex_;
    private boolean isPrivate_;
    private Factory factory_;
    private List<Error> errors_;

    public List<Error> getErrors() {
        return this.errors_;
    }

    private void reportError(Error error) {
        this.errors_.add(error);
    }

    private void reportFatalError(Error error) throws RuntimeException {
        this.reportError(error);
        throw new UnrecoveredErrorException("Error during the environment loading.");
    }

    public TranslatorVisitor(Environment environment) {
        this.environment_ = environment;
        this.currentProcess_ = null;
        this.factory_ = new Factory();
        this.errors_ = new ArrayList<Error>();
    }

    public Object visitTerm(Term term) {
        throw new VisitingMethodNotDefinedException(term.getClass(), this.getClass());
    }

    public Object visitAxPara(AxPara axPara) {
        String code = null;
        ListTerm gens = axPara.getDeclName();
        SchText schText = axPara.getSchText();
        Box box = axPara.getBox();
        if (box.equals((Object)Box.AxBox)) {
            ListTerm decl = schText.getDecl();
            Pred pred = schText.getPred();
            if (decl.size() == 1) {
                VarDecl varDecl = (VarDecl)decl.get(0);
                ListTerm names = varDecl.getDeclName();
                Expr expr = varDecl.getExpr();
                if (names.size() > 1) {
                    this.reportError(new Error(ErrorMessage.AXDEF_ONE_DECL, new Object[0]));
                }
                DeclName varName = (DeclName)names.get(0);
                CircusType circusType = Util.getCircusTypeAnn((TermA)varName);
                NameType nameType = Util.getNameTypeAnn((TermA)varName);
                boolean globalScope = nameType.equals((Object)NameType.GlobalConstant);
                code = this.axDefCode(varName.toString(), circusType, pred, globalScope);
            } else {
                this.reportError(new Error(ErrorMessage.AXDEF_ONE_DECL, new Object[0]));
            }
        } else if (box.equals((Object)Box.OmitBox)) {
            ListTerm decl = schText.getDecl();
            Pred pred = schText.getPred();
            ConstDecl constDecl = (ConstDecl)decl.get(0);
            DeclName declName = constDecl.getDeclName();
            Expr expr = constDecl.getExpr();
            CircusType circusType = Util.getCircusTypeAnn((TermA)declName);
            NameType nameType = Util.getNameTypeAnn((TermA)declName);
            boolean globalScope = nameType.equals((Object)NameType.GlobalConstant);
            code = this.horizDefCode(declName.toString(), circusType, expr, globalScope);
        } else if (box.equals((Object)Box.SchBox)) {
            code = "";
        }
        return code;
    }

    private String axDefCode(String methodName, CircusType circusType, Pred pred, boolean globalScope) {
        ListTerm exprs;
        String returnType = null;
        String paramType = null;
        Expr typeExpr = circusType.getExpression();
        if (typeExpr instanceof RefExpr) {
            boolean mixfix = ((RefExpr)typeExpr).getMixfix();
            exprs = ((RefExpr)typeExpr).getExpr();
            if (mixfix) {
                if (exprs.size() == 2) {
                    Expr paramExpr = (Expr)exprs.get(0);
                    Expr returnExpr = (Expr)exprs.get(1);
                    if (paramExpr instanceof RefExpr && returnExpr instanceof RefExpr) {
                        paramType = ((RefExpr)paramExpr).getRefName().toString();
                        returnType = ((RefExpr)returnExpr).getRefName().toString();
                        if (paramType.equals(ZString.NAT)) {
                            paramType = "CircusInteger";
                        }
                        if (returnType.equals(ZString.NAT)) {
                            returnType = "CircusInteger";
                        }
                    } else {
                        this.reportError(new Error(ErrorMessage.AXDEF_FORMAT));
                        System.out.println("AXDEF 1!");
                    }
                } else {
                    this.reportError(new Error(ErrorMessage.AXDEF_FORMAT));
                    System.out.println("AXDEF 2!");
                }
            } else {
                returnType = circusType.getJavaCircusTypeName();
            }
        } else if (typeExpr instanceof PowerExpr) {
            Expr expr = ((PowerExpr)typeExpr).getExpr();
            if (expr instanceof RefName) {
                returnType = "SetOfType";
            } else if (expr instanceof ProdExpr) {
                exprs = ((ProdExpr)expr).getExpr();
                if (exprs.size() == 2) {
                    Expr paramTypeExpr = (Expr)exprs.get(0);
                    Expr returnTypeExpr = (Expr)exprs.get(1);
                    if (paramTypeExpr instanceof RefExpr && returnTypeExpr instanceof RefExpr) {
                        CircusType circusTypeParam = Util.getCircusTypeAnn((TermA)((RefExpr)paramTypeExpr).getRefName());
                        CircusType circusTypeReturn = Util.getCircusTypeAnn((TermA)((RefExpr)returnTypeExpr).getRefName());
                        paramType = circusTypeParam.getJavaCircusTypeName();
                        returnType = circusTypeReturn.getJavaCircusTypeName();
                    } else {
                        this.reportError(new Error(ErrorMessage.AXDEF_FORMAT));
                        System.out.println("AXDEF 3!");
                    }
                } else {
                    this.reportError(new Error(ErrorMessage.AXDEF_FORMAT));
                    System.out.println("AXDEF 4!");
                }
            } else {
                this.reportError(new Error(ErrorMessage.AXDEF_FORMAT));
                System.out.println("AXDEF 5!");
            }
        } else {
            this.reportError(new Error(ErrorMessage.AXDEF_FORMAT));
            System.out.println("AXDEF 6!");
        }
        String parameters = "";
        String modifiers = "";
        if (paramType != null) {
            parameters = paramType + " p";
        }
        modifiers = globalScope ? "public static " : "private ";
        String code = modifiers + returnType + " " + methodName + "(" + parameters + ") {\n";
        code = code + returnType + " r = null;\n";
        code = code + this.axDefPredicateCode(pred);
        code = code + "return r;\n";
        code = code + "}";
        return code;
    }

    private String axDefPredicateCode(Pred pred) {
        String code = "";
        if (pred instanceof AndPred) {
            Pred rightPred = ((AndPred)pred).getRightPred();
            Pred leftPred = ((AndPred)pred).getLeftPred();
            code = code + this.axDefPredicateCode(rightPred);
            code = code + this.axDefPredicateCode(leftPred);
        } else if (pred instanceof MemPred) {
            Expr leftExpr = ((MemPred)pred).getLeftExpr();
            Expr rightExpr = ((MemPred)pred).getRightExpr();
            boolean mixfix = ((MemPred)pred).getMixfix();
            mixfix = !(rightExpr instanceof SetExpr);
            if (mixfix) {
                this.reportError(new Error(ErrorMessage.AXDEF_FORMAT));
            }
            Expr expr = (Expr)((SetExpr)rightExpr).getExpr().get(0);
            if (leftExpr instanceof RefExpr) {
                code = "r = " + expr.accept((Visitor)this) + ";\n";
            } else if (leftExpr instanceof ApplExpr) {
                Expr leftExpr2 = ((ApplExpr)leftExpr).getLeftExpr();
                Expr rightExpr2 = ((ApplExpr)leftExpr).getRightExpr();
                if (leftExpr2 instanceof RefExpr && rightExpr2 instanceof RefExpr) {
                    String functionName = ((RefExpr)leftExpr2).getRefName().toString();
                    String paramName = ((RefExpr)rightExpr2).getRefName().toString();
                    CircusType circusType = Util.getCircusTypeAnn((TermA)((RefExpr)rightExpr2).getRefName());
                    String type = circusType.getJavaCircusTypeName();
                    code = "if (p.equals(new " + type + "(" + type + "." + paramName + ")))\n";
                    code = code + "r = " + expr.accept((Visitor)this) + ";\n";
                } else {
                    this.reportError(new Error(ErrorMessage.AXDEF_FORMAT));
                }
            } else {
                this.reportError(new Error(ErrorMessage.AXDEF_FORMAT));
            }
        } else {
            this.reportError(new Error(ErrorMessage.AXDEF_FORMAT));
        }
        return code;
    }

    private String horizDefCode(String methodName, CircusType circusType, Expr expr, boolean globalScope) {
        String modifiers = globalScope ? "public static " : "private ";
        String returnType = circusType.getJavaCircusTypeName();
        String code = modifiers + returnType + " " + methodName + "() {\n";
        code = code + returnType + " r = null;\n";
        code = code + " r = " + expr.accept((Visitor)this);
        code = code + "return r;\n";
        code = code + "}";
        return code;
    }

    public Object visitProcessPara(ProcessPara processPara) {
        String code;
        DeclName declName = processPara.getDeclName();
        CircusProcess circusProcess = processPara.getCircusProcess();
        try {
            this.currentProcess_ = declName;
            code = this.attributesAndConstructor(processPara);
            code = code + "\npublic void run() {";
            code = code + (String)circusProcess.accept((Visitor)this) + ".run();";
            code = code + "\n}";
            this.currentProcess_ = null;
        }
        catch (Throwable t) {
            throw new JCircusException("Exception in process " + declName, t);
        }
        return code;
    }

    public Object visitActionPara(ActionPara actionPara) {
        String code = null;
        DeclName declName = actionPara.getDeclName();
        CircusAction circusAction = actionPara.getCircusAction();
        this.currentAction_ = declName;
        this.index_ = -1;
        String parameters = "";
        if (circusAction instanceof ActionD) {
            if (circusAction instanceof ParamAction) {
                ListTerm decls = ((ActionD)circusAction).getDecl();
                parameters = this.parameters((List)decls);
                circusAction = ((ActionD)circusAction).getCircusAction();
            } else if (circusAction instanceof ActionIte) {
                parameters = "";
            } else {
                throw new InvalidSubTypeException(circusAction.getClass());
            }
        }
        code = "private void " + declName.toString() + "(" + parameters + ") {" + (String)circusAction.accept((Visitor)this) + "\n}";
        this.currentAction_ = null;
        return code;
    }

    public Object visitBasicProcess(BasicProcess basicProcess) {
        int i;
        String code = null;
        RefName stateSchemaRefName = basicProcess.getStateSchema();
        CircusAction mainAction = basicProcess.getMainAction();
        ListTerm actionParas = basicProcess.getCircusActionPara();
        ListTerm zParas = basicProcess.getZPara();
        Template template = null;
        String stateDeclCode = "";
        String zParaCode = "";
        for (i = 0; i < zParas.size(); ++i) {
            Para para = (Para)zParas.get(i);
            if (!(para instanceof AxPara)) continue;
            zParaCode = zParaCode + para.accept((Visitor)this);
        }
        String actionsCode = "";
        for (i = 0; i < actionParas.size(); ++i) {
            ActionPara actionPara = (ActionPara)actionParas.get(i);
            CircusAction circusAction = actionPara.getCircusAction();
            actionsCode = actionsCode + actionPara.accept((Visitor)this);
        }
        if (stateSchemaRefName != null) {
            CircusType circusType = (CircusType)((Object)stateSchemaRefName.getAnn(CircusType.class));
            Signature signature = ((SignatureExpression)circusType.getExpression()).getSignature();
            stateDeclCode = this.visitingSignature(signature);
        } else {
            stateDeclCode = "";
        }
        String mainActionCode = (String)mainAction.accept((Visitor)this);
        try {
            VelocityContext velocityContext = new VelocityContext();
            Velocity.init();
            velocityContext.put("stateDecl", (Object)stateDeclCode);
            velocityContext.put("zParas", (Object)zParaCode);
            velocityContext.put("actionParas", (Object)actionsCode);
            velocityContext.put("mainAction", (Object)mainActionCode);
            template = Velocity.getTemplate((String)"BasicProcess.vm");
            StringWriter stringWriter = new StringWriter();
            template.merge((Context)velocityContext, (Writer)stringWriter);
            stringWriter.close();
            code = stringWriter.toString();
        }
        catch (Exception e) {
            throw new VelocityException("Velocity exception for basic process", e);
        }
        return code;
    }

    public Object visitCallProcess(CallProcess callProcess) {
        String code = null;
        RefName refName = callProcess.getRefName();
        CallType callType = callProcess.getCallType();
        Integer procId = Util.getIdCircusProcessAnn((TermA)callProcess).getId();
        if (callType == CallType.Normal) {
            code = "(new CSProcess() { public void run() {new " + refName.toString() + "(" + this.extractChans(refName.toString(), procId, null) + ").run(); } })";
        } else if (callType == CallType.Param) {
            ListTerm params = callProcess.getExpr();
            code = "(new CSProcess() { public void run() {new " + refName.toString() + "(" + this.extractChans(refName.toString(), procId, (List)params) + ").run(); } })";
        } else if (callType == CallType.Gen) {
            ListTerm exprs = callProcess.getExpr();
        } else if (callType == CallType.Index) {
            ListTerm exprs = callProcess.getExpr();
        } else {
            throw new InvalidParameterException("Invalid Parameter (" + callType.getClass() + "): " + callType.toString());
        }
        return code;
    }

    public Object visitHideProcess(HideProcess hideProcess) {
        String code = null;
        CircusProcess circusProcess = hideProcess.getCircusProcess();
        code = (String)circusProcess.accept((Visitor)this);
        return code;
    }

    public Object visitRenameProcess(RenameProcess renameProcess) {
        String code = null;
        CircusProcess circusProcess = renameProcess.getCircusProcess();
        ListTerm oldNames = renameProcess.getOldNames();
        ListTerm newNames = renameProcess.getNewNames();
        code = (String)circusProcess.accept((Visitor)this);
        code = Util.renameVars(code, (List)newNames, (List)oldNames);
        return code;
    }

    public Object visitIntChoiceProcess(IntChoiceProcess intChoiceProcess) {
        String code = null;
        List processes = this.getProcesses((CircusProcess)intChoiceProcess, 0);
        code = "(new CSProcess() { public void run() {";
        code = code + "int choosen = RandomGenerator.generateNumber(1, " + processes.size() + "); ";
        code = code + "switch(choosen) { ";
        for (int i = 0; i < processes.size(); ++i) {
            CircusProcess circusProcess = (CircusProcess)processes.get(i);
            code = code + "case " + (i + 1) + ": {" + (String)circusProcess.accept((Visitor)this) + ".run();" + " } break; ";
        }
        code = code + "} ";
        code = code + "} })";
        return code;
    }

    public Object visitParProcess(ParProcess parProcess) {
        String code = null;
        CircusProcess leftProc = parProcess.getLeftProc();
        CircusProcess rightProc = parProcess.getRightProc();
        code = "(new CSProcess() { public void run() {";
        code = code + "new Parallel( new CSProcess[] { " + (String)leftProc.accept((Visitor)this) + ", " + (String)rightProc.accept((Visitor)this) + "}).run();";
        code = code + "} })";
        return code;
    }

    public Object visitSeqProcess(SeqProcess seqProcess) {
        String code = null;
        CircusProcess leftProc = seqProcess.getLeftProc();
        CircusProcess rightProc = seqProcess.getRightProc();
        code = "(new CSProcess() { public void run() {";
        code = code + (String)leftProc.accept((Visitor)this) + ".run(); ";
        code = code + (String)rightProc.accept((Visitor)this) + ".run(); ";
        code = code + "} })";
        return code;
    }

    public Object visitParamProcess(ParamProcess paramProcess) {
        CircusProcess circusProcess = paramProcess.getCircusProcess();
        String code = (String)circusProcess.accept((Visitor)this);
        return code;
    }

    public Object visitIntChoiceProcessIte(IntChoiceProcessIte intChoiceProcessIte) {
        ListTerm decls = intChoiceProcessIte.getDecl();
        CircusProcess circusProcess = intChoiceProcessIte.getCircusProcess();
        ++this.index_;
        int index = this.index_;
        String codeProcessClass = "";
        Template template = null;
        String lAttributes = this.paramsDecl((List)decls);
        String lParamDeclConstructor = this.paramsArgs((List)decls);
        String lConstructorBody = this.assignParams((List)decls);
        String lMethodRun = (String)circusProcess.accept((Visitor)this) + ".run();";
        String indexString = index + "";
        try {
            VelocityContext velocityContext = new VelocityContext();
            Velocity.init();
            velocityContext.put("lAttributes", (Object)lAttributes);
            velocityContext.put("lParamDeclConstructor", (Object)lParamDeclConstructor);
            velocityContext.put("lConstructorBody", (Object)lConstructorBody);
            velocityContext.put("lMethodRun", (Object)lMethodRun);
            velocityContext.put("index", (Object)indexString);
            velocityContext.put("runRecursion", (Object)"");
            template = Velocity.getTemplate((String)"MuAction.vm");
            StringWriter stringWriter = new StringWriter();
            template.merge((Context)velocityContext, (Writer)stringWriter);
            stringWriter.close();
            codeProcessClass = stringWriter.toString();
        }
        catch (Exception e) {
            throw new VelocityException("Velocity exception for iterated internal choice", e);
        }
        String code = "(new CSProcess() { public void run() {";
        List formatDecls = this.formatDeclarations((List)decls);
        String parameters = "";
        for (int i = 0; i < formatDecls.size(); ++i) {
            VarDecl varDecl = (VarDecl)formatDecls.get(i);
            DeclName name = (DeclName)varDecl.getDeclName().get(0);
            CircusType circusType = (CircusType)((Object)name.getAnn(CircusType.class));
            code = code + "\n" + circusType.getJavaCircusTypeName() + " " + name + " = new " + circusType.getJavaCircusTypeName() + "(RandomGenerator.generateNumber(" + circusType.getJavaCircusTypeName() + ".MIN_VALUE, " + circusType.getJavaCircusTypeName() + ".MAX_VALUE" + "));";
            parameters = i == 0 ? parameters + name : parameters + ", " + name;
        }
        code = code + codeProcessClass;
        code = code + "new I_" + index + "(" + parameters + ").run(); } })";
        return code;
    }

    public Object visitParProcessIte(ParProcessIte parProcessIte) {
        String code = null;
        ++this.index_;
        String procVecName = "procVec_" + this.index_;
        try {
            code = "(new CSProcess() { public void run() {";
            code = code + this.instProcesses(procVecName, (ProcessIte)parProcessIte, this.index_);
            code = code + "\nCSProcess[] processes_" + this.index_ + " = new CSProcess[" + procVecName + ".size()];";
            code = code + "\nfor (int i = 0; i < " + procVecName + ".size(); i++) {";
            code = code + "\nprocesses_" + this.index_ + "[i] = (CSProcess)" + procVecName + ".get(i);";
            code = code + "}\n (new Parallel(processes_" + this.index_ + ")).run(); } })";
        }
        catch (Exception e) {
            throw new VelocityException("Velocity Exception for iterated parallel process", e);
        }
        return code;
    }

    public Object visitSeqProcessIte(SeqProcessIte seqProcessIte) {
        String code = null;
        ++this.index_;
        String procVecName = "procVec_" + this.index_;
        try {
            code = "(new CSProcess() { public void run() {";
            code = code + this.instProcesses(procVecName, (ProcessIte)seqProcessIte, this.index_);
            code = code + "\nfor (int i = 0; i < " + procVecName + ".size(); i++) {";
            code = code + "\n((CSProcess)" + procVecName + ".get(i)).run();";
            code = code + "} } })";
        }
        catch (Exception e) {
            throw new VelocityException("Velocity Exception for iterated sequential process", e);
        }
        return code;
    }

    public Object visitSkipAction(SkipAction skipAction) {
        String code = "(new Skip()).run();";
        return code;
    }

    public Object visitStopAction(StopAction stopAction) {
        String code = "(new Stop()).run();";
        return code;
    }

    public Object visitChaosAction(ChaosAction chaosAction) {
        String code = "while(true){} ";
        return code;
    }

    public Object visitGuardedAction(GuardedAction guardedAction) {
        String code = "";
        Pred pred = guardedAction.getPred();
        CircusAction circusAction = guardedAction.getCircusAction();
        code = code + "if(" + pred.accept((Visitor)this) + ") {";
        code = code + (String)circusAction.accept((Visitor)this);
        code = code + "} else { (new Stop()).run(); }";
        return code;
    }

    public Object visitMuAction(MuAction muAction) {
        String code = null;
        DeclName declName = muAction.getDeclName();
        CircusAction circusAction = muAction.getCircusAction();
        Template template = null;
        ++this.index_;
        int index = this.index_;
        this.currentMuActionName_ = declName.toString();
        NameTypeEnv localEnv = (NameTypeEnv)muAction.getAnn(NameTypeEnv.class);
        ArrayList oldVariables = new ArrayList();
        ArrayList newVariablesLeft = new ArrayList();
        this.getVarsSubstitution(localEnv, index, oldVariables, newVariablesLeft, null);
        String lAttributes = this.attributesRecursion(localEnv, index);
        String lParamDeclConstructor = this.constructorParametersRecursion(localEnv);
        String lConstructorBody = this.constructorBodyRecursion(localEnv, index);
        String lMethodRun = this.substituteRecursion((String)circusAction.accept((Visitor)this) + ";", declName.toString(), localEnv, index);
        lMethodRun = Util.renameVars(lMethodRun, newVariablesLeft, oldVariables);
        String indexString = index + "";
        String runRecursion = this.runRecursion(index, index, localEnv);
        try {
            VelocityContext velocityContext = new VelocityContext();
            Velocity.init();
            velocityContext.put("lAttributes", (Object)lAttributes);
            velocityContext.put("lParamDeclConstructor", (Object)lParamDeclConstructor);
            velocityContext.put("lConstructorBody", (Object)lConstructorBody);
            velocityContext.put("lMethodRun", (Object)lMethodRun);
            velocityContext.put("index", (Object)indexString);
            velocityContext.put("runRecursion", (Object)runRecursion);
            template = Velocity.getTemplate((String)"MuAction.vm");
            StringWriter stringWriter = new StringWriter();
            template.merge((Context)velocityContext, (Writer)stringWriter);
            stringWriter.close();
            code = stringWriter.toString();
        }
        catch (Exception e) {
            throw new VelocityException("Velocity Exception in recursive action", e);
        }
        return code;
    }

    public Object visitCallAction(CallAction callAction) {
        String code = "";
        CallType callType = callAction.getCallType();
        RefName refName = callAction.getRefName();
        if (callType == CallType.Normal) {
            code = this.currentMuActionName_ != null && this.currentMuActionName_.equals(refName.toString()) ? refName.toString() + " " : refName.toString() + "();";
        } else if (callType == CallType.Param) {
            ListTerm params = callAction.getExpr();
            code = refName.toString() + "(";
            for (int i = 0; i < params.size(); ++i) {
                Expr expr = (Expr)params.get(i);
                if (i > 0) {
                    code = code + ", ";
                }
                code = code + (String)expr.accept((Visitor)this);
            }
            code = code + ");";
        } else {
            throw new InvalidParameterException("Invalid Parameter (" + callType.getClass() + "): " + callType.toString());
        }
        return code;
    }

    public Object visitSeqActionIte(SeqActionIte seqActionIte) {
        String code = "";
        ListTerm decls = seqActionIte.getDecl();
        CircusAction circusAction = seqActionIte.getCircusAction();
        Template template = null;
        ++this.index_;
        int index = this.index_;
        NameTypeEnv localEnv = (NameTypeEnv)seqActionIte.getAnn(NameTypeEnv.class);
        ArrayList oldVariables = new ArrayList();
        ArrayList newVariablesLeft = new ArrayList();
        this.getVarsSubstitution(localEnv, index, oldVariables, newVariablesLeft, null);
        String indexString = index + "";
        String lAttributes = this.attributesInstantiation((List)decls, localEnv, index);
        String lParamDeclConstructor = this.constructorParametersInstantiation((List)decls, localEnv);
        String lConstructorBody = this.constructorBodyInstantiation((List)decls, localEnv, index);
        String lMethodRun = Util.renameVars((String)circusAction.accept((Visitor)this), newVariablesLeft, oldVariables);
        String runIteratedSequentialAction = this.runIteratedSequentialAction((List)decls, index, localEnv);
        try {
            VelocityContext velocityContext = new VelocityContext();
            Velocity.init();
            velocityContext.put("index", (Object)indexString);
            velocityContext.put("lAttributes", (Object)lAttributes);
            velocityContext.put("lParamDeclConstructor", (Object)lParamDeclConstructor);
            velocityContext.put("lConstructorBody", (Object)lConstructorBody);
            velocityContext.put("lMethodRun", (Object)lMethodRun);
            velocityContext.put("runRecursion", (Object)runIteratedSequentialAction);
            template = Velocity.getTemplate((String)"MuAction.vm");
            StringWriter stringWriter = new StringWriter();
            template.merge((Context)velocityContext, (Writer)stringWriter);
            stringWriter.close();
            code = stringWriter.toString();
        }
        catch (Exception e) {
            throw new VelocityException("Velocity Exception", e);
        }
        return code;
    }

    public Object visitIntChoiceActionIte(IntChoiceActionIte intChoiceActionIte) {
        String code = null;
        ListTerm decls = intChoiceActionIte.getDecl();
        CircusAction circusAction = intChoiceActionIte.getCircusAction();
        Template template = null;
        ++this.index_;
        int index = this.index_;
        NameTypeEnv localEnv = (NameTypeEnv)intChoiceActionIte.getAnn(NameTypeEnv.class);
        ArrayList oldVariables = new ArrayList();
        ArrayList newVariablesLeft = new ArrayList();
        this.getVarsSubstitution(localEnv, index, oldVariables, newVariablesLeft, null);
        String indexString = index + "";
        String lAttributes = this.attributesInstantiation((List)decls, localEnv, index);
        String lParamDeclConstructor = this.constructorParametersInstantiation((List)decls, localEnv);
        String lConstructorBody = this.constructorBodyInstantiation((List)decls, localEnv, index);
        String lMethodRun = Util.renameVars((String)circusAction.accept((Visitor)this), newVariablesLeft, oldVariables);
        String runIteratedInternalChoiceAction = this.runIteratedInternalChoiceAction((List)decls, index, localEnv);
        try {
            VelocityContext velocityContext = new VelocityContext();
            Velocity.init();
            velocityContext.put("index", (Object)indexString);
            velocityContext.put("lAttributes", (Object)lAttributes);
            velocityContext.put("lParamDeclConstructor", (Object)lParamDeclConstructor);
            velocityContext.put("lConstructorBody", (Object)lConstructorBody);
            velocityContext.put("lMethodRun", (Object)lMethodRun);
            velocityContext.put("runRecursion", (Object)runIteratedInternalChoiceAction);
            template = Velocity.getTemplate((String)"MuAction.vm");
            StringWriter stringWriter = new StringWriter();
            template.merge((Context)velocityContext, (Writer)stringWriter);
            stringWriter.close();
            code = stringWriter.toString();
        }
        catch (Exception e) {
            throw new VelocityException("Velocity Exception", e);
        }
        return code;
    }

    public Object visitExtChoiceAction(ExtChoiceAction extChoiceAction) {
        String code = "";
        List<CircusAction> actions = Util.getActions((CircusAction)extChoiceAction, 1);
        List<String> initialChannels = this.getInitialChannelsStr(actions);
        List<Pred> guards = this.getGuards(actions);
        String declConst = "";
        String init = "";
        String caseSwitch = "";
        String declGuards = "";
        String comma = "";
        for (int i = 0; i < initialChannels.size(); ++i) {
            String channelName = initialChannels.get(i);
            CircusAction circusAction = actions.get(i);
            declConst = declConst + "final int " + this.extChoiceConst(channelName) + " = " + i + ";";
            init = init + this.extChoiceInit(channelName);
            caseSwitch = caseSwitch + this.extChoiceCaseSwitch(channelName, circusAction);
            declGuards = declGuards + comma + (String)guards.get(i).accept((Visitor)this);
            comma = ", ";
        }
        code = code + declConst;
        code = code + "Object[] sync;";
        code = code + "Vector seqOfSync = new Vector();";
        code = code + "Vector seqOfNotSync = new Vector();";
        code = code + init;
        code = code + "boolean[] g = {" + declGuards + "};";
        code = code + "MultiSyncClient client = new MultiSyncClient(seqOfSync, seqOfNotSync, null, g);";
        code = code + "client.run();";
        code = code + "switch(client.getChoosen()) {";
        code = code + caseSwitch;
        code = code + "}";
        return code;
    }

    private String extChoiceInit(String channelName) {
        String code = "";
        code = code + "if (" + channelName + ".isMultiSync()) {";
        code = code + "sync = new Object[] { ";
        code = code + channelName + ".getFromControlerId(), ";
        code = code + channelName + ".getChannel(),";
        code = code + "new Integer(" + channelName + ".getProcessId()),";
        code = code + "new Integer(0)";
        code = code + "};";
        code = code + "seqOfSync.addElement(sync);";
        code = code + "} else {";
        code = code + "seqOfNotSync.addElement(" + channelName + ".getChannel());";
        code = code + "}";
        return code;
    }

    private String extChoiceCaseSwitch(String channelName, CircusAction circusAction) {
        String code = "";
        CircusAction actionWithoutPrefixing = this.prefixingActionWithoutGuard(circusAction);
        code = code + "case " + this.extChoiceConst(channelName) + ": ";
        this.externalChoice_ = true;
        if (actionWithoutPrefixing != null) {
            code = code + (String)actionWithoutPrefixing.accept((Visitor)this);
        }
        code = code + "break;";
        return code;
    }

    private CircusAction prefixingActionWithoutGuard(CircusAction circusAction) {
        CircusAction result = null;
        if (circusAction instanceof GuardedAction) {
            result = this.prefixingActionWithoutGuard(((GuardedAction)circusAction).getCircusAction());
        } else if (circusAction instanceof PrefixingAction) {
            result = circusAction;
        } else {
            Object[] params = new Object[]{this.currentProcess_.toString(), this.currentAction_.toString()};
            this.reportError(new Error(ErrorMessage.EXTCH_BRANCH, params));
        }
        return result;
    }

    private String extChoiceConst(String channelName) {
        return "CONST_" + channelName.toUpperCase();
    }

    public Object visitIntChoiceAction(IntChoiceAction intChoiceAction) {
        CircusAction leftAction = intChoiceAction.getLeftAction();
        CircusAction rightAction = intChoiceAction.getRightAction();
        List<CircusAction> actions = Util.getActions((CircusAction)intChoiceAction, 0);
        String code = "\nint choosen = RandomGenerator.generateNumber(1, " + actions.size() + ");";
        code = code + "\nswitch (choosen) {";
        for (int i = 0; i < actions.size(); ++i) {
            CircusAction circusAction = actions.get(i);
            code = code + "\ncase " + i + ": { " + (String)circusAction.accept((Visitor)this) + "} break;";
        }
        code = code + "\n}";
        return code;
    }

    public Object visitSeqAction(SeqAction seqAction) {
        CircusAction leftAction = seqAction.getLeftAction();
        CircusAction rightAction = seqAction.getRightAction();
        String code = (String)leftAction.accept((Visitor)this) + ";\n" + (String)rightAction.accept((Visitor)this);
        return code;
    }

    public Object visitParAction(ParAction parAction) {
        String code = null;
        Template template = null;
        CircusAction leftAction = parAction.getLeftAction();
        CircusAction rightAction = parAction.getRightAction();
        NameSet fstVariables = parAction.getLeftNameSet();
        NameSet sndVariables = parAction.getRightNameSet();
        ++this.index_;
        int index = this.index_;
        List fstNames = this.getNames(fstVariables);
        List sndNames = this.getNames(sndVariables);
        NameTypeEnv localEnv = (NameTypeEnv)parAction.getAnn(NameTypeEnv.class);
        ArrayList oldVariables = new ArrayList();
        ArrayList newVariablesLeft = new ArrayList();
        ArrayList newVariablesRight = new ArrayList();
        this.getVarsSubstitution(localEnv, index, oldVariables, newVariablesLeft, newVariablesRight);
        String lName = "ParallelLeftBranch_" + index;
        String lAttributes = this.attributesParallel(fstNames, localEnv, index, LEFT);
        String lParamDeclConstructor = this.constructorParametersParallel(fstNames, localEnv);
        String lConstructorBody = this.constructorBodyParallel(fstNames, localEnv, index, LEFT);
        String lMethodRun = Util.renameVars((String)leftAction.accept((Visitor)this) + ";", newVariablesLeft, oldVariables);
        String lParameters = this.parametersParallel(fstNames, localEnv);
        String rName = "ParallelRightBranch_" + index;
        String rAttributes = this.attributesParallel(sndNames, localEnv, index, RIGHT);
        String rParamDeclConstructor = this.constructorParametersParallel(sndNames, localEnv);
        String rConstructorBody = this.constructorBodyParallel(sndNames, localEnv, index, RIGHT);
        String rMethodRun = Util.renameVars((String)rightAction.accept((Visitor)this) + ";", newVariablesRight, oldVariables);
        String rParameters = this.parametersParallel(sndNames, localEnv);
        String indexString = index + "";
        String mergeVars = this.mergeVars(fstNames, localEnv, lName, index, LEFT);
        mergeVars = mergeVars + this.mergeVars(sndNames, localEnv, rName, index, RIGHT);
        try {
            VelocityContext velocityContext = new VelocityContext();
            Velocity.init();
            velocityContext.put("lName", (Object)lName);
            velocityContext.put("lAttributes", (Object)lAttributes);
            velocityContext.put("lParamDeclConstructor", (Object)lParamDeclConstructor);
            velocityContext.put("lConstructorBody", (Object)lConstructorBody);
            velocityContext.put("lMethodRun", (Object)lMethodRun);
            velocityContext.put("lParameters", (Object)lParameters);
            velocityContext.put("rName", (Object)rName);
            velocityContext.put("rAttributes", (Object)rAttributes);
            velocityContext.put("rParamDeclConstructor", (Object)rParamDeclConstructor);
            velocityContext.put("rConstructorBody", (Object)rConstructorBody);
            velocityContext.put("rMethodRun", (Object)rMethodRun);
            velocityContext.put("rParameters", (Object)rParameters);
            velocityContext.put("index", (Object)indexString);
            velocityContext.put("mergeVars", (Object)mergeVars);
            template = Velocity.getTemplate((String)"ActionParallelism.vm");
            StringWriter stringWriter = new StringWriter();
            template.merge((Context)velocityContext, (Writer)stringWriter);
            stringWriter.close();
            code = stringWriter.toString();
        }
        catch (Exception e) {
            throw new VelocityException("Velocity exception", e);
        }
        return code;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object visitPrefixingAction(PrefixingAction prefixingAction) {
        Field field;
        String arrayCode;
        String code = "";
        ChanUse chanUse = null;
        Communication communication = prefixingAction.getCommunication();
        CircusAction circusAction = prefixingAction.getCircusAction();
        RefName chanName = communication.getChanName();
        ListTerm actuals = communication.getGenActuals();
        ListTerm fields = communication.getChanFields();
        if (fields.size() >= 1) {
            Expr expr;
            int i;
            arrayCode = "";
            if (actuals != null && actuals.size() > 0) {
                for (i = 0; i < actuals.size(); ++i) {
                    expr = (Expr)actuals.get(i);
                    String typeName = "";
                    if (expr instanceof RefExpr) {
                        typeName = ((RefExpr)expr).getRefName().toString();
                        if (typeName.equals(MathToolkitConstants.NAT)) {
                            typeName = "CircusInteger";
                        }
                    } else {
                        Object[] params = new Object[]{this.currentProcess_, this.currentAction_, MathToolkitConstants.NAT, MathToolkitConstants.NUM};
                        this.reportError(new Error(ErrorMessage.CHAN_INST, params));
                    }
                    arrayCode = arrayCode + "[Type." + typeName + "]";
                }
            }
            for (i = 0; i <= fields.size() - 2; ++i) {
                Field field2 = (Field)fields.get(i);
                if (!(field2 instanceof DotField)) {
                    Object[] params = new Object[]{this.currentProcess_, this.currentAction_, chanName};
                    this.reportError(new Error(ErrorMessage.CHAN_FORMAT, params));
                }
                Expr expr2 = ((DotField)field2).getExpression();
                arrayCode = arrayCode + "[ (" + (String)expr2.accept((Visitor)this) + ").getValue() ]";
            }
            field = (Field)fields.get(fields.size() - 1);
            if (!(field instanceof InputField)) {
                if (field instanceof OutputField) {
                    expr = ((OutputField)field).getExpression();
                    return "\n" + chanName.toString() + arrayCode + ".write(" + (String)expr.accept((Visitor)this) + ");\n" + (String)circusAction.accept((Visitor)this);
                }
                if (!(field instanceof DotField)) throw new InvalidSubTypeException(field.getClass());
                expr = ((DotField)field).getExpression();
                return "\n" + chanName.toString() + arrayCode + "[ (" + (String)expr.accept((Visitor)this) + ").getValue() ]" + ".communicate(null);\n" + (String)circusAction.accept((Visitor)this);
            }
        } else {
            ProcChanEnv processChannelEnvironment = this.environment_.getProcessChannelEnvironment(this.currentProcess_.toString());
            try {
                chanUse = processChannelEnvironment.getJavaChannelType(chanName.toString());
            }
            catch (ChannelNotDefinedExceptionForProcess e) {
                Object[] params = new Object[]{this.currentProcess_, this.currentAction_, chanName};
                this.reportError(new Error(ErrorMessage.CHAN_NOT_DEF, params));
            }
            if (chanUse.equals((Object)ChanUse.Input) || chanUse.equals((Object)ChanUse.AltInput)) {
                if (!this.externalChoice_) {
                    code = "\n" + chanName.toString() + ".read(); ";
                }
                this.externalChoice_ = false;
                return code + (String)circusAction.accept((Visitor)this);
            } else if (chanUse.equals((Object)ChanUse.Output)) {
                code = "\n" + chanName.toString() + ".write(null); ";
                return code + (String)circusAction.accept((Visitor)this);
            } else {
                if (!chanUse.equals((Object)ChanUse.Undefined)) throw new InvalidParameterException(chanUse.toString());
                code = "\n" + chanName.toString() + ".communicate(null); ";
            }
            return code + (String)circusAction.accept((Visitor)this);
        }
        RefName variable = ((InputField)field).getVariable();
        CircusType circusType = (CircusType)((Object)variable.getAnn(CircusType.class));
        if (!this.externalChoice_) return "\n{ " + circusType.getJavaCircusTypeName() + " " + variable + " = (" + circusType.getJavaCircusTypeName() + ") " + chanName.toString() + arrayCode + ".read();\n" + (String)circusAction.accept((Visitor)this) + "\n}";
        code = "\n{ " + circusType.getJavaCircusTypeName() + " " + variable + " = (" + circusType.getJavaCircusTypeName() + ") client.getValueTrans(); " + (String)circusAction.accept((Visitor)this) + "\n}";
        this.externalChoice_ = false;
        return code;
    }

    public Object visitAssignmentCommand(AssignmentCommand assignmentCommand) {
        String code = "";
        ListTerm leftVars = assignmentCommand.getLeftVars();
        ListTerm exprs = assignmentCommand.getExprs();
        for (int i = 0; i < leftVars.size(); ++i) {
            RefName refName = (RefName)leftVars.get(i);
            Expr expr = (Expr)exprs.get(i);
            code = code + "\n" + refName.toString() + " = " + (String)expr.accept((Visitor)this) + ";";
        }
        return code;
    }

    public Object visitIfGuardedCommand(IfGuardedCommand ifGuardedCommand) {
        String code = "";
        ListTerm guardedActions = ifGuardedCommand.getGuardedAction();
        Object procChanEnv = null;
        for (int i = 0; i < guardedActions.size(); ++i) {
            GuardedAction guardedAction = (GuardedAction)guardedActions.get(i);
            Pred pred = guardedAction.getPred();
            CircusAction circusAction = guardedAction.getCircusAction();
            code = i != 0 ? code + "\n} else " : "\n";
            code = code + "if (" + (String)pred.accept((Visitor)this) + ") {\n" + circusAction.accept((Visitor)this) + ";";
        }
        code = code + "} else { while(true){} }";
        return code;
    }

    public Object visitVarDeclCommand(VarDeclCommand varDeclCommand) {
        ListTerm decls = varDeclCommand.getDeclarations();
        CircusAction circusAction = varDeclCommand.getCircusAction();
        String code = "\n{";
        for (int i = 0; i < decls.size(); ++i) {
            Decl decl = (Decl)decls.get(i);
            this.isPrivate_ = false;
            code = code + decl.accept((Visitor)this);
        }
        code = code + (String)circusAction.accept((Visitor)this) + ";";
        code = code + "\n}";
        return code;
    }

    public Object visitVarDecl(VarDecl varDecl) {
        String code = "\n";
        ListTerm names = varDecl.getDeclName();
        Expr expression = varDecl.getExpr();
        CircusType circusType = (CircusType)((Object)((DeclName)names.get(0)).getAnn(CircusType.class));
        if (this.isPrivate_) {
            code = "\nprivate ";
        }
        code = code + circusType.getJavaCircusTypeName() + " ";
        for (int i = 0; i < names.size(); ++i) {
            if (i != 0) {
                code = code + ", ";
            }
            code = code + ((DeclName)names.get(i)).toString() + " = null";
        }
        code = code + ";";
        return code;
    }

    public Object visitFalsePred(FalsePred fact) {
        return "false";
    }

    public Object visitTruePred(TruePred fact) {
        return "true";
    }

    public Object visitNegPred(NegPred negPred) {
        Pred pred = negPred.getPred();
        String code = "(!(" + pred.accept((Visitor)this) + "))";
        return code;
    }

    public Object visitAndPred(AndPred andPred) {
        Pred leftPred = andPred.getLeftPred();
        Pred rightPred = andPred.getRightPred();
        String code = "(" + leftPred.accept((Visitor)this) + " && " + rightPred.accept((Visitor)this) + ")";
        return code;
    }

    public Object visitOrPred(OrPred orPred) {
        Pred leftPred = orPred.getLeftPred();
        Pred rightPred = orPred.getRightPred();
        String code = "(" + leftPred.accept((Visitor)this) + " || " + rightPred.accept((Visitor)this) + ")";
        return code;
    }

    public Object visitIffPred(IffPred iffPred) {
        Pred leftPred = iffPred.getLeftPred();
        Pred rightPred = iffPred.getRightPred();
        String code = "(" + leftPred.accept((Visitor)this) + " == " + rightPred.accept((Visitor)this) + ")";
        return code;
    }

    public Object visitImpliesPred(ImpliesPred impliesPred) {
        Pred leftPred = impliesPred.getLeftPred();
        Pred rightPred = impliesPred.getRightPred();
        String code = "(!(" + leftPred.accept((Visitor)this) + ") || " + rightPred.accept((Visitor)this) + ")";
        return code;
    }

    public Object visitExprPred(ExprPred exprPred) {
        Expr expr = exprPred.getExpr();
        String code = (String)expr.accept((Visitor)this);
        return code;
    }

    public Object visitMemPred(MemPred memPred) {
        String code = "ERROR";
        Expr leftExpr = memPred.getLeftExpr();
        Expr rightExpr = memPred.getRightExpr();
        Boolean mixfix = memPred.getMixfix();
        if (mixfix == Boolean.TRUE) {
            if (rightExpr instanceof SetExpr) {
                Expr expr = (Expr)((SetExpr)rightExpr).getExpr().get(0);
                code = "((" + (String)leftExpr.accept((Visitor)this) + ").getValue() == (" + (String)expr.accept((Visitor)this) + ").getValue())";
            } else {
                code = this.visitingMathToolkit((RefExpr)rightExpr, leftExpr);
            }
        } else {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            return "************************";
        }
        return code;
    }

    public Object visitApplExpr(ApplExpr applExpr) {
        String code = "ERROR";
        Expr leftExpr = applExpr.getLeftExpr();
        Expr rightExpr = applExpr.getRightExpr();
        Boolean mixfix = applExpr.getMixfix();
        if (mixfix == Boolean.TRUE) {
            code = this.visitingMathToolkit((RefExpr)leftExpr, rightExpr);
        } else if (leftExpr instanceof RefExpr && rightExpr instanceof RefExpr) {
            code = ((RefExpr)leftExpr).getRefName() + "(" + ((RefExpr)rightExpr).getRefName() + ")";
        } else {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportError(new Error(ErrorMessage.FUNCAPP_FORMAT, params));
        }
        return code;
    }

    public Object visitRefExpr(RefExpr refExpr) {
        String code = "*ERRO*";
        RefName refName = refExpr.getRefName();
        NameType nameType = (NameType)((Object)refName.getAnn(NameType.class));
        if (nameType.equals((Object)NameType.StateComponent)) {
            code = refName.toString();
        } else if (nameType.equals((Object)NameType.ProcessParam)) {
            code = refName.toString();
        } else if (nameType.equals((Object)NameType.ActionParam)) {
            code = refName.toString();
        } else if (nameType.equals((Object)NameType.LocalVariable)) {
            code = refName.toString();
        } else if (!nameType.equals((Object)NameType.Channel)) {
            if (nameType.equals((Object)NameType.GlobalConstant)) {
                code = "AxiomaticDefinitions." + refName.toString() + "()";
            } else if (nameType.equals((Object)NameType.LocalConstant)) {
                code = refName.toString() + "()";
            } else if (nameType.equals((Object)NameType.FreeType)) {
                code = "TODO";
            } else if (nameType.equals((Object)NameType.ElemFreeType)) {
                DeclName declName = new Factory().createDeclName(refName.toString());
                String nameFreeType = this.environment_.getNameFreeType(declName);
                code = "new " + nameFreeType + "(" + nameFreeType + "." + refName.toString() + ")";
            } else {
                if (nameType.equals((Object)NameType.ProcessName)) {
                    throw new InvalidParameterException("The type of the reference expression " + refName.toString() + " is " + (Object)((Object)nameType));
                }
                if (nameType.equals((Object)NameType.ActionName)) {
                    throw new InvalidParameterException("The type of the reference expression " + refName.toString() + " is " + (Object)((Object)nameType));
                }
                if (nameType.equals((Object)NameType.SchemaName)) {
                    throw new InvalidParameterException("The type of the reference expression " + refName.toString() + " is " + (Object)((Object)nameType));
                }
                if (nameType.equals((Object)NameType.RecursiveName)) {
                    throw new InvalidParameterException("The type of the reference expression " + refName.toString() + " is " + (Object)((Object)nameType));
                }
                if (nameType.equals((Object)NameType.ChannelSetName)) {
                    throw new InvalidParameterException("The type of the reference expression " + refName.toString() + " is " + (Object)((Object)nameType));
                }
            }
        }
        return code;
    }

    public Object visitNumExpr(NumExpr numExpr) {
        BigInteger bigInteger = numExpr.getValue();
        String code = "new CircusInteger(" + bigInteger.toString() + ")";
        return code;
    }

    public Object visitSetExpr(SetExpr setExpr) {
        ListTerm exprs = setExpr.getExpr();
        String code = "new Set(new Object[] {";
        for (int i = 0; i < exprs.size(); ++i) {
            Expr expr = (Expr)exprs.get(i);
            code = code + expr.accept((Visitor)this);
        }
        code = code + "});";
        return code;
    }

    private String visitingMathToolkit(RefExpr opName, Expr expr) {
        String code = "ERROR";
        String op = opName.getRefName().toString();
        ListTerm exprs = null;
        Expr expr1 = null;
        Expr expr2 = null;
        if (expr instanceof TupleExpr && (exprs = ((TupleExpr)expr).getExpr()).size() == 2) {
            expr1 = (Expr)exprs.get(0);
            expr2 = (Expr)exprs.get(1);
        }
        if (op.equals(MathToolkitConstants.ADD)) {
            code = (String)expr1.accept((Visitor)this) + ".add(" + (String)expr2.accept((Visitor)this) + ")";
        } else if (op.equals(MathToolkitConstants.SUB)) {
            code = (String)expr1.accept((Visitor)this) + ".sub(" + (String)expr2.accept((Visitor)this) + ")";
        } else if (op.equals(MathToolkitConstants.MULT)) {
            code = (String)expr1.accept((Visitor)this) + ".mult(" + (String)expr2.accept((Visitor)this) + ")";
        } else if (op.equals(MathToolkitConstants.DIV)) {
            code = (String)expr1.accept((Visitor)this) + ".div(" + (String)expr2.accept((Visitor)this) + ")";
        } else if (op.equals(MathToolkitConstants.MOD)) {
            code = (String)expr1.accept((Visitor)this) + ".mod(" + (String)expr2.accept((Visitor)this) + ")";
        } else if (op.equals(MathToolkitConstants.NEGATE)) {
            code = (String)expr.accept((Visitor)this) + ".negate()";
        } else if (op.equals(MathToolkitConstants.LESS)) {
            code = (String)expr1.accept((Visitor)this) + ".less(" + (String)expr2.accept((Visitor)this) + ")";
        } else if (op.equals(MathToolkitConstants.LESS_EQUAL)) {
            code = (String)expr1.accept((Visitor)this) + ".lessEqual(" + (String)expr2.accept((Visitor)this) + ")";
        } else if (op.equals(MathToolkitConstants.GREATER)) {
            code = (String)expr1.accept((Visitor)this) + ".greater(" + (String)expr2.accept((Visitor)this) + ")";
        } else if (op.equals(MathToolkitConstants.GREATER_EQUAL)) {
            code = (String)expr1.accept((Visitor)this) + ".greaterEqual(" + (String)expr2.accept((Visitor)this) + ")";
        } else if (op.equals(MathToolkitConstants.NOTEQUAL)) {
            code = "!" + (String)expr1.accept((Visitor)this) + ".equals(" + (String)expr2.accept((Visitor)this) + ")";
        } else {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_, op};
            return "*************************";
        }
        return code;
    }

    private String extractChans(String procName, Integer procId, List parameters) {
        String code = "";
        ChanUseEnv channelUseEnvironment = this.environment_.getProcessChannelEnvironment(procName).getChanUseEnvVis();
        Iterator iteratorKeys = channelUseEnvironment.iteratorKeys();
        String comma = "";
        while (iteratorKeys.hasNext()) {
            String channelName = (String)iteratorKeys.next();
            code = code + comma + this.channelCode(channelName, procId, false);
            if (!comma.equals("")) continue;
            comma = ", ";
        }
        if (parameters != null) {
            for (int i = 0; i < parameters.size(); ++i) {
                Expr expr = (Expr)parameters.get(i);
                code = code + comma + expr.accept((Visitor)this);
                if (!comma.equals("")) continue;
                comma = ", ";
            }
        }
        return code;
    }

    private String channelCode(String channelName, Integer procId, boolean isMain) {
        if (isMain) {
            return channelName;
        }
        return "new GeneralChannel(" + channelName + ", new Integer(" + procId + "))";
    }

    private String attributesAndConstructor(ProcessPara processPara) {
        ListTerm decls;
        CircusType circusTypeChannel;
        ChanSync syncType;
        ChanUse chanUse;
        String channelName;
        String code = "";
        CircusProcess circusProcess = processPara.getCircusProcess();
        DeclName declName = processPara.getDeclName();
        ProcChanEnv procChanEnv = this.environment_.getProcessChannelEnvironment(declName.toString());
        ChanUseEnv chanUseEnvVis = procChanEnv.getChanUseEnvVis();
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();
        ChanSyncEnv chanSyncEnv = procChanEnv.getChanSyncEnv();
        NameTypeEnv nameTypeEnv = procChanEnv.getNameTypeEnv();
        Integer idProc = Util.getIdCircusProcessAnn((TermA)circusProcess).getId();
        Iterator iteratorVisible = chanUseEnvVis.iteratorKeys();
        Iterator iteratorHidden = chanUseEnvHid.iteratorKeys();
        String brackets = "";
        while (iteratorVisible.hasNext()) {
            channelName = (String)iteratorVisible.next();
            chanUse = chanUseEnvVis.get(channelName);
            syncType = chanSyncEnv.get(channelName);
            circusTypeChannel = nameTypeEnv.getCircusType(channelName);
            brackets = Util.arrayDim(circusTypeChannel, syncType, 0);
            code = code + "\nprivate GeneralChannel " + brackets + " " + channelName + ";";
        }
        while (iteratorHidden.hasNext()) {
            channelName = (String)iteratorHidden.next();
            chanUse = chanUseEnvHid.get(channelName);
            syncType = chanSyncEnv.get(channelName);
            circusTypeChannel = nameTypeEnv.getCircusType(channelName);
            brackets = Util.arrayDim(circusTypeChannel, syncType, 0);
            code = code + "\nprivate GeneralChannel " + brackets + " " + channelName + ";";
        }
        if (circusProcess instanceof ParamProcess) {
            decls = ((ParamProcess)circusProcess).getDecl();
            for (int i = 0; i < decls.size(); ++i) {
                Decl decl = (Decl)decls.get(i);
                this.isPrivate_ = true;
                code = code + decl.accept((Visitor)this);
            }
        } else {
            decls = null;
        }
        code = code + "\npublic " + declName.toString() + "(" + this.constructorParameters(procChanEnv, (List)decls) + ") {";
        code = code + this.constructorBody(processPara, (List)decls);
        code = code + "\n}";
        return code;
    }

    private List getProcesses(CircusProcess process, int operation) {
        ArrayList<CircusProcess> r = new ArrayList<CircusProcess>();
        if (operation == 1 && process instanceof ExtChoiceProcess || operation == 0 && process instanceof IntChoiceProcess) {
            r.addAll(this.getProcesses(((Process2)process).getLeftProc(), operation));
            r.addAll(this.getProcesses(((Process2)process).getRightProc(), operation));
        } else if (operation == 1 || operation == 0) {
            r.add(process);
        } else {
            throw new InvalidParameterException("Operation not defined: " + operation);
        }
        return r;
    }

    private String parameters(List decls) {
        return this.parameters(decls, true);
    }

    private String parameters(List decls, boolean isFirst) {
        String code = "";
        if (decls != null) {
            for (int i = 0; i < decls.size(); ++i) {
                Decl decl = (Decl)decls.get(i);
                if (!(decl instanceof VarDecl)) continue;
                ListTerm names = ((VarDecl)decl).getDeclName();
                CircusType circusType = (CircusType)((Object)((TermA)names.get(0)).getAnn(CircusType.class));
                for (int j = 0; j < names.size(); ++j) {
                    if (!isFirst) {
                        code = code + ", ";
                    } else {
                        isFirst = false;
                    }
                    code = code + circusType.getJavaCircusTypeName() + " " + names.get(j);
                }
            }
        }
        return code;
    }

    private String constructorParameters(ProcChanEnv processChannelEnvironment, List decls) {
        String code = "";
        boolean isFirst = true;
        ChanUseEnv channelUseEnvironmentVisible = processChannelEnvironment.getChanUseEnvVis();
        ChanSyncEnv channelSyncEnvironment = processChannelEnvironment.getChanSyncEnv();
        NameTypeEnv channelTypeEnvironment = processChannelEnvironment.getNameTypeEnv();
        Iterator iterator = channelUseEnvironmentVisible.iteratorKeys();
        String brackets = "";
        while (iterator.hasNext()) {
            String channelName = (String)iterator.next();
            ChanUse chanUse = channelUseEnvironmentVisible.get(channelName);
            ChanSync syncType = channelSyncEnvironment.get(channelName);
            CircusType circusTypeChannel = channelTypeEnvironment.getCircusType(channelName);
            brackets = Util.arrayDim(circusTypeChannel, syncType, 0);
            if (!isFirst) {
                code = code + ", ";
            } else {
                isFirst = false;
            }
            code = code + chanUse.toJava() + brackets + " " + channelName;
        }
        code = code + this.parameters(decls, isFirst);
        return code;
    }

    private String constructorBody(ProcessPara processPara, List decls) {
        String channelName;
        String code = "";
        boolean first = true;
        CircusProcess circusProcess = processPara.getCircusProcess();
        Integer procId = Util.getIdCircusProcessAnn((TermA)circusProcess).getId();
        DeclName declName = processPara.getDeclName();
        ProcChanEnv procChanEnv = this.environment_.getProcessChannelEnvironment(declName.toString());
        ChanUseEnv chanUseEnvVis = procChanEnv.getChanUseEnvVis();
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();
        ChanSyncEnv chanSyncEnv = procChanEnv.getChanSyncEnv();
        NameTypeEnv nameTypeEnv = procChanEnv.getNameTypeEnv();
        ChanInfoEnv multiSyncEnv = procChanEnv.getChanInfoEnv();
        Iterator iteratorVisible = chanUseEnvVis.iteratorKeys();
        Iterator iteratorHidden = chanUseEnvHid.iteratorKeys();
        while (iteratorVisible.hasNext()) {
            channelName = (String)iteratorVisible.next();
            code = code + "\nthis." + channelName + " = " + channelName + ";";
        }
        while (iteratorHidden.hasNext()) {
            channelName = (String)iteratorHidden.next();
            CircusType circusTypeChannel = this.environment_.getCircusType(channelName);
            ProcChanUseEnv chanMsEnv = multiSyncEnv.get(channelName);
            code = code + Util.instChannelSimple(channelName, chanMsEnv, procId, false);
        }
        if (decls != null) {
            for (int i = 0; i < decls.size(); ++i) {
                Decl decl = (Decl)decls.get(i);
                if (!(decl instanceof VarDecl)) continue;
                ListTerm names = ((VarDecl)decl).getDeclName();
                for (int j = 0; j < names.size(); ++j) {
                    code = code + "\nthis." + names.get(j) + " = " + names.get(j) + ";";
                }
            }
        }
        return code;
    }

    private String attributesParallel(List varsPartition, NameTypeEnv localEnv, int index, String leftRight) {
        String code = "";
        Enumeration keys = localEnv.keys();
        while (keys.hasMoreElements()) {
            DeclName declName = (DeclName)keys.nextElement();
            NameType nameType = (NameType)((Object)declName.getAnn(NameType.class));
            CircusType circusType = localEnv.getCircusType(declName.toString());
            if (nameType.equals((Object)NameType.StateComponent) || nameType.equals((Object)NameType.ProcessParam)) {
                code = code + "\npublic " + circusType.getJavaCircusTypeName() + " aux_" + leftRight + "_" + declName.toString() + "_" + index + " = " + declName.toString() + ";";
                continue;
            }
            if (!nameType.equals((Object)NameType.LocalVariable) && !nameType.equals((Object)NameType.ActionParam)) continue;
            code = code + "\npublic " + circusType.getJavaCircusTypeName() + " aux_" + leftRight + "_" + declName.toString() + "_" + index + ";";
        }
        return code;
    }

    private String constructorParametersParallel(List names, NameTypeEnv typeEnvironment) {
        String code = "";
        Enumeration keys = typeEnvironment.keys();
        String comma = "";
        while (keys.hasMoreElements()) {
            DeclName declName = (DeclName)keys.nextElement();
            NameType nameType = (NameType)((Object)declName.getAnn(NameType.class));
            if (!nameType.equals((Object)NameType.LocalVariable) && !nameType.equals((Object)NameType.ActionParam)) continue;
            CircusType circusType = typeEnvironment.getCircusType(declName.toString());
            code = code + comma + circusType.getJavaCircusTypeName() + " " + declName.toString();
            if (!comma.equals("")) continue;
            comma = ", ";
        }
        return code;
    }

    private String constructorBodyParallel(List names, NameTypeEnv typeEnvironment, int index, String leftRight) {
        String code = "";
        Enumeration keys = typeEnvironment.keys();
        while (keys.hasMoreElements()) {
            DeclName declName = (DeclName)keys.nextElement();
            NameType nameType = (NameType)((Object)declName.getAnn(NameType.class));
            if (!nameType.equals((Object)NameType.LocalVariable) && !nameType.equals((Object)NameType.ActionParam)) continue;
            CircusType circusType = typeEnvironment.getCircusType(declName.toString());
            code = code + "\naux_" + leftRight + "_" + declName.toString() + "_" + index + " = " + declName.toString() + ";";
        }
        return code;
    }

    private String parametersParallel(List names, NameTypeEnv typeEnvironment) {
        String code = "";
        Enumeration keys = typeEnvironment.keys();
        String comma = "";
        while (keys.hasMoreElements()) {
            DeclName declName = (DeclName)keys.nextElement();
            NameType nameType = (NameType)((Object)declName.getAnn(NameType.class));
            if (!nameType.equals((Object)NameType.LocalVariable) && !nameType.equals((Object)NameType.ActionParam)) continue;
            CircusType circusType = typeEnvironment.getCircusType(declName.toString());
            code = code + comma + declName.toString();
            if (!comma.equals("")) continue;
            comma = ", ";
        }
        return code;
    }

    private String mergeVars(List names, NameTypeEnv typeEnvironment, String lrName, int index, String leftRight) {
        String code = "";
        Enumeration keys = typeEnvironment.keys();
        String comma = "";
        int lf = 0;
        if (leftRight == RIGHT) {
            lf = 1;
        }
        for (int i = 0; i < names.size(); ++i) {
            String declName = (String)names.get(i);
            code = code + "\n" + declName + " = " + "((" + lrName + ")processes_" + index + "[" + lf + "]).aux_" + leftRight + "_" + declName + "_" + index + ";";
        }
        return code;
    }

    private void getVarsSubstitution(NameTypeEnv localEnv, int index, List varList, List auxVarLeft, List auxVarRight) {
        Enumeration keys = localEnv.keys();
        while (keys.hasMoreElements()) {
            DeclName declName = (DeclName)keys.nextElement();
            NameType nameType = (NameType)((Object)declName.getAnn(NameType.class));
            if (auxVarRight == null && !nameType.equals((Object)NameType.LocalVariable) && !nameType.equals((Object)NameType.ActionParam)) continue;
            varList.add(declName.toString());
            auxVarLeft.add("aux_left_" + declName.toString() + "_" + index);
            if (auxVarRight == null) continue;
            auxVarRight.add("aux_right_" + declName.toString() + "_" + index);
        }
    }

    private List getOldVariables(NameTypeEnv typeEnvironment, boolean isParallelism) {
        ArrayList<String> r = new ArrayList<String>();
        Enumeration keys = typeEnvironment.keys();
        while (keys.hasMoreElements()) {
            DeclName declName = (DeclName)keys.nextElement();
            NameType nameType = (NameType)((Object)declName.getAnn(NameType.class));
            if (!nameType.equals((Object)NameType.LocalVariable) && !nameType.equals((Object)NameType.ActionParam) && (!nameType.equals((Object)NameType.StateComponent) || !isParallelism)) continue;
            r.add(declName.toString());
        }
        return r;
    }

    private List getNewVariables(NameTypeEnv localEnv, String leftRight, int index, boolean isParallelism) {
        ArrayList<String> r = new ArrayList<String>();
        Enumeration keys = localEnv.keys();
        while (keys.hasMoreElements()) {
            DeclName declName = (DeclName)keys.nextElement();
            NameType nameType = (NameType)((Object)declName.getAnn(NameType.class));
            if (!isParallelism && !nameType.equals((Object)NameType.LocalVariable) && !nameType.equals((Object)NameType.ActionParam)) continue;
            r.add("aux_" + leftRight + "_" + declName.toString() + "_" + index);
        }
        return r;
    }

    private String attributesRecursion(NameTypeEnv typeEnvironment, int index) {
        String code = "";
        Enumeration keys = typeEnvironment.keys();
        while (keys.hasMoreElements()) {
            DeclName declName = (DeclName)keys.nextElement();
            NameType nameType = (NameType)((Object)declName.getAnn(NameType.class));
            if (!nameType.equals((Object)NameType.LocalVariable) && !nameType.equals((Object)NameType.ActionParam)) continue;
            CircusType circusType = typeEnvironment.getCircusType(declName.toString());
            code = code + "\npublic " + circusType.getJavaCircusTypeName() + " aux_left_" + declName.toString() + "_" + index + ";";
        }
        return code;
    }

    private String constructorParametersRecursion(NameTypeEnv typeEnvironment) {
        String code = "";
        Enumeration keys = typeEnvironment.keys();
        String comma = "";
        while (keys.hasMoreElements()) {
            DeclName declName = (DeclName)keys.nextElement();
            NameType nameType = (NameType)((Object)declName.getAnn(NameType.class));
            if (!nameType.equals((Object)NameType.LocalVariable) && !nameType.equals((Object)NameType.ActionParam)) continue;
            CircusType circusType = typeEnvironment.getCircusType(declName.toString());
            code = code + comma + circusType.getJavaCircusTypeName() + " " + declName.toString();
            if (!comma.equals("")) continue;
            comma = ", ";
        }
        return code;
    }

    private String constructorBodyRecursion(NameTypeEnv typeEnvironment, int index) {
        String code = "";
        Enumeration keys = typeEnvironment.keys();
        while (keys.hasMoreElements()) {
            DeclName declName = (DeclName)keys.nextElement();
            NameType nameType = (NameType)((Object)declName.getAnn(NameType.class));
            if (!nameType.equals((Object)NameType.LocalVariable) && !nameType.equals((Object)NameType.ActionParam)) continue;
            CircusType circusType = typeEnvironment.getCircusType(declName.toString());
            code = code + "\naux_left_" + declName.toString() + "_" + index + " = " + declName.toString() + ";";
        }
        return code;
    }

    private String parametersRecursion(NameTypeEnv typeEnvironment) {
        String code = "";
        Enumeration keys = typeEnvironment.keys();
        String comma = "";
        while (keys.hasMoreElements()) {
            DeclName declName = (DeclName)keys.nextElement();
            NameType nameType = (NameType)((Object)declName.getAnn(NameType.class));
            if (!nameType.equals((Object)NameType.LocalVariable) && !nameType.equals((Object)NameType.ActionParam)) continue;
            CircusType circusType = typeEnvironment.getCircusType(declName.toString());
            code = code + comma + declName.toString();
            if (!comma.equals("")) continue;
            comma = ", ";
        }
        return code;
    }

    private String mergeVarsRecursion(NameTypeEnv typeEnvironment, int index, int newIndex) {
        String code = "";
        Enumeration keys = typeEnvironment.keys();
        while (keys.hasMoreElements()) {
            DeclName declName = (DeclName)keys.nextElement();
            NameType nameType = (NameType)((Object)declName.getAnn(NameType.class));
            if (!nameType.equals((Object)NameType.LocalVariable) && !nameType.equals((Object)NameType.ActionParam)) continue;
            code = code + "\n" + declName.toString() + " = i_" + index + "_" + newIndex + ".aux_left_" + declName.toString() + "_" + index + ";";
        }
        return code;
    }

    private String substituteRecursion(String initialCode, String recName, NameTypeEnv typeEnvironment, int index) {
        String code = "";
        StringTokenizer st = new StringTokenizer(initialCode, ".;,(){} \t\n\r\f", true);
        int newIndex = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (recName.equals(token)) {
                token = this.runRecursion(index, newIndex, typeEnvironment);
                ++newIndex;
            }
            code = code + token;
        }
        return code;
    }

    private String runRecursion(int index, int newIndex, NameTypeEnv typeEnvironment) {
        String code = "";
        code = "\nI_" + index + " i_" + index + "_" + newIndex + " = new I_" + index + "(" + this.parametersRecursion(typeEnvironment) + "); ";
        code = code + "\ni_" + index + "_" + newIndex + ".run(); ";
        code = code + "\n" + this.mergeVarsRecursion(typeEnvironment, index, newIndex);
        return code;
    }

    private String attributesInstantiation(List decls, NameTypeEnv typeEnvironment, int index) {
        CircusType circusType;
        String code = "";
        Enumeration keys = typeEnvironment.keys();
        for (int i = 0; i < decls.size(); ++i) {
            Decl decl = (Decl)decls.get(i);
            if (!(decl instanceof VarDecl)) continue;
            ListTerm names = ((VarDecl)decl).getDeclName();
            circusType = (CircusType)((Object)((TermA)names.get(0)).getAnn(CircusType.class));
            for (int j = 0; j < names.size(); ++j) {
                code = code + "\nprivate " + circusType.getJavaCircusTypeName() + " " + names.get(j) + ";";
            }
        }
        while (keys.hasMoreElements()) {
            DeclName declName = (DeclName)keys.nextElement();
            NameType nameType = (NameType)((Object)declName.getAnn(NameType.class));
            circusType = typeEnvironment.getCircusType(declName.toString());
            if (!nameType.equals((Object)NameType.LocalVariable) && !nameType.equals((Object)NameType.ActionParam)) continue;
            code = code + "\npublic " + circusType.getJavaCircusTypeName() + " aux_left_" + declName.toString() + "_" + index + ";";
        }
        return code;
    }

    private String constructorParametersInstantiation(List decls, NameTypeEnv typeEnvironment) {
        CircusType circusType;
        String code = "";
        Enumeration keys = typeEnvironment.keys();
        String comma = "";
        boolean isFirst = true;
        for (int i = 0; i < decls.size(); ++i) {
            Decl decl = (Decl)decls.get(i);
            if (!(decl instanceof VarDecl)) continue;
            ListTerm names = ((VarDecl)decl).getDeclName();
            circusType = (CircusType)((Object)((TermA)names.get(0)).getAnn(CircusType.class));
            for (int j = 0; j < names.size(); ++j) {
                code = code + comma + circusType.getJavaCircusTypeName() + " " + names.get(j);
                if (!comma.equals("")) continue;
                comma = ", ";
            }
        }
        while (keys.hasMoreElements()) {
            DeclName declName = (DeclName)keys.nextElement();
            NameType nameType = (NameType)((Object)declName.getAnn(NameType.class));
            if (!nameType.equals((Object)NameType.LocalVariable) && !nameType.equals((Object)NameType.ActionParam)) continue;
            circusType = typeEnvironment.getCircusType(declName.toString());
            code = code + comma + circusType.getJavaCircusTypeName() + " " + declName.toString();
            if (!comma.equals("")) continue;
            comma = ", ";
        }
        return code;
    }

    private String constructorBodyInstantiation(List decls, NameTypeEnv typeEnvironment, int index) {
        String code = "";
        Enumeration keys = typeEnvironment.keys();
        for (int i = 0; i < decls.size(); ++i) {
            Decl decl = (Decl)decls.get(i);
            if (!(decl instanceof VarDecl)) continue;
            ListTerm names = ((VarDecl)decl).getDeclName();
            for (int j = 0; j < names.size(); ++j) {
                code = code + "\nthis." + names.get(j) + " = " + names.get(j) + ";";
            }
        }
        while (keys.hasMoreElements()) {
            DeclName declName = (DeclName)keys.nextElement();
            NameType nameType = (NameType)((Object)declName.getAnn(NameType.class));
            if (!nameType.equals((Object)NameType.LocalVariable) && !nameType.equals((Object)NameType.ActionParam)) continue;
            CircusType circusType = typeEnvironment.getCircusType(declName.toString());
            code = code + "\naux_left_" + declName.toString() + "_" + index + " = " + declName.toString() + ";";
        }
        return code;
    }

    private String parametersInstantiation(List parameters, NameTypeEnv typeEnvironment) {
        DeclName declName;
        String code = "";
        String comma = "";
        boolean isFirst = true;
        for (int i = 0; i < parameters.size(); ++i) {
            declName = (DeclName)parameters.get(i);
            code = code + comma + declName.toString();
            if (!comma.equals("")) continue;
            comma = ", ";
        }
        if (typeEnvironment != null) {
            Enumeration keys = typeEnvironment.keys();
            while (keys.hasMoreElements()) {
                declName = (DeclName)keys.nextElement();
                NameType nameType = (NameType)((Object)declName.getAnn(NameType.class));
                if (!nameType.equals((Object)NameType.LocalVariable) && !nameType.equals((Object)NameType.ActionParam)) continue;
                CircusType circusType = typeEnvironment.getCircusType(declName.toString());
                code = code + comma + declName.toString();
                if (!comma.equals("")) continue;
                comma = ", ";
            }
        }
        return code;
    }

    private String parametersInstantiation(List parameters) {
        return this.parametersInstantiation(parameters, null);
    }

    private String runInstantiation(List parameters, int index, int newIndex, NameTypeEnv typeEnvironment) {
        String code = "";
        code = "\nI_" + index + " i_" + index + "_" + newIndex + " = new I_" + index + "(" + this.parametersInstantiation(parameters, typeEnvironment) + "); ";
        code = code + "\ni_" + index + "_" + newIndex + ".run(); ";
        code = code + "\n" + this.mergeVarsRecursion(typeEnvironment, index, newIndex);
        return code;
    }

    private List<String> getInitialChannelsStr(List actions) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < actions.size(); ++i) {
            CircusAction circusAction = (CircusAction)actions.get(i);
            result.add(this.getInitialChannel(circusAction));
        }
        return result;
    }

    private String getInitialChannel(CircusAction circusAction) {
        String code = "";
        if (circusAction instanceof GuardedAction) {
            code = this.getInitialChannel(((GuardedAction)circusAction).getCircusAction());
        } else if (circusAction instanceof PrefixingAction) {
            Communication communication = ((PrefixingAction)circusAction).getCommunication();
            code = communication.getChanName().toString();
        } else {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportError(new Error(ErrorMessage.EXTCH_BRANCH, params));
        }
        return code;
    }

    private List<Pred> getGuards(List<CircusAction> actions) {
        ArrayList<Pred> result = new ArrayList<Pred>();
        for (int i = 0; i < actions.size(); ++i) {
            CircusAction circusAction = actions.get(i);
            result.add(this.getGuard(circusAction));
        }
        return result;
    }

    private Pred getGuard(CircusAction circusAction) {
        Object result;
        if (circusAction instanceof GuardedAction) {
            Pred pred = ((GuardedAction)circusAction).getPred();
            CircusAction circusAction2 = ((GuardedAction)circusAction).getCircusAction();
            Pred pred2 = this.getGuard(circusAction2);
            result = pred2.equals(this.factory_.createTruePred()) ? pred : this.factory_.createAndPred(pred, pred2, Op.And);
        } else {
            result = this.factory_.createTruePred();
        }
        return result;
    }

    private String runIteratedSequentialAction(List decls, int index, NameTypeEnv typeEnvironment) {
        int i;
        String code = "";
        List formDecls = this.formatDeclarations(decls);
        ArrayList<DeclName> parameters = new ArrayList<DeclName>();
        for (i = 0; i < formDecls.size(); ++i) {
            VarDecl varDecl = (VarDecl)formDecls.get(i);
            DeclName declName = (DeclName)varDecl.getDeclName().get(0);
            Expr expression = varDecl.getExpr();
            CircusType circusType = (CircusType)((Object)declName.getAnn(CircusType.class));
            String javaType = circusType.getJavaCircusTypeName();
            parameters.add(declName);
            code = code + "\nfor (" + javaType + " " + declName + " = " + this.getValue(javaType, 0) + "; ";
            code = code + declName + ".compareTo(" + this.getValue(javaType, 1) + ") <= 0; ";
            code = code + declName + ".setValue(" + declName + ".getValue() + 1" + ")) {";
        }
        code = code + "I_" + index + " i_" + index + "_" + index + " =  new I_" + index + "(" + this.parametersInstantiation(parameters, typeEnvironment) + ");";
        code = code + "\ni_" + index + "_" + index + ".run();";
        code = code + this.mergeVarsRecursion(typeEnvironment, index, index);
        for (i = 0; i < formDecls.size(); ++i) {
            code = code + "}";
        }
        return code;
    }

    private String runIteratedInternalChoiceAction(List decls, int index, NameTypeEnv typeEnvironment) {
        String code = "";
        List formatDecls = this.formatDeclarations(decls);
        ArrayList<DeclName> parameters = new ArrayList<DeclName>();
        for (int i = 0; i < formatDecls.size(); ++i) {
            VarDecl varDecl = (VarDecl)formatDecls.get(i);
            DeclName declName = (DeclName)varDecl.getDeclName().get(0);
            CircusType circusType = (CircusType)((Object)declName.getAnn(CircusType.class));
            code = code + "\n" + circusType.getJavaCircusTypeName() + " " + declName + " = new " + circusType.getJavaCircusTypeName() + "(RandomGenerator.generateNumber(" + circusType.getJavaCircusTypeName() + ".MIN_VALUE, " + circusType.getJavaCircusTypeName() + ".MAX_VALUE" + "));";
            parameters.add(declName);
        }
        code = code + "(new I_" + index + "(" + this.parametersInstantiation(parameters, typeEnvironment) + ")).run();";
        return code;
    }

    private List formatDeclarations(List decls) {
        ArrayList<VarDecl> r = new ArrayList<VarDecl>();
        for (int i = 0; i < decls.size(); ++i) {
            Decl decl = (Decl)decls.get(i);
            if (decl instanceof VarDecl) {
                ListTerm names = ((VarDecl)decl).getDeclName();
                Expr expression = ((VarDecl)decl).getExpr();
                for (int j = 0; j < names.size(); ++j) {
                    ArrayList declNames = new ArrayList();
                    declNames.add(names.get(j));
                    VarDecl newColonDecl = this.factory_.createVarDecl(declNames, expression);
                    r.add(newColonDecl);
                }
                continue;
            }
            throw new InvalidSubTypeException(decl.getClass());
        }
        return r;
    }

    private String getValue(String javaType, int type) {
        String value;
        value = type == 0 ? (value = "MIN_VALUE") : (value = "MAX_VALUE");
        String code = "new " + javaType + "(" + javaType + "." + value + ")";
        return code;
    }

    private List getNames(NameSet nameSet) {
        ArrayList<String> r = new ArrayList<String>();
        if (nameSet instanceof BasicNameSet) {
            ListTerm names = ((BasicNameSet)nameSet).getRefName();
            for (int i = 0; i < names.size(); ++i) {
                RefName refName = (RefName)names.get(i);
                r.add(refName.toString());
            }
        }
        return r;
    }

    private String paramsDecl(List decls) {
        String code = "";
        for (int i = 0; i < decls.size(); ++i) {
            Decl decl = (Decl)decls.get(i);
            this.isPrivate_ = true;
            code = code + (String)decl.accept((Visitor)this);
        }
        return code;
    }

    private String paramsArgs(List decls) {
        String code = "";
        String comma = "";
        boolean isFirst = true;
        for (int i = 0; i < decls.size(); ++i) {
            Decl decl = (Decl)decls.get(i);
            if (!(decl instanceof VarDecl)) continue;
            ListTerm names = ((VarDecl)decl).getDeclName();
            CircusType circusType = (CircusType)((Object)((TermA)names.get(0)).getAnn(CircusType.class));
            for (int j = 0; j < names.size(); ++j) {
                code = code + comma + circusType.getJavaCircusTypeName() + " " + names.get(j);
                if (!comma.equals("")) continue;
                comma = ", ";
            }
        }
        return code;
    }

    private String assignParams(List decls) {
        String code = "";
        for (int i = 0; i < decls.size(); ++i) {
            Decl decl = (Decl)decls.get(i);
            if (!(decl instanceof VarDecl)) continue;
            ListTerm names = ((VarDecl)decl).getDeclName();
            for (int j = 0; j < names.size(); ++j) {
                code = code + "\nthis." + names.get(j) + " = " + names.get(j) + ";";
            }
        }
        return code;
    }

    private String instProcesses(String procVecName, ProcessIte processIte, int index) throws Exception {
        int i;
        String code = "";
        Template template = null;
        ListTerm decls = processIte.getDecl();
        CircusProcess circusProcess = processIte.getCircusProcess();
        String lAttributes = this.paramsDecl((List)decls);
        String lParamDeclConstructor = this.paramsArgs((List)decls);
        String lConstructorBody = this.assignParams((List)decls);
        String lMethodRun = (String)circusProcess.accept((Visitor)this) + ".run();";
        String indexString = index + "";
        VelocityContext velocityContext = new VelocityContext();
        Velocity.init();
        velocityContext.put("lAttributes", (Object)lAttributes);
        velocityContext.put("lParamDeclConstructor", (Object)lParamDeclConstructor);
        velocityContext.put("lConstructorBody", (Object)lConstructorBody);
        velocityContext.put("lMethodRun", (Object)lMethodRun);
        velocityContext.put("index", (Object)indexString);
        velocityContext.put("runRecursion", (Object)"");
        template = Velocity.getTemplate((String)"MuAction.vm");
        StringWriter stringWriter = new StringWriter();
        template.merge((Context)velocityContext, (Writer)stringWriter);
        stringWriter.close();
        code = stringWriter.toString();
        code = "Vector " + procVecName + " = new Vector();\n" + code;
        List formDecls = this.formatDeclarations((List)decls);
        ArrayList<DeclName> parameters = new ArrayList<DeclName>();
        for (i = 0; i < formDecls.size(); ++i) {
            VarDecl varDecl = (VarDecl)formDecls.get(i);
            DeclName declName = (DeclName)varDecl.getDeclName().get(0);
            Expr expression = varDecl.getExpr();
            CircusType circusType = (CircusType)((Object)declName.getAnn(CircusType.class));
            String javaType = circusType.getJavaCircusTypeName();
            parameters.add(declName);
            code = code + "\nfor (" + javaType + " " + declName + " = " + this.getValue(javaType, 0) + "; ";
            code = code + declName + ".compareTo(" + this.getValue(javaType, 1) + ") <= 0; ";
            code = code + declName + ".setValue(" + declName + ".getValue() + 1" + ")) {";
        }
        code = code + procVecName + ".add(new I_" + index + "(" + this.parametersInstantiation(parameters) + "));";
        for (i = 0; i < formDecls.size(); ++i) {
            code = code + "} ";
        }
        return code;
    }

    private String chooseIndexVars(List decls) throws Exception {
        String code = "";
        List formatDecls = this.formatDeclarations(decls);
        String parameters = "";
        for (int i = 0; i < formatDecls.size(); ++i) {
            VarDecl varDecl = (VarDecl)formatDecls.get(i);
            DeclName declName = (DeclName)varDecl.getDeclName().get(0);
            CircusType circusType = (CircusType)((Object)declName.getAnn(CircusType.class));
            code = code + "\n" + circusType.getJavaCircusTypeName() + " " + declName + " = new " + circusType.getJavaCircusTypeName() + "(RandomGenerator.generateNumber(" + circusType.getJavaCircusTypeName() + ".MIN_VALUE, " + circusType.getJavaCircusTypeName() + ".MAX_VALUE" + "));";
            parameters = i == 0 ? parameters + declName : parameters + ", " + declName;
        }
        return code;
    }

    public String visitingSignature(Signature signature) {
        String code = "";
        ListTerm nameTypePairs = signature.getNameTypePair();
        for (int i = 0; i < nameTypePairs.size(); ++i) {
            NameTypePair nameTypePair = (NameTypePair)nameTypePairs.get(i);
            DeclName declName = nameTypePair.getName();
            CircusType circusType = (CircusType)nameTypePair.getType();
            code = code + "\nprivate " + circusType.getJavaCircusTypeName() + " " + declName.toString() + ";";
        }
        return code;
    }
}

