/*
 * Decompiled with CFR 0.152.
 */
package jcircus.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import jcircus.environment.Environment;
import jcircus.environment.NameTypeEnv;
import jcircus.environment.ProcChanEnv;
import jcircus.exceptions.ChanDefOtherChanSyncException;
import jcircus.exceptions.ChanDefOtherChanUseException;
import jcircus.exceptions.ChanSyncUnificationException;
import jcircus.exceptions.ChanUseUnificationException;
import jcircus.exceptions.DifferentCardinalitiesException;
import jcircus.exceptions.InvalidFormatCommException;
import jcircus.exceptions.InvalidParameterException;
import jcircus.exceptions.InvalidSubTypeException;
import jcircus.exceptions.MoreThanOneWriterException;
import jcircus.exceptions.UnrecoveredErrorException;
import jcircus.exceptions.VisitingMethodNotDefinedException;
import jcircus.util.ChanSync;
import jcircus.util.ChanUse;
import jcircus.util.CircusType;
import jcircus.util.Error;
import jcircus.util.ErrorMessage;
import jcircus.util.IdCircusProcessGenerator;
import jcircus.util.MathToolkitConstants;
import jcircus.util.NameType;
import jcircus.util.SignatureExpression;
import jcircus.util.Util;
import jcircus.util.annotations.IdCircusProcessAnn;
import jcircus.visitor.EnvLoadingVisitorInterface;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.circus.ast.Action1;
import net.sourceforge.czt.circus.ast.Action2;
import net.sourceforge.czt.circus.ast.ActionD;
import net.sourceforge.czt.circus.ast.ActionIte;
import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.AssignmentCommand;
import net.sourceforge.czt.circus.ast.BasicAction;
import net.sourceforge.czt.circus.ast.BasicChannelSet;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.CallProcess;
import net.sourceforge.czt.circus.ast.CallType;
import net.sourceforge.czt.circus.ast.ChannelDecl;
import net.sourceforge.czt.circus.ast.ChannelPara;
import net.sourceforge.czt.circus.ast.ChannelSet;
import net.sourceforge.czt.circus.ast.ChannelSetPara;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.CommType;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.DotField;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.Field;
import net.sourceforge.czt.circus.ast.GuardedAction;
import net.sourceforge.czt.circus.ast.HideProcess;
import net.sourceforge.czt.circus.ast.IfGuardedCommand;
import net.sourceforge.czt.circus.ast.InputField;
import net.sourceforge.czt.circus.ast.MuAction;
import net.sourceforge.czt.circus.ast.NameSetPara;
import net.sourceforge.czt.circus.ast.OutputField;
import net.sourceforge.czt.circus.ast.ParAction;
import net.sourceforge.czt.circus.ast.ParProcess;
import net.sourceforge.czt.circus.ast.ParamAction;
import net.sourceforge.czt.circus.ast.ParamProcess;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.Process1;
import net.sourceforge.czt.circus.ast.Process2;
import net.sourceforge.czt.circus.ast.ProcessD;
import net.sourceforge.czt.circus.ast.ProcessIdx;
import net.sourceforge.czt.circus.ast.ProcessIte;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circus.ast.RefChannelSet;
import net.sourceforge.czt.circus.ast.RenameProcess;
import net.sourceforge.czt.circus.ast.VarDeclCommand;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.BindExpr;
import net.sourceforge.czt.z.ast.Box;
import net.sourceforge.czt.z.ast.Branch;
import net.sourceforge.czt.z.ast.CondExpr;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.Expr0N;
import net.sourceforge.czt.z.ast.Expr1;
import net.sourceforge.czt.z.ast.Expr2;
import net.sourceforge.czt.z.ast.ExprPred;
import net.sourceforge.czt.z.ast.Fact;
import net.sourceforge.czt.z.ast.FreePara;
import net.sourceforge.czt.z.ast.Freetype;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.NameExprPair;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.NegPred;
import net.sourceforge.czt.z.ast.NumExpr;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.Pred2;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.Spec;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZSect;
import net.sourceforge.czt.z.util.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvLoadingVisitor
implements EnvLoadingVisitorInterface {
    private DeclName currentProcess_ = null;
    private DeclName currentAction_ = null;
    private String stateName_ = null;
    private Environment environment_;
    private boolean externalChoice_ = false;
    private String currentRecursiveAction_;
    private Factory factory_;
    private boolean globalScope_;
    private List<Error> errors_;

    public List<Error> getErrors() {
        return this.errors_;
    }

    private void reportError(Error error) {
        this.errors_.add(error);
    }

    private void reportFatalError(Error error) throws UnrecoveredErrorException {
        this.reportError(error);
        throw new UnrecoveredErrorException("Error during the environment loading.");
    }

    private void reportFatalError(Error error, Exception e) throws UnrecoveredErrorException {
        this.reportError(error);
        throw new UnrecoveredErrorException("Error during the environment loading.", e);
    }

    public EnvLoadingVisitor(Environment Environment2) {
        this.environment_ = Environment2;
        this.factory_ = new Factory();
        this.globalScope_ = true;
        this.stateName_ = null;
        this.loadMathToolkit();
        this.errors_ = new ArrayList<Error>();
    }

    public Object visitTerm(Term term) {
        throw new VisitingMethodNotDefinedException(term.getClass(), this.getClass());
    }

    public Object visitSpec(Spec spec) {
        ZSect zSect = (ZSect)spec.getSect().get(0);
        ListTerm paras = zSect.getPara();
        for (int i = 0; i < paras.size(); ++i) {
            Para para = (Para)paras.get(i);
            para.accept((Visitor)this);
        }
        return null;
    }

    public Object visitFreetype(Freetype freetype) {
        ListTerm branches = freetype.getBranch();
        DeclName declNameFreetype = freetype.getDeclName();
        this.environment_.freeTypesEnvironmentAdd(freetype);
        CircusType circusType = new CircusType((Expr)this.factory_.createPowerExpr((Expr)this.factory_.createRefExpr(this.factory_.createRefName(declNameFreetype.toString()))));
        this.environment_.declareName(this.factory_.createDeclName(declNameFreetype.toString()), NameType.FreeType, circusType);
        for (int i = 0; i < branches.size(); ++i) {
            RefExpr type;
            Branch branch = (Branch)branches.get(i);
            DeclName declNameBranch = branch.getDeclName();
            Expr expr = branch.getExpr();
            RefExpr refExprNameFreeType = this.factory_.createRefExpr(this.factory_.createRefName(declNameFreetype));
            if (expr != null) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(expr);
                list.add(declNameFreetype);
                type = this.factory_.createPowerExpr((Expr)this.factory_.createProdExpr(expr, (Expr)refExprNameFreeType));
            } else {
                type = refExprNameFreeType;
            }
            boolean b = i == 0;
            this.environment_.declareName(this.factory_.createDeclName(declNameBranch.toString()), NameType.ElemFreeType, new CircusType((Expr)type), b);
        }
        return null;
    }

    public Object visitSchText(SchText schText) {
        Signature result = this.factory_.createSignature(Util.createEmptyList());
        ListTerm decls = schText.getDecl();
        Pred pred = schText.getPred();
        NameType nameType = Util.getAndRemoveNameTypeAnn((TermA)schText);
        this.environment_.openScope();
        if (decls != null) {
            for (int i = 0; i < decls.size(); ++i) {
                Decl decl = (Decl)decls.get(i);
                Util.addNameTypeAnn((TermA)decl, nameType);
                Signature signature = (Signature)decl.accept((Visitor)this);
                result.getNameTypePair().addAll((Collection)signature.getNameTypePair());
            }
        }
        if (pred != null) {
            pred.accept((Visitor)this);
        }
        this.environment_.closeScope();
        return result;
    }

    public Object visitChannelDecl(ChannelDecl channelDecl) {
        ListTerm genNames = channelDecl.getDeclName();
        Decl decl = channelDecl.getDecl();
        if (decl instanceof VarDecl) {
            VarDecl varDecl = (VarDecl)decl;
            ListTerm declNames = varDecl.getDeclName();
            Expr expr = varDecl.getExpr();
            CircusType circusType = expr != null ? (genNames != null && genNames.size() > 0 ? new CircusType((List)genNames, expr) : new CircusType(expr)) : CircusType.createSyncType();
            for (int i = 0; i < declNames.size(); ++i) {
                DeclName declName = (DeclName)declNames.get(i);
                this.environment_.declareName(declName, NameType.Channel, circusType);
            }
        } else {
            throw new InvalidSubTypeException(decl.getClass());
        }
        return null;
    }

    public Object visitVarDecl(VarDecl varDecl) {
        ListTerm declNames = varDecl.getDeclName();
        Expr expr = varDecl.getExpr();
        expr.accept((Visitor)this);
        CircusType circusType = new CircusType(expr);
        NameType nameType = Util.getAndRemoveNameTypeAnn((TermA)varDecl);
        for (int i = 0; i < declNames.size(); ++i) {
            DeclName declName = (DeclName)declNames.get(i);
            this.environment_.declareName(declName, nameType, circusType);
            Util.addCircusTypeAnn((TermA)declName, circusType);
        }
        return null;
    }

    public Object visitConstDecl(ConstDecl constDecl) {
        DeclName declName = constDecl.getDeclName();
        Expr expr = constDecl.getExpr();
        expr.accept((Visitor)this);
        CircusType circusType = new CircusType(expr);
        NameType nameType = Util.getAndRemoveNameTypeAnn((TermA)constDecl);
        circusType = this.environment_.declareName(declName, nameType, circusType);
        Util.addCircusTypeAnn((TermA)declName, circusType);
        return null;
    }

    public Object visitChannelPara(ChannelPara channelPara) {
        ListTerm decls = channelPara.getChannelDecl();
        for (int i = 0; i < decls.size(); ++i) {
            Decl decl = (Decl)decls.get(i);
            decl.accept((Visitor)this);
        }
        return null;
    }

    public Object visitChannelSetPara(ChannelSetPara channelSetPara) {
        DeclName declName = channelSetPara.getDeclName();
        ChannelSet channelSet = channelSetPara.getChannelSet();
        HashSet hashSet = (HashSet)channelSet.accept((Visitor)this);
        this.environment_.declareChannelSet(declName.toString(), hashSet);
        return null;
    }

    public Object visitProcessPara(ProcessPara processPara) {
        DeclName declName = processPara.getDeclName();
        CircusProcess circusProcess = processPara.getCircusProcess();
        this.currentProcess_ = declName;
        this.globalScope_ = false;
        if (circusProcess instanceof HideProcess) {
            Util.addHideOkAnn((HideProcess)circusProcess);
        }
        ProcChanEnv procChanEnv = (ProcChanEnv)circusProcess.accept((Visitor)this);
        Util.addProcChanEnvAnn((TermA)processPara, procChanEnv);
        Util.addChannelMSEnvAnn((TermA)processPara, procChanEnv.getChanInfoEnv());
        this.environment_.declareProcess(declName.toString(), procChanEnv);
        this.globalScope_ = true;
        this.currentProcess_ = null;
        return null;
    }

    public Object visitFreePara(FreePara freePara) {
        ListTerm freeTypes = freePara.getFreetype();
        for (int i = 0; i < freeTypes.size(); ++i) {
            Freetype freetype = (Freetype)freeTypes.get(i);
            freetype.accept((Visitor)this);
        }
        return null;
    }

    public Object visitActionPara(ActionPara actionPara) {
        ProcChanEnv result = null;
        DeclName actionName = actionPara.getDeclName();
        CircusAction circusAction = actionPara.getCircusAction();
        this.currentAction_ = actionName;
        result = (ProcChanEnv)circusAction.accept((Visitor)this);
        this.currentAction_ = null;
        return result;
    }

    public Object visitNameSetPara(NameSetPara NameSetPara2) {
        return null;
    }

    public Object visitAxPara(AxPara axPara) {
        Box box = axPara.getBox();
        ListTerm genParams = axPara.getDeclName();
        SchText schText = axPara.getSchText();
        if (box.equals((Object)Box.AxBox) || box.equals((Object)Box.OmitBox)) {
            NameType nameType = this.globalScope_ ? NameType.GlobalConstant : NameType.LocalConstant;
            ListTerm decls = schText.getDecl();
            Pred pred = schText.getPred();
            this.environment_.openScope();
            for (int i = 0; i < decls.size(); ++i) {
                Decl decl = (Decl)decls.get(i);
                Util.addNameTypeAnn((TermA)decl, nameType);
                decl.accept((Visitor)this);
            }
            if (pred != null) {
                pred.accept((Visitor)this);
            }
            Signature signature = null;
            signature = this.environment_.getCurrentScopeAsSig();
            this.environment_.closeScope();
            this.defineSignature(signature, NameType.StateComponent);
        } else if (box.equals((Object)Box.SchBox)) {
            DeclName schName = ((ConstDecl)schText.getDecl().get(0)).getDeclName();
            ListTerm decls = ((SchExpr)((ConstDecl)schText.getDecl().get(0)).getExpr()).getSchText().getDecl();
            Pred pred = ((SchExpr)((ConstDecl)schText.getDecl().get(0)).getExpr()).getSchText().getPred();
            this.environment_.openScope();
            for (int i = 0; i < decls.size(); ++i) {
                Decl decl = (Decl)decls.get(i);
                Util.addNameTypeAnn((TermA)decl, NameType.StateComponent);
                decl.accept((Visitor)this);
            }
            if (pred != null) {
                pred.accept((Visitor)this);
            }
            Signature signature = this.environment_.getCurrentScopeAsSig();
            this.environment_.closeScope();
            this.environment_.declareName(schName, NameType.SchemaName, new CircusType(new SignatureExpression(signature)));
            if (this.stateName_ != null && this.stateName_.equals(schName.toString())) {
                this.defineSignature(signature, NameType.StateComponent);
            }
        } else {
            throw new InvalidParameterException("Box == " + axPara.getBox());
        }
        return null;
    }

    public Object visitBasicChannelSet(BasicChannelSet basicChannelSet) {
        HashSet<String> r = new HashSet<String>();
        ListTerm list = basicChannelSet.getRefName();
        for (int i = 0; i < list.size(); ++i) {
            r.add(list.get(i).toString());
        }
        return r;
    }

    public Object visitRefChannelSet(RefChannelSet refChannelSet) {
        HashSet result = null;
        RefName refName = refChannelSet.getRefName();
        result = this.environment_.getChannelSet(refName.toString());
        return result;
    }

    public Object visitBasicProcess(BasicProcess basicProcess) {
        ProcChanEnv result = new ProcChanEnv();
        RefName stateSchemaRefName = basicProcess.getStateSchema();
        CircusAction mainAction = basicProcess.getMainAction();
        ListTerm actionParas = basicProcess.getCircusActionPara();
        ListTerm nameSetParas = basicProcess.getCircusNameSetPara();
        ListTerm zParas = basicProcess.getZPara();
        try {
            int i;
            if (stateSchemaRefName != null) {
                this.stateName_ = stateSchemaRefName.toString();
            }
            ProcChanEnv procChanEnv = null;
            for (i = 0; i < zParas.size(); ++i) {
                Para para = (Para)zParas.get(i);
                para.accept((Visitor)this);
            }
            for (i = 0; i < nameSetParas.size(); ++i) {
                NameSetPara nameSetPara = (NameSetPara)nameSetParas.get(i);
                nameSetPara.accept((Visitor)this);
            }
            if (stateSchemaRefName != null) {
                CircusType circusType = this.environment_.getCircusType(stateSchemaRefName.toString());
                Util.addCircusTypeAnn((TermA)stateSchemaRefName, circusType);
                Signature signature = ((SignatureExpression)circusType.getExpression()).getSignature();
                this.defineSignature(signature, NameType.StateComponent);
            }
            for (int i2 = 0; i2 < actionParas.size(); ++i2) {
                ActionPara actionPara = (ActionPara)actionParas.get(i2);
                CircusAction circusAction = actionPara.getCircusAction();
                procChanEnv = (ProcChanEnv)actionPara.accept((Visitor)this);
                result = result.merge(procChanEnv, false);
            }
            procChanEnv = (ProcChanEnv)mainAction.accept((Visitor)this);
            result = result.merge(procChanEnv, false);
            int id = IdCircusProcessGenerator.getGenerator().getNextId();
            IdCircusProcessAnn ann = new IdCircusProcessAnn(id);
            Util.addIdCircusProcessAnn((TermA)basicProcess, ann);
            result.transform(new Integer(id));
            result.setBasicProcess();
        }
        catch (MoreThanOneWriterException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.PAR_WRITERS, params), e);
        }
        catch (ChanUseUnificationException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.CHANUSE_UNIF, params), e);
        }
        catch (DifferentCardinalitiesException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.DIFF_CARD, params), e);
        }
        catch (ChanSyncUnificationException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.CHANSYNC_UNIF, params), e);
        }
        this.stateName_ = null;
        return result;
    }

    public Object visitCallProcess(CallProcess callProcess) {
        ProcChanEnv result = null;
        RefName refName = callProcess.getRefName();
        CallType callType = callProcess.getCallType();
        if (callType == CallType.Normal) {
            result = this.environment_.getProcessChannelEnvironment(refName.toString());
        } else if (callType == CallType.Param || callType == CallType.Gen || callType == CallType.Index) {
            ListTerm params = callProcess.getExpr();
            for (int i = 0; i < params.size(); ++i) {
                Expr expr = (Expr)params.get(i);
                expr.accept((Visitor)this);
            }
            result = this.environment_.getProcessChannelEnvironment(refName.toString());
        } else {
            throw new InvalidParameterException("Invalid Parameter (" + callType.getClass() + "): " + callType.toString());
        }
        IdCircusProcessAnn ann = new IdCircusProcessAnn(IdCircusProcessGenerator.getGenerator().getNextId());
        Util.addIdCircusProcessAnn((TermA)callProcess, ann);
        if (result.isBasicProcess()) {
            result = result.replaceIdInChanInfoEnv(ann.getId());
        }
        return result;
    }

    public Object visitProcess1(Process1 process1) {
        CircusProcess circusProcess = process1.getCircusProcess();
        ProcChanEnv result = (ProcChanEnv)circusProcess.accept((Visitor)this);
        IdCircusProcessAnn ann = new IdCircusProcessAnn(IdCircusProcessGenerator.getGenerator().getNextId());
        Util.addIdCircusProcessAnn((TermA)process1, ann);
        return result;
    }

    public Object visitRenameProcess(RenameProcess renameProcess) {
        ProcChanEnv result = null;
        CircusProcess circusProcess = renameProcess.getCircusProcess();
        ListTerm oldChannels = renameProcess.getOldNames();
        ListTerm newChannels = renameProcess.getNewNames();
        result = (ProcChanEnv)circusProcess.accept((Visitor)this);
        result = result.substitute((List)newChannels, (List)oldChannels);
        IdCircusProcessAnn ann = new IdCircusProcessAnn(IdCircusProcessGenerator.getGenerator().getNextId());
        Util.addIdCircusProcessAnn((TermA)renameProcess, ann);
        return result;
    }

    public Object visitHideProcess(HideProcess hideProcess) {
        ProcChanEnv result = null;
        CircusProcess circusProcess = hideProcess.getCircusProcess();
        ChannelSet channelSet = hideProcess.getChannelSet();
        if (Util.getHideOkAnn(hideProcess) == null) {
            Object[] params = new Object[]{this.currentProcess_};
            this.reportError(new Error(ErrorMessage.HIDE_PROC_ILLEGAL, params));
        }
        HashSet channelNames = (HashSet)channelSet.accept((Visitor)this);
        result = (ProcChanEnv)circusProcess.accept((Visitor)this);
        result = result.hide(channelNames);
        IdCircusProcessAnn ann = new IdCircusProcessAnn(IdCircusProcessGenerator.getGenerator().getNextId());
        Util.addIdCircusProcessAnn((TermA)hideProcess, ann);
        return result;
    }

    public Object visitProcessD(ProcessD processD) {
        NameType nameType;
        ListTerm decls = processD.getDecl();
        CircusProcess circusProcess = processD.getCircusProcess();
        Util.addListTermAnn((TermA)processD, decls);
        if (processD instanceof ProcessIte || processD instanceof ProcessIdx) {
            nameType = NameType.LocalVariable;
        } else if (processD instanceof ParamProcess) {
            nameType = NameType.ProcessParam;
        } else {
            throw new InvalidSubTypeException(processD.getClass());
        }
        this.environment_.openScope();
        for (int i = 0; i < decls.size(); ++i) {
            Decl decl = (Decl)decls.get(i);
            Util.addNameTypeAnn((TermA)decl, nameType);
            decl.accept((Visitor)this);
        }
        ProcChanEnv result = (ProcChanEnv)circusProcess.accept((Visitor)this);
        this.environment_.closeScope();
        IdCircusProcessAnn ann = new IdCircusProcessAnn(IdCircusProcessGenerator.getGenerator().getNextId());
        Util.addIdCircusProcessAnn((TermA)processD, ann);
        return result;
    }

    public Object visitProcess2(Process2 process2) {
        ProcChanEnv result = null;
        ProcChanEnv procChanLeft = (ProcChanEnv)process2.getLeftProc().accept((Visitor)this);
        ProcChanEnv procChanRight = (ProcChanEnv)process2.getRightProc().accept((Visitor)this);
        try {
            result = procChanLeft.merge(procChanRight, false);
        }
        catch (MoreThanOneWriterException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.PAR_WRITERS, params), e);
        }
        catch (ChanUseUnificationException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.CHANUSE_UNIF, params), e);
        }
        catch (ChanSyncUnificationException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.CHANSYNC_UNIF, params), e);
        }
        catch (DifferentCardinalitiesException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.DIFF_CARD, params), e);
        }
        IdCircusProcessAnn ann = new IdCircusProcessAnn(IdCircusProcessGenerator.getGenerator().getNextId());
        Util.addIdCircusProcessAnn((TermA)process2, ann);
        return result;
    }

    public Object visitParProcess(ParProcess parProcess) {
        ProcChanEnv result = null;
        try {
            ProcChanEnv procChanLeft = (ProcChanEnv)parProcess.getLeftProc().accept((Visitor)this);
            ProcChanEnv procChanRight = (ProcChanEnv)parProcess.getRightProc().accept((Visitor)this);
            result = procChanLeft.merge(procChanRight, true);
            IdCircusProcessAnn ann = new IdCircusProcessAnn(IdCircusProcessGenerator.getGenerator().getNextId());
            Util.addIdCircusProcessAnn((TermA)parProcess, ann);
        }
        catch (MoreThanOneWriterException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.PAR_WRITERS, params), e);
        }
        catch (ChanUseUnificationException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.CHANUSE_UNIF, params), e);
        }
        catch (ChanSyncUnificationException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.CHANSYNC_UNIF, params), e);
        }
        catch (DifferentCardinalitiesException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.DIFF_CARD, params), e);
        }
        return result;
    }

    public Object visitBasicAction(BasicAction basicAction) {
        return new ProcChanEnv();
    }

    public Object visitAction1(Action1 action1) {
        CircusAction circusAction = action1.getCircusAction();
        ProcChanEnv result = (ProcChanEnv)circusAction.accept((Visitor)this);
        return result;
    }

    public Object visitMuAction(MuAction muAction) {
        ProcChanEnv result = null;
        DeclName declName = muAction.getDeclName();
        CircusAction circusAction = muAction.getCircusAction();
        NameTypeEnv localEnvironment = this.environment_.localEnvironment();
        Util.addNameTypeEnvAnn((TermA)muAction, localEnvironment);
        this.environment_.openScope();
        result = (ProcChanEnv)circusAction.accept((Visitor)this);
        this.environment_.closeScope();
        return result;
    }

    public Object visitActionD(ActionD actionD) {
        NameType nameType;
        ProcChanEnv result = null;
        ListTerm decls = actionD.getDecl();
        CircusAction circusAction = actionD.getCircusAction();
        NameTypeEnv localEnvironment = this.environment_.localEnvironment();
        Util.addNameTypeEnvAnn((TermA)actionD, localEnvironment);
        if (actionD instanceof ActionIte) {
            nameType = NameType.LocalVariable;
        } else if (actionD instanceof ParamAction) {
            nameType = NameType.ActionParam;
        } else {
            throw new InvalidSubTypeException(actionD.getClass());
        }
        this.environment_.openScope();
        for (int i = 0; i < decls.size(); ++i) {
            Decl decl = (Decl)decls.get(i);
            Util.addNameTypeAnn((TermA)decl, nameType);
            decl.accept((Visitor)this);
        }
        result = (ProcChanEnv)circusAction.accept((Visitor)this);
        this.environment_.closeScope();
        return result;
    }

    public Object visitGuardedAction(GuardedAction guardedAction) {
        ProcChanEnv result = null;
        Pred pred = guardedAction.getPred();
        CircusAction circusAction = guardedAction.getCircusAction();
        pred.accept((Visitor)this);
        result = (ProcChanEnv)circusAction.accept((Visitor)this);
        return result;
    }

    public Object visitAction2(Action2 action2) {
        ProcChanEnv result = new ProcChanEnv();
        result = (ProcChanEnv)action2.getLeftAction().accept((Visitor)this);
        try {
            result = result.merge((ProcChanEnv)action2.getRightAction().accept((Visitor)this), false);
        }
        catch (MoreThanOneWriterException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.PAR_WRITERS, params), e);
        }
        catch (ChanUseUnificationException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.CHANUSE_UNIF, params), e);
        }
        catch (ChanSyncUnificationException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.CHANSYNC_UNIF, params), e);
        }
        catch (DifferentCardinalitiesException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.DIFF_CARD, params), e);
        }
        return result;
    }

    public Object visitExtChoiceAction(ExtChoiceAction extChoiceAction) {
        ProcChanEnv result = new ProcChanEnv();
        CircusAction leftAction = extChoiceAction.getLeftAction();
        CircusAction rightAction = extChoiceAction.getRightAction();
        List<CircusAction> actions = Util.getActions((CircusAction)extChoiceAction, 1);
        for (int i = 0; i < actions.size(); ++i) {
            Object[] params;
            CircusAction circusAction = actions.get(i);
            this.externalChoice_ = true;
            try {
                result = result.merge((ProcChanEnv)circusAction.accept((Visitor)this), false);
                continue;
            }
            catch (MoreThanOneWriterException e) {
                params = new Object[]{this.currentProcess_, this.currentAction_};
                this.reportFatalError(new Error(ErrorMessage.PAR_WRITERS, params), e);
                continue;
            }
            catch (ChanUseUnificationException e) {
                params = new Object[]{this.currentProcess_, this.currentAction_};
                this.reportFatalError(new Error(ErrorMessage.CHANUSE_UNIF, params), e);
                continue;
            }
            catch (ChanSyncUnificationException e) {
                params = new Object[]{this.currentProcess_, this.currentAction_};
                this.reportFatalError(new Error(ErrorMessage.CHANSYNC_UNIF, params), e);
                continue;
            }
            catch (DifferentCardinalitiesException e) {
                params = new Object[]{this.currentProcess_, this.currentAction_};
                this.reportFatalError(new Error(ErrorMessage.DIFF_CARD, params), e);
            }
        }
        return result;
    }

    public Object visitParAction(ParAction parAction) {
        ProcChanEnv result = new ProcChanEnv();
        NameTypeEnv localEnvironment = this.environment_.localEnvironment();
        Util.addNameTypeEnvAnn((TermA)parAction, localEnvironment);
        result = (ProcChanEnv)parAction.getLeftAction().accept((Visitor)this);
        try {
            result = result.merge((ProcChanEnv)parAction.getRightAction().accept((Visitor)this), true);
        }
        catch (MoreThanOneWriterException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.PAR_WRITERS, params), e);
        }
        catch (ChanUseUnificationException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.CHANUSE_UNIF, params), e);
        }
        catch (ChanSyncUnificationException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.CHANSYNC_UNIF, params), e);
        }
        catch (DifferentCardinalitiesException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_};
            this.reportFatalError(new Error(ErrorMessage.DIFF_CARD, params), e);
        }
        return result;
    }

    public Object visitCallAction(CallAction callAction) {
        ProcChanEnv result = new ProcChanEnv();
        RefName refName = callAction.getRefName();
        CallType callType = callAction.getCallType();
        if (callType == CallType.Normal) {
            Util.addNameTypeAnn((TermA)refName, NameType.ActionName);
        } else if (callType == CallType.Param || callType == CallType.Gen || callType == CallType.Index) {
            ListTerm params = callAction.getExpr();
            for (int i = 0; i < params.size(); ++i) {
                Expr expr = (Expr)params.get(i);
                expr.accept((Visitor)this);
            }
            Util.addNameTypeAnn((TermA)refName, NameType.ActionName);
        } else {
            throw new InvalidParameterException("Invalid Parameter (" + callType.getClass() + "): " + callType.toString());
        }
        return result;
    }

    public Object visitPrefixingAction(PrefixingAction prefixingAction) {
        ProcChanEnv result = null;
        CircusAction circusAction = prefixingAction.getCircusAction();
        Communication communication = prefixingAction.getCommunication();
        ChanUse chanUse = null;
        ChanSync chanSync = null;
        this.environment_.openScope();
        communication.accept((Visitor)this);
        try {
            chanUse = Util.getChanUseClassification(communication);
            if (this.externalChoice_) {
                if (chanUse.equals((Object)ChanUse.Output)) {
                    Object[] params = new Object[]{this.currentProcess_, this.currentAction_, communication.getChanName()};
                    this.reportFatalError(new Error(ErrorMessage.OUTPUT_EXT_CHOICE, params));
                }
                chanUse = ChanUse.Input;
                this.externalChoice_ = false;
            } else {
                chanUse = Util.getChanUseClassification(communication);
            }
            chanSync = Util.getChanSyncClassification(communication);
        }
        catch (InvalidFormatCommException e) {
            Object[] params = new Object[]{this.currentProcess_, this.currentAction_, communication.getChanName()};
            this.reportFatalError(new Error(ErrorMessage.CHAN_FORMAT, params), e);
        }
        CircusType circusTypeChannel = this.environment_.getCircusType(communication.getChanName().toString());
        result = (ProcChanEnv)circusAction.accept((Visitor)this);
        this.environment_.closeScope();
        try {
            result.includeVisible(communication.getChanName().toString(), chanUse, chanSync, circusTypeChannel);
        }
        catch (ChanDefOtherChanUseException e) {
        }
        catch (ChanDefOtherChanSyncException e) {
            // empty catch block
        }
        return result;
    }

    public Object visitCommunication(Communication communication) {
        Field field;
        RefName chanName = communication.getChanName();
        ListTerm chanFields = communication.getChanFields();
        ListTerm genActuals = communication.getGenActuals();
        Integer multiSych = communication.getMultiSych();
        CommType commType = communication.getCommType();
        CircusType circusTypeChannel = this.environment_.getCircusType(chanName.toString());
        for (int i = 0; i < chanFields.size(); ++i) {
            field = (Field)chanFields.get(i);
            field.accept((Visitor)this);
        }
        field = null;
        if (chanFields.size() > 0 && (field = (Field)chanFields.get(chanFields.size() - 1)) instanceof InputField) {
            RefName refName = ((InputField)field).getVariable();
            CircusType circusTypeVariable = Util.getLastTypeChannel(circusTypeChannel, genActuals);
            circusTypeVariable = this.environment_.declareName(this.factory_.createDeclName(refName.toString()), NameType.LocalVariable, circusTypeVariable);
            Util.addCircusTypeAnn((TermA)refName, circusTypeVariable);
        }
        return null;
    }

    public Object visitInputField(InputField inputField) {
        Pred restriction = inputField.getRestriction();
        RefName variable = inputField.getVariable();
        if (restriction != null) {
            restriction.accept((Visitor)this);
        }
        return null;
    }

    public Object visitOutputField(OutputField outputField) {
        Expr expr = outputField.getExpression();
        expr.accept((Visitor)this);
        return null;
    }

    public Object visitDotField(DotField dotField) {
        Expr expr = dotField.getExpression();
        expr.accept((Visitor)this);
        return null;
    }

    public Object visitAssignmentCommand(AssignmentCommand assignmentCommand) {
        ProcChanEnv result = new ProcChanEnv();
        ListTerm leftVars = assignmentCommand.getLeftVars();
        ListTerm exprs = assignmentCommand.getExprs();
        for (int i = 0; i < leftVars.size(); ++i) {
            RefName refName = (RefName)leftVars.get(i);
            Expr expr = (Expr)exprs.get(i);
            CircusType circusType = this.environment_.getCircusType(refName.toString());
            Util.addCircusTypeAnn((TermA)refName, circusType);
            expr.accept((Visitor)this);
        }
        return result;
    }

    public Object visitIfGuardedCommand(IfGuardedCommand ifGuardedCommand) {
        ProcChanEnv result = new ProcChanEnv();
        ListTerm guardedActions = ifGuardedCommand.getGuardedAction();
        ProcChanEnv procChanEnv = null;
        for (int i = 0; i < guardedActions.size(); ++i) {
            Object[] params;
            GuardedAction guardedAction = (GuardedAction)guardedActions.get(i);
            procChanEnv = (ProcChanEnv)guardedAction.accept((Visitor)this);
            try {
                result = result.merge(procChanEnv, false);
                continue;
            }
            catch (MoreThanOneWriterException e) {
                params = new Object[]{this.currentProcess_, this.currentAction_};
                this.reportFatalError(new Error(ErrorMessage.PAR_WRITERS, params), e);
                continue;
            }
            catch (ChanUseUnificationException e) {
                params = new Object[]{this.currentProcess_, this.currentAction_};
                this.reportFatalError(new Error(ErrorMessage.CHANUSE_UNIF, params), e);
                continue;
            }
            catch (ChanSyncUnificationException e) {
                params = new Object[]{this.currentProcess_, this.currentAction_};
                this.reportFatalError(new Error(ErrorMessage.CHANSYNC_UNIF, params), e);
                continue;
            }
            catch (DifferentCardinalitiesException e) {
                params = new Object[]{this.currentProcess_, this.currentAction_};
                this.reportFatalError(new Error(ErrorMessage.DIFF_CARD, params), e);
            }
        }
        return result;
    }

    public Object visitVarDeclCommand(VarDeclCommand varDeclCommand) {
        ProcChanEnv result = new ProcChanEnv();
        ListTerm decls = varDeclCommand.getDeclarations();
        CircusAction circusAction = varDeclCommand.getCircusAction();
        this.environment_.openScope();
        for (int i = 0; i < decls.size(); ++i) {
            Decl decl = (Decl)decls.get(i);
            Util.addNameTypeAnn((TermA)decl, NameType.LocalVariable);
            decl.accept((Visitor)this);
        }
        result = (ProcChanEnv)circusAction.accept((Visitor)this);
        this.environment_.closeScope();
        return result;
    }

    public Object visitFact(Fact fact) {
        return null;
    }

    public Object visitExprPred(ExprPred exprPred) {
        Expr expr = exprPred.getExpr();
        expr.accept((Visitor)this);
        return null;
    }

    public Object visitMemPred(MemPred memPred) {
        Expr leftExpr = memPred.getLeftExpr();
        Expr rightExpr = memPred.getRightExpr();
        leftExpr.accept((Visitor)this);
        rightExpr.accept((Visitor)this);
        return null;
    }

    public Object visitNegPred(NegPred negPred) {
        negPred.getPred().accept((Visitor)this);
        return null;
    }

    public Object visitPred2(Pred2 pred2) {
        pred2.getLeftPred().accept((Visitor)this);
        pred2.getRightPred().accept((Visitor)this);
        return null;
    }

    public Object visitRefExpr(RefExpr refExpr) {
        RefName refName = refExpr.getRefName();
        CircusType circusType = this.environment_.getCircusType(refName.toString());
        Util.addCircusTypeAnn((TermA)refName, circusType);
        NameType nameType = this.environment_.getNameType(refName.toString());
        Util.addNameTypeAnn((TermA)refName, nameType);
        return null;
    }

    public Object visitNumExpr(NumExpr NumExpr2) {
        return null;
    }

    public Object visitExpr2(Expr2 expr2) {
        expr2.getLeftExpr().accept((Visitor)this);
        expr2.getRightExpr().accept((Visitor)this);
        return null;
    }

    public Object visitExpr1(Expr1 expr1) {
        expr1.getExpr().accept((Visitor)this);
        return null;
    }

    public Object visitExpr0N(Expr0N expr0N) {
        ListTerm exprs = expr0N.getExpr();
        for (int i = 0; i < exprs.size(); ++i) {
            Expr expr = (Expr)exprs.get(i);
            expr.accept((Visitor)this);
        }
        return null;
    }

    public Object visitBindExpr(BindExpr bindExpr) {
        ListTerm pairs = bindExpr.getNameExprPair();
        for (int i = 0; i < pairs.size(); ++i) {
            NameExprPair pair = (NameExprPair)pairs.get(i);
            DeclName declName = pair.getName();
            Expr expr = pair.getExpr();
            expr.accept((Visitor)this);
        }
        return null;
    }

    public Object visitCondExpr(CondExpr condExpr) {
        Pred pred = condExpr.getPred();
        Expr leftExpr = condExpr.getLeftExpr();
        Expr rightExpr = condExpr.getRightExpr();
        pred.accept((Visitor)this);
        leftExpr.accept((Visitor)this);
        rightExpr.accept((Visitor)this);
        return null;
    }

    public Object visitSchExpr(SchExpr schExpr) {
        SchText schText = schExpr.getSchText();
        Util.addNameTypeAnn((TermA)schText, NameType.StateComponent);
        schText.accept((Visitor)this);
        return null;
    }

    public Object visitApplExpr(ApplExpr applExpr) {
        Expr leftExpr = applExpr.getLeftExpr();
        Expr rightExpr = applExpr.getRightExpr();
        Boolean mixfix = applExpr.getMixfix();
        leftExpr.accept((Visitor)this);
        rightExpr.accept((Visitor)this);
        return null;
    }

    public void defineSignature(Signature signature, NameType nameType) {
        ListTerm nameTypePairs = signature.getNameTypePair();
        for (int i = 0; i < nameTypePairs.size(); ++i) {
            NameTypePair nameTypePair = (NameTypePair)nameTypePairs.get(i);
            DeclName declName = nameTypePair.getName();
            CircusType circusType = (CircusType)nameTypePair.getType();
            this.environment_.declareName(declName, nameType, circusType);
        }
    }

    public void loadMathToolkit() {
        this.environment_.declareName(this.factory_.createDeclName(MathToolkitConstants.NAT), NameType.GlobalConstant, CircusType.createCircusInteger(), true);
        this.environment_.declareName(this.factory_.createDeclName(MathToolkitConstants.ADD), NameType.GlobalConstant, CircusType.createCircusInteger());
        this.environment_.declareName(this.factory_.createDeclName(MathToolkitConstants.SUB), NameType.GlobalConstant, CircusType.createCircusInteger());
        this.environment_.declareName(this.factory_.createDeclName(MathToolkitConstants.MULT), NameType.GlobalConstant, CircusType.createCircusInteger());
        this.environment_.declareName(this.factory_.createDeclName(MathToolkitConstants.DIV), NameType.GlobalConstant, CircusType.createCircusInteger());
        this.environment_.declareName(this.factory_.createDeclName(MathToolkitConstants.MOD), NameType.GlobalConstant, CircusType.createCircusInteger());
        this.environment_.declareName(this.factory_.createDeclName(MathToolkitConstants.LESS_EQUAL), NameType.GlobalConstant, CircusType.createCircusInteger());
        this.environment_.declareName(this.factory_.createDeclName(MathToolkitConstants.GREATER_EQUAL), NameType.GlobalConstant, CircusType.createCircusInteger());
        this.environment_.declareName(this.factory_.createDeclName(MathToolkitConstants.LESS), NameType.GlobalConstant, CircusType.createCircusInteger());
        this.environment_.declareName(this.factory_.createDeclName(MathToolkitConstants.GREATER), NameType.GlobalConstant, CircusType.createCircusInteger());
        this.environment_.declareName(this.factory_.createDeclName(MathToolkitConstants.NOTEQUAL), NameType.GlobalConstant, CircusType.createCircusInteger());
        this.environment_.declareName(this.factory_.createDeclName(MathToolkitConstants.NUM_RANGE), NameType.GlobalConstant, CircusType.createCircusInteger());
        this.environment_.declareName(this.factory_.createDeclName(MathToolkitConstants.PFUNCTION), NameType.GlobalConstant, CircusType.createCircusInteger());
        this.environment_.declareName(this.factory_.createDeclName(MathToolkitConstants.PINJECTION), NameType.GlobalConstant, CircusType.createCircusInteger());
        this.environment_.declareName(this.factory_.createDeclName(MathToolkitConstants.EMPTYSET), NameType.GlobalConstant, CircusType.createCircusInteger());
        this.environment_.declareName(this.factory_.createDeclName(MathToolkitConstants.UNION), NameType.GlobalConstant, CircusType.createCircusInteger());
        this.environment_.declareName(this.factory_.createDeclName(MathToolkitConstants.CARDINALITY), NameType.GlobalConstant, CircusType.createCircusInteger());
        this.environment_.declareName(this.factory_.createDeclName(MathToolkitConstants.SUBSETEQ), NameType.GlobalConstant, CircusType.createCircusInteger());
        this.environment_.declareName(this.factory_.createDeclName(MathToolkitConstants.SET_DIFF), NameType.GlobalConstant, CircusType.createCircusInteger());
    }
}

