/*
 * Decompiled with CFR 0.152.
 */
package jcircus.util;

import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import jcircus.environment.ChanInfoEnv;
import jcircus.environment.NameTypeEnv;
import jcircus.environment.ProcChanEnv;
import jcircus.environment.ProcChanUseEnv;
import jcircus.environment.TypeList;
import jcircus.exceptions.InvalidFormatCommException;
import jcircus.exceptions.InvalidParameterException;
import jcircus.exceptions.InvalidSubTypeException;
import jcircus.exceptions.JCircusException;
import jcircus.exceptions.NoChannelMSEnvAnnotationException;
import jcircus.exceptions.NoCircusTypeAnnotationException;
import jcircus.exceptions.NoIdCircusProcessAnnException;
import jcircus.exceptions.NoNameTypeAnnotationException;
import jcircus.exceptions.NoProcChanEnvAnnotationException;
import jcircus.exceptions.NoSignatureAnnException;
import jcircus.util.ChanSync;
import jcircus.util.ChanUse;
import jcircus.util.CircusType;
import jcircus.util.NameType;
import jcircus.util.annotations.HideOkAnn;
import jcircus.util.annotations.IdCircusProcessAnn;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.base.impl.ListTermImpl;
import net.sourceforge.czt.circus.ast.Action2;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.DotField;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.Field;
import net.sourceforge.czt.circus.ast.HideProcess;
import net.sourceforge.czt.circus.ast.InputField;
import net.sourceforge.czt.circus.ast.IntChoiceAction;
import net.sourceforge.czt.circus.ast.OutputField;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.ProdExpr;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.util.Factory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static Factory factory_ = new Factory();

    public static ChanUse getChanUseClassification(Communication communication) throws InvalidFormatCommException {
        ChanUse r;
        RefName chanName = communication.getChanName();
        ListTerm fields = communication.getChanFields();
        if (fields.size() == 0) {
            r = ChanUse.Undefined;
        } else {
            Field field;
            if (fields.size() == 1) {
                field = (Field)fields.get(0);
            } else {
                for (int i = 0; i < fields.size() - 2; ++i) {
                    field = (Field)fields.get(i);
                    if (field instanceof DotField) continue;
                    throw new InvalidFormatCommException();
                }
                field = (Field)fields.get(fields.size() - 1);
            }
            if (field instanceof InputField) {
                r = ChanUse.Input;
            } else if (field instanceof OutputField) {
                r = ChanUse.Output;
            } else if (field instanceof DotField) {
                r = ChanUse.Undefined;
            } else {
                throw new InvalidSubTypeException(field.getClass());
            }
        }
        return r;
    }

    public static ChanSync getChanSyncClassification(Communication communication) throws InvalidFormatCommException {
        ChanSync r;
        RefName chanName = communication.getChanName();
        ListTerm fields = communication.getChanFields();
        if (fields.size() == 0) {
            r = ChanSync.S;
        } else {
            Field field;
            if (fields.size() == 1) {
                field = (Field)fields.get(0);
            } else {
                for (int i = 0; i < fields.size() - 2; ++i) {
                    field = (Field)fields.get(i);
                    if (field instanceof DotField) continue;
                    throw new InvalidFormatCommException();
                }
                field = (Field)fields.get(fields.size() - 1);
            }
            if (field instanceof InputField) {
                r = ChanSync.C;
            } else if (field instanceof OutputField) {
                r = ChanSync.C;
            } else if (field instanceof DotField) {
                r = ChanSync.S;
            } else {
                throw new InvalidSubTypeException(field.getClass());
            }
        }
        return r;
    }

    public static String renameVars(String code, String newVar, String oldVar) throws Exception {
        ArrayList<String> newVars = new ArrayList<String>();
        newVars.add(newVar);
        ArrayList<String> oldVars = new ArrayList<String>();
        oldVars.add(oldVar);
        return Util.renameVars(code, newVars, oldVars);
    }

    public static String renameVars(String code, List newVars, List oldVars) throws InvalidSubTypeException {
        String newCode = "";
        StringTokenizer st = new StringTokenizer(code, ".;,(){} \t\n\r\f", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int index = Util.contains(oldVars, token);
            if (index != -1) {
                Object object = newVars.get(index);
                if (object instanceof String) {
                    token = (String)object;
                } else if (object instanceof Name) {
                    token = ((Name)object).toString();
                } else {
                    throw new InvalidSubTypeException(object.getClass());
                }
            }
            newCode = newCode + token;
        }
        return newCode;
    }

    private static int contains(List list, String token) {
        int r = -1;
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (!obj.toString().equals(token)) continue;
            r = i;
            break;
        }
        return r;
    }

    public static void addNameTypeAnn(TermA termA, NameType nameType) {
        termA.getAnns().add((Object)nameType);
    }

    public static NameType getAndRemoveNameTypeAnn(TermA termA) throws NoNameTypeAnnotationException {
        NameType nameType = Util.getNameTypeAnn(termA);
        termA.getAnns().remove((Object)nameType);
        return nameType;
    }

    public static NameType getNameTypeAnn(TermA termA) throws NoNameTypeAnnotationException {
        NameType nameType = (NameType)((Object)termA.getAnn(NameType.class));
        if (nameType == null) {
            throw new NoNameTypeAnnotationException();
        }
        return nameType;
    }

    public static void addChannelMSEnvAnn(TermA termA, ChanInfoEnv channelMSEnv) {
        termA.getAnns().add((Object)channelMSEnv);
    }

    public static ChanInfoEnv getChannelMSEnvAnn(TermA termA) throws NoChannelMSEnvAnnotationException {
        ChanInfoEnv channelMSEnv = (ChanInfoEnv)termA.getAnn(ChanInfoEnv.class);
        if (channelMSEnv == null) {
            throw new NoChannelMSEnvAnnotationException();
        }
        return channelMSEnv;
    }

    public static void addCircusTypeAnn(TermA termA, CircusType circusType) {
        termA.getAnns().add((Object)circusType);
    }

    public static CircusType getCircusTypeAnn(TermA termA) throws NoCircusTypeAnnotationException {
        CircusType circusType = (CircusType)((Object)termA.getAnn(CircusType.class));
        if (circusType == null) {
            throw new NoCircusTypeAnnotationException();
        }
        return circusType;
    }

    public static void addProcChanEnvAnn(TermA termA, ProcChanEnv procChanEnv) {
        termA.getAnns().add((Object)procChanEnv);
    }

    public static ProcChanEnv getProcChanEnvAnn(TermA termA) throws NoProcChanEnvAnnotationException {
        ProcChanEnv procChanEnv = (ProcChanEnv)termA.getAnn(ProcChanEnv.class);
        if (procChanEnv == null) {
            throw new NoProcChanEnvAnnotationException();
        }
        return procChanEnv;
    }

    public static void addNameTypeEnvAnn(TermA termA, NameTypeEnv nameTypeEnv) {
        termA.getAnns().add((Object)nameTypeEnv);
    }

    public static void addListTermAnn(TermA termA, ListTerm listTerm) {
        termA.getAnns().add((Object)listTerm);
    }

    public static ListTerm getListTermAnn(TermA termA) throws Exception {
        ListTerm listTerm = (ListTerm)termA.getAnn(ListTerm.class);
        if (listTerm == null) {
            throw new Exception("No annotation");
        }
        return listTerm;
    }

    public static void addIdCircusProcessAnn(TermA termA, IdCircusProcessAnn ann) {
        termA.getAnns().add((Object)ann);
    }

    public static IdCircusProcessAnn getIdCircusProcessAnn(TermA termA) throws NoIdCircusProcessAnnException {
        IdCircusProcessAnn ann = (IdCircusProcessAnn)termA.getAnn(IdCircusProcessAnn.class);
        if (ann == null) {
            throw new NoIdCircusProcessAnnException();
        }
        return ann;
    }

    public static void addSignatureAnn(RefName refName, Signature ann) {
        refName.getAnns().add((Object)ann);
    }

    public static Signature getSignatureAnn(RefName refName) throws NoSignatureAnnException {
        Signature ann = (Signature)refName.getAnn(Signature.class);
        if (ann == null) {
            throw new NoSignatureAnnException();
        }
        return ann;
    }

    public static void addHideOkAnn(HideProcess hideProcess) {
        hideProcess.getAnns().add((Object)new HideOkAnn());
    }

    public static HideOkAnn getHideOkAnn(HideProcess hideProcess) {
        return (HideOkAnn)hideProcess.getAnn(HideOkAnn.class);
    }

    public static List<CircusAction> getActions(CircusAction circusAction, int operation) {
        ArrayList<CircusAction> result = new ArrayList<CircusAction>();
        if (operation == 1 && circusAction instanceof ExtChoiceAction || operation == 0 && circusAction instanceof IntChoiceAction) {
            result.addAll(Util.getActions(((Action2)circusAction).getLeftAction(), operation));
            result.addAll(Util.getActions(((Action2)circusAction).getRightAction(), operation));
        } else if (operation == 1 || operation == 0) {
            result.add(circusAction);
        } else {
            throw new InvalidParameterException("Operation");
        }
        return result;
    }

    public static String arrayDim(CircusType channelType, ChanSync sc, int gap) {
        String r = "";
        int dim = Util.dim(channelType, sc);
        return Util.arrayDim(dim - gap);
    }

    public static String arrayDim(int dim) {
        String r = "";
        for (int i = 0; i < dim; ++i) {
            r = r + "[]";
        }
        return r;
    }

    public static int dim(CircusType channelType, ChanSync sc) {
        Object types;
        List genericParameters = channelType.getGenericParameters();
        if (channelType.isSyncType()) {
            types = new ArrayList();
            types.add(Util.createSyncExpression());
        } else {
            Expr typeExpression = channelType.getExpression();
            if (typeExpression instanceof ProdExpr) {
                types = ((ProdExpr)typeExpression).getExpr();
            } else {
                types = new ArrayList();
                types.add(typeExpression);
            }
        }
        return Util.dim(genericParameters, (List)types, sc);
    }

    public static int dim(List genTypes, List types, ChanSync sc) {
        int dim = types.size() == 1 && types.get(0).equals(Util.createSyncExpression()) ? 0 : (sc.equals((Object)ChanSync.C) ? types.size() - 1 : types.size());
        if (genTypes != null) {
            dim += genTypes.size();
        }
        return dim;
    }

    public static String instArray(CircusType circusTypeChannel, ChanSync syncType, TypeList typeList) {
        Object types;
        String code = "";
        List genPars = new ArrayList();
        if (circusTypeChannel.isGeneric()) {
            genPars = circusTypeChannel.getGenericParameters();
        }
        if (circusTypeChannel.isSyncType()) {
            types = new ArrayList();
            types.add(Util.createSyncExpression());
        } else {
            Expr typeExpression = circusTypeChannel.getExpression();
            if (typeExpression instanceof ProdExpr) {
                types = ((ProdExpr)typeExpression).getExpr();
            } else {
                types = new ArrayList();
                types.add(typeExpression);
            }
        }
        ArrayList<String> listOfTypes = new ArrayList<String>();
        Iterator iterator = typeList.iterator();
        while (iterator.hasNext()) {
            CircusType circusType = (CircusType)((Object)iterator.next());
            listOfTypes.add(circusType.getJavaCircusTypeName());
        }
        return code;
    }

    public static String instArray(List genTypes, List types, ChanSync sc, List typeList) {
        String code = "";
        int dim = Util.dim(genTypes, types, sc);
        code = genTypes.size() > 0 ? "new Any2OneChannel " + Util.arrayDim(dim) + "{ " + Util.genericInst(genTypes, types, sc, typeList, typeList) + " }" : Util.instArraySync(types, sc);
        return code;
    }

    public static String genericInst(List genTypes, List types, ChanSync sc, List typeList, List typeList2) {
        String code = "";
        Name genPar = (Name)genTypes.get(0);
        String type = (String)typeList2.get(0);
        code = typeList2.size() == 1 ? Util.instArray(genTypes.subList(1, genTypes.size()), Util.replace(genPar, type, types), sc, typeList) : Util.instArray(genTypes.subList(1, genTypes.size()), Util.replace(genPar, type, types), sc, typeList) + ", " + Util.genericInst(genTypes, types, sc, typeList, typeList2.subList(1, typeList2.size()));
        return code;
    }

    public static String instArraySync(List types, ChanSync sc) {
        String code = "";
        int dim = Util.dim(new ArrayList(), types, sc);
        String type = (String)types.get(0);
        if (types.size() == 1) {
            code = Util.baseCase(type, sc);
        } else {
            int n = 0;
            code = " new Any2OneChannel " + Util.arrayDim(dim) + "{ " + Util.typeInstSync(types, sc, n) + "} ";
        }
        return code;
    }

    public static String typeInstSync(List types, ChanSync sc, int n) {
        String code = "";
        code = n == 1 ? Util.instArraySync(types.subList(1, types.size()), sc) : Util.instArraySync(types.subList(1, types.size()), sc) + ", " + Util.typeInstSync(types, sc, n - 1);
        return code;
    }

    public static List replace(Name genPar, String t, List types) {
        ArrayList<String> newList = new ArrayList<String>();
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            newList.add(new String(t));
        }
        return newList;
    }

    public static String baseCase(String type, ChanSync sc) {
        String code = "";
        int n = 0;
        code = sc.equals((Object)ChanSync.C) ? "new Any2OneChannel()" : "Any2OneChannel.create(" + n + ")";
        return code;
    }

    public static Expr createSyncExpression() {
        Factory factory = new Factory();
        return factory.createRefExpr(factory.createRefName("*SYNCHRONIZATION_CHANNEL*"));
    }

    public static List createEmptyList() {
        return new ListTermImpl();
    }

    public static CircusType getLastTypeChannel(CircusType circusTypeChannel, ListTerm genActuals) throws InvalidParameterException {
        Expr lastTypeExpr;
        Expr typeExpression = circusTypeChannel.getExpression();
        if (typeExpression instanceof ProdExpr) {
            ListTerm expressions = ((ProdExpr)typeExpression).getExpr();
            lastTypeExpr = (Expr)expressions.get(expressions.size() - 1);
        } else {
            lastTypeExpr = circusTypeChannel.getExpression();
        }
        if (circusTypeChannel.isGeneric()) {
            List genParams = circusTypeChannel.getGenericParameters();
            if (lastTypeExpr instanceof RefExpr) {
                RefName name = ((RefExpr)lastTypeExpr).getRefName();
                for (int i = 0; i < genParams.size(); ++i) {
                    DeclName genParam = (DeclName)genParams.get(i);
                    if (!genParam.toString().equals(name.toString())) continue;
                    lastTypeExpr = (Expr)genActuals.get(i);
                    break;
                }
            } else {
                throw new InvalidParameterException("");
            }
        }
        CircusType r = new CircusType(lastTypeExpr);
        return r;
    }

    public static String getCodeFromTemplate(String templName, Hashtable ht) {
        String result = "";
        try {
            Template template = null;
            VelocityContext velocityContext = new VelocityContext();
            Velocity.init();
            for (String key : ht.keySet()) {
                String code = (String)ht.get(key);
                velocityContext.put(key, (Object)code);
            }
            template = Velocity.getTemplate((String)templName);
            StringWriter stringWriter = new StringWriter();
            template.merge((Context)velocityContext, (Writer)stringWriter);
            stringWriter.close();
            result = stringWriter.toString();
        }
        catch (Throwable t) {
            throw new JCircusException("Velocity exception", t);
        }
        return result;
    }

    public static String createFileFromTemplate(String fileName, String templName, Hashtable ht) {
        String result = "";
        try {
            Template template = null;
            File file = new File(fileName);
            FileWriter fileWriter = new FileWriter(fileName);
            VelocityContext velocityContext = new VelocityContext();
            Velocity.init();
            for (String key : ht.keySet()) {
                String code = (String)ht.get(key);
                velocityContext.put(key, (Object)code);
            }
            template = Velocity.getTemplate((String)templName);
            template.merge((Context)velocityContext, (Writer)fileWriter);
            fileWriter.close();
        }
        catch (Throwable t) {
            throw new JCircusException("Velocity exception", t);
        }
        return result;
    }

    public static String instChannelSimple(String channelName, ProcChanUseEnv chanMsEnv, Integer procId, boolean isMain) {
        String code = "";
        List ids = Util.resolveUndefinedChannels(chanMsEnv, isMain);
        code = code + "\nChannelInfo chanInfo_" + channelName + " = new " + "ChannelInfo" + "();";
        for (int i = 0; i < ids.size(); ++i) {
            Integer subProcId = (Integer)ids.get(i);
            code = code + "\nchanInfo_" + channelName + ".put(new Integer(" + subProcId + "), new Integer(" + i + "));";
        }
        code = code + "\nthis." + channelName + " = new GeneralChannel(" + "new Any2OneChannel(), chanInfo_" + channelName + ", new Integer(" + procId + "));";
        return code;
    }

    public static List resolveUndefinedChannels(ProcChanUseEnv chanMSEnv, boolean isMain) {
        Integer procId;
        Iterator it;
        Integer[] array;
        boolean writerDefined = false;
        int index = 0;
        if (!chanMSEnv.isSync()) {
            if (!isMain) {
                array = new Integer[chanMSEnv.size()];
                it = chanMSEnv.iteratorKeys();
                while (it.hasNext()) {
                    array[index] = procId = (Integer)it.next();
                    ++index;
                }
            } else {
                ChanUse chanUse;
                Integer procId2;
                Iterator it2;
                array = new Integer[chanMSEnv.size() + 1];
                ChanUse chanUseNotSync = chanMSEnv.getChanUseGuiNotSyncChannel();
                if (chanUseNotSync.equals((Object)ChanUse.Input)) {
                    array[0] = new Integer(-1);
                    index = 1;
                    it2 = chanMSEnv.iteratorKeys();
                    while (it2.hasNext()) {
                        procId2 = (Integer)it2.next();
                        chanUse = chanMSEnv.get(procId2);
                        array[index] = procId2;
                        ++index;
                    }
                } else {
                    array[1] = new Integer(-1);
                    index = 2;
                    writerDefined = false;
                    it2 = chanMSEnv.iteratorKeys();
                    while (it2.hasNext()) {
                        procId2 = (Integer)it2.next();
                        chanUse = chanMSEnv.get(procId2);
                        if (chanUse.equals((Object)ChanUse.Undefined) && !writerDefined) {
                            array[0] = procId2;
                            writerDefined = true;
                            continue;
                        }
                        if (index != chanMSEnv.size() + 1) continue;
                        array[0] = procId2;
                    }
                }
            }
        } else {
            array = new Integer[chanMSEnv.size()];
            index = 0;
            writerDefined = false;
            it = chanMSEnv.iteratorKeys();
            while (it.hasNext()) {
                procId = (Integer)it.next();
                ChanUse chanUse = chanMSEnv.get(procId);
                if (chanUse.equals((Object)ChanUse.Output) && !writerDefined) {
                    writerDefined = true;
                    array[0] = procId;
                    continue;
                }
                if (++index == array.length) {
                    index = 0;
                }
                array[index] = procId;
            }
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static void print(String st, String cl, String method) {
        boolean debug = true;
        if (debug) {
            System.out.println(":: " + cl + ", " + method + ": " + st);
        }
    }
}

