/*
 * Decompiled with CFR 0.152.
 */
package jcircus.translator;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import jcircus.environment.ChanInfoEnv;
import jcircus.environment.ChanUseEnv;
import jcircus.environment.Environment;
import jcircus.environment.ProcChanEnv;
import jcircus.environment.ProcChanUseEnv;
import jcircus.exceptions.FailParsingException;
import jcircus.exceptions.FailTranslationException;
import jcircus.exceptions.FailTypeCheckingException;
import jcircus.exceptions.InvalidParameterException;
import jcircus.exceptions.UnrecoveredErrorException;
import jcircus.util.ChanUse;
import jcircus.util.CircusType;
import jcircus.util.CodeFormatting;
import jcircus.util.MathToolkitConstants;
import jcircus.util.ProcInfo;
import jcircus.util.Util;
import jcircus.visitor.EnvLoadingVisitor;
import jcircus.visitor.TranslatorVisitor;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.ParamProcess;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.Branch;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.Freetype;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.Spec;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZSect;
import net.sourceforge.czt.z.util.Factory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Translator2Java {
    private String projectDir;
    private String projectName;
    private Spec spec;
    private TranslatorVisitor translatorVisitor_;
    private EnvLoadingVisitor envLoadingVisitor_;
    private Environment environment_;
    private List<ProcInfo> procInfoList;
    private List axParaCodeList;

    public Translator2Java(String projectDir, String projectName, Spec spec) {
        this.projectDir = projectDir;
        this.projectName = projectName;
        this.spec = spec;
        this.environment_ = new Environment();
        this.envLoadingVisitor_ = new EnvLoadingVisitor(this.environment_);
        this.translatorVisitor_ = new TranslatorVisitor(this.environment_);
        this.procInfoList = new ArrayList<ProcInfo>();
        this.axParaCodeList = new ArrayList();
    }

    public List<ProcInfo> getProcInfoList() {
        return this.procInfoList;
    }

    public Environment getEnvironment() {
        return this.environment_;
    }

    public void translate(boolean gui) throws Exception {
        this.projectDir = this.projectDir + "\\" + this.projectName + "\\" + "src";
        try {
            this.envLoadingVisitor_.visitSpec(this.spec);
        }
        catch (UnrecoveredErrorException e) {
            throw new FailTranslationException(this.envLoadingVisitor_.getErrors(), (Throwable)e);
        }
        if (!this.envLoadingVisitor_.getErrors().isEmpty()) {
            throw new FailTranslationException(this.envLoadingVisitor_.getErrors());
        }
        for (Para para : ((ZSect)this.spec.getSect().get(0)).getPara()) {
            if (para instanceof ProcessPara) {
                DeclName procName = ((ProcessPara)para).getDeclName();
                CircusProcess circusProcess = ((ProcessPara)para).getCircusProcess();
                String procParaCode = null;
                try {
                    procParaCode = (String)para.accept((Visitor)this.translatorVisitor_);
                }
                catch (UnrecoveredErrorException e) {
                    throw new FailTranslationException(this.translatorVisitor_.getErrors(), (Throwable)e);
                }
                if (!this.translatorVisitor_.getErrors().isEmpty()) {
                    throw new FailTranslationException(this.translatorVisitor_.getErrors());
                }
                boolean createMain = !gui && !(circusProcess instanceof ParamProcess);
                ProcInfo procInfo = new ProcInfo(procName.toString(), (ProcessPara)para, procParaCode, this.getNormalizedParams(circusProcess), createMain);
                this.procInfoList.add(procInfo);
                continue;
            }
            if (!(para instanceof AxPara)) continue;
            String axParaCode = (String)para.accept((Visitor)this.translatorVisitor_);
            this.axParaCodeList.add(axParaCode);
        }
        if (!gui) {
            this.createSources();
        }
    }

    public void createSources() throws Exception {
        this.createDirectoriesStructure();
        this.createTypeClass();
        this.createCircusIntegerClass();
        this.createClassesForFreeTypes();
        this.createAxDefHorizDefClass();
        for (int i = 0; i < this.procInfoList.size(); ++i) {
            ProcInfo procInfo = this.procInfoList.get(i);
            this.createProcessClass(procInfo.getProcessName(), procInfo.getCode());
            if (!procInfo.getCreateMain()) continue;
            this.createClassMain(procInfo);
            this.createGUI(procInfo);
            this.createBatFile(procInfo);
        }
        System.out.println("Source files for project '" + this.projectName + "' were created at " + this.projectDir);
    }

    private List<VarDecl> getNormalizedParams(CircusProcess circusProcess) {
        Factory factory = new Factory();
        ArrayList<VarDecl> normParams = new ArrayList<VarDecl>();
        if (circusProcess instanceof ParamProcess) {
            ListTerm decls = ((ParamProcess)circusProcess).getDecl();
            for (int i = 0; i < decls.size(); ++i) {
                Decl decl = (Decl)decls.get(i);
                if (decl instanceof VarDecl) {
                    ListTerm declNames = ((VarDecl)decl).getDeclName();
                    Expr expr = ((VarDecl)decl).getExpr();
                    for (int j = 0; j < declNames.size(); ++j) {
                        DeclName declName = (DeclName)declNames.get(j);
                        VarDecl newDecl = factory.createVarDecl(factory.list((Object)declName), expr);
                        normParams.add(newDecl);
                    }
                    continue;
                }
                throw new InvalidParameterException("");
            }
        }
        return normParams;
    }

    private void createDirectoriesStructure() throws Exception {
        File dirProcesses = new File(this.projectDir + "\\" + this.projectName + "\\" + "processes");
        File dirAxDefs = new File(this.projectDir + "\\" + this.projectName + "\\" + "axiomaticDefinitions");
        File dirTyping = new File(this.projectDir + "\\" + this.projectName + "\\" + "typing");
        File dirGui = new File(this.projectDir + "\\" + this.projectName + "\\" + "gui");
        try {
            dirProcesses.mkdirs();
            dirAxDefs.mkdirs();
            dirTyping.mkdirs();
            dirGui.mkdirs();
        }
        catch (SecurityException se) {
            throw new Exception("The creation of the directory structure was not possible.");
        }
    }

    private void createClassMain(ProcInfo procInfo) throws Exception {
        Template template = null;
        String nameMain = "Main_" + procInfo.getProcessName();
        String declarations = this.declarationsCode(procInfo.getProcessPara());
        String processCall = this.processCallCode(procInfo);
        String fileName = this.projectDir + "\\" + this.projectName + "\\" + nameMain + ".java";
        File file = new File(fileName);
        FileWriter fileWriter = new FileWriter(fileName);
        VelocityContext velocityContext = new VelocityContext();
        Velocity.init();
        velocityContext.put("package", (Object)this.getPackage(this.projectName, null));
        velocityContext.put("imports", (Object)this.getImports(this.projectName));
        velocityContext.put("proj", (Object)this.projectName);
        velocityContext.put("nameMain", (Object)nameMain);
        velocityContext.put("declarations", (Object)declarations);
        velocityContext.put("processCall", (Object)processCall);
        template = Velocity.getTemplate((String)"Main.vm");
        template.merge((Context)velocityContext, (Writer)fileWriter);
        fileWriter.close();
    }

    private void createGUI(ProcInfo procInfo) throws Exception {
        Template template = null;
        String nameMain = procInfo.getProcessName();
        String nameGui = this.getNameGui(nameMain);
        String fileName = this.projectDir + "\\" + this.projectName + "\\" + "gui" + "\\" + nameGui + ".java";
        File file = new File(fileName);
        FileWriter fileWriter = new FileWriter(fileName);
        VelocityContext velocityContext = new VelocityContext();
        Velocity.init();
        velocityContext.put("package", (Object)this.getPackage(this.projectName, "gui"));
        velocityContext.put("imports", (Object)this.getImports(this.projectName));
        velocityContext.put("className", (Object)nameGui);
        velocityContext.put("chanDecl", (Object)this.chanDeclGuiCode(procInfo.getProcessPara()));
        velocityContext.put("chanAssign", (Object)this.chanAssignGuiCode(procInfo.getProcessPara()));
        velocityContext.put("chanParam", (Object)this.chanParamGuiCode(procInfo.getProcessPara()));
        velocityContext.put("chanInit", (Object)this.chanInitGuiCode(procInfo.getProcessPara()));
        velocityContext.put("chanActPerf", (Object)this.chanActPerfGuiCode(procInfo.getProcessPara()));
        template = Velocity.getTemplate((String)"Gui.vm");
        template.merge((Context)velocityContext, (Writer)fileWriter);
        fileWriter.close();
    }

    private void createBatFile(ProcInfo procInfo) throws Exception {
        Template template = null;
        String processName = procInfo.getProcessName();
        String fileName = this.projectDir + "\\" + this.getNameBat(processName) + ".bat";
        File file = new File(fileName);
        FileWriter fileWriter = new FileWriter(fileName);
        VelocityContext velocityContext = new VelocityContext();
        Velocity.init();
        velocityContext.put("proj", (Object)this.projectName);
        velocityContext.put("main", (Object)this.getNameMain(processName));
        template = Velocity.getTemplate((String)"BatFile.vm");
        template.merge((Context)velocityContext, (Writer)fileWriter);
        fileWriter.close();
    }

    private String chanDeclGuiCode(ProcessPara processParaMain) {
        String code = "";
        String processName = processParaMain.getDeclName().toString();
        CircusProcess circusProcess = processParaMain.getCircusProcess();
        ChanInfoEnv channelMSEnv = Util.getChannelMSEnvAnn((TermA)processParaMain);
        ProcChanEnv procChanEnv = Util.getProcChanEnvAnn((TermA)processParaMain);
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();
        Iterator it = channelMSEnv.iteratorKeys();
        while (it.hasNext()) {
            String channelName = (String)it.next();
            ProcChanUseEnv syncEnv = channelMSEnv.get(channelName);
            if (syncEnv.isSync() || chanUseEnvHid.containsKey(channelName)) continue;
            code = code + "\n\nprivate final GeneralChannel " + channelName + ";";
            code = code + "\nprivate javax.swing.JButton btn_" + channelName + ";";
            code = code + "\nprivate javax.swing.JLabel lbl_" + channelName + ";";
            code = code + "\nprivate javax.swing.JTextField txt_" + channelName + ";";
        }
        return code;
    }

    private String chanParamGuiCode(ProcessPara processParaMain) {
        String code = "";
        String processName = processParaMain.getDeclName().toString();
        CircusProcess circusProcess = processParaMain.getCircusProcess();
        ChanInfoEnv channelMSEnv = Util.getChannelMSEnvAnn((TermA)processParaMain);
        ProcChanEnv procChanEnv = Util.getProcChanEnvAnn((TermA)processParaMain);
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();
        Iterator it = channelMSEnv.iteratorKeys();
        while (it.hasNext()) {
            String channelName = (String)it.next();
            ProcChanUseEnv syncEnv = channelMSEnv.get(channelName);
            if (syncEnv.isSync() || chanUseEnvHid.containsKey(channelName)) continue;
            code = code + ", GeneralChannel " + channelName;
        }
        return code;
    }

    private String chanAssignGuiCode(ProcessPara processParaMain) {
        String code = "";
        String processName = processParaMain.getDeclName().toString();
        CircusProcess circusProcess = processParaMain.getCircusProcess();
        ChanInfoEnv channelMSEnv = Util.getChannelMSEnvAnn((TermA)processParaMain);
        ProcChanEnv procChanEnv = Util.getProcChanEnvAnn((TermA)processParaMain);
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();
        Iterator it = channelMSEnv.iteratorKeys();
        while (it.hasNext()) {
            String channelName = (String)it.next();
            ProcChanUseEnv syncEnv = channelMSEnv.get(channelName);
            if (syncEnv.isSync() || chanUseEnvHid.containsKey(channelName)) continue;
            code = code + "\nthis." + channelName + " = " + channelName + ";";
        }
        return code;
    }

    private String chanInitGuiCode(ProcessPara processParaMain) throws Exception {
        String code = "";
        String processName = processParaMain.getDeclName().toString();
        CircusProcess circusProcess = processParaMain.getCircusProcess();
        ChanInfoEnv channelMSEnv = Util.getChannelMSEnvAnn((TermA)processParaMain);
        ProcChanEnv procChanEnv = Util.getProcChanEnvAnn((TermA)processParaMain);
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();
        Iterator it = channelMSEnv.iteratorKeys();
        while (it.hasNext()) {
            String channelName = (String)it.next();
            ProcChanUseEnv syncEnv = channelMSEnv.get(channelName);
            if (syncEnv.isSync() || chanUseEnvHid.containsKey(channelName)) continue;
            ChanUse chanUse = syncEnv.getChanUseGuiNotSyncChannel();
            CircusType circusType = procChanEnv.getNameTypeEnv().getCircusType(channelName);
            if (circusType.isSyncType()) {
                code = code + this.initGuiChanSync(channelName);
                continue;
            }
            String commTypeName = circusType.getJavaCircusTypeName();
            code = code + this.initGuiChanComm(channelName, chanUse.toStringGUI(), commTypeName);
        }
        return code;
    }

    private String chanActPerfGuiCode(ProcessPara processParaMain) throws Exception {
        String code = "";
        String processName = processParaMain.getDeclName().toString();
        CircusProcess circusProcess = processParaMain.getCircusProcess();
        ChanInfoEnv channelMSEnv = Util.getChannelMSEnvAnn((TermA)processParaMain);
        ProcChanEnv procChanEnv = Util.getProcChanEnvAnn((TermA)processParaMain);
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();
        Iterator it = channelMSEnv.iteratorKeys();
        while (it.hasNext()) {
            String channelName = (String)it.next();
            ProcChanUseEnv syncEnv = channelMSEnv.get(channelName);
            if (syncEnv.isSync() || chanUseEnvHid.containsKey(channelName)) continue;
            ChanUse chanUse = syncEnv.getChanUseGuiNotSyncChannel();
            CircusType circusType = procChanEnv.getNameTypeEnv().getCircusType(channelName);
            if (chanUse.equals((Object)ChanUse.Input)) {
                code = code + this.chanActPerfWrite(channelName, circusType);
                continue;
            }
            code = code + this.chanActPerfRead(channelName, circusType);
        }
        return code;
    }

    private void createTypeClass() throws Exception {
        Template template = null;
        File file = new File(this.projectDir + "\\" + this.projectName + "\\" + "typing" + "\\" + "Type" + ".java");
        FileWriter fileWriter = new FileWriter(file);
        VelocityContext velocityContext = new VelocityContext();
        Velocity.init();
        velocityContext.put("declTypeConstants", (Object)this.declareTypeConstants());
        velocityContext.put("package", (Object)this.getPackage(this.projectName, "typing"));
        template = Velocity.getTemplate((String)"Type.vm");
        template.merge((Context)velocityContext, (Writer)fileWriter);
        fileWriter.close();
    }

    private void createCircusIntegerClass() throws Exception {
        Template template = null;
        File dir = new File(this.projectDir + "\\" + this.projectName + "\\" + "typing");
        try {
            boolean t = dir.mkdirs();
        }
        catch (SecurityException se) {
            throw new Exception("The creation of the directory was not possible.");
        }
        File file = new File(this.projectDir + "\\" + this.projectName + "\\" + "typing" + "\\" + "CircusInteger" + ".java");
        FileWriter fileWriter = new FileWriter(file);
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("package", (Object)this.getPackage(this.projectName, "typing"));
        Velocity.init();
        template = Velocity.getTemplate((String)"CircusInteger.vm");
        template.merge((Context)velocityContext, (Writer)fileWriter);
        fileWriter.close();
    }

    private void createProcessClass(String processName, String processBody) throws Exception {
        Template template = null;
        processBody = CodeFormatting.format(processBody);
        File file = new File(this.projectDir + "\\" + this.projectName + "\\" + "processes" + "\\" + processName + ".java");
        FileWriter fileWriter = new FileWriter(file);
        VelocityContext velocityContext = new VelocityContext();
        Velocity.init();
        velocityContext.put("proj", (Object)this.projectName);
        velocityContext.put("classBody", (Object)processBody);
        velocityContext.put("className", (Object)processName);
        velocityContext.put("package", (Object)this.getPackage(this.projectName, "processes"));
        velocityContext.put("imports", (Object)this.getImports(this.projectName));
        template = Velocity.getTemplate((String)"ProcDeclaration.vm");
        template.merge((Context)velocityContext, (Writer)fileWriter);
        fileWriter.close();
    }

    private void createClassesForFreeTypes() throws Exception {
        for (int i = 0; i < this.environment_.freeTypesEnvironmentSize(); ++i) {
            Freetype freetype = this.environment_.freeTypesEnvironmentGet(i);
            this.createClassForFreeType(freetype);
        }
    }

    private void createClassForFreeType(Freetype freetype) throws Exception {
        Template template = null;
        String name = freetype.getDeclName().toString();
        String constants = "";
        String toStringCode = "\nString result = null;\nswitch(super.getValue()) {";
        String constructorCode = "";
        ListTerm branches = freetype.getBranch();
        int index = 0;
        for (int i = 0; i < branches.size(); ++i) {
            Branch branch = (Branch)branches.get(i);
            String nameFreeTypeElement = branch.getDeclName().toString();
            constants = constants + "\npublic static final int " + nameFreeTypeElement + " = " + index + ";";
            toStringCode = toStringCode + "\ncase " + nameFreeTypeElement + ": result = \"" + nameFreeTypeElement + "\";\nbreak;";
            constructorCode = constructorCode + "\nif (st.equals(\"" + nameFreeTypeElement + "\"))\n\tthis.setValue(" + index + ");";
            ++index;
        }
        toStringCode = toStringCode + "\n}";
        toStringCode = toStringCode + "\nreturn result;";
        constants = constants + "\npublic static final int MIN_VALUE = 0;";
        constants = constants + "\npublic static final int MAX_VALUE = " + (branches.size() - 1) + ";";
        File file = new File(this.projectDir + "\\" + this.projectName + "\\" + "typing" + "\\" + name + ".java");
        FileWriter fileWriter = new FileWriter(file);
        VelocityContext velocityContext = new VelocityContext();
        Velocity.init();
        velocityContext.put("proj", (Object)this.projectName);
        velocityContext.put("className", (Object)name);
        velocityContext.put("constants", (Object)constants);
        velocityContext.put("toString", (Object)toStringCode);
        velocityContext.put("constructor", (Object)constructorCode);
        velocityContext.put("package", (Object)this.getPackage(this.projectName, "typing"));
        template = Velocity.getTemplate((String)"SubClassOfType.vm");
        template.merge((Context)velocityContext, (Writer)fileWriter);
        fileWriter.close();
    }

    private void createAxDefHorizDefClass() throws Exception {
        Template template = null;
        String body = "";
        for (int i = 0; i < this.axParaCodeList.size(); ++i) {
            body = body + this.axParaCodeList.get(i) + "\n";
        }
        File file = new File(this.projectDir + "\\" + this.projectName + "\\" + "axiomaticDefinitions" + "\\" + "AxiomaticDefinitions" + ".java");
        FileWriter fileWriter = new FileWriter(file);
        VelocityContext velocityContext = new VelocityContext();
        Velocity.init();
        velocityContext.put("package", (Object)this.getPackage(this.projectName, "axiomaticDefinitions"));
        velocityContext.put("imports", (Object)this.getImports(this.projectName));
        velocityContext.put("body", (Object)body);
        template = Velocity.getTemplate((String)"AxiomaticDefinitions.vm");
        template.merge((Context)velocityContext, (Writer)fileWriter);
        fileWriter.close();
    }

    private String declareTypeConstants() {
        int i;
        String javaCode = "";
        for (i = 0; i < this.environment_.freeTypesEnvironmentSize(); ++i) {
            Freetype ft = this.environment_.freeTypesEnvironmentGet(i);
            javaCode = javaCode + "\npublic static final int " + ft.getDeclName() + " = " + i + ";";
        }
        javaCode = javaCode + "\npublic static final int CircusInteger = " + i + ";";
        javaCode = javaCode + "\n\npublic static final int MIN_TYPE_ID = 0;";
        javaCode = javaCode + "\npublic static final int MAX_TYPE_ID = " + i + ";";
        return javaCode;
    }

    private String declarationsCode(ProcessPara processParaMain) {
        String code = "";
        String processName = processParaMain.getDeclName().toString();
        CircusProcess circusProcess = processParaMain.getCircusProcess();
        ChanInfoEnv multiSyncEnv = Util.getChannelMSEnvAnn((TermA)processParaMain);
        ProcChanEnv procChanEnv = Util.getProcChanEnvAnn((TermA)processParaMain);
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();
        Integer procId = Util.getIdCircusProcessAnn((TermA)circusProcess).getId();
        Iterator it = multiSyncEnv.iteratorKeys();
        while (it.hasNext()) {
            String channelName = (String)it.next();
            ProcChanUseEnv chanMSEnv = multiSyncEnv.get(channelName);
            if (chanUseEnvHid.containsKey(channelName)) continue;
            code = code + this.channelCode(channelName, procId, chanMSEnv);
        }
        return code;
    }

    private String channelCode(String channelName, Integer procId, ProcChanUseEnv chanMSEnv) {
        String code = "";
        String toChannel = "to_" + channelName;
        String fromChannel = "from_" + channelName;
        String chanInfo = "chanInfo_" + channelName;
        if (chanMSEnv.isMultiSync()) {
            code = code + "Any2OneChannel[] " + fromChannel + " = Any2OneChannel.create(" + chanMSEnv.getCardinality() + ");\n";
        }
        code = code + "Any2OneChannel " + toChannel + " = new Any2OneChannel();\n";
        List ids = Util.resolveUndefinedChannels(chanMSEnv, true);
        code = code + "ChannelInfo" + " " + chanInfo + " = new " + "ChannelInfo" + "();\n";
        for (int i = 0; i < ids.size(); ++i) {
            Integer subProcId = (Integer)ids.get(i);
            code = code + chanInfo + ".put(new Integer(" + subProcId + "), new Integer(" + i + "));\n";
        }
        code = chanMSEnv.isMultiSync() ? code + "GeneralChannel " + channelName + " = new GeneralChannel(\n" + toChannel + ",\n" + fromChannel + ",\n" + chanInfo + ",\n" + "new Integer(" + procId + "));\n" : code + "GeneralChannel " + channelName + " = new GeneralChannel(\n" + toChannel + ",\n" + chanInfo + ",\n" + "new Integer(" + procId + "));\n";
        return code;
    }

    private String processCallCode(ProcInfo procInfo) throws Exception {
        String code = "";
        String processName = procInfo.getProcessName();
        CircusProcess circusProcess = procInfo.getProcessPara().getCircusProcess();
        ChanInfoEnv chanInfoEnv = Util.getChannelMSEnvAnn((TermA)procInfo.getProcessPara());
        Integer procId = Util.getIdCircusProcessAnn((TermA)circusProcess).getId();
        ProcessPara processPara = procInfo.getProcessPara();
        ProcChanEnv procChanEnv = Util.getProcChanEnvAnn((TermA)processPara);
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();
        String params = this.paramsCode(procInfo);
        String paramsGui = "";
        String msControlCall = "";
        String comma = ", ";
        int c = 0;
        String processNameGui = this.getNameGui(processName);
        ArrayList<String> listProcessesCode = new ArrayList<String>();
        Iterator it = chanInfoEnv.iteratorKeys();
        while (it.hasNext()) {
            String channelName = (String)it.next();
            ProcChanUseEnv chanMSEnv = chanInfoEnv.get(channelName);
            if (chanMSEnv.isSync() || chanUseEnvHid.containsKey(channelName)) continue;
            paramsGui = paramsGui + comma + "new GeneralChannel(" + channelName + ", new Integer(-1))";
            ++c;
        }
        paramsGui = "\"" + processName + "\"" + paramsGui;
        if (chanInfoEnv.noMultiSync() == 0) {
            listProcessesCode.add(this.cspProcessCallCode(processName, params));
            listProcessesCode.add(this.cspProcessCallCode(processNameGui, paramsGui));
        } else {
            listProcessesCode.add(this.processManagerCallCode(processName, params, processNameGui, paramsGui));
            listProcessesCode.add(this.controllersManagerCallCode(chanInfoEnv));
        }
        code = this.parallelCallRunCode(listProcessesCode, true);
        return code;
    }

    private String parallelCallRunCode(List processes, boolean run) {
        String listProcessesCode = "";
        String comma = "";
        Hashtable<String, String> ht = new Hashtable<String, String>();
        for (int i = 0; i < processes.size(); ++i) {
            listProcessesCode = listProcessesCode + comma + processes.get(i);
            comma = ", ";
        }
        ht.put("listProcessesCode", listProcessesCode);
        String code = Util.getCodeFromTemplate("parCall.vm", ht);
        if (run) {
            code = code + ".run();";
        }
        return code;
    }

    private String processManagerCallCode(String processName, String params, String processNameGui, String paramsGui) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ArrayList<String> listProcessesCode = new ArrayList<String>();
        listProcessesCode.add(this.cspProcessCallCode(processName, params));
        listProcessesCode.add(this.cspProcessCallCode(processNameGui, paramsGui));
        String parallelismCode = this.parallelCallRunCode(listProcessesCode, false);
        ht.put("proc", parallelismCode);
        String code = Util.getCodeFromTemplate("ProcessManagerCall.vm", ht);
        return code;
    }

    private String controllersManagerCallCode(ChanInfoEnv chanInfoEnv) {
        String call;
        chanInfoEnv.print(0);
        Hashtable<String, String> ht = new Hashtable<String, String>();
        if (chanInfoEnv.noMultiSync() == 1) {
            ProcChanUseEnv syncEnv;
            Iterator it = chanInfoEnv.iteratorKeys();
            String channelName = "";
            while (it.hasNext() && !(syncEnv = chanInfoEnv.get(channelName = (String)it.next())).isMultiSync()) {
            }
            call = "new MultiSyncControl(from_" + channelName + ", to_" + channelName + ")";
        } else {
            Iterator it = chanInfoEnv.iteratorKeys();
            Hashtable<String, String> ht2 = new Hashtable<String, String>();
            ArrayList<String> listProcessCode = new ArrayList<String>();
            while (it.hasNext()) {
                String channelName = (String)it.next();
                ProcChanUseEnv syncEnv = chanInfoEnv.get(channelName);
                if (!syncEnv.isMultiSync()) continue;
                String processCode = "";
                ht2 = new Hashtable();
                ht2.put("channelNm", channelName);
                processCode = "new MultiSyncControl (from_" + channelName + ", to_" + channelName + ")";
                listProcessCode.add(processCode);
            }
            call = this.parallelCallRunCode(listProcessCode, false);
        }
        ht.put("msControlCall", call);
        String code = Util.getCodeFromTemplate("ControllersManagerCall.vm", ht);
        return code;
    }

    private String cspProcessCallCode(String name, String paramsCode) {
        return "new " + name + "(" + paramsCode + ")";
    }

    private String paramsCode(ProcInfo procInfo) throws Exception {
        String chanParamCode;
        String code = "";
        String processName = procInfo.getProcessName();
        CircusProcess circusProcess = procInfo.getProcessPara().getCircusProcess();
        String procParamCode = "";
        if (circusProcess instanceof ParamProcess) {
            ListTerm decls = Util.getListTermAnn((TermA)circusProcess);
            procParamCode = this.procParamsCode(procInfo.getCodeForActuals());
        }
        code = !(chanParamCode = this.paramsChanCode(procInfo.getProcessPara())).equals("") && !procParamCode.equals("") ? chanParamCode + ", " + procParamCode : chanParamCode + procParamCode;
        return code;
    }

    private String procParamsCode(List<String> codeForActuals) {
        String code = "";
        String comma = "";
        for (int i = 0; i < codeForActuals.size(); ++i) {
            code = code + comma + codeForActuals.get(i);
            comma = ", ";
        }
        return code;
    }

    private String paramsChanCode(ProcessPara processParaMain) throws Exception {
        String code = "";
        String processName = processParaMain.getDeclName().toString();
        CircusProcess circusProcess = processParaMain.getCircusProcess();
        ChanInfoEnv channelMSEnv = Util.getChannelMSEnvAnn((TermA)processParaMain);
        Integer id = Util.getIdCircusProcessAnn((TermA)circusProcess).getId();
        ProcChanEnv procChanEnv = Util.getProcChanEnvAnn((TermA)processParaMain);
        ChanUseEnv chanUseEnvHid = procChanEnv.getChanUseEnvHid();
        Iterator it = channelMSEnv.iteratorKeys();
        String comma = "";
        while (it.hasNext()) {
            String channelName = (String)it.next();
            if (chanUseEnvHid.containsKey(channelName)) continue;
            ProcChanUseEnv syncEnv = channelMSEnv.get(channelName);
            code = code + comma + channelName;
            if (!comma.equals("")) continue;
            comma = ", ";
        }
        return code;
    }

    private String chanActPerfWrite(String chanName, CircusType circusType) {
        String code = "";
        code = code + "\n\tprivate void btn_" + chanName + "_ActionPerformed(java.awt.event.ActionEvent evt) {";
        if (circusType.isSyncType()) {
            code = code + "\n\t\t" + chanName + ".write(null);";
        } else {
            String chanCommType = circusType.getJavaCircusTypeName();
            code = code + "\n\t\tString st = this.txt_" + chanName + ".getText();";
            code = code + "\n\t\t" + chanCommType + " o = new " + chanCommType + " (st);";
            code = code + "\n\t\t" + chanName + ".write(o);";
        }
        code = code + "\n\t}";
        return code;
    }

    private String chanActPerfRead(String chanName, CircusType circusType) {
        String code = "";
        code = code + "\n\tprivate void btn_" + chanName + "_ActionPerformed(java.awt.event.ActionEvent evt) {";
        if (circusType.isSyncType()) {
            code = code + "\n\t\t" + chanName + ".read();";
        } else {
            String chanCommType = circusType.getJavaCircusTypeName();
            code = code + "\n\t\t" + chanCommType + " o = (" + chanCommType + ") " + chanName + ".read();";
            code = code + "\n\t\tString st = o.toString();";
            code = code + "\n\t\tthis.txt_" + chanName + ".setText(st);";
        }
        code = code + "\n\t}";
        return code;
    }

    private String initGuiChanSync(String chanName) {
        String code = "";
        code = code + "\n\t\tbtn_" + chanName + " = new javax.swing.JButton(\"" + chanName + "\");";
        code = code + "\n\t\tbtn_" + chanName + ".addActionListener(new java.awt.event.ActionListener() {";
        code = code + "\n\t\t\tpublic void actionPerformed(java.awt.event.ActionEvent evt) {";
        code = code + "\n\t\t\t\tbtn_" + chanName + "_ActionPerformed(evt);";
        code = code + "\n\t\t\t}";
        code = code + "\n\t\t});";
        code = code + "\n\t\tthis.getContentPane().add(btn_" + chanName + ");";
        code = code + "\n\t\tthis.getContentPane().add(new javax.swing.JLabel(\"\"));";
        code = code + "\n\t\tthis.getContentPane().add(new javax.swing.JLabel(\"\"));";
        code = code + "\n";
        return code;
    }

    private String initGuiChanComm(String chanName, String chanType, String commType) {
        String code = "";
        code = code + "\n\t\tbtn_" + chanName + " = new javax.swing.JButton(\"" + chanName + "\");";
        code = code + "\n\t\ttxt_" + chanName + " = new javax.swing.JTextField();";
        code = code + "\n\t\tlbl_" + chanName + " = new javax.swing.JLabel(\"" + chanType + ": " + commType + "\", SwingConstants.LEFT);";
        code = code + "\n\t\tthis.btn_" + chanName + ".addActionListener(new java.awt.event.ActionListener() {";
        code = code + "\n\t\t\tpublic void actionPerformed(java.awt.event.ActionEvent evt) {";
        code = code + "\n\t\t\t\tbtn_" + chanName + "_ActionPerformed(evt);";
        code = code + "\n\t\t\t}";
        code = code + "\n\t\t});";
        code = code + "\n";
        code = code + "\n\t\tthis.getContentPane().add(btn_" + chanName + ");";
        code = code + "\n\t\tthis.getContentPane().add(txt_" + chanName + ");";
        code = code + "\n\t\tthis.getContentPane().add(lbl_" + chanName + ");";
        code = code + "\n";
        return code;
    }

    public String getImports(String projectName) {
        String code = "";
        code = "import " + projectName + ".axiomaticDefinitions.*;\n";
        code = code + "import " + projectName + ".processes.*;\n";
        code = code + "import " + projectName + ".typing.*;\n";
        code = code + "import jcircusutil.RandomGenerator;\n";
        code = code + "import jcircusutil.multisync.*;\n";
        code = code + "import " + projectName + ".gui.*;\n";
        return code;
    }

    public String getPackage(String projectName, String pack) {
        String code = "";
        code = "package " + projectName;
        if (pack != null) {
            code = code + "." + pack;
        }
        code = code + ";\n\n";
        return code;
    }

    private String getNameGui(String processName) {
        return "Gui_" + processName;
    }

    private String getNameBat(String processName) {
        return "Run_" + processName;
    }

    private String getNameMain(String processName) {
        return "Main_" + processName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String validateAndReturnCodeForParameter(String expression, Expr typeExpr) throws FailParsingException, FailTypeCheckingException {
        String code = "";
        String javaTypeName = "";
        if (!(typeExpr instanceof RefExpr)) throw new InvalidParameterException("");
        String typeExprSt = ((RefExpr)typeExpr).getRefName().toString();
        if (typeExprSt.equals(MathToolkitConstants.NAT) || typeExprSt.equals(MathToolkitConstants.NUM) || typeExprSt.equals(MathToolkitConstants.ARITHMOS)) {
            try {
                int number = Integer.parseInt(expression);
                return "new CircusInteger(" + number + ")";
            }
            catch (NumberFormatException nfe) {
                List errors = new Factory().list((Object)"Expression is not a number.");
                throw new FailTypeCheckingException(errors);
            }
        }
        if (this.environment_.isElementFreeType(typeExprSt, expression)) {
            return "new " + typeExprSt + "(" + typeExprSt + "." + expression + ")";
        }
        List errors = new Factory().list((Object)"Expression is not an element of free type.");
        throw new FailTypeCheckingException(errors);
    }
}

