/*
 * Decompiled with CFR 0.152.
 */
package jcircus.gui;

import java.awt.ComponentOrientation;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jcircus.exceptions.FailParsingException;
import jcircus.exceptions.FailTypeCheckingException;
import jcircus.exceptions.InvalidParameterException;
import jcircus.gui.JCircusFrame;
import jcircus.util.ProcInfo;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.VarDecl;

public class ParametersDialog
extends JDialog
implements ActionListener {
    private ProcInfo procInfo;
    private JTextField[] inputFields;
    private JButton btnOk;
    private JButton btnCancel;
    private JCircusFrame jCircusFrame;

    public ParametersDialog(JCircusFrame jCircusFrame, ProcInfo procInfo) {
        super(jCircusFrame, "Parameters", true);
        this.jCircusFrame = jCircusFrame;
        this.procInfo = procInfo;
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        String[] text = new String[]{"Process " + procInfo.getProcessName() + " requires parameters.", "Please enter their values."};
        for (int i = 0; i < text.length; ++i) {
            this.getContentPane().add(new JLabel(text[i]));
        }
        List params = procInfo.getParameters();
        JPanel pnlParams = new JPanel();
        pnlParams.setLayout(new GridLayout(params.size() + 1, 3));
        pnlParams.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        pnlParams.add(new JLabel("Parameter"));
        pnlParams.add(new JLabel("Type"));
        pnlParams.add(new JLabel("Value"));
        this.inputFields = new JTextField[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            String param = ((VarDecl)params.get(i)).getDeclName().get(0).toString();
            Expr expr = ((VarDecl)params.get(i)).getExpr();
            if (!(expr instanceof RefExpr)) {
                throw new InvalidParameterException("");
            }
            String type = ((RefExpr)expr).getRefName().toString();
            pnlParams.add(new JLabel(param));
            pnlParams.add(new JLabel(type));
            this.inputFields[i] = new JTextField();
            pnlParams.add(this.inputFields[i]);
        }
        this.getContentPane().add(pnlParams);
        JPanel pnlButtons = new JPanel();
        this.btnOk = new JButton("OK");
        this.btnOk.setSize(20, 10);
        this.btnOk.addActionListener(this);
        pnlButtons.add(this.btnOk);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setSize(20, 10);
        this.btnCancel.addActionListener(this);
        pnlButtons.add(this.btnCancel);
        this.getContentPane().add(pnlButtons);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnOk) {
            this.btnOkPressed();
        } else if (e.getSource() == this.btnCancel) {
            this.btnCancelPressed();
        }
    }

    private void btnOkPressed() {
        int i;
        List params = this.procInfo.getParameters();
        for (i = 0; i < this.inputFields.length; ++i) {
            if (!this.inputFields[i].getText().equals("")) continue;
            JOptionPane.showMessageDialog(this, "You must enter all the parameters.");
            return;
        }
        for (i = 0; i < this.inputFields.length; ++i) {
            String actualSt = this.inputFields[i].getText().trim();
            Expr typeExpr = ((VarDecl)params.get(i)).getExpr();
            try {
                String codeForActual = this.jCircusFrame.getJCircus().getTranslator2Java().validateAndReturnCodeForParameter(actualSt, typeExpr);
                this.procInfo.getCodeForActuals().add(i, codeForActual);
                continue;
            }
            catch (FailParsingException fpe) {
                JOptionPane.showMessageDialog(this, fpe.getFirstError(), "Parsing Error", 0);
                this.inputFields[i].selectAll();
                continue;
            }
            catch (FailTypeCheckingException ftce) {
                JOptionPane.showMessageDialog(this, ftce.getFirstError(), "Type Checking Error", 0);
                this.inputFields[i].selectAll();
            }
        }
        ((JCircusFrame)this.getOwner()).setCanceled(false);
        this.setVisible(false);
        this.dispose();
    }

    private void btnCancelPressed() {
        ((JCircusFrame)this.getOwner()).setCanceled(true);
        this.setVisible(false);
        this.dispose();
    }
}

