/*
 * Decompiled with CFR 0.152.
 */
package jcircus.environment;

import java.util.Hashtable;
import java.util.Iterator;
import jcircus.exceptions.ChanUseUnificationException;
import jcircus.exceptions.DifferentCardinalitiesException;
import jcircus.exceptions.MoreThanOneWriterException;
import jcircus.util.ChanUse;

public class ProcChanUseEnv {
    private Hashtable hashtable_ = new Hashtable();
    private int cardinality_;

    public ProcChanUseEnv(int cardinality) {
        this.cardinality_ = cardinality;
    }

    public int getCardinality() {
        return this.cardinality_;
    }

    public void put(Integer procId, ChanUse chanUse) {
        this.hashtable_.put(procId, chanUse);
    }

    public ChanUse get(Integer procId) {
        return (ChanUse)((Object)this.hashtable_.get(procId));
    }

    public void putAll(ProcChanUseEnv other) {
        Iterator iterator = other.iteratorKeys();
        while (iterator.hasNext()) {
            Integer procId = (Integer)iterator.next();
            ChanUse javaTypeChannel = other.get(procId);
            this.put(procId, javaTypeChannel);
        }
    }

    public ProcChanUseEnv merge(ProcChanUseEnv other, boolean isParallel) throws MoreThanOneWriterException, ChanUseUnificationException, DifferentCardinalitiesException {
        int c;
        if (isParallel && this.containsWriter() && other.containsWriter()) {
            throw new MoreThanOneWriterException();
        }
        if (!isParallel && (this.containsWriter() && other.containsReader() || this.containsReader() && other.containsWriter())) {
            throw new ChanUseUnificationException();
        }
        if (isParallel) {
            c = this.cardinality_ + other.cardinality_;
        } else {
            if (this.cardinality_ != other.cardinality_) {
                throw new DifferentCardinalitiesException();
            }
            c = this.cardinality_;
        }
        ProcChanUseEnv result = new ProcChanUseEnv(c);
        if (isParallel) {
            result.putAll(this);
            result.putAll(other);
        } else {
            Integer procId;
            ChanUse j = this.containsReader() || other.containsReader() ? ChanUse.Input : (this.containsWriter() || other.containsWriter() ? ChanUse.Output : ChanUse.Undefined);
            Iterator itThis = this.iteratorKeys();
            Iterator itOther = other.iteratorKeys();
            while (itThis.hasNext()) {
                procId = (Integer)itThis.next();
                result.put(procId, j);
            }
            while (itOther.hasNext()) {
                procId = (Integer)itOther.next();
                result.put(procId, j);
            }
        }
        return result;
    }

    private boolean containsWriter() {
        return this.hashtable_.contains((Object)ChanUse.Output);
    }

    private boolean containsReader() {
        return this.hashtable_.contains((Object)ChanUse.Input) || this.hashtable_.contains((Object)ChanUse.AltInput);
    }

    public Iterator iteratorKeys() {
        return this.hashtable_.keySet().iterator();
    }

    private boolean containsKey(Integer procId) {
        return this.hashtable_.containsKey(procId);
    }

    public boolean isMultiSync() {
        return this.cardinality_ > 2;
    }

    public boolean isSync() {
        return this.cardinality_ > 1;
    }

    public ChanUse getChanUseGuiNotSyncChannel() {
        if (this.isSync()) {
            return null;
        }
        ChanUse javaTypeChannel = this.containsReader() || !this.containsReader() && !this.containsWriter() ? ChanUse.Input : ChanUse.Output;
        return javaTypeChannel;
    }

    public ProcChanUseEnv replaceId(Integer newId, Integer oldId) {
        ChanUse chanUse = null;
        ProcChanUseEnv r = new ProcChanUseEnv(1);
        if (this.hashtable_.size() != 1) {
            throw new RuntimeException("Method replaceIds has been called for a non-basic process.");
        }
        Iterator it = this.iteratorKeys();
        while (it.hasNext()) {
            oldId = (Integer)it.next();
            chanUse = this.get(oldId);
        }
        r.put(newId, chanUse);
        return r;
    }

    public int size() {
        return this.hashtable_.size();
    }

    public String print(int nTabs) {
        String tabs = "";
        while (nTabs > 0) {
            tabs = tabs + "\t";
            --nTabs;
        }
        StringBuilder s = new StringBuilder();
        s.append(tabs + "ChanMSEnv, cardinality = " + this.cardinality_ + "\n");
        Iterator it = this.iteratorKeys();
        while (it.hasNext()) {
            Integer procId = (Integer)it.next();
            ChanUse jtc = this.get(procId);
            s.append(tabs + procId + " -> " + jtc.toStringGUI() + "\n");
        }
        return s.toString();
    }
}

