/*
 * Decompiled with CFR 0.152.
 */
package jcircus.environment;

import java.util.ArrayList;
import java.util.List;
import jcircus.exceptions.InvalidParameterException;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.z.ast.Branch;
import net.sourceforge.czt.z.ast.Freetype;
import net.sourceforge.czt.z.ast.Name;

public class FreeTypeEnv {
    private List<Freetype> freeTypeEnv_ = new ArrayList<Freetype>();

    public void add(Freetype freetype) {
        this.freeTypeEnv_.add(freetype);
    }

    public Freetype get(int i) {
        return this.freeTypeEnv_.get(i);
    }

    public int size() {
        return this.freeTypeEnv_.size();
    }

    public boolean isFreeType(String name) {
        boolean r = false;
        for (int i = 0; i < this.freeTypeEnv_.size(); ++i) {
            Freetype freetype = this.freeTypeEnv_.get(i);
            if (!name.equals(freetype.getDeclName().toString())) continue;
            r = true;
        }
        return r;
    }

    public boolean isElementFreeType(Name identifier) {
        boolean r = false;
        for (int i = 0; i < this.freeTypeEnv_.size(); ++i) {
            Freetype freetype = this.freeTypeEnv_.get(i);
            ListTerm branches = freetype.getBranch();
            for (int j = 0; j < branches.size(); ++j) {
                Branch branch = (Branch)branches.get(j);
                if (!identifier.toString().equals(branch.getDeclName().toString())) continue;
                r = true;
            }
        }
        return r;
    }

    public boolean isElementFreeType(String freeTypeName, String element) {
        boolean r = false;
        boolean foundFT = false;
        for (int i = 0; i < this.freeTypeEnv_.size(); ++i) {
            Freetype freetype = this.freeTypeEnv_.get(i);
            if (!freetype.getDeclName().toString().equals(freeTypeName)) continue;
            foundFT = true;
            ListTerm branches = freetype.getBranch();
            for (int j = 0; j < branches.size(); ++j) {
                Branch branch = (Branch)branches.get(j);
                if (!element.toString().equals(branch.getDeclName().toString())) continue;
                r = true;
            }
        }
        if (!foundFT) {
            throw new InvalidParameterException("Free type " + freeTypeName + " does not exist.");
        }
        return r;
    }

    public String getNameFreeType(Name identifier) {
        String r = null;
        for (int i = 0; i < this.freeTypeEnv_.size(); ++i) {
            Freetype freetype = this.freeTypeEnv_.get(i);
            ListTerm branches = freetype.getBranch();
            for (int j = 0; j < branches.size(); ++j) {
                Branch branch = (Branch)branches.get(j);
                if (!identifier.toString().equals(branch.getDeclName().toString())) continue;
                r = freetype.getDeclName().toString();
            }
        }
        return r;
    }
}

