/*
 * Decompiled with CFR 0.152.
 */
package jcircus.environment;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import jcircus.exceptions.ChanSyncUnificationException;
import jcircus.util.ChanSync;
import net.sourceforge.czt.z.ast.Name;

public class ChanSyncEnv {
    private Hashtable hashtable_ = new Hashtable();

    public void put(String channelName, ChanSync chanSync) {
        if (chanSync == null) {
            throw new NullPointerException();
        }
        this.hashtable_.put(channelName, chanSync);
    }

    public ChanSync get(String channelName) {
        return (ChanSync)((Object)this.hashtable_.get(channelName));
    }

    public void remove(String channelName) {
        this.hashtable_.remove(channelName);
    }

    public boolean containsKey(String channelName) {
        return this.hashtable_.containsKey(channelName);
    }

    private void putAll(ChanSyncEnv channelSyncEnvironment) {
        Iterator iterator = channelSyncEnvironment.iteratorKeys();
        while (iterator.hasNext()) {
            String channelName = (String)iterator.next();
            ChanSync syncTypeChannel = channelSyncEnvironment.get(channelName);
            this.put(channelName, syncTypeChannel);
        }
    }

    public ChanSyncEnv substitute(List newChannels, List oldChannels) {
        ChanSyncEnv r = new ChanSyncEnv();
        r.putAll(this);
        for (int i = 0; i < oldChannels.size(); ++i) {
            Name name = (Name)oldChannels.get(i);
            String newChannelName = ((Name)newChannels.get(i)).toString();
            if (!r.containsKey(name.toString())) continue;
            ChanSync syncTypeChannel = r.get(name.toString());
            r.remove(name.toString());
            r.put(newChannelName, syncTypeChannel);
        }
        return r;
    }

    public ChanSyncEnv merge(ChanSyncEnv other) throws ChanSyncUnificationException {
        ChanSyncEnv r = new ChanSyncEnv();
        r.putAll(this);
        Iterator iterator = other.iteratorKeys();
        while (iterator.hasNext()) {
            ChanSync chanSyncInEnv;
            String chanName = (String)iterator.next();
            ChanSync chanSync = other.get(chanName);
            if (r.containsKey(chanName) && !chanSync.equals((Object)(chanSyncInEnv = r.get(chanName)))) {
                throw new ChanSyncUnificationException();
            }
            r.put(chanName, chanSync);
        }
        return r;
    }

    public Iterator iteratorKeys() {
        return this.hashtable_.keySet().iterator();
    }

    public void print() {
        Enumeration en = this.hashtable_.keys();
        System.out.println("-------------");
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            ChanSync type = (ChanSync)((Object)this.hashtable_.get(name));
            System.out.println("Name: " + name + ", Type: " + (Object)((Object)type));
        }
        System.out.println("-------------");
    }
}

