/*
 * Decompiled with CFR 0.152.
 */
package jcsp.lang;

import jcsp.lang.CSProcess;
import jcsp.lang.Parallel;

public class ProcessManager
implements CSProcess {
    private final CSProcess process;
    private Thread thread;
    private ThreadGroup threadGroup;

    public ProcessManager(CSProcess cSProcess) {
        this.process = cSProcess;
        Runnable runnable = new Runnable(){

            public void run() {
                ProcessManager.this.process.run();
            }
        };
        try {
            this.threadGroup = new ThreadGroup("ProcessManager-" + this.process.getClass().getName());
            try {
                this.threadGroup.setDaemon(true);
            }
            catch (SecurityException securityException) {
                System.out.println("ProcessManager: could not setDaemon on new threadgroup");
                System.out.println(securityException);
            }
            this.thread = new Thread(this.threadGroup, runnable, this.process.getClass().getName());
        }
        catch (SecurityException securityException) {
            System.out.println("ProcessManager: SecurityManager disallowed new threadgroup");
            System.out.println(securityException);
            this.threadGroup = null;
            this.thread = new Thread(null, runnable, this.process.getClass().getName());
        }
        Parallel.allParThreads.addElement(this.thread);
        this.thread.setDaemon(true);
    }

    public void start() {
        this.thread.start();
    }

    public void stop() {
        if (this.threadGroup != null) {
            this.threadGroup.stop();
        }
        this.threadGroup = null;
    }

    public void suspend() {
        if (this.threadGroup != null) {
            this.threadGroup.suspend();
        }
    }

    public void resume() {
        if (this.threadGroup != null) {
            this.threadGroup.resume();
        }
    }

    public void join() {
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean stopOK() {
        return this.threadGroup != null;
    }

    public void run() {
        this.process.run();
    }
}

