/*
 * Decompiled with CFR 0.152.
 */
package jcsp.lang;

import java.io.Serializable;
import jcsp.lang.Alternative;
import jcsp.lang.AltingChannel;
import jcsp.lang.ProcessInterruptedError;
import jcsp.util.ChannelDataStore;
import jcsp.util.ZeroBuffer;

public class One2OneChannel
extends AltingChannel
implements Serializable {
    private ChannelDataStore data;
    private Alternative alt;

    public One2OneChannel() {
        this(null);
    }

    public One2OneChannel(ChannelDataStore channelDataStore) {
        this.data = channelDataStore == null ? new ZeroBuffer() : (ChannelDataStore)channelDataStore.clone();
    }

    public synchronized Object read() {
        if (this.data.getState() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new ProcessInterruptedError("*** Thrown from One2OneChannel.read (int)\n" + interruptedException.toString());
            }
        }
        Object object = this.data.get();
        this.notify();
        return object;
    }

    public synchronized void write(Object object) {
        this.data.put(object);
        if (this.alt != null) {
            this.alt.schedule();
        } else {
            this.notify();
        }
        if (this.data.getState() == 2) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new ProcessInterruptedError("*** Thrown from One2OneChannel.write (int)\n" + interruptedException.toString());
            }
        }
    }

    synchronized boolean enable(Alternative alternative) {
        if (this.data.getState() == 0) {
            this.alt = alternative;
            return false;
        }
        return true;
    }

    synchronized boolean disable() {
        this.alt = null;
        return this.data.getState() != 0;
    }

    public synchronized boolean pending() {
        return this.data.getState() != 0;
    }

    public static One2OneChannel[] create(int n) {
        return One2OneChannel.create(n, null);
    }

    public static One2OneChannel create(ChannelDataStore channelDataStore) {
        return new One2OneChannel(channelDataStore);
    }

    public static One2OneChannel[] create(int n, ChannelDataStore channelDataStore) {
        One2OneChannel[] one2OneChannelArray = new One2OneChannel[n];
        int n2 = 0;
        while (n2 < n) {
            one2OneChannelArray[n2] = new One2OneChannel(channelDataStore);
            ++n2;
        }
        return one2OneChannelArray;
    }
}

