/*
 * Decompiled with CFR 0.152.
 */
package jcsp.lang;

import jcsp.lang.AltingChannelInput;
import jcsp.lang.Guard;
import jcsp.lang.ProcessInterruptedError;

public class Alternative {
    private static final int enabling = 0;
    private static final int waiting = 1;
    private static final int ready = 2;
    private static final int inactive = 3;
    private int state = 3;
    private final Guard[] guard;
    private int favourite = 0;
    private int selected;
    private final int NONE_SELECTED = -1;
    private int enableIndex;
    private boolean timeout = false;
    private long msecs;
    private int timeIndex;

    public Alternative(Guard[] guardArray) {
        this.guard = guardArray;
    }

    public final int select() {
        return this.fairSelect();
    }

    public final int priSelect() {
        this.state = 0;
        this.favourite = 0;
        this.enableGuards();
        Alternative alternative = this;
        synchronized (alternative) {
            if (this.state == 0) {
                this.state = 1;
                try {
                    if (this.timeout) {
                        long l = this.msecs - System.currentTimeMillis();
                        if (l > 0L) {
                            this.wait(l);
                        }
                    } else {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new ProcessInterruptedError("*** Thrown from Alternative.priSelect ()\n" + interruptedException.toString());
                }
                this.state = 2;
            }
        }
        this.disableGuards();
        this.state = 3;
        this.timeout = false;
        return this.selected;
    }

    public final int fairSelect() {
        this.state = 0;
        this.enableGuards();
        Alternative alternative = this;
        synchronized (alternative) {
            if (this.state == 0) {
                this.state = 1;
                try {
                    if (this.timeout) {
                        long l = this.msecs - System.currentTimeMillis();
                        if (l > 0L) {
                            this.wait(l);
                        }
                    } else {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new ProcessInterruptedError("*** Thrown from Alternative.fairSelect/select ()\n" + interruptedException.toString());
                }
                this.state = 2;
            }
        }
        this.disableGuards();
        this.state = 3;
        this.favourite = this.selected + 1;
        if (this.favourite == this.guard.length) {
            this.favourite = 0;
        }
        this.timeout = false;
        return this.selected;
    }

    public final int select(boolean[] blArray) {
        return this.fairSelect(blArray);
    }

    public final int priSelect(boolean[] blArray) {
        if (blArray.length != this.guard.length) {
            System.err.println("*** jcsp.lang.select called with a preCondition array");
            System.err.println("*** whose length does not match the guard array");
            System.exit(-1);
        }
        this.state = 0;
        this.favourite = 0;
        this.enableGuards(blArray);
        Alternative alternative = this;
        synchronized (alternative) {
            if (this.state == 0) {
                this.state = 1;
                try {
                    if (this.timeout) {
                        long l = this.msecs - System.currentTimeMillis();
                        if (l > 0L) {
                            this.wait(l);
                        }
                    } else {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new ProcessInterruptedError("*** Thrown from Alternative.priSelect (boolean[])\n" + interruptedException.toString());
                }
                this.state = 2;
            }
        }
        this.disableGuards(blArray);
        this.state = 3;
        this.timeout = false;
        return this.selected;
    }

    public final int fairSelect(boolean[] blArray) {
        if (blArray.length != this.guard.length) {
            System.err.println("*** jcsp.lang.select called with a preCondition array");
            System.err.println("*** whose length does not match the guard array");
            System.exit(-1);
        }
        this.state = 0;
        this.enableGuards(blArray);
        Alternative alternative = this;
        synchronized (alternative) {
            if (this.state == 0) {
                this.state = 1;
                try {
                    if (this.timeout) {
                        long l = this.msecs - System.currentTimeMillis();
                        if (l > 0L) {
                            this.wait(l);
                        }
                    } else {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new ProcessInterruptedError("*** Thrown from Alternative.fairSelect/select (boolean[])\n" + interruptedException.toString());
                }
                this.state = 2;
            }
        }
        this.disableGuards(blArray);
        this.state = 3;
        this.favourite = this.selected + 1;
        if (this.favourite == this.guard.length) {
            this.favourite = 0;
        }
        this.timeout = false;
        return this.selected;
    }

    private final void enableGuards() {
        this.enableIndex = this.favourite;
        while (this.enableIndex < this.guard.length) {
            if (this.guard[this.enableIndex].enable(this)) {
                this.selected = this.enableIndex;
                this.state = 2;
                return;
            }
            ++this.enableIndex;
        }
        this.enableIndex = 0;
        while (this.enableIndex < this.favourite) {
            if (this.guard[this.enableIndex].enable(this)) {
                this.selected = this.enableIndex;
                this.state = 2;
                return;
            }
            ++this.enableIndex;
        }
        this.selected = -1;
    }

    private void disableGuards() {
        if (this.selected != this.favourite) {
            int n;
            int n2;
            int n3 = n2 = this.selected == -1 ? this.favourite - 1 : this.selected - 1;
            if (n2 < this.favourite) {
                n = n2;
                while (n >= 0) {
                    if (this.guard[n].disable()) {
                        this.selected = n;
                    }
                    --n;
                }
                n2 = this.guard.length - 1;
            }
            n = n2;
            while (n >= this.favourite) {
                if (this.guard[n].disable()) {
                    this.selected = n;
                }
                --n;
            }
            if (this.selected == -1) {
                this.selected = this.timeIndex;
            }
        }
    }

    private final void enableGuards(boolean[] blArray) {
        this.enableIndex = this.favourite;
        while (this.enableIndex < this.guard.length) {
            if (blArray[this.enableIndex] && this.guard[this.enableIndex].enable(this)) {
                this.selected = this.enableIndex;
                this.state = 2;
                return;
            }
            ++this.enableIndex;
        }
        this.enableIndex = 0;
        while (this.enableIndex < this.favourite) {
            if (blArray[this.enableIndex] && this.guard[this.enableIndex].enable(this)) {
                this.selected = this.enableIndex;
                this.state = 2;
                return;
            }
            ++this.enableIndex;
        }
        this.selected = -1;
    }

    private void disableGuards(boolean[] blArray) {
        if (this.selected != this.favourite) {
            int n;
            int n2;
            int n3 = n2 = this.selected == -1 ? this.favourite - 1 : this.selected - 1;
            if (n2 < this.favourite) {
                n = n2;
                while (n >= 0) {
                    if (blArray[n] && this.guard[n].disable()) {
                        this.selected = n;
                    }
                    --n;
                }
                n2 = this.guard.length - 1;
            }
            n = n2;
            while (n >= this.favourite) {
                if (blArray[n] && this.guard[n].disable()) {
                    this.selected = n;
                }
                --n;
            }
            if (this.selected == -1) {
                this.selected = this.timeIndex;
            }
        }
    }

    void setTimeout(long l) {
        if (this.timeout) {
            if (l < this.msecs) {
                this.msecs = l;
                this.timeIndex = this.enableIndex;
            }
        } else {
            this.timeout = true;
            this.msecs = l;
            this.timeIndex = this.enableIndex;
        }
    }

    synchronized void schedule() {
        switch (this.state) {
            case 0: {
                this.state = 2;
                break;
            }
            case 1: {
                this.state = 2;
                this.notify();
            }
        }
    }

    public Alternative() {
        this.guard = null;
    }

    public int select(AltingChannelInput[] altingChannelInputArray) {
        this.state = 0;
        this.enableChannels(altingChannelInputArray);
        Alternative alternative = this;
        synchronized (alternative) {
            if (this.state == 0) {
                this.state = 1;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.state = 2;
            }
        }
        this.disableChannels(altingChannelInputArray);
        this.state = 3;
        return this.selected;
    }

    public int select(AltingChannelInput[] altingChannelInputArray, long l) {
        return this.select(altingChannelInputArray, l, 0);
    }

    public int select(AltingChannelInput[] altingChannelInputArray, long l, int n) {
        this.state = 0;
        this.enableChannels(altingChannelInputArray);
        Alternative alternative = this;
        synchronized (alternative) {
            if (this.state == 0) {
                this.state = 1;
                try {
                    if (l > 0L) {
                        this.wait(l, n);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.state = 2;
            }
        }
        this.disableChannels(altingChannelInputArray);
        this.state = 3;
        return this.selected;
    }

    public int select(AltingChannelInput[] altingChannelInputArray, boolean bl) {
        if (bl) {
            this.state = 0;
            this.enableChannels(altingChannelInputArray);
            this.disableChannels(altingChannelInputArray);
            this.state = 3;
            return this.selected;
        }
        return this.select(altingChannelInputArray);
    }

    public int select(AltingChannelInput[] altingChannelInputArray, boolean[] blArray) {
        this.state = 0;
        this.enableChannels(altingChannelInputArray, blArray);
        Alternative alternative = this;
        synchronized (alternative) {
            if (this.state == 0) {
                this.state = 1;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.state = 2;
            }
        }
        this.disableChannels(altingChannelInputArray, blArray);
        this.state = 3;
        return this.selected;
    }

    public int select(AltingChannelInput[] altingChannelInputArray, boolean[] blArray, long l) {
        return this.select(altingChannelInputArray, blArray, l, 0);
    }

    public int select(AltingChannelInput[] altingChannelInputArray, boolean[] blArray, long l, int n) {
        this.state = 0;
        this.enableChannels(altingChannelInputArray, blArray);
        Alternative alternative = this;
        synchronized (alternative) {
            if (this.state == 0) {
                this.state = 1;
                try {
                    if (l > 0L) {
                        this.wait(l, n);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.state = 2;
            }
        }
        this.disableChannels(altingChannelInputArray, blArray);
        this.state = 3;
        return this.selected;
    }

    public int select(AltingChannelInput[] altingChannelInputArray, boolean[] blArray, boolean bl) {
        if (bl) {
            this.state = 0;
            this.enableChannels(altingChannelInputArray, blArray);
            this.disableChannels(altingChannelInputArray, blArray);
            this.state = 3;
            return this.selected;
        }
        return this.select(altingChannelInputArray, blArray);
    }

    private void enableChannels(AltingChannelInput[] altingChannelInputArray) {
        int n = 0;
        while (n < altingChannelInputArray.length) {
            if (altingChannelInputArray[n].enable(this)) {
                this.selected = n;
                this.state = 2;
                return;
            }
            ++n;
        }
        this.selected = -1;
    }

    private void disableChannels(AltingChannelInput[] altingChannelInputArray) {
        int n;
        int n2 = n = this.selected == -1 ? altingChannelInputArray.length - 1 : this.selected - 1;
        while (n2 >= 0) {
            if (altingChannelInputArray[n2].disable()) {
                this.selected = n2;
            }
            --n2;
        }
    }

    private void enableChannels(AltingChannelInput[] altingChannelInputArray, boolean[] blArray) {
        int n = 0;
        while (n < altingChannelInputArray.length) {
            if (blArray[n] && altingChannelInputArray[n].enable(this)) {
                this.selected = n;
                this.state = 2;
                return;
            }
            ++n;
        }
        this.selected = -1;
    }

    private void disableChannels(AltingChannelInput[] altingChannelInputArray, boolean[] blArray) {
        int n;
        int n2 = n = this.selected == -1 ? altingChannelInputArray.length - 1 : this.selected - 1;
        while (n2 >= 0) {
            if (blArray[n2] && altingChannelInputArray[n2].disable()) {
                this.selected = n2;
            }
            --n2;
        }
    }
}

