/*
 * Decompiled with CFR 0.152.
 */
package jcsp.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import jcsp.awt.Display;
import jcsp.awt.GraphicsCommand;
import jcsp.awt.Paintable;

public class DisplayList
implements Paintable,
Display {
    private Component component;
    private Dimension size;
    private Image image;
    private Graphics imageGraphics;
    private final int INITIAL_MAX_COMMANDS = 10;
    private GraphicsCommand[] command = new GraphicsCommand[10];
    private int maxCommands = 10;
    private int nCommands = 0;
    private int updateIndex = 0;
    private boolean refresh = false;
    private boolean updated = true;
    private long minRefreshInterval = 10L;

    public void set(GraphicsCommand[] graphicsCommandArray) {
        int n;
        if (graphicsCommandArray != null && (n = graphicsCommandArray.length) > 0) {
            if (n <= this.maxCommands) {
                DisplayList displayList = this;
                synchronized (displayList) {
                    System.arraycopy(graphicsCommandArray, 0, this.command, 0, n);
                    this.nCommands = n;
                    this.updateIndex = 0;
                    this.refresh = true;
                }
            }
            this.maxCommands = 2 * n;
            GraphicsCommand[] graphicsCommandArray2 = new GraphicsCommand[this.maxCommands];
            System.arraycopy(graphicsCommandArray, 0, graphicsCommandArray2, 0, n);
            DisplayList displayList = this;
            synchronized (displayList) {
                this.command = graphicsCommandArray2;
                this.nCommands = n;
                this.updateIndex = 0;
                this.refresh = true;
            }
        }
        this.component.repaint(this.minRefreshInterval);
    }

    public void set(GraphicsCommand graphicsCommand) {
        if (graphicsCommand != null) {
            DisplayList displayList = this;
            synchronized (displayList) {
                this.command[0] = graphicsCommand;
                this.nCommands = 1;
                this.updateIndex = 0;
                this.refresh = true;
            }
        }
        this.component.repaint(this.minRefreshInterval);
    }

    public synchronized int extend(GraphicsCommand[] graphicsCommandArray) {
        int n;
        int n2 = this.nCommands;
        if (graphicsCommandArray != null && (n = graphicsCommandArray.length) > 0) {
            int n3 = n2 + n;
            if (n3 <= this.maxCommands) {
                System.arraycopy(graphicsCommandArray, 0, this.command, n2, n);
                if (this.updated) {
                    this.updateIndex = n2;
                    this.updated = false;
                }
                this.nCommands = n3;
            } else {
                this.maxCommands = 2 * n3;
                GraphicsCommand[] graphicsCommandArray2 = new GraphicsCommand[this.maxCommands];
                System.arraycopy(this.command, 0, graphicsCommandArray2, 0, n2);
                System.arraycopy(graphicsCommandArray, 0, graphicsCommandArray2, n2, n);
                this.command = graphicsCommandArray2;
                if (this.updated) {
                    this.updateIndex = n2;
                    this.updated = false;
                }
                this.nCommands = n3;
            }
        }
        this.component.repaint(this.minRefreshInterval);
        return n2;
    }

    public synchronized int extend(GraphicsCommand graphicsCommand) {
        int n = this.nCommands;
        if (graphicsCommand != null) {
            int n2 = n + 1;
            if (n2 <= this.maxCommands) {
                this.command[n] = graphicsCommand;
                if (this.updated) {
                    this.updateIndex = n;
                    this.updated = false;
                }
                this.nCommands = n2;
            } else {
                this.maxCommands = 2 * n2;
                GraphicsCommand[] graphicsCommandArray = new GraphicsCommand[this.maxCommands];
                System.arraycopy(this.command, 0, graphicsCommandArray, 0, n);
                graphicsCommandArray[n] = graphicsCommand;
                this.command = graphicsCommandArray;
                if (this.updated) {
                    this.updateIndex = n;
                    this.updated = false;
                }
                this.nCommands = n2;
            }
        }
        this.component.repaint(this.minRefreshInterval);
        return n;
    }

    public boolean change(GraphicsCommand[] graphicsCommandArray, int n) {
        int n2;
        if (graphicsCommandArray != null && (n2 = graphicsCommandArray.length) > 0) {
            if (n + n2 <= this.nCommands) {
                DisplayList displayList = this;
                synchronized (displayList) {
                    System.arraycopy(graphicsCommandArray, 0, this.command, n, n2);
                    this.updateIndex = 0;
                    this.refresh = true;
                }
            } else {
                return false;
            }
        }
        this.component.repaint(this.minRefreshInterval);
        return true;
    }

    public boolean change(GraphicsCommand graphicsCommand, int n) {
        if (graphicsCommand != null) {
            if (n + 1 <= this.nCommands) {
                DisplayList displayList = this;
                synchronized (displayList) {
                    this.command[n] = graphicsCommand;
                    this.updateIndex = 0;
                    this.refresh = true;
                }
            } else {
                return false;
            }
        }
        this.component.repaint(this.minRefreshInterval);
        return true;
    }

    public GraphicsCommand[] get() {
        GraphicsCommand[] graphicsCommandArray = new GraphicsCommand[this.nCommands];
        DisplayList displayList = this;
        synchronized (displayList) {
            System.arraycopy(this.command, 0, graphicsCommandArray, 0, this.nCommands);
        }
        return graphicsCommandArray;
    }

    public void setMinRefreshInterval(long l) {
        this.minRefreshInterval = l;
    }

    private void execute(int n, Graphics graphics) {
        int n2 = n;
        while (n2 < this.nCommands) {
            GraphicsCommand graphicsCommand = this.command[n2];
            switch (graphicsCommand.tag) {
                case 0: {
                    break;
                }
                case 1: {
                    GraphicsCommand.Translate translate = (GraphicsCommand.Translate)graphicsCommand;
                    graphics.translate(translate.x, translate.y);
                    break;
                }
                case 2: {
                    GraphicsCommand.SetColor setColor = (GraphicsCommand.SetColor)graphicsCommand;
                    graphics.setColor(setColor.c);
                    break;
                }
                case 3: {
                    graphics.setPaintMode();
                    break;
                }
                case 4: {
                    GraphicsCommand.SetXORMode setXORMode = (GraphicsCommand.SetXORMode)graphicsCommand;
                    graphics.setXORMode(setXORMode.c);
                    break;
                }
                case 5: {
                    GraphicsCommand.SetFont setFont = (GraphicsCommand.SetFont)graphicsCommand;
                    graphics.setFont(setFont.f);
                    break;
                }
                case 6: {
                    GraphicsCommand.ClipRect clipRect = (GraphicsCommand.ClipRect)graphicsCommand;
                    graphics.clipRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
                    break;
                }
                case 7: {
                    GraphicsCommand.SetClip setClip = (GraphicsCommand.SetClip)graphicsCommand;
                    switch (setClip.cliptag) {
                        case 0: {
                            graphics.setClip(setClip.x, setClip.y, setClip.width, setClip.height);
                            break;
                        }
                        case 1: {
                            graphics.setClip(setClip.s);
                        }
                    }
                    break;
                }
                case 8: {
                    GraphicsCommand.CopyArea copyArea = (GraphicsCommand.CopyArea)graphicsCommand;
                    graphics.copyArea(copyArea.x, copyArea.y, copyArea.width, copyArea.height, copyArea.dx, copyArea.dy);
                    break;
                }
                case 9: {
                    GraphicsCommand.DrawLine drawLine = (GraphicsCommand.DrawLine)graphicsCommand;
                    graphics.drawLine(drawLine.x1, drawLine.y1, drawLine.x2, drawLine.y2);
                    break;
                }
                case 10: {
                    GraphicsCommand.FillRect fillRect = (GraphicsCommand.FillRect)graphicsCommand;
                    graphics.fillRect(fillRect.x, fillRect.y, fillRect.width, fillRect.height);
                    break;
                }
                case 11: {
                    GraphicsCommand.DrawRect drawRect = (GraphicsCommand.DrawRect)graphicsCommand;
                    graphics.drawRect(drawRect.x, drawRect.y, drawRect.width, drawRect.height);
                    break;
                }
                case 12: {
                    GraphicsCommand.ClearRect clearRect = (GraphicsCommand.ClearRect)graphicsCommand;
                    graphics.clearRect(clearRect.x, clearRect.y, clearRect.width, clearRect.height);
                    break;
                }
                case 13: {
                    GraphicsCommand.DrawRoundRect drawRoundRect = (GraphicsCommand.DrawRoundRect)graphicsCommand;
                    graphics.drawRoundRect(drawRoundRect.x, drawRoundRect.y, drawRoundRect.width, drawRoundRect.height, drawRoundRect.arcWidth, drawRoundRect.arcHeight);
                    break;
                }
                case 14: {
                    GraphicsCommand.FillRoundRect fillRoundRect = (GraphicsCommand.FillRoundRect)graphicsCommand;
                    graphics.fillRoundRect(fillRoundRect.x, fillRoundRect.y, fillRoundRect.width, fillRoundRect.height, fillRoundRect.arcWidth, fillRoundRect.arcHeight);
                    break;
                }
                case 15: {
                    GraphicsCommand.Draw3DRect draw3DRect = (GraphicsCommand.Draw3DRect)graphicsCommand;
                    graphics.draw3DRect(draw3DRect.x, draw3DRect.y, draw3DRect.width, draw3DRect.height, draw3DRect.raised);
                    break;
                }
                case 16: {
                    GraphicsCommand.Fill3DRect fill3DRect = (GraphicsCommand.Fill3DRect)graphicsCommand;
                    graphics.fill3DRect(fill3DRect.x, fill3DRect.y, fill3DRect.width, fill3DRect.height, fill3DRect.raised);
                    break;
                }
                case 17: {
                    GraphicsCommand.DrawOval drawOval = (GraphicsCommand.DrawOval)graphicsCommand;
                    graphics.drawOval(drawOval.x, drawOval.y, drawOval.width, drawOval.height);
                    break;
                }
                case 18: {
                    GraphicsCommand.FillOval fillOval = (GraphicsCommand.FillOval)graphicsCommand;
                    graphics.fillOval(fillOval.x, fillOval.y, fillOval.width, fillOval.height);
                    break;
                }
                case 19: {
                    GraphicsCommand.DrawArc drawArc = (GraphicsCommand.DrawArc)graphicsCommand;
                    graphics.drawArc(drawArc.x, drawArc.y, drawArc.width, drawArc.height, drawArc.startAngle, drawArc.arcAngle);
                    break;
                }
                case 20: {
                    GraphicsCommand.FillArc fillArc = (GraphicsCommand.FillArc)graphicsCommand;
                    graphics.fillArc(fillArc.x, fillArc.y, fillArc.width, fillArc.height, fillArc.startAngle, fillArc.arcAngle);
                    break;
                }
                case 21: {
                    GraphicsCommand.DrawPolyline drawPolyline = (GraphicsCommand.DrawPolyline)graphicsCommand;
                    graphics.drawPolyline(drawPolyline.xPoints, drawPolyline.yPoints, drawPolyline.nPoints);
                    break;
                }
                case 22: {
                    GraphicsCommand.DrawPolygon drawPolygon = (GraphicsCommand.DrawPolygon)graphicsCommand;
                    switch (drawPolygon.polytag) {
                        case 0: {
                            graphics.drawPolygon(drawPolygon.xPoints, drawPolygon.yPoints, drawPolygon.nPoints);
                            break;
                        }
                        case 1: {
                            graphics.drawPolygon(drawPolygon.p);
                        }
                    }
                    break;
                }
                case 23: {
                    GraphicsCommand.FillPolygon fillPolygon = (GraphicsCommand.FillPolygon)graphicsCommand;
                    switch (fillPolygon.polytag) {
                        case 0: {
                            graphics.fillPolygon(fillPolygon.xPoints, fillPolygon.yPoints, fillPolygon.nPoints);
                            break;
                        }
                        case 1: {
                            graphics.fillPolygon(fillPolygon.p);
                        }
                    }
                    break;
                }
                case 24: {
                    GraphicsCommand.DrawString drawString = (GraphicsCommand.DrawString)graphicsCommand;
                    graphics.drawString(drawString.string, drawString.x, drawString.y);
                    break;
                }
                case 25: {
                    GraphicsCommand.DrawChars drawChars = (GraphicsCommand.DrawChars)graphicsCommand;
                    graphics.drawChars(drawChars.data, drawChars.offset, drawChars.length, drawChars.x, drawChars.y);
                    break;
                }
                case 26: {
                    GraphicsCommand.DrawBytes drawBytes = (GraphicsCommand.DrawBytes)graphicsCommand;
                    graphics.drawBytes(drawBytes.data, drawBytes.offset, drawBytes.length, drawBytes.x, drawBytes.y);
                    break;
                }
                case 27: {
                    GraphicsCommand.DrawImage drawImage = (GraphicsCommand.DrawImage)graphicsCommand;
                    switch (drawImage.drawtag) {
                        case 0: {
                            graphics.drawImage(drawImage.image, drawImage.x, drawImage.y, this.component);
                            break;
                        }
                        case 1: {
                            graphics.drawImage(drawImage.image, drawImage.x, drawImage.y, drawImage.width, drawImage.height, this.component);
                            break;
                        }
                        case 2: {
                            graphics.drawImage(drawImage.image, drawImage.x, drawImage.y, drawImage.bgcolor, this.component);
                            break;
                        }
                        case 3: {
                            graphics.drawImage(drawImage.image, drawImage.x, drawImage.y, drawImage.width, drawImage.height, drawImage.bgcolor, this.component);
                            break;
                        }
                        case 4: {
                            graphics.drawImage(drawImage.image, drawImage.dx1, drawImage.dy1, drawImage.dx2, drawImage.dy2, drawImage.sx1, drawImage.sy1, drawImage.sx2, drawImage.sy2, this.component);
                            break;
                        }
                        case 5: {
                            graphics.drawImage(drawImage.image, drawImage.dx1, drawImage.dy1, drawImage.dx2, drawImage.dy2, drawImage.sx1, drawImage.sy1, drawImage.sx2, drawImage.sy2, drawImage.bgcolor, this.component);
                        }
                    }
                    break;
                }
                case 28: {
                    GraphicsCommand.General general = (GraphicsCommand.General)graphicsCommand;
                    general.g.doGraphic(graphics, this.component);
                }
            }
            ++n2;
        }
    }

    public synchronized void register(Component component) {
        this.component = component;
    }

    public synchronized void paint(Graphics graphics) {
        Dimension dimension = this.component.getSize();
        if (this.image == null) {
            this.size = dimension;
            this.image = this.component.createImage(this.size.width, this.size.height);
            this.imageGraphics = this.image.getGraphics();
        } else if (dimension.width != this.size.width || dimension.height != this.size.height) {
            this.size = dimension;
            this.image = this.component.createImage(this.size.width, this.size.height);
            this.imageGraphics = this.image.getGraphics();
        }
        this.execute(0, this.imageGraphics);
        graphics.drawImage(this.image, 0, 0, this.component);
        this.refresh = false;
    }

    public synchronized void update(Graphics graphics) {
        if (this.refresh) {
            Dimension dimension = this.component.getSize();
            if (this.image == null) {
                this.size = dimension;
                this.image = this.component.createImage(this.size.width, this.size.height);
                this.imageGraphics = this.image.getGraphics();
            } else if (dimension.width != this.size.width || dimension.height != this.size.height) {
                this.size = dimension;
                this.image = this.component.createImage(this.size.width, this.size.height);
                this.imageGraphics = this.image.getGraphics();
            }
            this.execute(0, this.imageGraphics);
            graphics.drawImage(this.image, 0, 0, this.component);
            this.refresh = false;
            this.updated = true;
        } else {
            Dimension dimension = this.component.getSize();
            if (this.image == null) {
                this.size = dimension;
                this.image = this.component.createImage(this.size.width, this.size.height);
                this.imageGraphics = this.image.getGraphics();
            } else if (dimension.width != this.size.width || dimension.height != this.size.height) {
                this.size = dimension;
                this.image = this.component.createImage(this.size.width, this.size.height);
                this.imageGraphics = this.image.getGraphics();
            }
            this.execute(this.updateIndex, this.imageGraphics);
            graphics.drawImage(this.image, 0, 0, this.component);
            this.updated = true;
        }
    }
}

