/*
 * Decompiled with CFR 0.152.
 */
package jcsp.awt;

import java.applet.Applet;
import java.util.Vector;
import jcsp.awt.ComponentEventHandler;
import jcsp.awt.ContainerEventHandler;
import jcsp.awt.FocusEventHandler;
import jcsp.awt.KeyEventHandler;
import jcsp.awt.MouseEventHandler;
import jcsp.awt.MouseMotionEventHandler;
import jcsp.lang.Alternative;
import jcsp.lang.AltingChannelInputInt;
import jcsp.lang.CSProcess;
import jcsp.lang.CSTimer;
import jcsp.lang.ChannelInput;
import jcsp.lang.ChannelOutput;
import jcsp.lang.ChannelOutputInt;
import jcsp.lang.Guard;
import jcsp.lang.Parallel;
import jcsp.lang.ProcessManager;

public class ActiveApplet
extends Applet
implements CSProcess {
    private CSProcess process = null;
    private ProcessManager manager = null;
    private boolean started = false;
    public static final int STOP = 0;
    public static final int START = 1;
    public static final int DESTROY = 2;
    public static final int DEFAULT_TIMEOUT_ACK = 10000;
    private int timeoutAck = 10000;
    private ChannelOutputInt stopStart = null;
    private ChannelOutputInt destroy = null;
    private AltingChannelInputInt destroyAck = null;
    private final CSTimer tim = new CSTimer();
    private Alternative destroyAlt;
    private final int ACKNOWLEDGE = 0;
    private final int TIMEOUT = 1;
    private Vector vec = new Vector();
    private ChannelInput configure;

    public void setProcess(CSProcess cSProcess) {
        this.process = cSProcess;
    }

    public void setStopStartChannel(ChannelOutputInt channelOutputInt) {
        this.stopStart = channelOutputInt;
    }

    public void setDestroyChannels(ChannelOutputInt channelOutputInt, AltingChannelInputInt altingChannelInputInt) {
        this.setDestroyChannels(channelOutputInt, altingChannelInputInt, 10000);
    }

    public void setDestroyChannels(ChannelOutputInt channelOutputInt, AltingChannelInputInt altingChannelInputInt, int n) {
        if (channelOutputInt != null && altingChannelInputInt != null) {
            this.destroy = channelOutputInt;
            this.destroyAck = altingChannelInputInt;
            this.timeoutAck = n;
            this.destroyAlt = new Alternative(new Guard[]{altingChannelInputInt, this.tim});
        }
    }

    public void start() {
        if (this.started) {
            System.out.println("*** ActiveApplet: started - subsequent");
            if (this.manager != null) {
                if (this.stopStart != null) {
                    this.stopStart.write(1);
                } else if (this.destroy == null && this.manager.stopOK()) {
                    this.manager.resume();
                }
            }
        } else {
            System.out.println("*** ActiveApplet: started - first time");
            if (this.process == null) {
                System.out.println("*** ActiveApplet: no process defined ...");
            } else {
                this.manager = new ProcessManager(this.process);
                this.manager.start();
            }
            this.started = true;
        }
    }

    public void stop() {
        System.out.println("*** ActiveApplet: stop");
        if (this.manager != null) {
            if (this.stopStart != null) {
                this.stopStart.write(0);
            } else if (this.destroy == null && this.manager.stopOK()) {
                this.manager.suspend();
            }
        }
    }

    public void destroy() {
        System.out.println("*** ActiveApplet: destroy");
        if (this.manager != null) {
            if (this.destroy != null) {
                this.destroy.write(2);
                if (this.timeoutAck < 0) {
                    this.destroyAck.read();
                } else {
                    this.tim.setAlarm(this.tim.read() + (long)this.timeoutAck);
                    switch (this.destroyAlt.select()) {
                        case 0: {
                            this.destroyAck.read();
                            System.out.println("*** ActiveApplet: ACKNOWLEDGE");
                            break;
                        }
                        case 1: {
                            System.out.println("*** ActiveApplet: TIMEOUT");
                        }
                    }
                }
            }
            System.out.println("*** ActiveApplet: shutting down associated process ... ");
            if (this.manager.stopOK()) {
                this.manager.stop();
            } else {
                Parallel.destroy();
            }
            this.manager = null;
            this.process = null;
        } else {
            Parallel.destroy();
        }
    }

    public int getAppletInt(String string, int n, int n2, int n3) {
        int n4;
        String string2 = this.getParameter(string);
        if (string2 == null) {
            System.out.println("*** Applet parameter " + string + " is missing - defaulting to " + n3);
            n4 = n3;
        } else {
            try {
                n4 = Integer.parseInt(string2);
                if (n4 < n) {
                    System.out.println("*** Applet parameter " + string + " too small (" + n4 + ") - defaulting to " + n);
                    n4 = n;
                } else if (n4 > n2) {
                    System.out.println("*** Applet parameter " + string + " too large (" + n4 + ") - defaulting to " + n2);
                    n4 = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("*** Applet parameter " + string + " is not an integer (" + string2 + ") - defaulting to " + n3);
                n4 = n3;
            }
        }
        return n4;
    }

    public boolean getAppletBoolean(String string, boolean bl) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            System.out.println("*** Applet parameter " + string + " is missing - defaulting to " + bl);
            return bl;
        }
        String string3 = string2.toLowerCase();
        if (string3.equals("true")) {
            return true;
        }
        if (string3.equals("false")) {
            return false;
        }
        System.out.println("*** Applet parameter " + string + " is not a boolean - defaulting to " + bl);
        return bl;
    }

    public byte getAppletByte(String string, byte by, byte by2, byte by3) {
        byte by4;
        String string2 = this.getParameter(string);
        if (string2 == null) {
            System.out.println("*** Applet parameter " + string + " is missing - defaulting to " + by3);
            by4 = by3;
        } else {
            try {
                by4 = Byte.parseByte(string2);
                if (by4 < by) {
                    System.out.println("*** Applet parameter " + string + " too small (" + by4 + ") - defaulting to " + by);
                    by4 = by;
                } else if (by4 > by2) {
                    System.out.println("*** Applet parameter " + string + " too large (" + by4 + ") - defaulting to " + by2);
                    by4 = by2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("*** Applet parameter " + string + " is not a byte (" + string2 + ") - defaulting to " + by3);
                by4 = by3;
            }
        }
        return by4;
    }

    public short getAppletShort(String string, short s, short s2, short s3) {
        short s4;
        String string2 = this.getParameter(string);
        if (string2 == null) {
            System.out.println("*** Applet parameter " + string + " is missing - defaulting to " + s3);
            s4 = s3;
        } else {
            try {
                s4 = Short.parseShort(string2);
                if (s4 < s) {
                    System.out.println("*** Applet parameter " + string + " too small (" + s4 + ") - defaulting to " + s);
                    s4 = s;
                } else if (s4 > s2) {
                    System.out.println("*** Applet parameter " + string + " too large (" + s4 + ") - defaulting to " + s2);
                    s4 = s2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("*** Applet parameter " + string + " is not a short (" + string2 + ") - defaulting to " + s3);
                s4 = s3;
            }
        }
        return s4;
    }

    public long getAppletLong(String string, long l, long l2, long l3) {
        long l4;
        String string2 = this.getParameter(string);
        if (string2 == null) {
            System.out.println("*** Applet parameter " + string + " is missing - defaulting to " + l3);
            l4 = l3;
        } else {
            try {
                l4 = Long.parseLong(string2);
                if (l4 < l) {
                    System.out.println("*** Applet parameter " + string + " too small (" + l4 + ") - defaulting to " + l);
                    l4 = l;
                } else if (l4 > l2) {
                    System.out.println("*** Applet parameter " + string + " too large (" + l4 + ") - defaulting to " + l2);
                    l4 = l2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("*** Applet parameter " + string + " is not a long (" + string2 + ") - defaulting to " + l3);
                l4 = l3;
            }
        }
        return l4;
    }

    public float getAppletFloat(String string, float f, float f2, float f3) {
        float f4;
        String string2 = this.getParameter(string);
        if (string2 == null) {
            System.out.println("*** Applet parameter " + string + " is missing - defaulting to " + f3);
            f4 = f3;
        } else {
            try {
                f4 = Float.parseFloat(string2);
                if (f4 < f) {
                    System.out.println("*** Applet parameter " + string + " too small (" + f4 + ") - defaulting to " + f);
                    f4 = f;
                } else if (f4 > f2) {
                    System.out.println("*** Applet parameter " + string + " too large (" + f4 + ") - defaulting to " + f2);
                    f4 = f2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("*** Applet parameter " + string + " is not a float (" + string2 + ") - defaulting to " + f3);
                f4 = f3;
            }
        }
        return f4;
    }

    public double getAppletDouble(String string, double d, double d2, double d3) {
        double d4;
        String string2 = this.getParameter(string);
        if (string2 == null) {
            System.out.println("*** Applet parameter " + string + " is missing - defaulting to " + d3);
            d4 = d3;
        } else {
            try {
                d4 = Double.parseDouble(string2);
                if (d4 < d) {
                    System.out.println("*** Applet parameter " + string + " too small (" + d4 + ") - defaulting to " + d);
                    d4 = d;
                } else if (d4 > d2) {
                    System.out.println("*** Applet parameter " + string + " too large (" + d4 + ") - defaulting to " + d2);
                    d4 = d2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("*** Applet parameter " + string + " is not a double (" + string2 + ") - defaulting to " + d3);
                d4 = d3;
            }
        }
        return d4;
    }

    public void setConfigureChannel(ChannelInput channelInput) {
        this.configure = channelInput;
    }

    public void addContainerEventChannel(ChannelOutput channelOutput) {
        if (channelOutput != null) {
            ContainerEventHandler containerEventHandler = new ContainerEventHandler(channelOutput);
            this.addContainerListener(containerEventHandler);
            this.vec.addElement(containerEventHandler);
        }
    }

    public void addComponentEventChannel(ChannelOutput channelOutput) {
        if (channelOutput != null) {
            ComponentEventHandler componentEventHandler = new ComponentEventHandler(channelOutput);
            this.addComponentListener(componentEventHandler);
            this.vec.addElement(componentEventHandler);
        }
    }

    public void addFocusEventChannel(ChannelOutput channelOutput) {
        if (channelOutput != null) {
            FocusEventHandler focusEventHandler = new FocusEventHandler(channelOutput);
            this.addFocusListener(focusEventHandler);
            this.vec.addElement(focusEventHandler);
        }
    }

    public void addKeyEventChannel(ChannelOutput channelOutput) {
        if (channelOutput != null) {
            KeyEventHandler keyEventHandler = new KeyEventHandler(channelOutput);
            this.addKeyListener(keyEventHandler);
            this.vec.addElement(keyEventHandler);
        }
    }

    public void addMouseEventChannel(ChannelOutput channelOutput) {
        if (channelOutput != null) {
            MouseEventHandler mouseEventHandler = new MouseEventHandler(channelOutput);
            this.addMouseListener(mouseEventHandler);
            this.vec.addElement(mouseEventHandler);
        }
    }

    public void addMouseMotionEventChannel(ChannelOutput channelOutput) {
        if (channelOutput != null) {
            MouseMotionEventHandler mouseMotionEventHandler = new MouseMotionEventHandler(channelOutput);
            this.addMouseMotionListener(mouseMotionEventHandler);
            this.vec.addElement(mouseMotionEventHandler);
        }
    }

    public void run() {
        if (this.configure != null) {
            while (true) {
                Object object;
                if (!((object = this.configure.read()) instanceof Configure)) {
                    continue;
                }
                ((Configure)object).configure(this);
            }
        }
    }

    public static interface Configure {
        public void configure(Applet var1);
    }
}

