/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.session;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.session.Source;

public class FileSource
extends Source {
    private File file_;

    public FileSource(String filename) {
        this(new File(filename));
    }

    public FileSource(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file_ = file;
        String filename = this.file_.getAbsolutePath();
        if (filename.endsWith(".tex")) {
            this.setMarkup(Markup.LATEX);
        }
        if (filename.endsWith(".utf8")) {
            this.setMarkup(Markup.UNICODE);
            this.setEncoding("UTF-8");
        }
        if (filename.endsWith(".utf16")) {
            this.setMarkup(Markup.UNICODE);
            this.setEncoding("UTF-16");
        }
    }

    public String toString() {
        return this.file_.toString();
    }

    protected InputStream getStream() throws IOException {
        return new FileInputStream(this.file_);
    }
}

