/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.print.z;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.ListTermVisitor;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.parser.util.Decorword;
import net.sourceforge.czt.print.ast.Application;
import net.sourceforge.czt.print.ast.ApplicationVisitor;
import net.sourceforge.czt.print.ast.OperatorApplication;
import net.sourceforge.czt.print.ast.OperatorApplicationVisitor;
import net.sourceforge.czt.print.ast.PrintExpression;
import net.sourceforge.czt.print.ast.PrintExpressionVisitor;
import net.sourceforge.czt.print.ast.PrintParagraph;
import net.sourceforge.czt.print.ast.PrintParagraphVisitor;
import net.sourceforge.czt.print.ast.PrintPredicate;
import net.sourceforge.czt.print.ast.PrintPredicateVisitor;
import net.sourceforge.czt.print.z.AbstractPrintVisitor;
import net.sourceforge.czt.util.CztException;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.AndExpr;
import net.sourceforge.czt.z.ast.AndPred;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.Assoc;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.BindExpr;
import net.sourceforge.czt.z.ast.BindSelExpr;
import net.sourceforge.czt.z.ast.Branch;
import net.sourceforge.czt.z.ast.Cat;
import net.sourceforge.czt.z.ast.CompExpr;
import net.sourceforge.czt.z.ast.CondExpr;
import net.sourceforge.czt.z.ast.ConjPara;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.DecorExpr;
import net.sourceforge.czt.z.ast.Directive;
import net.sourceforge.czt.z.ast.Exists1Expr;
import net.sourceforge.czt.z.ast.Exists1Pred;
import net.sourceforge.czt.z.ast.ExistsExpr;
import net.sourceforge.czt.z.ast.ExistsPred;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ExprPred;
import net.sourceforge.czt.z.ast.FalsePred;
import net.sourceforge.czt.z.ast.ForallExpr;
import net.sourceforge.czt.z.ast.ForallPred;
import net.sourceforge.czt.z.ast.FreePara;
import net.sourceforge.czt.z.ast.Freetype;
import net.sourceforge.czt.z.ast.GenParamType;
import net.sourceforge.czt.z.ast.GenericType;
import net.sourceforge.czt.z.ast.GivenPara;
import net.sourceforge.czt.z.ast.GivenType;
import net.sourceforge.czt.z.ast.HideExpr;
import net.sourceforge.czt.z.ast.IffExpr;
import net.sourceforge.czt.z.ast.IffPred;
import net.sourceforge.czt.z.ast.ImpliesExpr;
import net.sourceforge.czt.z.ast.ImpliesPred;
import net.sourceforge.czt.z.ast.InStroke;
import net.sourceforge.czt.z.ast.InclDecl;
import net.sourceforge.czt.z.ast.LambdaExpr;
import net.sourceforge.czt.z.ast.LatexMarkupPara;
import net.sourceforge.czt.z.ast.LetExpr;
import net.sourceforge.czt.z.ast.LocAnn;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.MuExpr;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.NameExprPair;
import net.sourceforge.czt.z.ast.NameNamePair;
import net.sourceforge.czt.z.ast.NameSectTypeTriple;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.NarrPara;
import net.sourceforge.czt.z.ast.NarrSect;
import net.sourceforge.czt.z.ast.NegExpr;
import net.sourceforge.czt.z.ast.NegPred;
import net.sourceforge.czt.z.ast.NextStroke;
import net.sourceforge.czt.z.ast.NumExpr;
import net.sourceforge.czt.z.ast.NumStroke;
import net.sourceforge.czt.z.ast.Operand;
import net.sourceforge.czt.z.ast.Operator;
import net.sourceforge.czt.z.ast.OptempPara;
import net.sourceforge.czt.z.ast.OrExpr;
import net.sourceforge.czt.z.ast.OrPred;
import net.sourceforge.czt.z.ast.OutStroke;
import net.sourceforge.czt.z.ast.ParenAnn;
import net.sourceforge.czt.z.ast.Parent;
import net.sourceforge.czt.z.ast.PipeExpr;
import net.sourceforge.czt.z.ast.PowerExpr;
import net.sourceforge.czt.z.ast.PowerType;
import net.sourceforge.czt.z.ast.PreExpr;
import net.sourceforge.czt.z.ast.ProdExpr;
import net.sourceforge.czt.z.ast.ProdType;
import net.sourceforge.czt.z.ast.ProjExpr;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.RenameExpr;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.SchemaType;
import net.sourceforge.czt.z.ast.SectTypeEnvAnn;
import net.sourceforge.czt.z.ast.SetCompExpr;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.SignatureAnn;
import net.sourceforge.czt.z.ast.Spec;
import net.sourceforge.czt.z.ast.Stroke;
import net.sourceforge.czt.z.ast.ThetaExpr;
import net.sourceforge.czt.z.ast.TruePred;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.TupleSelExpr;
import net.sourceforge.czt.z.ast.TypeAnn;
import net.sourceforge.czt.z.ast.TypeEnvAnn;
import net.sourceforge.czt.z.ast.UnparsedPara;
import net.sourceforge.czt.z.ast.UnparsedZSect;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZSect;
import net.sourceforge.czt.z.util.OperatorName;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.z.visitor.ZVisitor;

public class ZPrintVisitor
extends AbstractPrintVisitor
implements TermVisitor,
ListTermVisitor,
ZVisitor,
ApplicationVisitor,
OperatorApplicationVisitor,
PrintParagraphVisitor,
PrintPredicateVisitor,
PrintExpressionVisitor {
    public ZPrintVisitor(AbstractPrintVisitor.ZPrinter printer) {
        super(printer);
    }

    public Object visitTerm(Term term) {
        throw new CztException("Unexpected term " + term);
    }

    public Object visitListTerm(ListTerm listTerm) {
        for (Object o : listTerm) {
            if (!(o instanceof Term)) continue;
            Term t = (Term)o;
            this.visit(t);
        }
        return null;
    }

    public Object visitAndPred(AndPred andPred) {
        throw new UnsupportedOperationException("Unexpeced term AndPred");
    }

    public Object visitAndExpr(AndExpr andExpr) {
        boolean braces;
        boolean bl = braces = andExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.visit((Term)andExpr.getLeftExpr());
        this.printAnd();
        this.visit((Term)andExpr.getRightExpr());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitAxPara(AxPara axPara) {
        throw new UnsupportedOperationException("Unexpeced term AxPara");
    }

    private void print(Term t1, int symbol, Term t2) {
        this.visit(t1);
        this.print(symbol);
        this.visit(t2);
    }

    private void print(Term t1, String symbol, Term t2) {
        if (symbol == null) {
            throw new CztException();
        }
        this.visit(t1);
        this.print(36, new Decorword(symbol));
        this.visit(t2);
    }

    private String getBinOperatorName(RefExpr refExpr) {
        String result = null;
        String word = refExpr.getRefName().getWord();
        String[] split = word.split(" ");
        int expectedLength = 4;
        int third = 3;
        if (split.length == 4 && split[1].equals("_") && split[3].equals("_")) {
            result = split[2];
        }
        if (result == null) {
            String message = "ZPrintVisitor: getBinOperatorName of " + word + " failed.";
            message = message + " split is " + split + " of length " + split.length;
            throw new CztException(message);
        }
        return result;
    }

    public Object visitApplication(Application appl) {
        boolean braces;
        boolean bl = braces = appl.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.visit((Term)appl.getLeftExpr());
        this.visit((Term)appl.getRightExpr());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitApplExpr(ApplExpr applExpr) {
        throw new CztException("Unexpected term " + applExpr);
    }

    public Object visitBindExpr(BindExpr bindExpr) {
        boolean braces;
        boolean bl = braces = bindExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.print(8);
        this.printTermList((List)bindExpr.getNameExprPair());
        this.print(9);
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitBindSelExpr(BindSelExpr bindSelExpr) {
        boolean braces;
        boolean bl = braces = bindSelExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.visit((Term)bindSelExpr.getExpr());
        this.printKeyword(ZString.DOT);
        this.visit((Term)bindSelExpr.getName());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitBranch(Branch branch) {
        this.visit((Term)branch.getDeclName());
        if (branch.getExpr() != null) {
            this.print(10);
            this.visit((Term)branch.getExpr());
            this.print(11);
        }
        return null;
    }

    public Object visitCompExpr(CompExpr compExpr) {
        boolean braces;
        boolean bl = braces = compExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.visit((Term)compExpr.getLeftExpr());
        this.printKeyword(ZString.ZCOMP);
        this.visit((Term)compExpr.getRightExpr());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitCondExpr(CondExpr condExpr) {
        boolean braces;
        boolean bl = braces = condExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.printKeyword("if");
        this.visit((Term)condExpr.getPred());
        this.printKeyword("then");
        this.visit((Term)condExpr.getLeftExpr());
        this.printKeyword("else");
        this.visit((Term)condExpr.getRightExpr());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitConjPara(ConjPara conjPara) {
        this.print(12);
        if (conjPara.getDeclName().size() > 0) {
            this.print(4);
            this.visit((Term)conjPara.getDeclName());
            this.print(5);
        }
        this.printKeyword(ZString.CONJECTURE);
        this.visit((Term)conjPara.getPred());
        this.print(17);
        return null;
    }

    public Object visitConstDecl(ConstDecl constDecl) {
        this.visit((Term)constDecl.getDeclName());
        this.printKeyword("==");
        this.visit((Term)constDecl.getExpr());
        return null;
    }

    public Object visitDeclName(DeclName declName) {
        OperatorName op = declName.getOperatorName();
        if (op == null) {
            return this.visitName((Name)declName);
        }
        Iterator iter = op.iterator();
        while (iter.hasNext()) {
            this.print(36, new Decorword((String)iter.next()));
        }
        return null;
    }

    public Object visitDecorExpr(DecorExpr decorExpr) {
        boolean braces;
        boolean bl = braces = decorExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.visit((Term)decorExpr.getExpr());
        this.visit((Term)decorExpr.getStroke());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitDirective(Directive directive) {
        return null;
    }

    public Object visitExists1Expr(Exists1Expr exists1Expr) {
        boolean braces;
        boolean bl = braces = exists1Expr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.printKeyword(ZString.EXIONE);
        this.visit((Term)exists1Expr.getSchText());
        this.printKeyword(ZString.SPOT);
        this.visit((Term)exists1Expr.getExpr());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitExists1Pred(Exists1Pred exists1Pred) {
        boolean braces;
        boolean bl = braces = exists1Pred.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.printKeyword(ZString.EXIONE);
        this.visit((Term)exists1Pred.getSchText());
        this.printKeyword(ZString.SPOT);
        this.visit((Term)exists1Pred.getPred());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitExistsExpr(ExistsExpr existsExpr) {
        boolean braces;
        boolean bl = braces = existsExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.printKeyword(ZString.EXI);
        this.visit((Term)existsExpr.getSchText());
        this.printKeyword(ZString.SPOT);
        this.visit((Term)existsExpr.getExpr());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitExistsPred(ExistsPred existsPred) {
        boolean braces;
        boolean bl = braces = existsPred.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.printKeyword(ZString.EXI);
        this.visit((Term)existsPred.getSchText());
        this.printKeyword(ZString.SPOT);
        this.visit((Term)existsPred.getPred());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitExprPred(ExprPred exprPred) {
        boolean braces;
        boolean bl = braces = exprPred.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.visit((Term)exprPred.getExpr());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitFalsePred(FalsePred falsePred) {
        this.printKeyword("false");
        return null;
    }

    public Object visitForallExpr(ForallExpr forallExpr) {
        boolean braces;
        boolean bl = braces = forallExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.printKeyword(ZString.ALL);
        this.visit((Term)forallExpr.getSchText());
        this.printKeyword(ZString.SPOT);
        this.visit((Term)forallExpr.getExpr());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitForallPred(ForallPred forallPred) {
        boolean braces;
        boolean bl = braces = forallPred.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.printKeyword(ZString.ALL);
        this.visit((Term)forallPred.getSchText());
        this.printKeyword(ZString.SPOT);
        this.visit((Term)forallPred.getPred());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitFreePara(FreePara freePara) {
        this.print(12);
        this.printTermList((List)freePara.getFreetype(), ZString.ANDALSO);
        this.print(17);
        return null;
    }

    public Object visitFreetype(Freetype freetype) {
        this.visit((Term)freetype.getDeclName());
        this.printKeyword("::=");
        this.printTermList((List)freetype.getBranch(), "|");
        return null;
    }

    public Object visitGenericType(GenericType genType) {
        throw new UnsupportedOperationException("Unexpected term GenType");
    }

    public Object visitGenParamType(GenParamType genType) {
        throw new UnsupportedOperationException("Unexpected term GenType");
    }

    public Object visitGivenPara(GivenPara givenPara) {
        this.print(12);
        this.print(4);
        this.printTermList((List)givenPara.getDeclName());
        this.print(5);
        this.print(17);
        return null;
    }

    public Object visitGivenType(GivenType givenType) {
        throw new UnsupportedOperationException("Unexpected term GenType");
    }

    public Object visitHideExpr(HideExpr hideExpr) {
        boolean braces;
        boolean bl = braces = hideExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.visit((Term)hideExpr.getExpr());
        this.printKeyword(ZString.ZHIDE);
        this.print(2);
        this.printTermList((List)hideExpr.getName());
        this.print(3);
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitIffExpr(IffExpr iffExpr) {
        boolean braces;
        boolean bl = braces = iffExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.visit((Term)iffExpr.getLeftExpr());
        this.printKeyword(ZString.IFF);
        this.visit((Term)iffExpr.getRightExpr());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitIffPred(IffPred iffPred) {
        boolean braces;
        boolean bl = braces = iffPred.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.visit((Term)iffPred.getLeftPred());
        this.printKeyword(ZString.IFF);
        this.visit((Term)iffPred.getRightPred());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitImpliesExpr(ImpliesExpr impliesExpr) {
        boolean braces;
        boolean bl = braces = impliesExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.visit((Term)impliesExpr.getLeftExpr());
        this.printKeyword(ZString.IMP);
        this.visit((Term)impliesExpr.getRightExpr());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitImpliesPred(ImpliesPred impliesPred) {
        boolean braces;
        boolean bl = braces = impliesPred.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.visit((Term)impliesPred.getLeftPred());
        this.printKeyword(ZString.IMP);
        this.visit((Term)impliesPred.getRightPred());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitInclDecl(InclDecl inclDecl) {
        this.visit((Term)inclDecl.getExpr());
        return null;
    }

    public Object visitInStroke(InStroke inStroke) {
        this.print(22);
        return null;
    }

    public Object visitLambdaExpr(LambdaExpr lambdaExpr) {
        boolean braces;
        boolean bl = braces = lambdaExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.printKeyword(ZString.LAMBDA);
        this.visit((Term)lambdaExpr.getSchText());
        this.printKeyword(ZString.SPOT);
        this.visit((Term)lambdaExpr.getExpr());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitLetExpr(LetExpr letExpr) {
        boolean braces;
        boolean bl = braces = letExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.printKeyword("let");
        this.visit((Term)letExpr.getSchText());
        this.printKeyword(ZString.SPOT);
        this.visit((Term)letExpr.getExpr());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitLatexMarkupPara(LatexMarkupPara latexMarkupPara) {
        return null;
    }

    public Object visitLocAnn(LocAnn locAnn) {
        throw new UnsupportedOperationException("Unexpeced term LocAnn");
    }

    public Object visitMemPred(MemPred memPred) {
        throw new UnsupportedOperationException("Unexpeced term MemPred");
    }

    public Object visitMuExpr(MuExpr muExpr) {
        if (muExpr.getExpr() != null) {
            boolean braces;
            boolean bl = braces = muExpr.getAnn(ParenAnn.class) != null;
            if (braces) {
                this.print(2);
            }
            this.printKeyword(ZString.MU);
            this.visit((Term)muExpr.getSchText());
            this.printKeyword(ZString.SPOT);
            this.visit((Term)muExpr.getExpr());
            if (braces) {
                this.print(3);
            }
        } else {
            this.print(2);
            this.printKeyword(ZString.MU);
            this.visit((Term)muExpr.getSchText());
            this.print(3);
        }
        return null;
    }

    public Object visitName(Name name) {
        this.print(36, new Decorword(name.getWord(), (List)name.getStroke()));
        return null;
    }

    public Object visitNameExprPair(NameExprPair pair) {
        this.visit((Term)pair.getName());
        this.printKeyword("==");
        this.visit((Term)pair.getExpr());
        return null;
    }

    public Object visitNameNamePair(NameNamePair pair) {
        this.visit((Term)pair.getNewName());
        this.printKeyword("/");
        this.visit((Term)pair.getOldName());
        return null;
    }

    public Object visitNameSectTypeTriple(NameSectTypeTriple triple) {
        String message = "Unexpected term NameSectTypeTriple.";
        throw new UnsupportedOperationException(message);
    }

    public Object visitNameTypePair(NameTypePair pair) {
        String message = "Unexpected term NameTypePair.";
        throw new UnsupportedOperationException(message);
    }

    public Object visitNarrPara(NarrPara narrPara) {
        this.printNarrText((List)narrPara.getContent());
        return null;
    }

    public Object visitNarrSect(NarrSect narrSect) {
        this.printNarrText((List)narrSect.getContent());
        return null;
    }

    private void printNarrText(List list) {
        StringBuffer txt = new StringBuffer();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            txt.append((String)iter.next());
        }
        this.print(30, txt.toString());
    }

    public Object visitNegExpr(NegExpr negExpr) {
        boolean braces;
        boolean bl = braces = negExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.printKeyword(ZString.NOT);
        this.visit((Term)negExpr.getExpr());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitNegPred(NegPred negPred) {
        boolean braces;
        boolean bl = braces = negPred.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.printKeyword(ZString.NOT);
        this.visit((Term)negPred.getPred());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitNextStroke(NextStroke nextStroke) {
        this.print(24);
        return null;
    }

    public Object visitNumExpr(NumExpr numExpr) {
        boolean braces;
        boolean bl = braces = numExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.print(28, Integer.valueOf(numExpr.getValue().toString()));
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitNumStroke(NumStroke numStroke) {
        this.print(29, numStroke.getNumber());
        return null;
    }

    public Object visitOperand(Operand operand) {
        if (operand.getList().booleanValue()) {
            this.printKeyword(",,");
        } else {
            this.printKeyword(ZString.ARG);
        }
        return null;
    }

    public Object visitOperator(Operator operator) {
        this.print(36, new Decorword(operator.getWord()));
        return null;
    }

    public Object visitOperatorApplication(OperatorApplication appl) {
        String message;
        boolean braces;
        boolean bl = braces = appl.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        if ((message = this.printOperator(appl.getOperatorName(), (Object)appl.getArgs())) != null) {
            throw new CztException("Cannot print appl");
        }
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitOptempPara(OptempPara optempPara) {
        Assoc assoc;
        this.print(12);
        Cat cat = optempPara.getCat();
        if (Cat.Function.equals((Object)cat)) {
            this.printKeyword("function");
        } else if (Cat.Generic.equals((Object)cat)) {
            this.printKeyword("generic");
        } else if (Cat.Relation.equals((Object)cat)) {
            this.printKeyword("relation");
        }
        if (optempPara.getPrec() != null) {
            this.print(28, optempPara.getPrec());
        }
        if (Assoc.Left.equals((Object)(assoc = optempPara.getAssoc()))) {
            this.printKeyword("leftassoc");
        } else if (Assoc.Right.equals((Object)assoc)) {
            this.printKeyword("rightassoc");
        }
        this.print(2);
        ListTerm list = optempPara.getOper();
        for (Term term : list) {
            this.visit(term);
        }
        this.print(3);
        this.print(17);
        return null;
    }

    public Object visitOrExpr(OrExpr orExpr) {
        boolean braces;
        boolean bl = braces = orExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.visit((Term)orExpr.getLeftExpr());
        this.printKeyword(ZString.OR);
        this.visit((Term)orExpr.getRightExpr());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitOrPred(OrPred orPred) {
        boolean braces;
        boolean bl = braces = orPred.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.visit((Term)orPred.getLeftPred());
        this.printKeyword(ZString.OR);
        this.visit((Term)orPred.getRightPred());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitOutStroke(OutStroke outStroke) {
        this.print(23);
        return null;
    }

    public Object visitParenAnn(ParenAnn parenAnn) {
        throw new UnsupportedOperationException("Unexpected term ParenAnn.");
    }

    public Object visitParent(Parent parent) {
        String word = parent.getWord();
        if (word == null) {
            throw new CztException();
        }
        this.print(36, new Decorword(word));
        return null;
    }

    public Object visitPipeExpr(PipeExpr pipeExpr) {
        boolean braces;
        boolean bl = braces = pipeExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.visit((Term)pipeExpr.getLeftExpr());
        this.printKeyword(ZString.ZPIPE);
        this.visit((Term)pipeExpr.getRightExpr());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitPowerExpr(PowerExpr powerExpr) {
        boolean braces;
        boolean bl = braces = powerExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.printKeyword(ZString.POWER);
        this.visit((Term)powerExpr.getExpr());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitPowerType(PowerType powerType) {
        throw new UnsupportedOperationException("Unexpected term PowerType.");
    }

    public Object visitPreExpr(PreExpr preExpr) {
        boolean braces;
        boolean bl = braces = preExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.printKeyword("pre");
        this.visit((Term)preExpr.getExpr());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitPrintParagraph(PrintParagraph printParagraph) {
        Object[] array = printParagraph.getChildren();
        for (int i = 0; i < array.length; ++i) {
            Object object = array[i];
            if (object instanceof String) {
                String string = (String)object;
                if (string.equals(ZString.ZED)) {
                    this.print(12);
                    continue;
                }
                if (string.equals(ZString.AX)) {
                    this.print(13);
                    continue;
                }
                if (string.equals(ZString.GENAX)) {
                    this.print(15);
                    continue;
                }
                if (string.equals(ZString.SCH)) {
                    this.print(14);
                    continue;
                }
                if (string.equals(ZString.GENSCH)) {
                    this.print(16);
                    continue;
                }
                if (string.equals(ZString.LSQUARE)) {
                    this.print(4);
                    continue;
                }
                if (string.equals(ZString.RSQUARE)) {
                    this.print(5);
                    continue;
                }
                if (string.equals("|")) {
                    this.print(21);
                    continue;
                }
                if (string.equals(ZString.NL)) {
                    this.print(18);
                    continue;
                }
                if (string.equals(ZString.END)) {
                    this.print(17);
                    continue;
                }
                this.print(36, new Decorword((String)object));
                continue;
            }
            if (!(object instanceof Term)) continue;
            this.visit((Term)object);
        }
        return null;
    }

    public Object visitPrintPredicate(PrintPredicate printPredicate) {
        boolean braces;
        boolean bl = braces = printPredicate.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        Object[] array = printPredicate.getChildren();
        for (int i = 0; i < array.length; ++i) {
            Object object = array[i];
            if (object instanceof String) {
                String string = (String)object;
                if (string.equals(ZString.NL)) {
                    this.print(18);
                    continue;
                }
                this.print(36, new Decorword((String)object));
                continue;
            }
            if (!(object instanceof Term)) continue;
            this.visit((Term)object);
        }
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitPrintExpression(PrintExpression printExpression) {
        boolean braces;
        boolean bl = braces = printExpression.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        Object[] array = printExpression.getChildren();
        for (int i = 0; i < array.length; ++i) {
            Object object = array[i];
            if (object instanceof String) {
                this.print(36, new Decorword((String)object));
                continue;
            }
            if (!(object instanceof Term)) continue;
            this.visit((Term)object);
        }
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitProdExpr(ProdExpr prodExpr) {
        boolean braces;
        boolean bl = braces = prodExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.printTermList((List)prodExpr.getExpr(), ZString.CROSS);
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitProdType(ProdType prodType) {
        throw new UnsupportedOperationException("Unexpected term ProdType.");
    }

    public Object visitProjExpr(ProjExpr projExpr) {
        boolean braces;
        boolean bl = braces = projExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.visit((Term)projExpr.getLeftExpr());
        this.printKeyword(ZString.ZPROJ);
        this.visit((Term)projExpr.getRightExpr());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitRefExpr(RefExpr refExpr) {
        boolean braces;
        boolean bl = braces = refExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        if (refExpr.getMixfix().booleanValue()) {
            String message = "RefExpr with Mixfix set to true are not contained in print trees; did you run the AstToPrintTreeVisitor before calling this ZPrintVisitor?";
            throw new CztException(message);
        }
        this.visit((Term)refExpr.getRefName());
        if (refExpr.getExpr().size() > 0) {
            this.print(4);
            this.printTermList((List)refExpr.getExpr());
            this.print(5);
        }
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitRefName(RefName refName) {
        OperatorName op = refName.getOperatorName();
        if (op == null) {
            return this.visitName((Name)refName);
        }
        this.print(2);
        Iterator iter = op.iterator();
        while (iter.hasNext()) {
            this.print(36, new Decorword((String)iter.next()));
        }
        this.print(3);
        return null;
    }

    public Object visitRenameExpr(RenameExpr renameExpr) {
        boolean braces;
        boolean bl = braces = renameExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.visit((Term)renameExpr.getExpr());
        this.print(4);
        this.printTermList((List)renameExpr.getNameNamePair());
        this.print(5);
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitSchemaType(SchemaType schemaType) {
        throw new UnsupportedOperationException("Unexpected term SchemaType.");
    }

    public Object visitSchExpr(SchExpr schExpr) {
        this.print(4);
        this.visit((Term)schExpr.getSchText());
        this.print(5);
        return null;
    }

    public Object visitSchText(SchText schText) {
        this.printTermList((List)schText.getDecl(), ZString.SEMICOLON);
        if (schText.getPred() != null) {
            this.printKeyword("|");
            this.visit((Term)schText.getPred());
        }
        return null;
    }

    public Object visitSectTypeEnvAnn(SectTypeEnvAnn ann) {
        throw new UnsupportedOperationException("Unexpected term SectTypeEnvAnn.");
    }

    public Object visitSetCompExpr(SetCompExpr setCompExpr) {
        this.print(6);
        this.visit((Term)setCompExpr.getSchText());
        if (setCompExpr.getExpr() != null) {
            this.printKeyword(ZString.SPOT);
            this.visit((Term)setCompExpr.getExpr());
        }
        this.print(7);
        return null;
    }

    public Object visitSetExpr(SetExpr setExpr) {
        this.print(6);
        this.printTermList((List)setExpr.getExpr());
        this.print(7);
        return null;
    }

    public Object visitSignature(Signature s) {
        throw new UnsupportedOperationException("Unexpected term Signature.");
    }

    public Object visitSpec(Spec spec) {
        this.visit((Term)spec.getSect());
        return null;
    }

    public Object visitThetaExpr(ThetaExpr thetaExpr) {
        boolean braces;
        boolean bl = braces = thetaExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.printKeyword(ZString.THETA);
        this.visit((Term)thetaExpr.getExpr());
        this.visit((Term)thetaExpr.getStroke());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitTruePred(TruePred truePred) {
        this.printKeyword("true");
        return null;
    }

    public Object visitTupleExpr(TupleExpr tupleExpr) {
        this.print(2);
        this.printTermList((List)tupleExpr.getExpr());
        this.print(3);
        return null;
    }

    public Object visitTupleSelExpr(TupleSelExpr tupleSelExpr) {
        boolean braces;
        boolean bl = braces = tupleSelExpr.getAnn(ParenAnn.class) != null;
        if (braces) {
            this.print(2);
        }
        this.visit((Term)tupleSelExpr.getExpr());
        this.printKeyword(ZString.DOT);
        this.print(28, tupleSelExpr.getSelect());
        if (braces) {
            this.print(3);
        }
        return null;
    }

    public Object visitSignatureAnn(SignatureAnn typeAnn) {
        throw new UnsupportedOperationException("Unexpected term SignatureAnn.");
    }

    public Object visitTypeAnn(TypeAnn typeAnn) {
        throw new UnsupportedOperationException("Unexpected term TypeAnn.");
    }

    public Object visitTypeEnvAnn(TypeEnvAnn typeEnvAnn) {
        throw new UnsupportedOperationException("Unexpected term TypeEnvAnn.");
    }

    public Object visitUnparsedPara(UnparsedPara unparsedPara) {
        return null;
    }

    public Object visitUnparsedZSect(UnparsedZSect unparsedZSect) {
        return null;
    }

    public Object visitVarDecl(VarDecl varDecl) {
        this.printTermList((List)varDecl.getDeclName());
        this.printKeyword(ZString.COLON);
        this.visit((Term)varDecl.getExpr());
        return null;
    }

    public Object visitZSect(ZSect zSect) {
        boolean isAnonymous;
        String name = zSect.getName();
        ListTerm parents = zSect.getParent();
        boolean nameIsSpecification = "Specification".equals(name);
        boolean bl = isAnonymous = "Specification".equals(name) && parents.size() == 1 && "standard_toolkit".equals(((Parent)parents.get(0)).getWord());
        if (!isAnonymous) {
            this.print(12);
            this.print(19);
            if (name == null) {
                throw new CztException();
            }
            this.print(36, new Decorword(name));
            if (parents.size() > 0) {
                this.print(20);
                this.printTermList((List)parents);
            }
            this.print(17);
        }
        this.visit((Term)zSect.getPara());
        return null;
    }

    protected void visit(Term t) {
        if (t != null) {
            t.accept((Visitor)this);
        }
    }

    private void printAnd() {
        this.printKeyword(ZString.AND);
    }

    private String printOperator(Expr operator, Object arguments) {
        if (!(operator instanceof RefExpr)) {
            return operator.toString() + " not instance of RefExpr.";
        }
        RefExpr ref = (RefExpr)operator;
        OperatorName op = null;
        try {
            op = new OperatorName((Name)ref.getRefName());
        }
        catch (OperatorName.OperatorNameException e) {
            return "Unexpected operator " + ref.getRefName().getWord();
        }
        assert (op != null);
        return this.printOperator(op, arguments);
    }

    private String printOperator(OperatorName op, Object arguments) {
        List<Object> args = new ArrayList();
        if (arguments instanceof List) {
            args = (List)arguments;
        } else if (op.isUnary()) {
            args.add(arguments);
        } else {
            if (!(arguments instanceof TupleExpr)) {
                return arguments.toString() + " not instance of TupleExpr";
            }
            TupleExpr tuple = (TupleExpr)arguments;
            args = tuple.getExpr();
        }
        int pos = 0;
        for (String opPart : op) {
            if (opPart.equals(ZString.ARG)) {
                this.visit((Term)args.get(pos));
                ++pos;
                continue;
            }
            if (opPart.equals(",,")) {
                Object arg = args.get(pos);
                if (!(arg instanceof SetExpr)) {
                    return "Expected SetExpr but got " + arg;
                }
                SetExpr setExpr = (SetExpr)arg;
                ListTerm sequence = setExpr.getExpr();
                Iterator i = sequence.iterator();
                while (i.hasNext()) {
                    Object o = i.next();
                    if (!(o instanceof TupleExpr)) {
                        return "Expected TupleExpr but got " + o;
                    }
                    TupleExpr tuple = (TupleExpr)o;
                    ListTerm tupleContents = tuple.getExpr();
                    if (tupleContents.size() != 2) {
                        return "Expected tuple of size 2 but was " + tupleContents.size();
                    }
                    this.visit((Term)((Expr)tupleContents.get(1)));
                    if (!i.hasNext()) continue;
                    this.printKeyword(ZString.COMMA);
                }
                ++pos;
                continue;
            }
            this.print(36, new Decorword(opPart));
        }
        return null;
    }

    private String strokeListToString(List strokes) {
        StringBuffer result = new StringBuffer();
        for (Stroke stroke : strokes) {
            result.append(stroke.toString());
        }
        return result.toString();
    }

    protected void printTermList(List list) {
        this.printTermList(list, ZString.COMMA);
    }

    protected void printTermList(List list, int separator) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Term term = (Term)iter.next();
            this.visit(term);
            if (!iter.hasNext()) continue;
            this.print(separator);
        }
    }

    protected void printTermList(List list, String separator) {
        if (separator == null) {
            throw new NullPointerException();
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Term term = (Term)iter.next();
            this.visit(term);
            if (!iter.hasNext()) continue;
            this.printKeyword(separator);
        }
    }

    protected void printKeyword(String keyword) {
        this.print(36, new Decorword(keyword));
    }
}

