/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.zpatt;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.sourceforge.czt.java_cup.runtime.Scanner;
import net.sourceforge.czt.java_cup.runtime.Symbol;
import net.sourceforge.czt.parser.util.Decorword;
import net.sourceforge.czt.parser.util.JokerTable;
import net.sourceforge.czt.parser.zpatt.Sym;
import net.sourceforge.czt.util.CztException;
import net.sourceforge.czt.z.util.Factory;
import net.sourceforge.czt.zpatt.ast.JokerType;

public class JokerScanner
implements Scanner {
    private Scanner scanner_;
    private JokerTable table_;
    private Factory factory_;
    private boolean lookup_ = false;

    JokerScanner(Scanner scanner) {
        this.scanner_ = scanner;
        this.factory_ = new Factory();
    }

    public JokerTable getJokerTable() {
        return this.table_;
    }

    public void setJokerTable(JokerTable table) {
        this.table_ = table;
    }

    public Symbol next_token() throws Exception {
        Symbol result = this.scanner_.next_token();
        if (result.sym == 69) {
            this.lookup_ = true;
        } else if (this.lookup_ && result.sym == 62) {
            this.lookup_ = false;
        } else {
            result = this.localLookup(result);
        }
        return result;
    }

    protected Symbol localLookup(Symbol symbol) throws Exception {
        if (!this.lookup_) {
            return symbol;
        }
        Symbol result = null;
        if (symbol.sym == 104 || symbol.sym == 105) {
            String name = ((Decorword)symbol.value).getName();
            assert (this.table_ != null);
            JokerType jokertype = this.table_.getTokenType(name);
            int type = -1;
            if (jokertype != null) {
                Field[] fields = Sym.class.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    try {
                        if (!Modifier.isStatic(field.getModifiers()) || !jokertype.toString().equals(field.getName())) continue;
                        type = (Integer)field.get(null);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new CztException((Throwable)e);
                    }
                }
                assert (type != -1);
            }
            result = type == -1 ? symbol : new Symbol(type, symbol.left, symbol.right, (Object)name);
        } else {
            result = symbol;
        }
        return result;
    }
}

