/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.base.visitor.VisitorUtils;
import net.sourceforge.czt.parser.util.OpTable;
import net.sourceforge.czt.parser.util.WrappedExpr;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.Assoc;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ParenAnn;
import net.sourceforge.czt.z.ast.ProdExpr;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.ZFactory;
import net.sourceforge.czt.z.impl.ZFactoryImpl;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.z.visitor.ApplExprVisitor;
import net.sourceforge.czt.z.visitor.ProdExprVisitor;
import net.sourceforge.czt.z.visitor.RefExprVisitor;

public class PrecedenceHandlingVisitor
implements TermVisitor,
RefExprVisitor,
ApplExprVisitor,
ProdExprVisitor {
    protected static Integer PRODEXPR_PRECEDENCE = new Integer(8);
    protected OpTable table_;
    protected ZFactory zFactory_ = new ZFactoryImpl();
    protected List parent_ = new ArrayList();

    public PrecedenceHandlingVisitor(OpTable opTable) {
        this.table_ = opTable;
    }

    public Object visitTerm(Term term) {
        return VisitorUtils.visitTerm((Visitor)this, (Term)term, (boolean)true);
    }

    public Object visitRefExpr(RefExpr refExpr) {
        Object o = this.visitTerm((Term)refExpr);
        if (WrappedExpr.isValidWrappedExpr(o)) {
            return this.reorder(new WrappedExpr(o));
        }
        return o;
    }

    public Object visitApplExpr(ApplExpr applExpr) {
        Object o = this.visitTerm((Term)applExpr);
        if (WrappedExpr.isValidWrappedExpr(o)) {
            return this.reorder(new WrappedExpr(o));
        }
        return o;
    }

    public Object visitProdExpr(ProdExpr prodExpr) {
        Object o = this.visitTerm((Term)prodExpr);
        if (WrappedExpr.isValidWrappedExpr(o)) {
            return this.reorder(new WrappedExpr(o));
        }
        return o;
    }

    protected Expr reorder(WrappedExpr wExpr) {
        if (this.needsReordering(wExpr)) {
            WrappedExpr wChild = new WrappedExpr(wExpr.getList().get(0));
            RefName childName = wChild.getRefName();
            Object newParent = null;
            if (wChild.getExpr() instanceof ApplExpr) {
                RefExpr refExpr = this.zFactory_.createRefExpr(childName, new ArrayList(), Boolean.FALSE);
                TupleExpr tupleExpr = this.zFactory_.createTupleExpr();
                newParent = this.zFactory_.createApplExpr((Expr)refExpr, (Expr)tupleExpr, Boolean.TRUE);
            } else {
                newParent = wChild.getExpr() instanceof ProdExpr ? this.zFactory_.createProdExpr() : this.zFactory_.createRefExpr(childName, new ArrayList(), Boolean.TRUE);
            }
            if (this.hasParenAnn((TermA)wExpr.getExpr())) {
                newParent.getAnns().add((Object)this.zFactory_.createParenAnn());
            }
            RefName parentName = wExpr.getRefName();
            Object newChild = null;
            if (wExpr.getExpr() instanceof ApplExpr) {
                RefExpr refExpr = this.zFactory_.createRefExpr(parentName, new ArrayList(), Boolean.FALSE);
                TupleExpr tupleExpr = this.zFactory_.createTupleExpr();
                newChild = this.zFactory_.createApplExpr((Expr)refExpr, (Expr)tupleExpr, Boolean.TRUE);
            } else {
                newChild = wExpr.getExpr() instanceof ProdExpr ? this.zFactory_.createProdExpr() : this.zFactory_.createRefExpr(parentName, new ArrayList(), Boolean.TRUE);
            }
            WrappedExpr wNewParent = new WrappedExpr(newParent);
            WrappedExpr wNewChild = new WrappedExpr(newChild);
            List wChildList = wChild.getList();
            List wNewChildList = wNewChild.getList();
            wNewChildList.add(wChildList.get(wChildList.size() - 1));
            ArrayList fromParentList = new ArrayList(wExpr.getList().subList(1, wExpr.getList().size()));
            wNewChildList.addAll(fromParentList);
            List wNewParentList = wNewParent.getList();
            wNewParentList.addAll(wChildList.subList(0, wChildList.size() - 1));
            wNewParentList.add(wNewChild.getExpr());
            return (Expr)wNewParent.getExpr().accept((Visitor)this);
        }
        return wExpr.getExpr();
    }

    protected boolean needsReordering(WrappedExpr wrappedExpr) {
        Object firstElem;
        List wrappedExprList = wrappedExpr.getList();
        Object v0 = firstElem = wrappedExprList.size() > 0 ? wrappedExprList.get(0) : null;
        if (wrappedExprList.size() < 2 || !(firstElem instanceof ApplExpr) && !(firstElem instanceof RefExpr) && !(firstElem instanceof ProdExpr)) {
            return false;
        }
        WrappedExpr nestedExpr = null;
        if (!WrappedExpr.isValidWrappedExpr(firstElem)) {
            return false;
        }
        nestedExpr = new WrappedExpr(firstElem);
        if (this.hasParenAnn((TermA)nestedExpr.getExpr())) {
            return false;
        }
        if (nestedExpr.getMixfix().equals(Boolean.FALSE)) {
            return false;
        }
        Integer prec = this.getPrec(wrappedExpr);
        Integer nestedPrec = this.getPrec(nestedExpr);
        if (prec == null || nestedPrec == null || prec.compareTo(nestedPrec) < 0) {
            return false;
        }
        Assoc assoc = this.getAssoc(wrappedExpr);
        Assoc nestedAssoc = this.getAssoc(nestedExpr);
        return prec.compareTo(nestedPrec) != 0 || assoc != Assoc.Left;
    }

    private RefExpr getRefExpr(Expr expr) {
        RefExpr result = null;
        if (expr instanceof ApplExpr) {
            ApplExpr applExpr = (ApplExpr)expr;
            if (applExpr.getLeftExpr() instanceof RefExpr) {
                result = (RefExpr)applExpr.getLeftExpr();
            }
        } else if (expr instanceof RefExpr) {
            // empty if block
        }
        return result;
    }

    private boolean hasParenAnn(TermA termA) {
        ListTerm anns = termA.getAnns();
        Iterator iter = anns.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof ParenAnn)) continue;
            return true;
        }
        return false;
    }

    private Integer getPrec(WrappedExpr wrappedExpr) {
        Integer result = null;
        if (wrappedExpr.getExpr() instanceof ProdExpr) {
            result = PRODEXPR_PRECEDENCE;
        } else {
            RefName refName = wrappedExpr.getRefName();
            String first = this.getFirstInfixName(refName);
            if (first != null) {
                result = this.table_.getPrec(first);
            }
        }
        return result;
    }

    private Assoc getAssoc(WrappedExpr wrappedExpr) {
        Assoc assoc = null;
        if (wrappedExpr.getExpr() instanceof ProdExpr) {
            assoc = Assoc.Right;
        } else {
            String first = this.getFirstInfixName(wrappedExpr.getRefName());
            if (first != null) {
                assoc = this.table_.getAssoc(first);
            }
        }
        return assoc;
    }

    private String getFirstInfixName(RefName refName) {
        String result = null;
        String name = refName.getWord();
        StringTokenizer st = new StringTokenizer(name);
        if (st.hasMoreTokens()) {
            String first = st.nextToken();
            if (!first.equals(ZString.ARG)) {
                result = null;
            } else if (st.hasMoreTokens()) {
                String second = st.nextToken();
                result = second.equals(ZString.ARG) ? null : second;
            }
        } else {
            result = null;
        }
        return result;
    }
}

