/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.util;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.ListTermVisitor;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.parser.util.AbstractVisitor;
import net.sourceforge.czt.parser.util.DefinitionTable;
import net.sourceforge.czt.session.CommandException;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.util.CztException;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.Parent;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.ZSect;
import net.sourceforge.czt.z.visitor.AxParaVisitor;
import net.sourceforge.czt.z.visitor.ParaVisitor;
import net.sourceforge.czt.z.visitor.ZSectVisitor;

public class DefinitionTableVisitor
extends AbstractVisitor
implements TermVisitor,
ListTermVisitor,
AxParaVisitor,
ParaVisitor,
ZSectVisitor {
    private DefinitionTable table_;

    public DefinitionTableVisitor(SectionInfo sectInfo) {
        super(sectInfo);
    }

    public Object run(Term term) throws CommandException {
        super.run(term);
        return this.getDefinitionTable();
    }

    protected DefinitionTable getDefinitionTable() {
        return this.table_;
    }

    public Object visitTerm(Term term) {
        String message = "DefinitionTables can only be build for ZSects; was tried for " + term.getClass();
        throw new UnsupportedOperationException(message);
    }

    public Object visitListTerm(ListTerm listTerm) {
        for (Object o : listTerm) {
            if (!(o instanceof Term)) continue;
            Term t = (Term)o;
            this.visit(t);
        }
        return null;
    }

    public Object visitAxPara(AxPara axPara) {
        ListTerm declNames = axPara.getDeclName();
        SchText schText = axPara.getSchText();
        ListTerm decls = schText.getDecl();
        for (Decl decl : decls) {
            if (!(decl instanceof ConstDecl)) continue;
            ConstDecl constDecl = (ConstDecl)decl;
            DeclName declName = constDecl.getDeclName();
            String name = declName.toString();
            DefinitionTable.Definition def = new DefinitionTable.Definition((List)declNames, constDecl.getExpr());
            try {
                this.table_.add(name, def);
            }
            catch (Exception e) {
                throw new CztException((Throwable)e);
            }
        }
        return null;
    }

    public Object visitPara(Para para) {
        return null;
    }

    public Object visitZSect(ZSect zSect) {
        String name = zSect.getName();
        ArrayList<DefinitionTable> parentTables = new ArrayList<DefinitionTable>();
        for (Parent parent : zSect.getParent()) {
            DefinitionTable parentTable = (DefinitionTable)this.get(parent.getWord(), DefinitionTable.class);
            parentTables.add(parentTable);
        }
        try {
            this.table_ = new DefinitionTable(name, parentTables);
        }
        catch (DefinitionTable.DefinitionException exception) {
            throw new CztException((Throwable)exception);
        }
        this.visit((Term)zSect.getPara());
        return null;
    }

    protected void visit(Term term) {
        term.accept((Visitor)this);
    }
}

