/*
 * Decompiled with CFR 0.152.
 */
package jcircusutil.multisync;

import jcsp.lang.CSProcess;
import jcsp.lang.ChannelInput;
import jcsp.lang.ChannelOutput;
import test.CommException;
import test.Print;

public class MultiSyncControlSimple
implements CSProcess {
    private String cname;
    private int id;
    private int numberOfClients;
    private ChannelOutput[] fromSync;
    private ChannelInput toSync;

    public MultiSyncControlSimple(String cname, ChannelOutput[] fromSync, ChannelInput toSync) {
        this.cname = cname;
        this.id = 0;
        this.numberOfClients = fromSync.length;
        this.fromSync = fromSync;
        this.toSync = toSync;
    }

    public void run() {
        try {
            this.offer(this.numberOfClients);
        }
        catch (Throwable t) {
            throw new CommException("Exception in controller for channel " + this.cname, t);
        }
    }

    private void offer(int countdown) {
        if (countdown > 0 && countdown <= this.numberOfClients) {
            Print.print("cdown =  " + countdown, this.getClass(), this.cname);
            Integer x = (Integer)this.toSync.read();
            Print.print("C read " + x + " from to_" + this.cname, this.getClass(), this.cname);
            int nextOffer = x;
            if (nextOffer >= 0) {
                this.offer(countdown - 1);
            } else if (nextOffer < 0) {
                this.offer(countdown + 1);
            }
        } else if (countdown == 0) {
            this.invite(0);
        }
    }

    private void invite(int client) {
        if (client < this.numberOfClients) {
            this.fromSync[client].write((Object)new Boolean(true));
            this.invite(client + 1);
        } else if (client == this.numberOfClients) {
            this.invitePrime(0, this.numberOfClients);
        }
    }

    private void invitePrime(int client, int countdown) {
        if (client >= 0 && client < this.numberOfClients) {
            int nextCommit = (Integer)this.toSync.read();
            if (nextCommit >= 0) {
                this.invitePrime(client + 1, countdown - 1);
            } else if (nextCommit < 0) {
                this.invitePrime(client + 1, countdown);
            }
        } else if (client == this.numberOfClients) {
            this.sync(0, countdown);
        }
    }

    private void sync(int client, int countdown) {
        if (client < this.numberOfClients) {
            this.fromSync[client].write((Object)new Boolean(countdown == 0));
            this.sync(client + 1, countdown);
        } else if (client == this.numberOfClients) {
            this.offer(this.numberOfClients);
        }
    }
}

