/*
 * Decompiled with CFR 0.152.
 */
package jcircusutil.multisync;

import java.util.List;
import java.util.Vector;
import jcircusutil.multisync.AuxiliarMethods;
import jcsp.lang.Alternative;
import jcsp.lang.AltingChannelInput;
import jcsp.lang.CSProcess;
import jcsp.lang.ChannelOutput;
import jcsp.lang.Guard;
import jcsp.lang.Parallel;

public class MultiSyncClient
implements CSProcess {
    private final int FROM_INDEX = 0;
    private final int TO_INDEX = 1;
    private final int SYNC_ID_INDEX = 2;
    private final int WRITER_ID_INDEX = 3;
    private List seqOfSync;
    private List seqOfNotSync;
    private int choosen;
    private Object valueTrans;
    private boolean[] guards;

    public MultiSyncClient(List seqOfSync, List seqOfNotSync, Object valueTrans) {
        this.seqOfSync = seqOfSync;
        this.seqOfNotSync = seqOfNotSync;
        this.valueTrans = valueTrans;
    }

    public MultiSyncClient(List seqOfSync, List seqOfNotSync, Object valueTrans, boolean[] guards) {
        this.seqOfSync = seqOfSync;
        this.seqOfNotSync = seqOfNotSync;
        this.valueTrans = valueTrans;
        this.guards = guards;
    }

    public int getChoosen() {
        return this.choosen;
    }

    public Object getValueTrans() {
        return this.valueTrans;
    }

    public void run() {
        List result = this.offer();
        this.choosen = (Integer)result.get(0);
        this.valueTrans = result.get(1);
    }

    private List offer() {
        int numberOfSyncs = this.seqOfSync.size();
        CSProcess[] syncs = new CSProcess[numberOfSyncs];
        for (int i = 0; i < numberOfSyncs; ++i) {
            CSProcess sync;
            final ChannelOutput toSync = (ChannelOutput)((Object[])this.seqOfSync.get(i))[1];
            final Integer syncIdFinal = (Integer)((Object[])this.seqOfSync.get(i))[2];
            syncs[i] = sync = new CSProcess(){

                public void run() {
                    toSync.write((Object)syncIdFinal);
                }
            };
        }
        Parallel parallel = new Parallel(syncs);
        parallel.run();
        return this.sync();
    }

    private List sync() {
        Object object = this.valueTrans;
        Object[] fromChannels = this.toAltingChannelsInput(this.getSyncs(0, this.seqOfSync));
        Object[] toChannels = this.toChannelsOutput(this.getSyncs(1, this.seqOfSync));
        Object[] syncIds = this.toInteger(this.getSyncs(2, this.seqOfSync));
        Integer[] writerIds = this.toInteger(this.getSyncs(3, this.seqOfSync));
        Object[] notSyncChannels = this.toAltingChannelsInput(this.seqOfNotSync.toArray());
        AltingChannelInput[] allInputChannels = this.toAltingChannelsInput(this.concat(fromChannels, notSyncChannels));
        Alternative alt = new Alternative((Guard[])allInputChannels);
        int choosen = this.guards == null ? alt.select() : alt.select(this.guards);
        if (choosen < fromChannels.length) {
            Object from = fromChannels[choosen];
            ChannelOutput to = toChannels[choosen];
            Integer syncId = syncIds[choosen];
            Integer writerId = writerIds[choosen];
            from.read();
            to.write((Object)syncId);
            Boolean synchronised = (Boolean)from.read();
            if (synchronised.booleanValue()) {
                if (syncId.intValue() == writerId.intValue()) {
                    to.write(this.valueTrans);
                } else if (syncId.intValue() != writerId.intValue()) {
                    object = from.read();
                }
                AltingChannelInput[] fromChannels_withdraw = this.toAltingChannelsInput(this.remove(choosen, fromChannels));
                ChannelOutput[] toChannels_withdraw = this.toChannelsOutput(this.remove(choosen, toChannels));
                Integer[] syncIds_withdraw = this.toInteger(this.remove(choosen, syncIds));
                CSProcess[] no_sync = new CSProcess[fromChannels_withdraw.length];
                for (int i = 0; i < fromChannels_withdraw.length; ++i) {
                    CSProcess process;
                    final AltingChannelInput fromInt = fromChannels_withdraw[i];
                    final ChannelOutput toInt = toChannels_withdraw[i];
                    final Integer syncIdInt = syncIds_withdraw[i];
                    int internalI = i;
                    no_sync[i] = process = new CSProcess(){

                        public void run() {
                            CSProcess first = new CSProcess(){

                                public void run() {
                                    toInt.write((Object)AuxiliarMethods.flip(syncIdInt));
                                }
                            };
                            CSProcess second = new CSProcess(){

                                public void run() {
                                    Boolean invite = (Boolean)fromInt.read();
                                    if (invite.booleanValue()) {
                                        fromInt.read();
                                    } else if (!invite.booleanValue()) {
                                        // empty if block
                                    }
                                }
                            };
                            CSProcess[] procs = new CSProcess[]{first, second};
                            Parallel intInterleave = new Parallel(procs);
                            intInterleave.run();
                        }
                    };
                }
                Parallel extInterleave = new Parallel(no_sync);
                extInterleave.run();
            } else if (!synchronised.booleanValue()) {
                return this.sync();
            }
        } else {
            AltingChannelInput not_sync = allInputChannels[choosen];
            object = not_sync.read();
            System.out.println("read from a notSync channel");
            Object[] fromChannels_withdraw = fromChannels;
            Object[] toChannels_withdraw = toChannels;
            Object[] syncIds_withdraw = syncIds;
            CSProcess[] no_sync = new CSProcess[fromChannels_withdraw.length];
            for (int i = 0; i < fromChannels_withdraw.length; ++i) {
                CSProcess process;
                Object fromInt = fromChannels_withdraw[i];
                final ChannelOutput toInt = toChannels_withdraw[i];
                final Integer syncIdInt = syncIds_withdraw[i];
                no_sync[i] = process = new CSProcess((AltingChannelInput)fromInt){
                    final /* synthetic */ AltingChannelInput val$fromInt;
                    {
                        this.val$fromInt = altingChannelInput;
                    }

                    public void run() {
                        CSProcess first = new CSProcess(){

                            public void run() {
                                toInt.write((Object)AuxiliarMethods.flip(syncIdInt));
                            }
                        };
                        CSProcess second = new CSProcess(){

                            public void run() {
                                Boolean invite = (Boolean)val$fromInt.read();
                                if (invite.booleanValue()) {
                                    val$fromInt.read();
                                } else if (!invite.booleanValue()) {
                                    // empty if block
                                }
                            }
                        };
                        CSProcess[] procs = new CSProcess[]{first, second};
                        Parallel intInterleave = new Parallel(procs);
                        intInterleave.run();
                    }
                };
            }
            Parallel extInterleave = new Parallel(no_sync);
            extInterleave.run();
        }
        Vector<Object> result = new Vector<Object>();
        result.add(new Integer(choosen));
        result.add(object);
        return result;
    }

    private Object[] getSyncs(int type, List seqOfSync) {
        Object[] result = new Object[seqOfSync.size()];
        for (int i = 0; i < seqOfSync.size(); ++i) {
            Object[] x = (Object[])seqOfSync.get(i);
            result[i] = x[type];
        }
        return result;
    }

    private Object[] concat(Object[] array1, Object[] array2) {
        int i;
        int finalSize = array1.length + array2.length;
        Object[] result = new Object[finalSize];
        for (i = 0; i < array1.length; ++i) {
            result[i] = array1[i];
        }
        for (i = 0; i < array2.length; ++i) {
            result[array1.length + i] = array2[i];
        }
        return result;
    }

    private Object[] remove(int index, Object[] array) {
        int finalSize = array.length - 1;
        Object[] result = new Object[finalSize];
        int currentIndex = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) continue;
            result[currentIndex] = array[i];
            ++currentIndex;
        }
        return result;
    }

    private AltingChannelInput[] toAltingChannelsInput(Object[] array) {
        AltingChannelInput[] result = new AltingChannelInput[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (AltingChannelInput)array[i];
        }
        return result;
    }

    private ChannelOutput[] toChannelsOutput(Object[] array) {
        ChannelOutput[] result = new ChannelOutput[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (ChannelOutput)array[i];
        }
        return result;
    }

    private Integer[] toInteger(Object[] array) {
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (Integer)array[i];
        }
        return result;
    }
}

