/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.z.util;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.typecheck.z.impl.UnknownType;
import net.sourceforge.czt.typecheck.z.impl.UnknownTypeVisitor;
import net.sourceforge.czt.typecheck.z.impl.VariableSignature;
import net.sourceforge.czt.typecheck.z.impl.VariableSignatureVisitor;
import net.sourceforge.czt.typecheck.z.impl.VariableType;
import net.sourceforge.czt.typecheck.z.impl.VariableTypeVisitor;
import net.sourceforge.czt.typecheck.z.util.UndeterminedTypeException;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.GenParamType;
import net.sourceforge.czt.z.ast.GivenType;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.PowerExpr;
import net.sourceforge.czt.z.ast.PowerType;
import net.sourceforge.czt.z.ast.ProdExpr;
import net.sourceforge.czt.z.ast.ProdType;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.SchemaType;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.Type2;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZFactory;
import net.sourceforge.czt.z.impl.ZFactoryImpl;
import net.sourceforge.czt.z.visitor.GenParamTypeVisitor;
import net.sourceforge.czt.z.visitor.GivenTypeVisitor;
import net.sourceforge.czt.z.visitor.PowerTypeVisitor;
import net.sourceforge.czt.z.visitor.ProdTypeVisitor;
import net.sourceforge.czt.z.visitor.SchemaTypeVisitor;
import net.sourceforge.czt.z.visitor.SignatureVisitor;

public class CarrierSet
implements TermVisitor,
PowerTypeVisitor,
GenParamTypeVisitor,
GivenTypeVisitor,
SchemaTypeVisitor,
SignatureVisitor,
ProdTypeVisitor,
VariableTypeVisitor,
VariableSignatureVisitor,
UnknownTypeVisitor {
    protected ZFactory zFactory_;
    protected boolean allowVariableTypes_;

    public CarrierSet() {
        this((ZFactory)new ZFactoryImpl(), false);
    }

    public CarrierSet(boolean allowVariableTypes) {
        this((ZFactory)new ZFactoryImpl(), allowVariableTypes);
    }

    public CarrierSet(ZFactory zFactory) {
        this(zFactory, false);
    }

    public CarrierSet(ZFactory zFactory, boolean allowVariableTypes) {
        this.zFactory_ = zFactory;
        this.allowVariableTypes_ = allowVariableTypes;
    }

    public Object visitTerm(Term term) {
        return term;
    }

    public Object visitPowerType(PowerType powerType) {
        Type2 type = powerType.getType();
        if (type == null) {
            throw new UndeterminedTypeException();
        }
        Expr expr = (Expr)type.accept((Visitor)this);
        PowerExpr result = this.zFactory_.createPowerExpr(expr);
        return result;
    }

    public Object visitGenParamType(GenParamType genParamType) {
        RefName refName = this.zFactory_.createRefName(genParamType.getName().getWord(), (List)genParamType.getName().getStroke(), null);
        RefExpr result = this.zFactory_.createRefExpr(refName, this.list(), Boolean.FALSE);
        return result;
    }

    public Object visitGivenType(GivenType givenType) {
        RefName refName = this.zFactory_.createRefName(givenType.getName().getWord(), (List)givenType.getName().getStroke(), null);
        RefExpr result = this.zFactory_.createRefExpr(refName, this.list(), Boolean.FALSE);
        return result;
    }

    public Object visitSchemaType(SchemaType schemaType) {
        Signature signature = schemaType.getSignature();
        SchText schText = (SchText)signature.accept((Visitor)this);
        SchExpr result = this.zFactory_.createSchExpr(schText);
        return result;
    }

    public Object visitSignature(Signature signature) {
        ListTerm pairs = signature.getNameTypePair();
        List decls = this.list();
        for (NameTypePair pair : pairs) {
            Expr expr = (Expr)pair.getType().accept((Visitor)this);
            List name = this.list(pair.getName());
            VarDecl varDecl = this.zFactory_.createVarDecl(name, expr);
            decls.add(varDecl);
        }
        SchText schText = this.zFactory_.createSchText(decls, null);
        return schText;
    }

    public Object visitProdType(ProdType prodType) {
        List exprs = this.list();
        ListTerm types = prodType.getType();
        for (Type type : types) {
            Expr expr = (Expr)type.accept((Visitor)this);
            exprs.add(expr);
        }
        ProdExpr result = this.zFactory_.createProdExpr(exprs);
        return result;
    }

    public Object visitUnknownType(UnknownType unknownType) {
        if (!this.allowVariableTypes_) {
            throw new UndeterminedTypeException();
        }
        RefName refName = this.zFactory_.createRefName("unknown", this.list(), null);
        RefExpr result = this.zFactory_.createRefExpr(refName, this.list(), Boolean.FALSE);
        return result;
    }

    public Object visitVariableType(VariableType vType) {
        if (vType.getValue() instanceof VariableType) {
            if (!this.allowVariableTypes_) {
                throw new UndeterminedTypeException();
            }
            RefName refName = this.zFactory_.createRefName("var", new ArrayList(), null);
            RefExpr result = this.zFactory_.createRefExpr(refName, this.list(), Boolean.FALSE);
            return result;
        }
        return vType.getValue().accept((Visitor)this);
    }

    public Object visitVariableSignature(VariableSignature vSig) {
        if (vSig.getValue() instanceof VariableSignature) {
            throw new UndeterminedTypeException();
        }
        return vSig.getValue().accept((Visitor)this);
    }

    protected List list() {
        return new ArrayList();
    }

    protected List list(Object o) {
        List list = this.list();
        list.add(o);
        return list;
    }
}

