/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.z;

import java.util.Collection;
import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.typecheck.z.Checker;
import net.sourceforge.czt.typecheck.z.ErrorAnn;
import net.sourceforge.czt.typecheck.z.ErrorMessage;
import net.sourceforge.czt.typecheck.z.TypeChecker;
import net.sourceforge.czt.typecheck.z.impl.VariableType;
import net.sourceforge.czt.typecheck.z.util.GlobalDefs;
import net.sourceforge.czt.typecheck.z.util.ParameterAnn;
import net.sourceforge.czt.typecheck.z.util.UndeclaredAnn;
import net.sourceforge.czt.typecheck.z.util.UndeterminedTypeException;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ExprPred;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.PowerType;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.SchemaType;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.ThetaExpr;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.Type2;
import net.sourceforge.czt.z.ast.TypeAnn;
import net.sourceforge.czt.z.visitor.RefExprVisitor;
import net.sourceforge.czt.z.visitor.SetExprVisitor;
import net.sourceforge.czt.z.visitor.ThetaExprVisitor;

public class PostChecker
extends Checker
implements ThetaExprVisitor,
RefExprVisitor,
SetExprVisitor {
    public PostChecker(TypeChecker typeChecker) {
        super(typeChecker);
    }

    public Object visitThetaExpr(ThetaExpr thetaExpr) {
        TypeAnn typeAnn = (TypeAnn)thetaExpr.getAnn(TypeAnn.class);
        Type type = typeAnn.getType();
        if (type instanceof SchemaType) {
            Signature signature = GlobalDefs.schemaType(type).getSignature();
            ListTerm pairs = signature.getNameTypePair();
            for (NameTypePair pair : pairs) {
                Object undecAnn = pair.getName().getAnn(UndeclaredAnn.class);
                if (undecAnn == null) continue;
                DeclName decorName = this.factory().createDeclName(pair.getName());
                decorName.getStroke().addAll((Collection)thetaExpr.getStroke());
                Object[] params = new Object[]{decorName, thetaExpr};
                ErrorAnn errorAnn = this.errorAnn((TermA)thetaExpr, ErrorMessage.UNDECLARED_IDENTIFIER_IN_EXPR, params);
                boolean added = this.addErrorAnn((TermA)thetaExpr, errorAnn);
                return added ? errorAnn : null;
            }
        }
        return null;
    }

    public Object visitRefExpr(RefExpr refExpr) {
        RefName refName = refExpr.getRefName();
        UndeclaredAnn uAnn = (UndeclaredAnn)refName.getAnn(UndeclaredAnn.class);
        ParameterAnn pAnn = (ParameterAnn)refExpr.getAnn(ParameterAnn.class);
        if (uAnn != null) {
            Object[] params = new Object[]{refName.getWord()};
            ErrorAnn errorAnn = this.errorAnn((TermA)refName, ErrorMessage.UNDECLARED_IDENTIFIER, params);
            GlobalDefs.removeAnn((TermA)refName, uAnn);
            ExprPred exprPred = (ExprPred)refName.getAnn(ExprPred.class);
            boolean added = false;
            if (exprPred == null) {
                added = this.addErrorAnn((TermA)refName, errorAnn);
            } else {
                added = this.addErrorAnn((TermA)exprPred, errorAnn);
                GlobalDefs.removeAnn((TermA)refName, exprPred);
                ParameterAnn ann = (ParameterAnn)exprPred.getAnn(ParameterAnn.class);
                GlobalDefs.removeAnn((TermA)exprPred, ann);
            }
            return added ? errorAnn : null;
        }
        if (pAnn != null) {
            List gParams = pAnn.getParameters();
            List<Expr> exprs = GlobalDefs.list();
            for (Type2 type : gParams) {
                try {
                    Expr expr = (Expr)type.accept((Visitor)this.carrierSet());
                    assert (expr != null);
                    exprs.add(expr);
                }
                catch (UndeterminedTypeException e) {
                    Object[] params = new Object[]{refExpr};
                    ErrorAnn errorAnn = this.errorAnn((TermA)refExpr, ErrorMessage.PARAMETERS_NOT_DETERMINED, params);
                    boolean added = this.addErrorAnn((TermA)refExpr, errorAnn);
                    GlobalDefs.removeAnn((TermA)refExpr, pAnn);
                    return added ? errorAnn : null;
                }
            }
            refExpr.getExpr().addAll(exprs);
            GlobalDefs.removeAnn((TermA)refExpr, pAnn);
        }
        return null;
    }

    public Object visitSetExpr(SetExpr setExpr) {
        PowerType powerType;
        Type2 innerType;
        Type2 type = this.getType2FromAnns((TermA)setExpr);
        if (type instanceof PowerType && GlobalDefs.resolve(innerType = (powerType = (PowerType)type).getType()) instanceof VariableType) {
            Object[] params = new Object[]{setExpr};
            ErrorAnn errorAnn = this.errorAnn((TermA)setExpr, ErrorMessage.PARAMETERS_NOT_DETERMINED, params);
            boolean added = this.addErrorAnn((TermA)setExpr, errorAnn);
            return added ? errorAnn : null;
        }
        return null;
    }
}

