/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.z;

import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.typecheck.z.Checker;
import net.sourceforge.czt.typecheck.z.ErrorMessage;
import net.sourceforge.czt.typecheck.z.TypeChecker;
import net.sourceforge.czt.typecheck.z.util.GlobalDefs;
import net.sourceforge.czt.typecheck.z.util.UResult;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.Branch;
import net.sourceforge.czt.z.ast.ConjPara;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.FreePara;
import net.sourceforge.czt.z.ast.Freetype;
import net.sourceforge.czt.z.ast.GivenPara;
import net.sourceforge.czt.z.ast.GivenType;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.PowerType;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.ProdType;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.Type2;
import net.sourceforge.czt.z.visitor.AxParaVisitor;
import net.sourceforge.czt.z.visitor.ConjParaVisitor;
import net.sourceforge.czt.z.visitor.FreeParaVisitor;
import net.sourceforge.czt.z.visitor.FreetypeVisitor;
import net.sourceforge.czt.z.visitor.GivenParaVisitor;
import net.sourceforge.czt.z.visitor.ParaVisitor;
import net.sourceforge.czt.z.visitor.SchTextVisitor;

public class ParaChecker
extends Checker
implements GivenParaVisitor,
AxParaVisitor,
FreeParaVisitor,
FreetypeVisitor,
ConjParaVisitor,
SchTextVisitor,
ParaVisitor {
    public ParaChecker(TypeChecker typeChecker) {
        super(typeChecker);
    }

    public Object visitPara(Para para) {
        Signature signature = this.factory().createSignature();
        return signature;
    }

    public Object visitGivenPara(GivenPara givenPara) {
        List<NameTypePair> pairs = GlobalDefs.list();
        ListTerm declNames = givenPara.getDeclName();
        for (DeclName declName : declNames) {
            GivenType givenType = this.factory().createGivenType(declName);
            PowerType powerType = this.factory().createPowerType((Type2)givenType);
            NameTypePair pair = this.factory().createNameTypePair(declName, (Type)powerType);
            pairs.add(pair);
        }
        Signature signature = this.factory().createSignature(pairs);
        this.addSignatureAnn((TermA)givenPara, signature);
        return signature;
    }

    public Object visitAxPara(AxPara axPara) {
        this.typeEnv().enterScope();
        this.addGenParamTypes((List<DeclName>)axPara.getDeclName());
        SchText schText = axPara.getSchText();
        Signature signature = (Signature)schText.accept((Visitor)this.paraChecker());
        this.addSignatureAnn((TermA)axPara, signature);
        this.typeEnv().exitScope();
        return signature;
    }

    public Object visitFreePara(FreePara freePara) {
        List pairs = GlobalDefs.list();
        this.pending().enterScope();
        ListTerm freetypes = freePara.getFreetype();
        for (Freetype freetype : freetypes) {
            freetype.accept((Visitor)this.paraChecker());
        }
        this.pending().enterScope();
        for (Freetype freetype : freetypes) {
            pairs.addAll((List)freetype.accept((Visitor)this.paraChecker()));
        }
        this.pending().exitScope();
        this.pending().exitScope();
        Signature signature = this.factory().createSignature(pairs);
        this.addSignatureAnn((TermA)freePara, signature);
        return signature;
    }

    public Object visitFreetype(Freetype freetype) {
        List<NameTypePair> pairs = GlobalDefs.list();
        DeclName declName = freetype.getDeclName();
        GivenType givenType = this.factory().createGivenType(declName);
        PowerType powerType = this.factory().createPowerType((Type2)givenType);
        NameTypePair pair = this.factory().createNameTypePair(declName, (Type)powerType);
        pairs.add(pair);
        this.pending().add(pair);
        ListTerm branches = freetype.getBranch();
        for (Branch branch : branches) {
            pair = this.localVisitBranch(branch, givenType);
            if (pair == null) continue;
            pairs.add(pair);
            this.pending().add(pair);
        }
        return pairs;
    }

    protected NameTypePair localVisitBranch(Branch branch, GivenType givenType) {
        NameTypePair pair = null;
        DeclName declName = branch.getDeclName();
        Expr expr = branch.getExpr();
        if (expr != null) {
            Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
            PowerType vPowerType = this.factory().createPowerType();
            UResult unified = this.unify((Type2)vPowerType, exprType);
            if (unified == GlobalDefs.FAIL) {
                Object[] params = new Object[]{expr, exprType};
                this.error((TermA)expr, ErrorMessage.NON_SET_IN_FREETYPE, params);
            } else {
                ProdType prodType = this.factory().createProdType(GlobalDefs.list(vPowerType.getType(), givenType));
                PowerType powerType = this.factory().createPowerType((Type2)prodType);
                pair = this.factory().createNameTypePair(declName, (Type)powerType);
            }
        } else {
            pair = this.factory().createNameTypePair(declName, (Type)givenType);
        }
        return pair;
    }

    public Object visitConjPara(ConjPara conjPara) {
        this.typeEnv().enterScope();
        this.addGenParamTypes((List<DeclName>)conjPara.getDeclName());
        Pred pred = conjPara.getPred();
        UResult solved = (UResult)((Object)pred.accept((Visitor)this.predChecker()));
        if (solved == GlobalDefs.PARTIAL) {
            pred.accept((Visitor)this.predChecker());
        }
        Signature signature = this.factory().createSignature();
        this.addSignatureAnn((TermA)conjPara, signature);
        this.typeEnv().exitScope();
        return signature;
    }

    public Object visitSchText(SchText schText) {
        UResult solved;
        List<NameTypePair> pairs = GlobalDefs.list();
        ListTerm decls = schText.getDecl();
        for (Decl decl : decls) {
            List dPairs = (List)decl.accept((Visitor)this.declChecker());
            for (NameTypePair dPair : dPairs) {
                DeclName gName = dPair.getName();
                Type gType = this.addGenerics((Type2)dPair.getType());
                NameTypePair gPair = this.factory().createNameTypePair(gName, gType);
                pairs.add(gPair);
            }
        }
        this.pending().enterScope();
        this.pending().add(pairs);
        Pred pred = schText.getPred();
        if (pred != null && (solved = (UResult)((Object)pred.accept((Visitor)this.predChecker()))) == GlobalDefs.PARTIAL) {
            pred.accept((Visitor)this.predChecker());
        }
        this.checkForDuplicates(pairs, null);
        this.pending().exitScope();
        Signature signature = this.factory().createSignature(pairs);
        this.addSignatureAnn((TermA)schText, signature);
        return signature;
    }
}

