/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.oz.util;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.oz.ast.ClassPolyType;
import net.sourceforge.czt.oz.ast.ClassRef;
import net.sourceforge.czt.oz.ast.ClassRefType;
import net.sourceforge.czt.oz.ast.ClassSig;
import net.sourceforge.czt.oz.ast.ClassUnionExpr;
import net.sourceforge.czt.oz.ast.ClassUnionType;
import net.sourceforge.czt.oz.ast.OzFactory;
import net.sourceforge.czt.oz.ast.PolyExpr;
import net.sourceforge.czt.oz.impl.OzFactoryImpl;
import net.sourceforge.czt.oz.visitor.ClassPolyTypeVisitor;
import net.sourceforge.czt.oz.visitor.ClassRefTypeVisitor;
import net.sourceforge.czt.oz.visitor.ClassRefVisitor;
import net.sourceforge.czt.oz.visitor.ClassUnionTypeVisitor;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ParenAnn;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.Type2;
import net.sourceforge.czt.z.ast.ZFactory;

public class CarrierSet
extends net.sourceforge.czt.typecheck.z.util.CarrierSet
implements ClassRefTypeVisitor,
ClassUnionTypeVisitor,
ClassPolyTypeVisitor,
ClassRefVisitor {
    protected OzFactory ozFactory_;

    public CarrierSet() {
        this.ozFactory_ = new OzFactoryImpl();
    }

    public CarrierSet(boolean allowVariableTypes) {
        this();
        this.allowVariableTypes_ = allowVariableTypes;
    }

    public CarrierSet(ZFactory zFactory, OzFactory ozFactory) {
        super(zFactory);
        this.ozFactory_ = ozFactory;
    }

    public Object visitClassRefType(ClassRefType classRefType) {
        ClassRef classRef = classRefType.getThisClass();
        Expr result = (Expr)classRef.accept((Visitor)this);
        return result;
    }

    public Object visitClassPolyType(ClassPolyType classPolyType) {
        ClassRef classRef = classPolyType.getRootClass();
        Expr expr = (Expr)classRef.accept((Visitor)this);
        PolyExpr result = this.ozFactory_.createPolyExpr(expr);
        return result;
    }

    public Object visitClassUnionType(ClassUnionType classUnionType) {
        ClassSig classSig = classUnionType.getClassSig();
        ListTerm classRefs = classSig.getClasses();
        assert (classRefs.size() > 1);
        ClassUnionExpr result = null;
        for (ClassRef classRef : classRefs) {
            ClassUnionExpr next;
            Expr expr = (Expr)classRef.accept((Visitor)this);
            if (result == null) {
                result = this.ozFactory_.createClassUnionExpr();
                result.setLeftExpr(expr);
                continue;
            }
            if (result.getRightExpr() == null) {
                result.setRightExpr(expr);
                continue;
            }
            result = next = this.ozFactory_.createClassUnionExpr((Expr)result, expr);
        }
        ParenAnn pAnn = this.ozFactory_.createParenAnn();
        result.getAnns().add((Object)pAnn);
        return result;
    }

    public Object visitClassRef(ClassRef classRef) {
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        ListTerm types = classRef.getType2();
        for (Type2 type : types) {
            Expr expr = (Expr)type.accept((Visitor)this);
            exprs.add(expr);
        }
        RefExpr result = this.zFactory_.createRefExpr(classRef.getRefName(), exprs, Boolean.FALSE);
        if (classRef.getNameNamePair().size() > 0) {
            result = this.zFactory_.createRenameExpr((Expr)result, (List)classRef.getNameNamePair());
        }
        return result;
    }
}

