/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.circus;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.DotField;
import net.sourceforge.czt.circus.ast.Field;
import net.sourceforge.czt.circus.ast.InputField;
import net.sourceforge.czt.circus.ast.OutputField;
import net.sourceforge.czt.circus.visitor.CommunicationVisitor;
import net.sourceforge.czt.circus.visitor.DotFieldVisitor;
import net.sourceforge.czt.circus.visitor.InputFieldVisitor;
import net.sourceforge.czt.circus.visitor.OutputFieldVisitor;
import net.sourceforge.czt.typecheck.circus.Checker;
import net.sourceforge.czt.typecheck.circus.ErrorMessage;
import net.sourceforge.czt.typecheck.circus.TypeChecker;
import net.sourceforge.czt.typecheck.circus.util.GlobalDefs;
import net.sourceforge.czt.typecheck.z.DeclChecker;
import net.sourceforge.czt.typecheck.z.impl.UnknownType;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.GenParamType;
import net.sourceforge.czt.z.ast.GivenType;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.PowerType;
import net.sourceforge.czt.z.ast.ProdType;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.Type2;

public class CommunicationChecker
extends Checker
implements CommunicationVisitor,
DotFieldVisitor,
InputFieldVisitor,
OutputFieldVisitor {
    protected DeclChecker zDeclChecker_;
    private int position_;
    private Type chanType_;
    private DeclName chanName_;

    public CommunicationChecker(TypeChecker typeChecker) {
        super(typeChecker);
        this.zDeclChecker_ = new DeclChecker(typeChecker);
    }

    public Object visitCommunication(Communication term) {
        List<NameTypePair> result = new ArrayList<NameTypePair>();
        this.chanName_ = this.factory().createDeclName(term.getChanName().getWord(), null, null);
        if (this.isChannel(this.chanName_)) {
            DeclName name = this.factory().createDeclName("Synch", null, null);
            GivenType typeSynch = this.factory().createGivenType(name);
            this.chanType_ = this.getChannelType(this.chanName_);
            this.position_ = 0;
            ListTerm cParams = term.getChanFields();
            Object[] params = new Object[]{this.currentProcess().getWord(), this.chanName_.getWord()};
            if (this.chanType_.equals(typeSynch)) {
                if (!cParams.isEmpty()) {
                    this.error((TermA)term, ErrorMessage.SYNCH_CHANNEL_WITH_CPARAMS_ERROR, params);
                }
            } else if (!cParams.isEmpty()) {
                if (this.chanType_ instanceof ProdType) {
                    if (((ProdType)this.chanType_).getType().size() != cParams.size()) {
                        this.error((TermA)term, ErrorMessage.NUMBER_CPARAMS_INCOMPATIBLE_CHANNEL_TYPE, params);
                    }
                } else if (cParams.size() > 1) {
                    this.error((TermA)term, ErrorMessage.NUMBER_CPARAMS_INCOMPATIBLE_CHANNEL_TYPE, params);
                }
                if (!term.getGenActuals().isEmpty()) {
                    if (!this.isGenericChannel(this.chanName_)) {
                        this.error((TermA)term, ErrorMessage.IS_NOT_GENERIC_CHANNEL, params);
                    } else {
                        ListTerm exprs = term.getGenActuals();
                        List<DeclName> genParams = this.getGenParamsChannel(this.chanName_);
                        if (exprs.size() != genParams.size()) {
                            this.error((TermA)term, ErrorMessage.DIFF_NUMBER_IN_GENERIC_CHANNEL_INSTATIATION, params);
                        } else {
                            int i = 0;
                            for (Expr expr : exprs) {
                                Type typeExpr = (Type)expr.accept((Visitor)this.exprChecker());
                                DeclName genName = genParams.get(i);
                                if (!(typeExpr instanceof PowerType)) {
                                    this.error((TermA)term, ErrorMessage.EXPR_TYPE_IS_NOT_POWERSET, params);
                                    break;
                                }
                                Type2 type = ((PowerType)typeExpr).getType();
                                this.chanType_ = this.replaceChannelType(genName, (Type)type, this.chanType_);
                                ++i;
                            }
                        }
                    }
                }
                this.typeEnv().enterScope();
                for (Field cParam : cParams) {
                    List pairs = (List)cParam.accept((Visitor)this.communicChecker());
                    ArrayList<String> paramsError = new ArrayList<String>();
                    paramsError.add(this.currentProcess().getWord());
                    result = this.checkDecls(result, pairs, (TermA)term, ErrorMessage.REDECLARED_INPUT_VAR_IN_PROCESS, paramsError);
                    ++this.position_;
                    this.typeEnv().add(pairs);
                }
                this.typeEnv().exitScope();
            } else {
                this.error((TermA)term, ErrorMessage.CHANNEL_NEEDS_CPARAMS, params);
            }
            ArrayList<NameTypePair> usedChans = new ArrayList<NameTypePair>();
            NameTypePair usedChan = this.factory().createNameTypePair(this.chanName_, this.chanType_);
            usedChans.add(usedChan);
            this.localCircTypeEnv().addUsedChans(usedChans);
        } else {
            Object[] params = new Object[]{this.chanName_.getWord()};
            this.error((TermA)term, ErrorMessage.IS_NOT_CHANNEL_NAME, params);
        }
        this.addTypeAnn((TermA)term.getChanName(), this.chanType_);
        return result;
    }

    public Object visitDotField(DotField term) {
        Type exprType = (Type)term.getExpression().accept((Visitor)this.exprChecker());
        Type type = this.chanType_;
        if (this.chanType_ instanceof ProdType) {
            ListTerm types = ((ProdType)this.chanType_).getType();
            type = (Type)types.get(this.position_);
        }
        if (!(exprType instanceof UnknownType)) {
            Type2 expectedU = net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType(type);
            Type2 foundU = net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType(exprType);
            if (this.unify(foundU, expectedU) != net.sourceforge.czt.typecheck.z.util.GlobalDefs.SUCC) {
                Object[] params = new Object[]{this.currentProcess().getWord(), expectedU, this.chanName_.getWord(), foundU};
                this.error((TermA)term, ErrorMessage.CHANNEL_PARAM_NOT_UNIFY, params);
            }
        }
        return new ArrayList();
    }

    public Object visitInputField(InputField term) {
        ArrayList<NameTypePair> result = new ArrayList<NameTypePair>();
        DeclName varName = this.factory().createDeclName(term.getVariable());
        UnknownType varType = this.factory().createUnknownType();
        if (this.chanType_ instanceof ProdType) {
            ListTerm types = ((ProdType)this.chanType_).getType();
            if (types.size() > this.position_) {
                varType = (Type)types.get(this.position_);
            } else {
                Object[] params = new Object[]{varName.getWord(), this.chanName_.getWord()};
                this.error((TermA)term, ErrorMessage.IMPOSSIBLE_EXTRACT_INPUT_VAR, params);
            }
        } else if (this.position_ == 0) {
            varType = this.chanType_;
        } else {
            Object[] params = new Object[]{varName.getWord(), this.chanName_.getWord()};
            this.error((TermA)term, ErrorMessage.IMPOSSIBLE_EXTRACT_INPUT_VAR, params);
        }
        NameTypePair pair = this.factory().createNameTypePair(varName, (Type)varType);
        result.add(pair);
        this.typeEnv().enterScope();
        this.typeEnv().add(pair);
        term.getRestriction().accept((Visitor)this.predChecker());
        this.typeEnv().exitScope();
        this.addTypeAnn((TermA)term.getVariable(), (Type)varType);
        return result;
    }

    public Object visitOutputField(OutputField term) {
        return this.visitDotField((DotField)term);
    }

    private Type replaceChannelType(DeclName genName, Type typeExpr, Type typeChan) {
        Type result = null;
        if (typeChan instanceof ProdType) {
            ListTerm types = ((ProdType)typeChan).getType();
            ArrayList<Type2> typesResult = new ArrayList<Type2>();
            for (Type2 type : types) {
                Type res = this.replaceChannelType(genName, typeExpr, (Type)type);
                typesResult.add(net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType(res));
            }
            result = this.factory().createProdType(typesResult);
        } else if (typeChan instanceof PowerType) {
            Type2 type = ((PowerType)typeChan).getType();
            Type res = this.replaceChannelType(genName, typeExpr, (Type)type);
            result = this.factory().createPowerType((Type2)res);
        } else {
            DeclName nameType;
            result = typeChan instanceof GenParamType ? (GlobalDefs.compareDeclName(nameType = ((GenParamType)typeChan).getName(), genName, false) ? typeExpr : typeChan) : typeChan;
        }
        return result;
    }
}

