/*
 * Decompiled with CFR 0.152.
 */
package jcsp.util;

import java.io.Serializable;
import jcsp.util.BufferSizeError;
import jcsp.util.ChannelDataStore;

public class OverWriteOldestBuffer
implements ChannelDataStore,
Serializable {
    private final Object[] buffer;
    private int counter = 0;
    private int firstIndex = 0;
    private int lastIndex = 0;

    public OverWriteOldestBuffer(int n) {
        if (n <= 0) {
            throw new BufferSizeError("\n*** Attempt to create an overwriting buffered channel with negative or zero capacity");
        }
        this.buffer = new Object[n];
    }

    public Object get() {
        Object object = this.buffer[this.firstIndex];
        this.buffer[this.firstIndex] = null;
        this.firstIndex = (this.firstIndex + 1) % this.buffer.length;
        --this.counter;
        return object;
    }

    public void put(Object object) {
        if (this.counter == this.buffer.length) {
            this.firstIndex = (this.firstIndex + 1) % this.buffer.length;
        } else {
            ++this.counter;
        }
        this.buffer[this.lastIndex] = object;
        this.lastIndex = (this.lastIndex + 1) % this.buffer.length;
    }

    public int getState() {
        if (this.counter == 0) {
            return 0;
        }
        return 1;
    }

    public Object clone() {
        return new OverWriteOldestBuffer(this.buffer.length);
    }
}

