/*
 * Decompiled with CFR 0.152.
 */
package jcsp.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Vector;
import jcsp.awt.ComponentEventHandler;
import jcsp.awt.FocusEventHandler;
import jcsp.awt.GraphicsProtocol;
import jcsp.awt.KeyEventHandler;
import jcsp.awt.MouseEventHandler;
import jcsp.awt.MouseMotionEventHandler;
import jcsp.awt.Paintable;
import jcsp.lang.CSProcess;
import jcsp.lang.ChannelInput;
import jcsp.lang.ChannelOutput;

public class ActiveCanvas
extends Canvas
implements CSProcess {
    private ChannelInput toGraphics;
    private ChannelOutput fromGraphics;
    private Paintable paintable;
    private Vector vec = new Vector();
    private int requestedWidth;
    private int requestedHeight;

    public void setGraphicsChannels(ChannelInput channelInput, ChannelOutput channelOutput) {
        this.toGraphics = channelInput;
        this.fromGraphics = channelOutput;
    }

    public void setPaintable(Paintable paintable) {
        this.paintable = paintable;
        paintable.register(this);
    }

    public void paint(Graphics graphics) {
        if (this.paintable == null) {
            super.paint(graphics);
        } else {
            this.paintable.paint(graphics);
        }
    }

    public void update(Graphics graphics) {
        if (this.paintable == null) {
            super.update(graphics);
        } else {
            this.paintable.update(graphics);
        }
    }

    public void addComponentEventChannel(ChannelOutput channelOutput) {
        if (channelOutput != null) {
            ComponentEventHandler componentEventHandler = new ComponentEventHandler(channelOutput);
            this.addComponentListener(componentEventHandler);
            this.vec.addElement(componentEventHandler);
        }
    }

    public void addFocusEventChannel(ChannelOutput channelOutput) {
        if (channelOutput != null) {
            FocusEventHandler focusEventHandler = new FocusEventHandler(channelOutput);
            this.addFocusListener(focusEventHandler);
            this.vec.addElement(focusEventHandler);
        }
    }

    public void addKeyEventChannel(ChannelOutput channelOutput) {
        if (channelOutput != null) {
            KeyEventHandler keyEventHandler = new KeyEventHandler(channelOutput);
            this.addKeyListener(keyEventHandler);
            this.vec.addElement(keyEventHandler);
        }
    }

    public void addMouseEventChannel(ChannelOutput channelOutput) {
        if (channelOutput != null) {
            MouseEventHandler mouseEventHandler = new MouseEventHandler(channelOutput);
            this.addMouseListener(mouseEventHandler);
            this.vec.addElement(mouseEventHandler);
        }
    }

    public void addMouseMotionEventChannel(ChannelOutput channelOutput) {
        if (channelOutput != null) {
            MouseMotionEventHandler mouseMotionEventHandler = new MouseMotionEventHandler(channelOutput);
            this.addMouseMotionListener(mouseMotionEventHandler);
            this.vec.addElement(mouseMotionEventHandler);
        }
    }

    public void setSize(int n, int n2) {
        this.requestedWidth = n;
        this.requestedHeight = n2;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.requestedWidth, this.requestedHeight);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.requestedWidth, this.requestedHeight);
    }

    public void run() {
        if (this.toGraphics != null) {
            while (true) {
                GraphicsProtocol graphicsProtocol;
                if ((graphicsProtocol = (GraphicsProtocol)this.toGraphics.read()) == null) {
                    continue;
                }
                switch (graphicsProtocol.tag) {
                    case 0: {
                        this.fromGraphics.write(this.getSize());
                        break;
                    }
                    case 1: {
                        this.fromGraphics.write(this);
                        break;
                    }
                    case 2: {
                        this.fromGraphics.write(this.getBackground());
                        break;
                    }
                    case 3: {
                        GraphicsProtocol.SetBackground setBackground = (GraphicsProtocol.SetBackground)graphicsProtocol;
                        this.setBackground(setBackground.color);
                        this.fromGraphics.write(Boolean.TRUE);
                        break;
                    }
                    case 4: {
                        this.requestFocus();
                        this.fromGraphics.write(Boolean.TRUE);
                        break;
                    }
                    case 5: {
                        GraphicsProtocol.MakeMISImage makeMISImage = (GraphicsProtocol.MakeMISImage)graphicsProtocol;
                        this.fromGraphics.write(this.createImage(makeMISImage.mis));
                        break;
                    }
                    case 6: {
                        GraphicsProtocol.SetPaintable setPaintable = (GraphicsProtocol.SetPaintable)graphicsProtocol;
                        this.paintable = setPaintable.paintable;
                        this.paintable.register(this);
                        this.fromGraphics.write(Boolean.TRUE);
                        break;
                    }
                    case 7: {
                        GraphicsProtocol.General general = (GraphicsProtocol.General)graphicsProtocol;
                        this.fromGraphics.write(general.c.configure(this));
                    }
                }
            }
        }
    }
}

