/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.print.z;

import java.util.List;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.base.visitor.VisitorUtils;
import net.sourceforge.czt.print.ast.Application;
import net.sourceforge.czt.print.ast.ApplicationVisitor;
import net.sourceforge.czt.print.ast.OperatorApplication;
import net.sourceforge.czt.print.ast.OperatorApplicationVisitor;
import net.sourceforge.czt.print.ast.Precedence;
import net.sourceforge.czt.print.ast.PrintPredicate;
import net.sourceforge.czt.util.CztLogger;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.AndExpr;
import net.sourceforge.czt.z.ast.Assoc;
import net.sourceforge.czt.z.ast.BindSelExpr;
import net.sourceforge.czt.z.ast.CompExpr;
import net.sourceforge.czt.z.ast.CondExpr;
import net.sourceforge.czt.z.ast.DecorExpr;
import net.sourceforge.czt.z.ast.Exists1Expr;
import net.sourceforge.czt.z.ast.Exists1Pred;
import net.sourceforge.czt.z.ast.ExistsExpr;
import net.sourceforge.czt.z.ast.ExistsPred;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ForallExpr;
import net.sourceforge.czt.z.ast.ForallPred;
import net.sourceforge.czt.z.ast.HideExpr;
import net.sourceforge.czt.z.ast.IffExpr;
import net.sourceforge.czt.z.ast.IffPred;
import net.sourceforge.czt.z.ast.ImpliesExpr;
import net.sourceforge.czt.z.ast.ImpliesPred;
import net.sourceforge.czt.z.ast.LambdaExpr;
import net.sourceforge.czt.z.ast.LetExpr;
import net.sourceforge.czt.z.ast.MuExpr;
import net.sourceforge.czt.z.ast.NegExpr;
import net.sourceforge.czt.z.ast.NegPred;
import net.sourceforge.czt.z.ast.OrExpr;
import net.sourceforge.czt.z.ast.OrPred;
import net.sourceforge.czt.z.ast.PipeExpr;
import net.sourceforge.czt.z.ast.PowerExpr;
import net.sourceforge.czt.z.ast.PreExpr;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.ProdExpr;
import net.sourceforge.czt.z.ast.ProjExpr;
import net.sourceforge.czt.z.ast.RenameExpr;
import net.sourceforge.czt.z.ast.ThetaExpr;
import net.sourceforge.czt.z.ast.TupleSelExpr;
import net.sourceforge.czt.z.util.Factory;
import net.sourceforge.czt.z.util.OperatorName;
import net.sourceforge.czt.z.visitor.ExprVisitor;
import net.sourceforge.czt.z.visitor.PredVisitor;
import net.sourceforge.czt.z.visitor.ProdExprVisitor;

public class PrecedenceParenAnnVisitor
implements TermVisitor,
PredVisitor,
ExprVisitor,
ProdExprVisitor,
ApplicationVisitor,
OperatorApplicationVisitor {
    private Factory factory_ = new Factory();

    public void run(Term term) {
        term.accept((Visitor)this);
    }

    public Object visitTerm(Term term) {
        VisitorUtils.visitTerm((Visitor)this, (Term)term);
        return null;
    }

    public Object visitPred(Pred term) {
        VisitorUtils.visitTerm((Visitor)this, (Term)term);
        this.preservePrecedence((Term)term);
        return null;
    }

    public Object visitExpr(Expr term) {
        VisitorUtils.visitTerm((Visitor)this, (Term)term);
        this.preservePrecedence((Term)term);
        return null;
    }

    protected void preservePrecedence(Term term) {
        Precedence prec = this.precedence(term);
        if (prec != null) {
            Object[] children = term.getChildren();
            for (int i = 0; i < children.length; ++i) {
                Object child = children[i];
                if (child instanceof List) {
                    List list = (List)child;
                    for (Object elem : list) {
                        this.addParenAnnIfNecessary(elem, prec);
                    }
                    continue;
                }
                if (!(child instanceof TermA)) continue;
                this.addParenAnnIfNecessary((TermA)child, prec);
            }
        }
    }

    public Object visitApplication(Application appl) {
        VisitorUtils.visitTerm((Visitor)this, (Term)appl);
        this.preservePrecedence((Term)appl);
        Expr rightExpr = appl.getRightExpr();
        if (rightExpr instanceof Application) {
            this.addParenAnn((TermA)rightExpr);
        }
        return null;
    }

    protected boolean isInfix(OperatorName opName) {
        if (opName == null) {
            return false;
        }
        return OperatorName.Fixity.INFIX.equals(opName.getFixity());
    }

    public Object visitOperatorApplication(OperatorApplication appl) {
        VisitorUtils.visitTerm((Visitor)this, (Term)appl);
        this.preservePrecedence((Term)appl);
        OperatorName opName = appl.getOperatorName();
        if (this.isInfix(opName)) {
            Assoc assoc = appl.getAssoc();
            if (assoc == null) {
                String message = "Cannot find associativity for '" + opName + "'; assume leftassoc";
                CztLogger.getLogger(PrecedenceParenAnnVisitor.class).warning(message);
                assoc = Assoc.Left;
            }
            if (Assoc.Right.equals((Object)assoc)) {
                OperatorApplication childApp;
                Object firstArg = appl.getArgs().get(0);
                if (firstArg instanceof OperatorApplication && this.isInfix((childApp = (OperatorApplication)((Object)firstArg)).getOperatorName())) {
                    this.addParenAnn((TermA)childApp);
                }
            } else {
                OperatorApplication childApp;
                Object lastArg = appl.getArgs().get(appl.getArgs().size() - 1);
                if (lastArg instanceof OperatorApplication && this.isInfix((childApp = (OperatorApplication)((Object)lastArg)).getOperatorName())) {
                    this.addParenAnn((TermA)childApp);
                }
            }
        }
        return null;
    }

    public Object visitProdExpr(ProdExpr prodExpr) {
        VisitorUtils.visitTerm((Visitor)this, (Term)prodExpr);
        this.preservePrecedence((Term)prodExpr);
        for (Object child : prodExpr.getExpr()) {
            if (!(child instanceof ProdExpr)) continue;
            this.addParenAnn((TermA)((ProdExpr)child));
        }
        return null;
    }

    protected void addParenAnnIfNecessary(Object object, Precedence parentPrec) {
        if (object instanceof TermA) {
            this.addParenAnnIfNecessary((TermA)object, parentPrec);
        }
    }

    protected void addParenAnnIfNecessary(TermA termA, Precedence parentPrec) {
        Precedence prec = this.precedence((Term)termA);
        if (prec != null && parentPrec.compareTo(prec) > 0) {
            this.addParenAnn(termA);
        }
    }

    protected void addParenAnn(TermA termA) {
        termA.getAnns().add((Object)this.factory_.createParenAnn());
    }

    public Precedence precedence(Term t) {
        if (t instanceof PrintPredicate) {
            return ((PrintPredicate)t).getPrecedence();
        }
        if (t instanceof ThetaExpr) {
            return new Precedence(250);
        }
        if (t instanceof BindSelExpr || t instanceof TupleSelExpr) {
            return new Precedence(240);
        }
        if (t instanceof RenameExpr) {
            return new Precedence(230);
        }
        if (t instanceof DecorExpr) {
            return new Precedence(220);
        }
        if (t instanceof Application) {
            return new Precedence(210);
        }
        if (t instanceof OperatorApplication) {
            OperatorApplication appl = (OperatorApplication)t;
            return appl.getPrecedence();
        }
        if (t instanceof PowerExpr) {
            return new Precedence(190);
        }
        if (t instanceof ProdExpr) {
            return new Precedence(180, 8);
        }
        if (t instanceof PreExpr) {
            return new Precedence(170);
        }
        if (t instanceof ProjExpr) {
            return new Precedence(160);
        }
        if (t instanceof HideExpr) {
            return new Precedence(150);
        }
        if (t instanceof PipeExpr) {
            return new Precedence(140);
        }
        if (t instanceof CompExpr) {
            return new Precedence(130);
        }
        if (t instanceof CondExpr) {
            return new Precedence(120);
        }
        if (t instanceof LetExpr) {
            return new Precedence(110);
        }
        if (t instanceof MuExpr) {
            return new Precedence(100);
        }
        if (t instanceof LambdaExpr) {
            return new Precedence(90);
        }
        if (t instanceof NegPred || t instanceof NegExpr) {
            return new Precedence(70);
        }
        if (t instanceof AndExpr) {
            return new Precedence(60);
        }
        if (t instanceof OrPred || t instanceof OrExpr) {
            return new Precedence(50);
        }
        if (t instanceof ImpliesPred || t instanceof ImpliesExpr) {
            return new Precedence(40);
        }
        if (t instanceof IffPred || t instanceof IffExpr) {
            return new Precedence(30);
        }
        if (t instanceof ForallPred || t instanceof ExistsPred || t instanceof Exists1Pred || t instanceof ForallExpr || t instanceof ExistsExpr || t instanceof Exists1Expr) {
            return new Precedence(20);
        }
        return null;
    }
}

