/*
 * Decompiled with CFR 0.152.
 */
package jcircus.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;

public class CodeFormatting {
    public static String SEQUENCE = ";";
    public static String OPEN_BLOCK = "{";
    public static String CLOSE_BLOCK = "}";
    public static String LINE_BREAK = "\n";
    public static String TAB = "\t";

    private static String insertString(String input, String insertString, String afterString) {
        String output = "";
        StringTokenizer tokenizer = new StringTokenizer(input, afterString, true);
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken();
            if (next.equals(afterString)) {
                output = output + next + insertString;
                continue;
            }
            output = output + next.trim();
        }
        return output;
    }

    private static String insertLineBreaks(String input, String afterString) {
        return CodeFormatting.insertString(input, LINE_BREAK, afterString);
    }

    private static int count(char c, String str) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    private static String repeat(char c, int n) {
        String output = "";
        for (int i = 0; i < n; ++i) {
            output = output + c;
        }
        return output;
    }

    private static String insertTabs(String input) {
        String output = "";
        String done = "";
        String toDo = "";
        StringTokenizer tokenizer = new StringTokenizer(input, LINE_BREAK, true);
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken();
            done = done + next;
            if (next.equals(LINE_BREAK)) {
                int numberOfOpenBlocks = CodeFormatting.count(OPEN_BLOCK.charAt(0), done);
                int numberOfCloseBlocks = CodeFormatting.count(CLOSE_BLOCK.charAt(0), done);
                int numberOfTabs = numberOfOpenBlocks - numberOfCloseBlocks;
                output = output + next + CodeFormatting.repeat(TAB.charAt(0), numberOfTabs);
                continue;
            }
            output = output + next.trim();
        }
        output = output.replaceAll(TAB + CLOSE_BLOCK, CLOSE_BLOCK);
        return output;
    }

    public static String format(String input) {
        String output = input;
        if (input != null) {
            output = output.replaceAll(LINE_BREAK, "");
            output = CodeFormatting.insertLineBreaks(output, OPEN_BLOCK);
            output = CodeFormatting.insertLineBreaks(output, CLOSE_BLOCK);
            output = CodeFormatting.insertLineBreaks(output, SEQUENCE);
            output = CodeFormatting.insertTabs(output);
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String input = "";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(new File("source.txt")));
            String line = reader.readLine();
            while (line != null) {
                input = input + line + LINE_BREAK;
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
        }
        String output = CodeFormatting.format(input);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(new File("target.txt")));
            writer.write(output);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

