/*
 * Decompiled with CFR 0.152.
 */
package jcircus.environment;

import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import jcircus.exceptions.ChanUseUnificationException;
import jcircus.exceptions.MoreThanOneWriterException;
import jcircus.util.ChanUse;
import net.sourceforge.czt.z.ast.Name;

public class ChanUseEnv {
    private TreeMap treeMap_ = new TreeMap();

    public void put(String channelName, ChanUse chanUse) {
        if (chanUse == null) {
            throw new NullPointerException();
        }
        this.treeMap_.put(channelName.toString(), chanUse);
    }

    public ChanUse get(String channelName) {
        return (ChanUse)((Object)this.treeMap_.get(channelName));
    }

    public void remove(String channelName) {
        this.treeMap_.remove(channelName);
    }

    public int size() {
        return this.treeMap_.size();
    }

    public boolean containsKey(String channelName) {
        return this.treeMap_.containsKey(channelName);
    }

    private void putAll(ChanUseEnv channelUseEnvironment) {
        Iterator iterator = channelUseEnvironment.iteratorKeys();
        while (iterator.hasNext()) {
            String channelName = (String)iterator.next();
            ChanUse javaTypeChannel = channelUseEnvironment.get(channelName);
            this.put(channelName, javaTypeChannel);
        }
    }

    public void removeAll(ChanUseEnv channelUseEnvironment) {
        Iterator iterator = channelUseEnvironment.iteratorKeys();
        while (iterator.hasNext()) {
            String channelName = (String)iterator.next();
            this.remove(channelName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChanUseEnv merge(ChanUseEnv other, boolean isParallel) throws ChanUseUnificationException, MoreThanOneWriterException {
        ChanUseEnv r = new ChanUseEnv();
        r.putAll(this);
        Iterator iterator = other.iteratorKeys();
        while (iterator.hasNext()) {
            ChanUse otherChanUse;
            String chanName = (String)iterator.next();
            ChanUse newChanUse = otherChanUse = other.get(chanName);
            if (r.containsKey(chanName)) {
                ChanUse thisChanUse = r.get(chanName);
                if (isParallel) {
                    if (thisChanUse.equals((Object)ChanUse.Input) && otherChanUse.equals((Object)ChanUse.Output) || thisChanUse.equals((Object)ChanUse.Output) && otherChanUse.equals((Object)ChanUse.Input)) {
                        newChanUse = ChanUse.Mixed;
                    } else if (otherChanUse.equals((Object)thisChanUse)) {
                        newChanUse = otherChanUse;
                    } else if (thisChanUse.equals((Object)ChanUse.Mixed) && otherChanUse.equals((Object)ChanUse.Input) || thisChanUse.equals((Object)ChanUse.Input) && otherChanUse.equals((Object)ChanUse.Mixed)) {
                        newChanUse = ChanUse.Mixed;
                    } else {
                        if (thisChanUse.equals((Object)ChanUse.Mixed) && otherChanUse.equals((Object)ChanUse.Output) || thisChanUse.equals((Object)ChanUse.Output) && otherChanUse.equals((Object)ChanUse.Mixed)) {
                            throw new MoreThanOneWriterException();
                        }
                        if (thisChanUse.equals((Object)ChanUse.Undefined) && otherChanUse.equals((Object)ChanUse.Input) || thisChanUse.equals((Object)ChanUse.Input) && otherChanUse.equals((Object)ChanUse.Undefined)) {
                            newChanUse = ChanUse.Input;
                        } else {
                            if ((!thisChanUse.equals((Object)ChanUse.Undefined) || !otherChanUse.equals((Object)ChanUse.Output)) && (!thisChanUse.equals((Object)ChanUse.Output) || !otherChanUse.equals((Object)ChanUse.Undefined))) throw new ChanUseUnificationException(chanName, thisChanUse, otherChanUse);
                            newChanUse = ChanUse.Output;
                        }
                    }
                } else if (otherChanUse.equals((Object)thisChanUse)) {
                    newChanUse = otherChanUse;
                }
            }
            r.put(chanName, newChanUse);
        }
        return r;
    }

    public ChanUseEnv substitute(List newChannels, List oldChannels) {
        ChanUseEnv r = new ChanUseEnv();
        r.putAll(this);
        for (int i = 0; i < oldChannels.size(); ++i) {
            Name name = (Name)oldChannels.get(i);
            String newChannelName = ((Name)newChannels.get(i)).toString();
            if (!r.containsKey(name.toString())) continue;
            ChanUse javaType = r.get(name.toString());
            r.remove(name.toString());
            r.put(newChannelName, javaType);
        }
        return r;
    }

    public Iterator iteratorKeys() {
        return this.treeMap_.keySet().iterator();
    }

    public void print() {
        Iterator it = this.iteratorKeys();
        System.out.println("---------------------------");
        while (it.hasNext()) {
            String chanName = (String)it.next();
            ChanUse chanUse = this.get(chanName);
            System.out.println(chanName + " " + (Object)((Object)chanUse));
        }
    }
}

