/*
 * Decompiled with CFR 0.152.
 */
package jcircus;

import circparser.CircusParser;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jcircus.exceptions.FailParsingException;
import jcircus.exceptions.FailTranslationException;
import jcircus.exceptions.FailTypeCheckingException;
import jcircus.gui.JCircusFrame;
import jcircus.translator.Translator2Java;
import jcircus.util.ProcInfo;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.session.SectionManager;
import net.sourceforge.czt.typecheck.circus.TypeChecker;
import net.sourceforge.czt.z.ast.Spec;

public class JCircus {
    private JCircusFrame jCircusFrame_;
    private Translator2Java translator_;
    private boolean useWithGUI_;

    public JCircus() {
        this.useWithGUI_ = false;
    }

    public JCircus(JCircusFrame jCircusFrame) {
        this.jCircusFrame_ = jCircusFrame;
        this.useWithGUI_ = true;
    }

    public Translator2Java getTranslator2Java() {
        return this.translator_;
    }

    public void jCircusMain(String path, String projectName, String projectDir) throws Exception {
        Spec spec = CircusParser.parse((String)path);
        Map errors = CircusParser.getErrors();
        if (errors.isEmpty()) {
            if (this.jCircusFrame_ != null) {
                this.jCircusFrame_.reportParsingOK();
            } else {
                System.out.println("No parse errors, good!");
            }
        } else {
            List parseErrors = null;
            int c = 0;
            Iterator<Object> i$ = errors.values().iterator();
            while (i$.hasNext()) {
                List l;
                parseErrors = l = (List)i$.next();
                if (++c <= 1) continue;
                throw new RuntimeException();
            }
            System.err.println(parseErrors.size() + " error(s) in total, bad!");
            for (String e : parseErrors) {
                System.err.println("\t" + e);
            }
            throw new FailParsingException(parseErrors);
        }
        SectionManager manager = new SectionManager();
        TypeChecker typeChecker = new TypeChecker((SectionInfo)manager, Markup.LATEX);
        typeChecker.visitTerm((Term)spec);
        List typeErrors = typeChecker.errors();
        if (typeErrors.isEmpty()) {
            if (this.jCircusFrame_ != null) {
                this.jCircusFrame_.reportTypeCheckingOK();
            } else {
                System.out.println("No typing errors, good!");
            }
        } else {
            System.out.println(typeErrors.size() + " type error(s) in total, bad!");
            for (int i = 0; i < typeErrors.size(); ++i) {
                System.out.println(typeErrors.get(i));
            }
            throw new FailTypeCheckingException(typeErrors);
        }
        try {
            this.translator_ = new Translator2Java(projectDir, projectName, spec);
            this.translator_.translate(this.useWithGUI_);
            if (this.useWithGUI_) {
                List<ProcInfo> procInfoList = this.translator_.getProcInfoList();
                boolean confirmTranslation = this.jCircusFrame_.promptForMainProcesses(procInfoList);
                if (!confirmTranslation) {
                    return;
                }
                for (int i = 0; i < procInfoList.size(); ++i) {
                    ProcInfo procInfo = procInfoList.get(i);
                    if (!procInfo.getCreateMain() || procInfo.getParameters() == null || procInfo.getParameters().isEmpty() || (confirmTranslation = this.jCircusFrame_.promptForParameters(procInfo))) continue;
                    return;
                }
                this.translator_.createSources();
            }
        }
        catch (FailTranslationException fte) {
            List transErrors = fte.getErrors();
            System.out.println(transErrors.size() + " problems(s) in the input file!");
            for (int i = 0; i < transErrors.size(); ++i) {
                System.out.println(transErrors.get(i));
            }
            throw fte;
        }
        if (this.jCircusFrame_ != null) {
            this.jCircusFrame_.reportTranslationOK(projectDir, projectName);
        } else {
            System.out.println("Translation sucessfull!");
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length < 3) {
                System.out.println("Error: Wrong number of parameters");
                System.out.println("Use: java jCircus.Jcircus <input-file> <proj-name> <output-dir>");
                System.exit(0);
            }
            String path = args[0];
            String projectName = args[1];
            String projectDir = args[2];
            String nameMainProcess = null;
            if (args.length > 3) {
                nameMainProcess = args[3];
            }
            JCircus jCircus = new JCircus();
            jCircus.jCircusMain(path, projectName, projectDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

