/*
 * Decompiled with CFR 0.152.
 */
package circparser.grammar;

import circparser.grammar.ActionSeparator;
import circparser.grammar.AfterNewLine;
import circparser.grammar.BeforeNewLine;
import circparser.grammar.BothNewLine;
import circparser.grammar.FilaTokens;
import circparser.grammar.GreekLetters;
import circparser.grammar.NeitherNewLine;
import circparser.grammar.SpaceExcl;
import circparser.grammar.StartExpression;
import circparser.grammar.TokenValue;
import circparser.grammar.Yylex;
import circparser.grammar.table.OperatorDeclaredException;
import java.io.IOException;
import java.io.InputStream;
import java_cup.runtime.Symbol;

public class ClassifyTokens {
    Symbol preToken;
    FilaTokens buffer;
    Yylex yylex;
    public static final int HARD_NL = 1;
    public static final int SOFT_NL = 2;
    private AfterNewLine cAfterNewLine;
    private BeforeNewLine cBeforeNewLine;
    private BothNewLine cBothNewLine;
    private NeitherNewLine cNeitherNewLine;
    private SpaceExcl cSpaceExcl;
    private GreekLetters greekLetters;
    private StartExpression startExpression = new StartExpression();
    private ActionSeparator actionSeparator = new ActionSeparator();

    public ClassifyTokens(InputStream instream) {
        this.yylex = new Yylex(instream);
        this.buffer = new FilaTokens();
        this.cBeforeNewLine = new BeforeNewLine();
        this.cAfterNewLine = new AfterNewLine();
        this.cNeitherNewLine = new NeitherNewLine();
        this.cBothNewLine = new BothNewLine();
        this.cSpaceExcl = new SpaceExcl();
        this.greekLetters = new GreekLetters();
    }

    public Yylex getLexer() {
        return this.yylex;
    }

    public Symbol yylex() throws IOException, OperatorDeclaredException {
        Symbol token = this.buffer.isEmpty() ? this.yylex.yylex() : this.buffer.remover();
        if (token.sym == 68) {
            Symbol posToken;
            if (!this.buffer.isEmpty()) {
                posToken = this.buffer.getId();
            } else {
                posToken = this.yylex.yylex();
                this.buffer.inserir(posToken);
            }
            if (this.isHardNewLine(this.preToken.sym, posToken.sym)) {
                return token;
            }
            return this.yylex();
        }
        if (token.sym == 40) {
            token = this.classifyComma((TokenValue)token.value);
        } else if (token.sym == 7) {
            token = this.completeName(token);
            if (((TokenValue)token.value).text.endsWith("!")) {
                token = this.ClassifyExcl(token);
            } else if (((TokenValue)token.value).text.endsWith("?")) {
                token = this.ClassifyInter(token);
            }
        } else if (token.sym == 129) {
            token = this.ClassifyInter(token);
        } else if (token.sym == 128) {
            token = this.ClassifyExcl(token);
        } else if (token.sym == 13) {
            token = this.classifyDot(token);
        }
        if (token.sym == 86 || token.sym == 62 || token.sym == 63 || token.sym == 7 && this.greekLetters.contains(((TokenValue)token.value).text)) {
            token = this.completeGreekLetter(token);
        }
        this.preToken = token;
        return token;
    }

    public Symbol classifyComma(TokenValue comma) throws IOException, OperatorDeclaredException {
        FilaTokens corredor = this.buffer;
        boolean control = true;
        while (control) {
            Symbol nextTok;
            if (corredor.isEmpty()) {
                nextTok = this.yylex.yylex();
                this.buffer.inserir(nextTok);
            } else {
                nextTok = corredor.getId();
                corredor = corredor.getNext();
            }
            if (nextTok == null) continue;
            TokenValue tok = (TokenValue)nextTok.value;
            if (tok.toString().equals("==") || tok.toString().equals(":") || tok.toString().equals("\\end{circus}") || tok.toString().equals(":=") || tok.toString().equals("\\rchanset")) {
                return new Symbol(40, new TokenValue(comma.text, comma.lineBegin));
            }
            if (!tok.toString().equals("\\}") && !tok.toString().equals(")") && !tok.toString().equals("]") && !tok.toString().equals("(") && !tok.toString().equals("\\rangle") && !tok.toString().equals("\\rpar") && !tok.toString().equals("\\rinter") && !tok.toString().equals("\\rfloor")) continue;
            return new Symbol(39, new TokenValue(comma.text, comma.lineBegin));
        }
        return new Symbol(1, new TokenValue(this.yylex.getYytext(), this.yylex.getYyline()));
    }

    public boolean isHardNewLine(int pre, int pos) {
        int nPreTok = 1;
        int nFolTok = 1;
        Integer iPreTok = new Integer(pre);
        Integer iFolTok = new Integer(pos);
        if (this.cNeitherNewLine.contains(iPreTok) && this.cNeitherNewLine.contains(iFolTok)) {
            return true;
        }
        if (this.cBothNewLine.contains(iPreTok) || this.cAfterNewLine.contains(iPreTok)) {
            nPreTok = 2;
        }
        if (this.cBothNewLine.contains(iFolTok) || this.cBeforeNewLine.contains(iFolTok)) {
            nFolTok = 2;
        }
        return nPreTok != 2 && nFolTok != 2;
    }

    public Symbol completeName(Symbol tok) throws IOException, OperatorDeclaredException {
        Symbol nextTok;
        int upArrow = 0;
        int downArrow = 0;
        int closeArrow = 0;
        FilaTokens corredor = this.buffer;
        boolean isWordGlue = false;
        boolean endName = false;
        boolean removeBuffer = false;
        if (corredor.isEmpty()) {
            nextTok = this.yylex.yylex();
            corredor.inserir(nextTok);
        } else {
            nextTok = corredor.getId();
        }
        String name = ((TokenValue)tok.value).text;
        while (!(nextTok.sym != 94 && nextTok.sym != 7 && nextTok.sym != 36 || upArrow + downArrow < closeArrow || endName)) {
            String nextToken = ((TokenValue)nextTok.value).text;
            if (nextToken.equals("^{")) {
                ++upArrow;
                name = name + nextToken;
                isWordGlue = true;
                removeBuffer = true;
            } else if (nextToken.equals("_{")) {
                ++downArrow;
                name = name + nextToken;
                isWordGlue = true;
                removeBuffer = true;
            } else if (nextToken.equals("^") || nextToken.equals("_")) {
                name = name + nextToken;
                isWordGlue = true;
                removeBuffer = true;
            } else if (nextToken.equals("}")) {
                if (upArrow + downArrow - closeArrow > 0) {
                    ++closeArrow;
                    name = name + nextToken;
                    isWordGlue = true;
                    removeBuffer = true;
                } else {
                    endName = true;
                }
            } else if (isWordGlue) {
                name = name + nextToken;
                isWordGlue = false;
                removeBuffer = true;
            } else {
                endName = true;
            }
            if (corredor.isEmpty()) {
                nextTok = this.yylex.yylex();
                corredor.inserir(nextTok);
                continue;
            }
            if (removeBuffer) {
                corredor.remover();
                removeBuffer = false;
            }
            if (corredor.isEmpty()) {
                nextTok = this.yylex.yylex();
                corredor.inserir(nextTok);
                continue;
            }
            nextTok = corredor.getId();
            corredor = corredor.getNext();
        }
        return new Symbol(7, new TokenValue(name, this.yylex.getYyline()));
    }

    public Symbol ClassifyExcl(Symbol tok) throws IOException, OperatorDeclaredException {
        Symbol aux = null;
        Symbol token = tok;
        if (this.buffer.isEmpty()) {
            aux = this.yylex.yylex();
            this.buffer.inserir(aux);
        } else {
            aux = this.buffer.getId();
        }
        TokenValue nextTokenValue = (TokenValue)aux.value;
        if (token.sym == 128) {
            if (!((TokenValue)token.value).hasSpace() && !nextTokenValue.hasSpace() && this.startExpression.contains(aux.sym)) {
                String text = ((TokenValue)token.value).toString();
                token = new Symbol(136, new TokenValue("!", nextTokenValue.LineBegin(), false));
            }
        } else if (!nextTokenValue.hasSpace() && this.startExpression.contains(aux.sym)) {
            String text = ((TokenValue)token.value).toString();
            this.buffer.inserirFirst(new Symbol(136, new TokenValue("!", nextTokenValue.LineBegin(), false)));
            ((TokenValue)token.value).setText(text.substring(0, text.length() - 1));
        }
        return token;
    }

    public Symbol ClassifyInter(Symbol tok) throws IOException, OperatorDeclaredException {
        Symbol aux = null;
        Symbol token = tok;
        if (this.buffer.isEmpty()) {
            aux = this.yylex.yylex();
            this.buffer.inserir(aux);
        } else {
            aux = this.buffer.getId();
        }
        TokenValue nextTokenValue = (TokenValue)aux.value;
        if (token.sym == 129) {
            if (!((TokenValue)token.value).hasSpace() && !nextTokenValue.hasSpace() && this.startExpression.contains(aux.sym)) {
                String text = ((TokenValue)token.value).toString();
                token = new Symbol(134, new TokenValue("?", nextTokenValue.LineBegin(), false));
            }
        } else if (!nextTokenValue.hasSpace() && this.startExpression.contains(aux.sym)) {
            String text = ((TokenValue)token.value).toString();
            this.buffer.inserirFirst(new Symbol(134, new TokenValue("?", nextTokenValue.LineBegin(), false)));
            ((TokenValue)token.value).setText(text.substring(0, text.length() - 1));
        }
        return token;
    }

    public Symbol classifyDot(Symbol dot) throws IOException, OperatorDeclaredException {
        FilaTokens corredor = this.buffer;
        boolean classified = false;
        int paren = 0;
        int brack = 0;
        int keys = 0;
        int type = -1;
        while (!classified) {
            Symbol nextTok;
            if (corredor.isEmpty()) {
                nextTok = this.yylex.yylex();
                this.buffer.inserir(nextTok);
            } else {
                nextTok = corredor.getId();
                corredor = corredor.getNext();
            }
            if (nextTok == null) continue;
            if (nextTok.sym == 5) {
                ++brack;
                continue;
            }
            if (nextTok.sym == 6) {
                if (--brack >= 0) continue;
                classified = true;
                type = 0;
                continue;
            }
            if (nextTok.sym == 11) {
                ++keys;
                continue;
            }
            if (nextTok.sym == 12) {
                if (--keys >= 0) continue;
                classified = true;
                type = 0;
                continue;
            }
            if (nextTok.sym == 3) {
                ++paren;
                continue;
            }
            if (nextTok.sym == 4) {
                if (--paren >= 0) continue;
                classified = true;
                type = 0;
                continue;
            }
            if (nextTok.sym == 106) {
                classified = true;
                type = 1;
                continue;
            }
            if (!this.actionSeparator.contains(nextTok.sym)) continue;
            classified = true;
            type = 0;
        }
        Symbol r = type == 0 ? dot : (type == 1 ? new Symbol(135, new TokenValue(".", ((TokenValue)dot.value).LineBegin(), false)) : new Symbol(1, new TokenValue(this.yylex.getYytext(), this.yylex.getYyline())));
        return r;
    }

    public Symbol completeGreekLetter(Symbol token) throws IOException, OperatorDeclaredException {
        Symbol aux = null;
        FilaTokens corredor = this.buffer;
        boolean control = true;
        if (corredor.isEmpty()) {
            aux = this.yylex.yylex();
            this.buffer.inserir(aux);
        } else {
            aux = this.buffer.getId();
        }
        TokenValue tok = (TokenValue)aux.value;
        while (!tok.hasHardSpace() && control) {
            ((TokenValue)token.value).setText(((TokenValue)token.value).toString() + tok.toString());
            token.sym = 7;
            if (!this.buffer.isEmpty()) {
                this.buffer.remover();
            }
            control = aux.sym == 86 || aux.sym == 62 || aux.sym == 63 || aux.sym == 7 && this.greekLetters.contains(((TokenValue)aux.value).text);
            if (!this.buffer.isEmpty()) {
                aux = this.buffer.getId();
            } else {
                aux = this.yylex.yylex();
                this.buffer.inserir(aux);
            }
            tok = (TokenValue)aux.value;
        }
        return token;
    }
}

