/*
 * Decompiled with CFR 0.152.
 */
package circparser;

import circparser.grammar.ClassifyTokens;
import circparser.grammar.parser;
import java.io.FileInputStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java_cup.runtime.Symbol;
import net.sourceforge.czt.z.ast.Spec;
import net.sourceforge.czt.z.ast.ZSect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircusParser {
    private static Map<String, List<String>> errors = new TreeMap<String, List<String>>();

    public static Map<String, List<String>> getErrors() {
        return errors;
    }

    public static void completeTest() {
        System.out.println("Complete test.");
        CircusParser.singleTest("D:\\Netbeans\\JCircus\\src\\examples\\T_AxDef.tex");
    }

    public static void singleTest(String path) {
        System.out.println("Parsing: " + path);
        Spec spec = CircusParser.parse(path);
        if (spec != null) {
            System.out.println("OK!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Spec parse(String path) {
        FileInputStream instream = null;
        parser parser_obj = new parser(path);
        Spec spec = null;
        Symbol parse_tree = null;
        try {
            instream = new FileInputStream(path);
            ClassifyTokens classifyTokens = new ClassifyTokens(instream);
            parser_obj.assignLex(classifyTokens);
            classifyTokens.getLexer().sourceFilename = path;
            parse_tree = parser_obj.parse();
            spec = (Spec)parse_tree.value;
            ZSect sect = (ZSect)spec.getSect().get(0);
            boolean parada = false;
        }
        catch (Exception e) {
            System.out.println(path + " - Exception: " + e.getMessage() + "\n");
            e.printStackTrace(System.err);
        }
        finally {
            if (parser_obj.getErrors() != null && !parser_obj.getErrors().isEmpty()) {
                errors.put(path, parser_obj.getErrors());
            }
        }
        return spec;
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            CircusParser.singleTest(args[0]);
        } else {
            CircusParser.completeTest();
        }
        if (errors.isEmpty()) {
            System.out.println("No errors, good!");
        } else {
            System.err.println(errors.size() + " error(s) in total, bad!");
            for (String s : errors.keySet()) {
                System.err.println("Error(s) for " + s.substring(s.lastIndexOf(92) + 1));
                for (String e : errors.get(s)) {
                    System.err.println("\t" + e);
                }
            }
        }
    }
}

