/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.z.ast.LocAnn;
import net.sourceforge.czt.zpatt.ast.JokerType;
import net.sourceforge.czt.zpatt.ast.Jokers;

public class JokerTable {
    private String section_;
    private Map jokers_ = new HashMap();

    public JokerTable(String section, Collection parents) throws JokerException {
        this.section_ = section;
        if (parents != null) {
            for (JokerTable table : parents) {
                this.addJokerTable(table);
            }
        }
    }

    public String getSection() {
        return this.section_;
    }

    public JokerType getTokenType(String name) {
        return (JokerType)this.jokers_.get(name);
    }

    public void add(Jokers jokers) throws JokerException {
        LocAnn locAnn = (LocAnn)jokers.getAnn(LocAnn.class);
        JokerType kind = jokers.getKind();
        ListTerm names = jokers.getName();
        for (String name : names) {
            int line = locAnn.getLine();
            int col = locAnn.getCol();
            String loc = locAnn.getLoc();
            this.addTokenType(name, kind, line, col, loc);
        }
    }

    private void addTokenType(String name, JokerType type, String loc) throws JokerException {
        this.addTokenType(name, type, -1, -1, loc);
    }

    private void addTokenType(String name, JokerType kind, int line, int col, String loc) throws JokerException {
        JokerType existingType = (JokerType)this.jokers_.get(name);
        if (existingType != null) {
            String message = "Duplicate joker name " + name;
            if (line >= 0) {
                message = message + " at line " + line;
            }
            if (col >= 0) {
                message = message + " column " + col;
            }
            message = message + " in " + loc;
            throw new JokerException(message);
        }
        this.jokers_.put(name, kind);
    }

    private void addJokerTable(JokerTable parentTable) throws JokerException {
        Set parentJokers = parentTable.jokers_.entrySet();
        for (Map.Entry entry : parentJokers) {
            this.addTokenType((String)entry.getKey(), (JokerType)entry.getValue(), parentTable.getSection());
        }
    }

    public static class JokerException
    extends Exception {
        public JokerException(String message) {
            super(message);
        }
    }
}

