/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.oz;

import java.io.IOException;
import java.util.Properties;
import java.util.Stack;
import net.sourceforge.czt.java_cup.runtime.Scanner;
import net.sourceforge.czt.java_cup.runtime.Symbol;
import net.sourceforge.czt.parser.oz.ContextFreeScanner;
import net.sourceforge.czt.parser.util.Decorword;
import net.sourceforge.czt.parser.util.ParsePropertiesKeys;

class SeparateDelimiter
implements Scanner,
ParsePropertiesKeys {
    private Properties properties_;
    private ContextFreeScanner scanner_;
    private Stack<Symbol> tokens_ = new Stack();

    public SeparateDelimiter(ContextFreeScanner scanner, Properties properties) {
        this.scanner_ = scanner;
        this.properties_ = properties;
    }

    private boolean getBooleanProperty(String propertyKey) {
        if (this.properties_ == null) {
            return false;
        }
        return "true".equals(this.properties_.getProperty(propertyKey));
    }

    private boolean needsSeparation(char c) {
        return c == ',' || c == ';' || c == '.';
    }

    public Symbol next_token() throws IOException {
        if (!this.tokens_.empty()) {
            return this.tokens_.pop();
        }
        Symbol symbol = this.scanner_.next_token();
        int left = symbol.left;
        int right = symbol.right;
        if (symbol.sym == 112 && this.getBooleanProperty("extract_comma_or_semi")) {
            String value = ((Decorword)symbol.value).getName();
            char[] charArray = value.toCharArray();
            int length = charArray.length;
            int suffix = length - 1;
            while (this.needsSeparation(charArray[suffix])) {
                if (suffix <= 0) {
                    return symbol;
                }
                --suffix;
            }
            assert (suffix >= 0);
            if (suffix < length - 1) {
                String string = new String(charArray, suffix + 1, length - suffix - 1);
                Decorword dw = new Decorword(string);
                this.tokens_.push(new Symbol(112, left, right, (Object)dw));
            }
            int prefix = 0;
            while (this.needsSeparation(charArray[prefix])) {
                ++prefix;
            }
            assert (prefix <= suffix);
            String string = new String(charArray, prefix, suffix - prefix + 1);
            Symbol newSymbol = new Symbol(112, left, right, (Object)new Decorword(string));
            if (prefix == 0) {
                return newSymbol;
            }
            this.tokens_.push(newSymbol);
            string = new String(charArray, 0, prefix);
            return new Symbol(112, left, right, (Object)new Decorword(string));
        }
        return symbol;
    }
}

