/*
 * Decompiled with CFR 0.152.
 */
package jcircusutil.multisync;

import jcircusutil.multisync.AuxiliarMethods;
import jcsp.lang.CSProcess;
import jcsp.lang.ChannelInput;
import jcsp.lang.ChannelOutput;

public class MultiSyncControl
implements CSProcess {
    private int id = 0;
    private int numberOfClients;
    private ChannelOutput[] fromSync;
    private ChannelInput toSync;

    public MultiSyncControl(ChannelOutput[] fromSync, ChannelInput toSync) {
        this.numberOfClients = fromSync.length;
        this.fromSync = fromSync;
        this.toSync = toSync;
    }

    public void run() {
        this.offer(this.numberOfClients);
    }

    private void offer(int countdown) {
        if (countdown > 0 && countdown <= this.numberOfClients) {
            Integer x = (Integer)this.toSync.read();
            int nextOffer = x;
            if (nextOffer >= 0) {
                this.offer(countdown - 1);
            } else if (nextOffer < 0) {
                int flipNextOffer = AuxiliarMethods.flip(new Integer(nextOffer));
                this.fromSync[flipNextOffer].write((Object)new Boolean(false));
                this.offer(countdown + 1);
            }
        } else if (countdown == 0) {
            this.invite(0);
        }
    }

    private void invite(int client) {
        if (client < this.numberOfClients) {
            this.fromSync[client].write((Object)new Boolean(true));
            this.invite(client + 1);
        } else if (client == this.numberOfClients) {
            this.invitePrime(0, this.numberOfClients);
        }
    }

    private void invitePrime(int client, int countdown) {
        if (client >= 0 && client < this.numberOfClients) {
            int nextCommit = (Integer)this.toSync.read();
            if (nextCommit >= 0) {
                this.invitePrime(client + 1, countdown - 1);
            } else if (nextCommit < 0) {
                this.invitePrime(client + 1, countdown);
            }
        } else if (client == this.numberOfClients) {
            this.sync(0, countdown);
        }
    }

    private void sync(int client, int countdown) {
        if (client < this.numberOfClients) {
            this.fromSync[client].write((Object)new Boolean(countdown == 0));
            if (countdown == 0) {
                Object value = this.toSync.read();
                System.out.println("Read value " + value + " from writer.");
                this.syncV(client + 1, countdown, value);
            } else if (countdown != 0) {
                // empty if block
            }
            this.sync(client + 1, countdown);
        } else if (client == this.numberOfClients) {
            this.syncPrime(countdown);
        }
    }

    private void syncV(int client, int countdown, Object value) {
        if (client < this.numberOfClients) {
            this.fromSync[client].write((Object)new Boolean(countdown == 0));
            this.fromSync[client].write(value);
            this.syncV(client + 1, countdown, value);
        } else if (client == this.numberOfClients) {
            this.syncPrime(countdown);
        }
    }

    private void syncPrime(int countdown) {
        if (countdown > 0) {
            this.offer(countdown);
        } else if (countdown == 0) {
            this.offer(this.numberOfClients);
        }
    }
}

