/*
 * Decompiled with CFR 0.152.
 */
package jcircusutil.multisync;

import java.util.Vector;
import jcircusutil.multisync.MultiSyncClient;
import jcircusutil.multisync.SyncInfo;
import jcsp.lang.Any2OneChannel;

public class GeneralChannelR {
    public static final int RW_ND = 0;
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int SM_ND = 0;
    public static final int P2P = 1;
    public static final int MULTI = 2;
    private Any2OneChannel toController;
    private Any2OneChannel[] fromControler;
    private int procIdMS;
    private int writerId;
    private int rw;
    private int ms;
    private SyncInfo syncInfo;
    private String procId;

    private GeneralChannelR(Any2OneChannel channel, Any2OneChannel[] fromControler, SyncInfo msInfo, String processName, int rw) {
        this.toController = channel;
        this.fromControler = fromControler;
        this.procIdMS = msInfo != null ? msInfo.get(processName) : -1;
        this.syncInfo = msInfo;
        this.procId = processName;
        this.writerId = 0;
        int n = this.ms = fromControler == null ? 1 : 2;
        this.rw = rw == -1 ? (this.procIdMS == this.writerId ? 2 : 1) : rw;
    }

    public GeneralChannelR(Any2OneChannel channel, Any2OneChannel[] fromControler, SyncInfo msInfo, String processName) {
        this(channel, fromControler, msInfo, processName, -1);
    }

    public GeneralChannelR(Any2OneChannel channel, SyncInfo msInfo, String processName) {
        this(channel, null, msInfo, processName, -1);
    }

    public GeneralChannelR(GeneralChannelR gc, String processName) {
        this(gc.getChannel(), gc.getFromControler(), gc.getMsInfo(), processName, -1);
    }

    public GeneralChannelR(GeneralChannelR gc, int rw) {
        this(gc.getChannel(), gc.getFromControler(), gc.getMsInfo(), gc.getProcessName(), rw);
    }

    public GeneralChannelR(GeneralChannelR gc, String processName, int rw) {
        this(gc.getChannel(), gc.getFromControler(), gc.getMsInfo(), processName, rw);
    }

    public Object read() {
        Object r;
        if (this.ms == 1) {
            System.out.println(this.procId + " will read ");
            r = this.toController.read();
        } else {
            Vector<Object[]> seqOfSync = new Vector<Object[]>();
            Object[] sync = new Object[]{this.fromControler[this.procIdMS], this.toController, new Integer(this.procIdMS), new Integer(this.writerId)};
            seqOfSync.addElement(sync);
            MultiSyncClient client = new MultiSyncClient(seqOfSync, new Vector(), null);
            client.run();
            r = client.getValueTrans();
        }
        System.out.println(this.procId + " read " + r);
        return r;
    }

    public void write(Object x) {
        if (this.ms == 1) {
            this.toController.write(x);
        } else {
            Vector<Object[]> seqOfSync = new Vector<Object[]>();
            Object[] sync = new Object[]{this.fromControler[this.procIdMS], this.toController, new Integer(this.procIdMS), new Integer(this.writerId)};
            seqOfSync.addElement(sync);
            MultiSyncClient client = new MultiSyncClient(seqOfSync, new Vector(), x);
            client.run();
        }
        System.out.println(this.procId + " wrote " + x);
    }

    public Object communicate(Object x) {
        Object r = null;
        if (this.rw == 1) {
            r = this.read();
        } else {
            this.write(x);
        }
        return r;
    }

    public boolean isMultiSync() {
        return this.fromControler != null;
    }

    public Any2OneChannel getFromControlerId() {
        return this.fromControler[this.procIdMS];
    }

    public Any2OneChannel getChannel() {
        return this.toController;
    }

    public Any2OneChannel[] getFromControler() {
        return this.fromControler;
    }

    public int getProcessId() {
        return this.procIdMS;
    }

    public int getWriterId() {
        return this.writerId;
    }

    public int getRw() {
        return this.rw;
    }

    public int getMs() {
        return this.ms;
    }

    public SyncInfo getMsInfo() {
        return this.syncInfo;
    }

    public String getProcessName() {
        return this.procId;
    }

    public void setChannel(Any2OneChannel channel) {
        this.toController = channel;
    }

    public void set(Any2OneChannel[] fromControler) {
        this.fromControler = fromControler;
    }

    public void setProcessId(int processId) {
        this.procIdMS = processId;
    }

    public void setWriterId(int writerId) {
        this.writerId = writerId;
    }

    public void setRw(int rw) {
        this.rw = rw;
    }

    public void setMs(int ms) {
        this.ms = ms;
    }

    public void setMsInfo(SyncInfo msInfo) {
        this.syncInfo = msInfo;
    }

    public void setProcessName(String processName) {
        this.procId = processName;
    }
}

