/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.z.impl;

import java.util.List;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.typecheck.z.impl.GenericTypeImpl;
import net.sourceforge.czt.typecheck.z.impl.NameSectTypeTripleImpl;
import net.sourceforge.czt.typecheck.z.impl.NameTypePairImpl;
import net.sourceforge.czt.typecheck.z.impl.PowerTypeImpl;
import net.sourceforge.czt.typecheck.z.impl.ProdTypeImpl;
import net.sourceforge.czt.typecheck.z.impl.SchemaTypeImpl;
import net.sourceforge.czt.typecheck.z.impl.SignatureAnnImpl;
import net.sourceforge.czt.typecheck.z.impl.TypeAnnImpl;
import net.sourceforge.czt.typecheck.z.impl.UnknownType;
import net.sourceforge.czt.typecheck.z.impl.VariableSignature;
import net.sourceforge.czt.typecheck.z.impl.VariableType;
import net.sourceforge.czt.typecheck.z.util.UndeclaredAnn;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.GenParamType;
import net.sourceforge.czt.z.ast.GenericType;
import net.sourceforge.czt.z.ast.GivenType;
import net.sourceforge.czt.z.ast.InStroke;
import net.sourceforge.czt.z.ast.LocAnn;
import net.sourceforge.czt.z.ast.NameNamePair;
import net.sourceforge.czt.z.ast.NameSectTypeTriple;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.NextStroke;
import net.sourceforge.czt.z.ast.NumStroke;
import net.sourceforge.czt.z.ast.OutStroke;
import net.sourceforge.czt.z.ast.PowerType;
import net.sourceforge.czt.z.ast.ProdType;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.SchemaType;
import net.sourceforge.czt.z.ast.SectTypeEnvAnn;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.SignatureAnn;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.Type2;
import net.sourceforge.czt.z.ast.TypeAnn;
import net.sourceforge.czt.z.ast.TypeEnvAnn;
import net.sourceforge.czt.z.ast.ZFactory;
import net.sourceforge.czt.z.impl.ZFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Factory {
    protected ZFactory zFactory_;

    public Factory() {
        this.zFactory_ = new ZFactoryImpl();
    }

    public Factory(ZFactory zFactory) {
        this.zFactory_ = zFactory;
    }

    public ZFactory getZFactory() {
        return this.zFactory_;
    }

    public static Term cloneTerm(Term term) {
        return Factory.cloneTerm(term, term);
    }

    public static Term cloneTerm(Term term, Term rootTerm) {
        Object[] children = term.getChildren();
        Object[] args = new Object[children.length];
        for (int i = 0; i < children.length; ++i) {
            Object next = children[i];
            if (next == rootTerm) {
                args[i] = next;
                continue;
            }
            if (next != null && next instanceof Term) {
                Term nextTerm = (Term)next;
                args[i] = Factory.cloneTerm(nextTerm, rootTerm);
                continue;
            }
            args[i] = children[i];
        }
        Term result = term.create(args);
        assert (result.equals(term));
        Factory.copyAnns(term, result);
        return result;
    }

    public static void copyAnns(Term term1, Term term2) {
        if (term1 instanceof TermA && term2 instanceof TermA) {
            UndeclaredAnn uAnn;
            TermA termA1 = (TermA)term1;
            TermA termA2 = (TermA)term2;
            LocAnn locAnn = (LocAnn)termA1.getAnn(LocAnn.class);
            if (locAnn != null) {
                termA2.getAnns().add((Object)locAnn);
            }
            if ((uAnn = (UndeclaredAnn)termA1.getAnn(UndeclaredAnn.class)) != null) {
                termA2.getAnns().add((Object)uAnn);
            }
        }
    }

    public PowerType createPowerType() {
        VariableType vType = this.createVariableType();
        PowerType result = this.createPowerType(vType);
        return result;
    }

    public PowerType createPowerType(Type2 type) {
        PowerType powerType = this.zFactory_.createPowerType(type);
        PowerTypeImpl result = new PowerTypeImpl(powerType);
        return result;
    }

    public ProdType createProdType(List type) {
        ProdType prodType = this.zFactory_.createProdType(type);
        ProdTypeImpl result = new ProdTypeImpl(prodType);
        return result;
    }

    public SchemaType createSchemaType() {
        VariableSignature vSignature = this.createVariableSignature();
        SchemaType result = this.createSchemaType(vSignature);
        return result;
    }

    public SchemaType createSchemaType(Signature signature) {
        SchemaType schemaType = this.zFactory_.createSchemaType(signature);
        SchemaTypeImpl result = new SchemaTypeImpl(schemaType);
        return result;
    }

    public GenericType createGenericType(List declName, Type2 type, Type2 optionalType) {
        GenericType genericType = this.zFactory_.createGenericType(declName, type, optionalType);
        GenericTypeImpl result = new GenericTypeImpl(genericType);
        return result;
    }

    public GenParamType createGenParamType(DeclName declName) {
        return this.zFactory_.createGenParamType(declName);
    }

    public GivenType createGivenType(DeclName declName) {
        return this.zFactory_.createGivenType(declName);
    }

    public NameNamePair createNameNamePair(RefName refName, DeclName declName) {
        NameNamePair result = this.zFactory_.createNameNamePair(refName, declName);
        return result;
    }

    public NameTypePair createNameTypePair(DeclName declName, Type type) {
        NameTypePair pair = this.zFactory_.createNameTypePair(declName, type);
        NameTypePairImpl result = new NameTypePairImpl(pair);
        return result;
    }

    public NameSectTypeTriple createNameSectTypeTriple(DeclName declName, String section, Type type) {
        NameSectTypeTriple nameSectTypeTriple = this.zFactory_.createNameSectTypeTriple(declName, section, type);
        NameSectTypeTripleImpl result = new NameSectTypeTripleImpl(nameSectTypeTriple);
        return result;
    }

    public Signature createSignature() {
        return this.zFactory_.createSignature();
    }

    public Signature createSignature(List pairs) {
        return this.zFactory_.createSignature(pairs);
    }

    public VariableSignature createVariableSignature() {
        return new VariableSignature(this);
    }

    public VariableType createVariableType() {
        return new VariableType(this);
    }

    public VariableType createVariableType(DeclName declName) {
        return new VariableType(declName);
    }

    public UnknownType createUnknownType() {
        return new UnknownType();
    }

    public UnknownType createUnknownType(RefName refName) {
        return new UnknownType(refName);
    }

    public UnknownType createUnknownType(RefName refName, boolean isMem) {
        return new UnknownType(refName, isMem);
    }

    public UnknownType createUnknownType(RefName refName, boolean isMem, List<Type2> types) {
        return new UnknownType(refName, isMem, types);
    }

    public UnknownType createUnknownType(RefName refName, boolean isMem, List<Type2> types, List<NameNamePair> pairs) {
        return new UnknownType(refName, isMem, types, pairs);
    }

    public TypeAnn createTypeAnn() {
        return this.zFactory_.createTypeAnn();
    }

    public TypeAnn createTypeAnn(Type type) {
        TypeAnn typeAnn = this.zFactory_.createTypeAnn(type);
        TypeAnnImpl result = new TypeAnnImpl(typeAnn);
        return result;
    }

    public SignatureAnn createSignatureAnn(Signature signature) {
        SignatureAnn signatureAnn = this.zFactory_.createSignatureAnn(signature);
        SignatureAnnImpl result = new SignatureAnnImpl(signatureAnn);
        return result;
    }

    public TypeEnvAnn createTypeEnvAnn(List pairs) {
        return this.zFactory_.createTypeEnvAnn(pairs);
    }

    public SectTypeEnvAnn createSectTypeEnvAnn(List nameSecTypeTriple) {
        return this.zFactory_.createSectTypeEnvAnn(nameSecTypeTriple);
    }

    public DeclName createDeclName(String word, List stroke, String id) {
        return this.zFactory_.createDeclName(word, stroke, id);
    }

    public DeclName createDeclName(DeclName declName) {
        return this.createDeclName(declName.getWord(), (List)declName.getStroke(), declName.getId());
    }

    public DeclName createDeclName(RefName refName) {
        return this.createDeclName(refName.getWord(), (List)refName.getStroke(), null);
    }

    public RefName createRefName(String word, List stroke, DeclName declName) {
        return this.zFactory_.createRefName(word, stroke, declName);
    }

    public RefName createRefName(RefName refName) {
        return this.zFactory_.createRefName(refName.getWord(), (List)refName.getStroke(), refName.getDecl());
    }

    public RefName createRefName(DeclName declName) {
        return this.zFactory_.createRefName(declName.getWord(), (List)declName.getStroke(), null);
    }

    public RefExpr createRefExpr(RefName refName, List expr, Boolean mixfix) {
        return this.zFactory_.createRefExpr(refName, expr, mixfix);
    }

    public InStroke createInStroke() {
        return this.zFactory_.createInStroke();
    }

    public OutStroke createOutStroke() {
        return this.zFactory_.createOutStroke();
    }

    public NextStroke createNextStroke() {
        return this.zFactory_.createNextStroke();
    }

    public NumStroke createNumStroke(Integer number) {
        return this.zFactory_.createNumStroke(number);
    }
}

