/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.z;

import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.typecheck.z.Checker;
import net.sourceforge.czt.typecheck.z.ErrorMessage;
import net.sourceforge.czt.typecheck.z.TypeChecker;
import net.sourceforge.czt.typecheck.z.impl.UnknownType;
import net.sourceforge.czt.typecheck.z.util.GlobalDefs;
import net.sourceforge.czt.typecheck.z.util.UResult;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.InclDecl;
import net.sourceforge.czt.z.ast.LocAnn;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.PowerType;
import net.sourceforge.czt.z.ast.SchemaType;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.Type2;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.visitor.ConstDeclVisitor;
import net.sourceforge.czt.z.visitor.InclDeclVisitor;
import net.sourceforge.czt.z.visitor.VarDeclVisitor;

public class DeclChecker
extends Checker
implements VarDeclVisitor,
ConstDeclVisitor,
InclDeclVisitor {
    public DeclChecker(TypeChecker typeChecker) {
        super(typeChecker);
    }

    public Object visitVarDecl(VarDecl varDecl) {
        List<NameTypePair> pairs = GlobalDefs.list();
        Expr expr = varDecl.getExpr();
        Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
        PowerType vPowerType = this.factory().createPowerType();
        String vPowerTypeBefore = vPowerType.toString();
        UResult unified = this.unify((Type2)vPowerType, exprType);
        String vPowerTypeAfter = vPowerType.toString();
        if (unified == GlobalDefs.FAIL) {
            Object[] params = new Object[]{expr, exprType};
            this.error((TermA)expr, ErrorMessage.NON_SET_IN_DECL, params);
        } else {
            Object baseType = null;
            if (this.useBeforeDecl() && exprType instanceof UnknownType) {
                UnknownType uType = (UnknownType)exprType;
                if (uType.getRefName() != null) {
                    uType.setIsMem(true);
                }
                baseType = uType;
            } else {
                baseType = vPowerType.getType();
            }
            ListTerm declNames = varDecl.getDeclName();
            for (DeclName declName : declNames) {
                NameTypePair pair = this.factory().createNameTypePair(declName, (Type)baseType);
                pairs.add(pair);
            }
        }
        return pairs;
    }

    public Object visitConstDecl(ConstDecl constDecl) {
        DeclName declName = constDecl.getDeclName();
        Expr expr = constDecl.getExpr();
        Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
        NameTypePair pair = this.factory().createNameTypePair(declName, (Type)exprType);
        List<NameTypePair> pairs = GlobalDefs.list(pair);
        return pairs;
    }

    public Object visitInclDecl(InclDecl inclDecl) {
        List<NameTypePair> pairs = GlobalDefs.list();
        Expr expr = inclDecl.getExpr();
        Type2 exprType = (Type2)expr.accept((Visitor)this.exprChecker());
        SchemaType vSchemaType = this.factory().createSchemaType();
        PowerType powerType = this.factory().createPowerType((Type2)vSchemaType);
        UResult unified = this.unify((Type2)powerType, exprType);
        if (unified == GlobalDefs.FAIL) {
            Object[] params = new Object[]{inclDecl, exprType};
            this.error((TermA)inclDecl, ErrorMessage.NON_SCHEXPR_IN_INCLDECL, params);
        } else {
            LocAnn locAnn = (LocAnn)expr.getAnn(LocAnn.class);
            ListTerm lPairs = vSchemaType.getSignature().getNameTypePair();
            for (NameTypePair pair : lPairs) {
                GlobalDefs.addAnn((TermA)pair.getName(), locAnn);
                pairs.add(pair);
            }
        }
        return pairs;
    }
}

