/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.oz;

import java.util.Collection;
import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.oz.ast.AnonOpExpr;
import net.sourceforge.czt.oz.ast.AssoParallelOpExpr;
import net.sourceforge.czt.oz.ast.ClassRefType;
import net.sourceforge.czt.oz.ast.ClassSig;
import net.sourceforge.czt.oz.ast.ClassType;
import net.sourceforge.czt.oz.ast.ConjOpExpr;
import net.sourceforge.czt.oz.ast.DeltaList;
import net.sourceforge.czt.oz.ast.DistOpExpr;
import net.sourceforge.czt.oz.ast.DistSeqOpExpr;
import net.sourceforge.czt.oz.ast.ExChoiceOpExpr;
import net.sourceforge.czt.oz.ast.HideOpExpr;
import net.sourceforge.czt.oz.ast.NameSignaturePair;
import net.sourceforge.czt.oz.ast.OpExpr;
import net.sourceforge.czt.oz.ast.OpExpr2;
import net.sourceforge.czt.oz.ast.OpPromotionExpr;
import net.sourceforge.czt.oz.ast.OpText;
import net.sourceforge.czt.oz.ast.Operation;
import net.sourceforge.czt.oz.ast.ParallelOpExpr;
import net.sourceforge.czt.oz.ast.RenameOpExpr;
import net.sourceforge.czt.oz.ast.ScopeEnrichOpExpr;
import net.sourceforge.czt.oz.ast.SeqOpExpr;
import net.sourceforge.czt.oz.visitor.AnonOpExprVisitor;
import net.sourceforge.czt.oz.visitor.AssoParallelOpExprVisitor;
import net.sourceforge.czt.oz.visitor.DistOpExprVisitor;
import net.sourceforge.czt.oz.visitor.HideOpExprVisitor;
import net.sourceforge.czt.oz.visitor.OpExpr2Visitor;
import net.sourceforge.czt.oz.visitor.OpPromotionExprVisitor;
import net.sourceforge.czt.oz.visitor.OpTextVisitor;
import net.sourceforge.czt.oz.visitor.ParallelOpExprVisitor;
import net.sourceforge.czt.oz.visitor.RenameOpExprVisitor;
import net.sourceforge.czt.oz.visitor.ScopeEnrichOpExprVisitor;
import net.sourceforge.czt.oz.visitor.SeqOpExprVisitor;
import net.sourceforge.czt.typecheck.oz.Checker;
import net.sourceforge.czt.typecheck.oz.ErrorMessage;
import net.sourceforge.czt.typecheck.oz.TypeChecker;
import net.sourceforge.czt.typecheck.oz.impl.VariableClassSig;
import net.sourceforge.czt.typecheck.oz.util.GlobalDefs;
import net.sourceforge.czt.typecheck.z.impl.VariableSignature;
import net.sourceforge.czt.typecheck.z.impl.VariableType;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.NameNamePair;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.OutStroke;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.Type2;

public class OpExprChecker
extends Checker
implements AnonOpExprVisitor,
OpPromotionExprVisitor,
OpExpr2Visitor,
SeqOpExprVisitor,
ParallelOpExprVisitor,
AssoParallelOpExprVisitor,
HideOpExprVisitor,
RenameOpExprVisitor,
ScopeEnrichOpExprVisitor,
DistOpExprVisitor,
OpTextVisitor {
    public OpExprChecker(TypeChecker typeChecker) {
        super(typeChecker);
    }

    public Object visitAnonOpExpr(AnonOpExpr anonOpExpr) {
        OpText opText = anonOpExpr.getOpText();
        Signature signature = (Signature)opText.accept((Visitor)this.opExprChecker());
        this.addSignatureAnn((TermA)anonOpExpr, signature);
        return signature;
    }

    public Object visitOpText(OpText opText) {
        this.typeEnv().enterScope();
        ClassSig selfSig = this.getSelfSig();
        DeltaList deltaList = opText.getDeltaList();
        if (deltaList != null) {
            ListTerm refNames = deltaList.getRefName();
            for (RefName delta : refNames) {
                DeclName declName = this.factory().createDeclName(delta);
                if (this.primary().contains(declName)) continue;
                Object[] params = new Object[]{delta};
                this.error((TermA)delta, ErrorMessage.NON_PRIMDECL_IN_DELTALIST, params);
            }
        }
        SchText schText = opText.getSchText();
        Signature signature = (Signature)schText.accept((Visitor)this.exprChecker());
        this.typeEnv().exitScope();
        this.addSignatureAnn((TermA)opText, signature);
        return signature;
    }

    public Object visitOpPromotionExpr(OpPromotionExpr opPromExpr) {
        ClassType classType;
        ClassSig cSig;
        VariableSignature signature = this.factory().createVariableSignature();
        Expr expr = opPromExpr.getExpr();
        ClassRefType exprType = this.getSelfType();
        if (expr != null) {
            exprType = (Type2)expr.accept((Visitor)this.exprChecker());
            exprType = this.resolveClassType((Type2)exprType);
        }
        if (!net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(exprType, ClassType.class) && !net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(exprType, VariableType.class)) {
            Object[] params = new Object[]{opPromExpr, exprType};
            this.error((TermA)opPromExpr, ErrorMessage.NON_CLASS_IN_OPPROMEXPR, params);
        } else if (!net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(exprType, VariableType.class) && !net.sourceforge.czt.typecheck.z.util.GlobalDefs.instanceOf(cSig = (classType = (ClassType)exprType).getClassSig(), VariableClassSig.class)) {
            Object[] params;
            RefName refName = opPromExpr.getName();
            NameSignaturePair opDef = this.findOperation(refName, cSig);
            if (opDef == null && this.sectTypeEnv().getSecondTime() && (expr == null || this.isSelfExpr(expr))) {
                ListTerm ops = this.classPara().getOperation();
                for (Operation op : ops) {
                    if (!net.sourceforge.czt.typecheck.z.util.GlobalDefs.namesEqual((Name)op.getName(), (Name)refName)) continue;
                    opDef = (NameSignaturePair)op.accept((Visitor)this.paraChecker());
                }
            }
            if (opDef == null) {
                params = new Object[]{opPromExpr};
                this.error((TermA)opPromExpr, ErrorMessage.NON_EXISTENT_NAME_IN_OPPROMEXPR, params);
            } else {
                signature = opDef.getSignature();
                if (net.sourceforge.czt.typecheck.z.util.GlobalDefs.resolve(signature) instanceof VariableSignature) {
                    params = new Object[]{opPromExpr};
                    this.error((TermA)opPromExpr, ErrorMessage.SIGNATURE_NOT_DETERMINED, params);
                }
            }
            if (opDef != null && !GlobalDefs.isVisible(refName, (Type2)classType)) {
                params = new Object[]{refName, opPromExpr};
                this.error((TermA)opPromExpr, ErrorMessage.NON_VISIBLE_NAME_IN_OPPROMEXPR, params);
            }
        }
        this.addSignatureAnn((TermA)opPromExpr, signature);
        return signature;
    }

    public Object visitOpExpr2(OpExpr2 opExpr2) {
        this.typeEnv().enterScope();
        if (opExpr2 instanceof ConjOpExpr) {
            this.traverseForDowncasts((OpExpr)opExpr2);
        }
        OpExpr lOpExpr = opExpr2.getLeftOpExpr();
        Signature lSig = (Signature)lOpExpr.accept((Visitor)this.opExprChecker());
        if (opExpr2 instanceof ExChoiceOpExpr) {
            this.typeEnv().exitScope();
            this.typeEnv().enterScope();
        }
        OpExpr rOpExpr = opExpr2.getRightOpExpr();
        Signature rSig = (Signature)rOpExpr.accept((Visitor)this.opExprChecker());
        List<NameTypePair> newPairs = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list(lSig.getNameTypePair());
        newPairs.addAll((Collection<NameTypePair>)rSig.getNameTypePair());
        this.checkForDuplicates(newPairs, (TermA)opExpr2, ErrorMessage.TYPE_MISMATCH_IN_OPEXPR2);
        Signature signature = this.factory().createSignature(newPairs);
        this.typeEnv().exitScope();
        this.addSignatureAnn((TermA)opExpr2, signature);
        return signature;
    }

    public Object visitSeqOpExpr(SeqOpExpr seqOpExpr) {
        this.typeEnv().enterScope();
        OpExpr lOpExpr = seqOpExpr.getLeftOpExpr();
        OpExpr rOpExpr = seqOpExpr.getRightOpExpr();
        Signature lSig = (Signature)lOpExpr.accept((Visitor)this.opExprChecker());
        Signature rSig = (Signature)rOpExpr.accept((Visitor)this.opExprChecker());
        String errorMessage = ErrorMessage.TYPE_MISMATCH_IN_SEQOPEXPR.toString();
        Signature signature = this.createCompSig(lSig, rSig, (TermA)seqOpExpr, errorMessage);
        this.checkForDuplicates((List<NameTypePair>)signature.getNameTypePair(), (TermA)seqOpExpr, ErrorMessage.TYPE_MISMATCH_IN_OPEXPR2);
        this.typeEnv().exitScope();
        this.addSignatureAnn((TermA)seqOpExpr, signature);
        return signature;
    }

    public Object visitParallelOpExpr(ParallelOpExpr parallelOpExpr) {
        this.typeEnv().enterScope();
        OpExpr lOpExpr = parallelOpExpr.getLeftOpExpr();
        OpExpr rOpExpr = parallelOpExpr.getRightOpExpr();
        Signature lSig = (Signature)lOpExpr.accept((Visitor)this.opExprChecker());
        Signature rSig = (Signature)rOpExpr.accept((Visitor)this.opExprChecker());
        String errorMessage = ErrorMessage.TYPE_MISMATCH_IN_PARALLELOPEXPR.toString();
        Signature sigA = this.createPipeSig(lSig, rSig, (TermA)parallelOpExpr, errorMessage);
        Signature sigB = this.createPipeSig(rSig, lSig, (TermA)parallelOpExpr, errorMessage);
        Signature signature = this.intersect(sigA, sigB);
        this.checkForDuplicates((List<NameTypePair>)signature.getNameTypePair(), (TermA)parallelOpExpr, ErrorMessage.TYPE_MISMATCH_IN_OPEXPR2);
        this.typeEnv().exitScope();
        this.addSignatureAnn((TermA)parallelOpExpr, signature);
        return signature;
    }

    public Object visitAssoParallelOpExpr(AssoParallelOpExpr assoParallelOpExpr) {
        this.typeEnv().enterScope();
        OpExpr lOpExpr = assoParallelOpExpr.getLeftOpExpr();
        OpExpr rOpExpr = assoParallelOpExpr.getRightOpExpr();
        Signature lSig = (Signature)lOpExpr.accept((Visitor)this.opExprChecker());
        Signature rSig = (Signature)rOpExpr.accept((Visitor)this.opExprChecker());
        String errorMessage = ErrorMessage.TYPE_MISMATCH_IN_ASSOPARALLELOPEXPR.toString();
        Signature sigA = this.createPloSig(lSig, rSig, (TermA)assoParallelOpExpr, errorMessage);
        Signature sigB = this.createPloSig(rSig, lSig, (TermA)assoParallelOpExpr, errorMessage);
        Signature signature = this.intersect(sigA, sigB);
        this.checkForDuplicates((List<NameTypePair>)signature.getNameTypePair(), (TermA)assoParallelOpExpr, ErrorMessage.TYPE_MISMATCH_IN_OPEXPR2);
        this.typeEnv().exitScope();
        this.addSignatureAnn((TermA)assoParallelOpExpr, signature);
        return signature;
    }

    public Object visitHideOpExpr(HideOpExpr hideOpExpr) {
        OpExpr opExpr = hideOpExpr.getOpExpr();
        Signature hideSig = (Signature)opExpr.accept((Visitor)this.opExprChecker());
        Signature signature = this.createHideSig(hideSig, (List<RefName>)hideOpExpr.getName(), (TermA)hideOpExpr);
        this.addSignatureAnn((TermA)hideOpExpr, signature);
        return signature;
    }

    public Object visitRenameOpExpr(RenameOpExpr renameOpExpr) {
        OpExpr opExpr = renameOpExpr.getOpExpr();
        Signature renameSig = (Signature)opExpr.accept((Visitor)this.opExprChecker());
        String errorMessage = ErrorMessage.DUPLICATE_NAME_IN_RENAMEOPEXPR.toString();
        ListTerm namePairs = renameOpExpr.getNameNamePair();
        Signature signature = this.createRenameSig(renameSig, (List<NameNamePair>)namePairs, (TermA)renameOpExpr, errorMessage);
        this.checkForDuplicates((List<NameTypePair>)signature.getNameTypePair(), (TermA)renameOpExpr);
        this.addSignatureAnn((TermA)renameOpExpr, signature);
        return signature;
    }

    public Object visitScopeEnrichOpExpr(ScopeEnrichOpExpr scopeEnrichOpExpr) {
        this.typeEnv().enterScope();
        OpExpr lOpExpr = scopeEnrichOpExpr.getLeftOpExpr();
        Signature lSig = (Signature)lOpExpr.accept((Visitor)this.opExprChecker());
        this.typeEnv().add((List<NameTypePair>)lSig.getNameTypePair());
        OpExpr rOpExpr = scopeEnrichOpExpr.getRightOpExpr();
        Signature rSig = (Signature)rOpExpr.accept((Visitor)this.opExprChecker());
        List<NameTypePair> newPairs = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list(lSig.getNameTypePair());
        newPairs.addAll((Collection<NameTypePair>)rSig.getNameTypePair());
        this.checkForDuplicates(newPairs, (TermA)scopeEnrichOpExpr, ErrorMessage.TYPE_MISMATCH_IN_OPEXPR2);
        this.typeEnv().exitScope();
        Signature signature = this.factory().createSignature(newPairs);
        this.addSignatureAnn((TermA)scopeEnrichOpExpr, signature);
        return signature;
    }

    public Object visitDistOpExpr(DistOpExpr distOpExpr) {
        DeclName distName;
        this.typeEnv().enterScope();
        SchText schText = distOpExpr.getSchText();
        Signature distSig = (Signature)schText.accept((Visitor)this.exprChecker());
        OpExpr opExpr = distOpExpr.getOpExpr();
        Signature signature = (Signature)opExpr.accept((Visitor)this.opExprChecker());
        ListTerm distPairs = distSig.getNameTypePair();
        for (NameTypePair distPair : distPairs) {
            distName = distPair.getName();
            NameTypePair opExprPair = this.findNameTypePair(distName, signature);
            if (opExprPair == null) continue;
            Object[] params = new Object[]{distName, distOpExpr};
            this.error((TermA)distOpExpr, ErrorMessage.DUPLICATE_NAME_IN_DISTOPEXPR, params);
        }
        if (distOpExpr instanceof DistSeqOpExpr) {
            for (NameTypePair distPair : distPairs) {
                distName = distPair.getName();
                List strokes = net.sourceforge.czt.typecheck.z.util.GlobalDefs.list(distName.getStroke());
                int size = strokes.size();
                if (size <= 0 || !(strokes.get(size - 1) instanceof OutStroke)) continue;
                strokes.remove(size - 1);
                DeclName baseName = this.factory().createDeclName(distName.getWord(), strokes, null);
                NameTypePair opExprPair = this.findNameTypePair(baseName, signature);
                if (opExprPair == null) continue;
                Object[] params = new Object[]{distName, baseName, distOpExpr};
                this.error((TermA)distOpExpr, ErrorMessage.DUPLICATE_OUTNAME_IN_DISTOPEXPR, params);
            }
        }
        this.typeEnv().exitScope();
        this.addSignatureAnn((TermA)distOpExpr, signature);
        return signature;
    }
}

