/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.circus.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.CircusFactory;
import net.sourceforge.czt.circustools.ast.ActionType;
import net.sourceforge.czt.typecheck.circus.impl.ActionInfo;
import net.sourceforge.czt.typecheck.circus.impl.Factory;
import net.sourceforge.czt.typecheck.circus.util.GlobalDefs;
import net.sourceforge.czt.typecheck.z.util.TypeEnv;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.ZFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalTypeEnv {
    protected Factory circusFactory_;
    protected Stack<List<DeclName>> namesets_;
    protected Stack<List<ActionInfo>> actions_;
    protected Stack<List<NameTypePair>> stateVars_;
    protected Stack<List<ActionPara>> onTheFlyActions_;
    protected Stack<List<NameTypePair>> usedChans_;
    protected Stack<List<DeclName>> genericImplicitChans_;
    protected TypeEnv localDefs_;

    public LocalTypeEnv(CircusFactory circusFactory, TypeEnv typeEnv) {
        this.circusFactory_ = new Factory((ZFactory)circusFactory);
        this.namesets_ = new Stack();
        this.actions_ = new Stack();
        this.stateVars_ = new Stack();
        this.onTheFlyActions_ = new Stack();
        this.usedChans_ = new Stack();
        this.genericImplicitChans_ = new Stack();
        this.localDefs_ = typeEnv;
    }

    public List<DeclName> getNamesets() {
        return this.namesets_.peek();
    }

    public List<ActionInfo> getActions() {
        return this.actions_.peek();
    }

    public List<NameTypePair> getStateVars() {
        return this.stateVars_.peek();
    }

    public List<ActionPara> getOnTheFlyActions() {
        return this.onTheFlyActions_.peek();
    }

    public List<NameTypePair> getUsedChans() {
        return this.usedChans_.peek();
    }

    public List<DeclName> getGenericImplicitChans() {
        return this.genericImplicitChans_.peek();
    }

    public void enterScope() {
        ArrayList nameset = new ArrayList();
        this.namesets_.push(nameset);
        ArrayList action = new ArrayList();
        this.actions_.push(action);
        ArrayList local = new ArrayList();
        this.stateVars_.push(local);
        ArrayList onTheFly = new ArrayList();
        this.onTheFlyActions_.push(onTheFly);
        ArrayList usedChans = new ArrayList();
        this.usedChans_.push(usedChans);
        ArrayList genericImplicitChans = new ArrayList();
        this.genericImplicitChans_.push(genericImplicitChans);
        ArrayList paramsIndexes = new ArrayList();
    }

    public void exitScope() {
        this.namesets_.pop();
        this.actions_.pop();
        this.stateVars_.pop();
        this.onTheFlyActions_.pop();
        this.usedChans_.pop();
        this.genericImplicitChans_.pop();
    }

    public boolean isNameSet(DeclName name) {
        boolean result = false;
        List<DeclName> namesets = this.namesets_.peek();
        for (DeclName decl : namesets) {
            if (!GlobalDefs.compareDeclName(decl, name, false)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isStateVar(DeclName name) {
        boolean result = false;
        List<NameTypePair> locals = this.stateVars_.peek();
        for (NameTypePair var : locals) {
            DeclName decl = var.getName();
            if (!GlobalDefs.compareDeclName(decl, name, false)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isAction(DeclName name) {
        boolean result = false;
        List<ActionInfo> actions = this.actions_.peek();
        for (ActionInfo action : actions) {
            DeclName decl = action.getActionName();
            if (!GlobalDefs.compareDeclName(decl, name, false)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean addAction(DeclName declName) {
        boolean result = true;
        List<ActionInfo> actions = this.actions_.peek();
        for (ActionInfo action : actions) {
            if (!GlobalDefs.compareDeclName(action.getActionName(), declName, false)) continue;
            result = false;
        }
        if (result) {
            ActionInfo insert = new ActionInfo(declName);
            actions.add(insert);
        }
        return result;
    }

    public ActionInfo getActionInfo(DeclName name) {
        ActionInfo result = null;
        List<ActionInfo> actions = this.actions_.peek();
        for (ActionInfo action : actions) {
            if (!GlobalDefs.compareDeclName(action.getActionName(), name, false)) continue;
            result = action;
        }
        return result;
    }

    public boolean addStateVar(NameTypePair pair) {
        boolean result = true;
        DeclName name = pair.getName();
        List<NameTypePair> locals = this.stateVars_.peek();
        for (NameTypePair local : locals) {
            if (!GlobalDefs.compareDeclName(local.getName(), name, false)) continue;
            result = false;
        }
        if (result) {
            locals.add(pair);
            this.localDefs_.add(pair);
            DeclName primedVar = this.circusFactory_.createDeclName(pair.getName().getWord() + "'", null, null);
            this.localDefs_.add(primedVar, pair.getType());
        }
        return result;
    }

    public boolean addStateVars(List<NameTypePair> vars) {
        NameTypePair local;
        boolean result = true;
        Iterator<NameTypePair> i$ = vars.iterator();
        while (i$.hasNext() && (result = this.addStateVar(local = i$.next()))) {
        }
        return result;
    }

    public boolean addNameSet(DeclName declName) {
        boolean result = true;
        List<DeclName> namesets = this.namesets_.peek();
        for (DeclName nameset : namesets) {
            if (!GlobalDefs.compareDeclName(nameset, declName, false)) continue;
            result = false;
        }
        if (result) {
            namesets.add(declName);
        }
        return result;
    }

    public Type getStateVarType(DeclName name) {
        Type result = null;
        List<NameTypePair> locals = this.stateVars_.peek();
        for (NameTypePair pair : locals) {
            if (!GlobalDefs.compareDeclName(pair.getName(), name, false)) continue;
            result = pair.getType();
            break;
        }
        return result;
    }

    public boolean isParamAction(DeclName name) {
        boolean result = false;
        List<ActionInfo> actions = this.actions_.peek();
        for (ActionInfo action : actions) {
            DeclName decl = action.getActionName();
            if (!GlobalDefs.compareDeclName(decl, name, false)) continue;
            result = action.isParam();
            break;
        }
        return result;
    }

    public void addUsedChans(List<NameTypePair> chans) {
        List<NameTypePair> usedChans = this.usedChans_.peek();
        for (NameTypePair pair : chans) {
            if (usedChans.contains(pair)) continue;
            usedChans.add(pair);
        }
    }

    public void addGenericImplicitChan(DeclName name) {
        List<DeclName> genericChans = this.genericImplicitChans_.peek();
        if (!genericChans.contains(name)) {
            genericChans.add(name);
        }
    }

    public void setActionType(DeclName name, ActionType type) {
        List<ActionInfo> actions = this.actions_.peek();
        for (ActionInfo action : actions) {
            DeclName decl = action.getActionName();
            if (!GlobalDefs.compareDeclName(decl, name, false)) continue;
            action.setActionType(type);
            break;
        }
    }

    public ActionType getActionType(DeclName name) {
        ActionType result = null;
        ActionInfo info = this.getActionInfo(name);
        if (info != null) {
            result = info.getActionType();
        }
        return result;
    }
}

