/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.circus;

import java.util.ArrayList;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.typecheck.circus.Checker;
import net.sourceforge.czt.typecheck.circus.ErrorAnn;
import net.sourceforge.czt.typecheck.circus.ErrorMessage;
import net.sourceforge.czt.typecheck.circus.TypeChecker;
import net.sourceforge.czt.typecheck.z.util.GlobalDefs;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.Parent;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.ZSect;
import net.sourceforge.czt.z.visitor.ZSectVisitor;

public class SpecChecker
extends Checker
implements ZSectVisitor {
    protected net.sourceforge.czt.typecheck.z.SpecChecker zSpecChecker_;

    public SpecChecker(TypeChecker typeChecker) {
        super(typeChecker);
        this.zSpecChecker_ = new net.sourceforge.czt.typecheck.z.SpecChecker(typeChecker);
    }

    public Object visitTerm(Term term) {
        return term.accept((Visitor)this.zSpecChecker_);
    }

    public Object visitZSect(ZSect zSect) {
        this.sectName(zSect.getName());
        if (this.sectTypeEnv().isChecked(this.sectName())) {
            Object[] params = new Object[]{zSect.getName()};
            this.error((TermA)zSect, ErrorMessage.REDECLARED_SECTION, params);
        }
        this.sectTypeEnv().setSection(this.sectName());
        ListTerm parents = zSect.getParent();
        ArrayList<String> names = new ArrayList<String>();
        for (Parent parent : parents) {
            Object[] params;
            parent.accept((Visitor)this.specChecker());
            if (names.contains(parent.getWord())) {
                params = new Object[]{parent.getWord(), this.sectName()};
                this.error((TermA)parent, ErrorMessage.REDECLARED_PARENT, params);
                continue;
            }
            if (parent.getWord().equals(this.sectName())) {
                params = new Object[]{parent.getWord()};
                this.error((TermA)parent, ErrorMessage.SELF_PARENT, params);
                continue;
            }
            names.add(parent.getWord());
        }
        ListTerm allParas = zSect.getPara();
        ListTerm paras = new ArrayList();
        if (zSect.getName().equals("CircusParserSection")) {
            ArrayList<ProcessPara> implicitProcesses = new ArrayList<ProcessPara>();
            for (Para p : allParas) {
                if (p instanceof ProcessPara) {
                    String nameProc = ((ProcessPara)p).getDeclName().getWord();
                    if (nameProc.startsWith("$$implicitProcess_")) {
                        implicitProcesses.add((ProcessPara)p);
                        continue;
                    }
                    paras.add(p);
                    continue;
                }
                paras.add(p);
            }
            this.setOnTheFlyProcesses(implicitProcesses);
        } else {
            paras = allParas;
        }
        for (Para para : paras) {
            Signature signature = (Signature)para.accept((Visitor)this.paraChecker());
            ListTerm pairs = signature.getNameTypePair();
            for (NameTypePair pair : pairs) {
                if (this.sectTypeEnv().add(pair.getName(), pair.getType())) continue;
                Object[] params = new Object[]{pair.getName()};
                this.error((TermA)pair.getName(), ErrorMessage.REDECLARED_GLOBAL_NAME, params);
            }
            this.postCheck();
        }
        this.postProcessCallCheck();
        if (this.useBeforeDecl() && !this.sectTypeEnv().getSecondTime()) {
            this.errors().clear();
            this.removeErrorAndTypeAnns((Term)zSect);
            this.sectTypeEnv().setSecondTime(true);
            zSect.accept((Visitor)this.specChecker());
        }
        GlobalDefs.addAnn((TermA)zSect, this.sectTypeEnv().getSectTypeEnvAnn());
        Boolean result = this.getResult();
        if (result == Boolean.FALSE) {
            this.removeTypeAnns((Term)zSect);
        }
        return result;
    }

    protected Boolean getResult() {
        Boolean result = Boolean.TRUE;
        if (this.errors().size() > 0) {
            result = Boolean.FALSE;
        }
        return result;
    }

    protected void postCheck() {
        ArrayList<ErrorAnn> paraErrors = new ArrayList<ErrorAnn>();
        ArrayList<Object> pErrors = new ArrayList<Object>();
        for (Object next : this.paraErrors()) {
            if (next instanceof Expr) {
                Expr expr = (Expr)next;
                ErrorAnn errorAnn = (ErrorAnn)expr.accept((Visitor)this.postChecker());
                if (errorAnn == null) continue;
                paraErrors.add(errorAnn);
                continue;
            }
            if (next instanceof ErrorAnn) {
                ErrorAnn errorAnn = (ErrorAnn)next;
                paraErrors.add(errorAnn);
                continue;
            }
            pErrors.add(next);
        }
        this.paraErrors().clear();
        this.paraErrors().addAll(pErrors);
        this.errors().addAll(paraErrors);
    }

    protected void postProcessCallCheck() {
        ArrayList<ErrorAnn> paraErrors = new ArrayList<ErrorAnn>();
        ArrayList<Object> errors = new ArrayList<Object>();
        errors.addAll(this.paraErrors());
        for (Object e : errors) {
            CircusProcess proc;
            ErrorAnn errorAnn;
            if (!(e instanceof CircusProcess) || (errorAnn = (ErrorAnn)(proc = (CircusProcess)e).accept((Visitor)this.postChecker())) == null) continue;
            paraErrors.add(errorAnn);
        }
        this.paraErrors().clear();
        this.errors().addAll(paraErrors);
    }
}

