/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.circus;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.ChannelDecl;
import net.sourceforge.czt.circus.ast.ChannelPara;
import net.sourceforge.czt.circus.ast.ChannelSetPara;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.NameSetPara;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circus.visitor.ActionParaVisitor;
import net.sourceforge.czt.circus.visitor.ChannelParaVisitor;
import net.sourceforge.czt.circus.visitor.ChannelSetParaVisitor;
import net.sourceforge.czt.circus.visitor.NameSetParaVisitor;
import net.sourceforge.czt.circus.visitor.ProcessParaVisitor;
import net.sourceforge.czt.circustools.ast.ActionSignature;
import net.sourceforge.czt.circustools.ast.ActionType;
import net.sourceforge.czt.circustools.ast.ProcessSignature;
import net.sourceforge.czt.circustools.ast.ProcessType;
import net.sourceforge.czt.typecheck.circus.Checker;
import net.sourceforge.czt.typecheck.circus.ErrorMessage;
import net.sourceforge.czt.typecheck.circus.TypeChecker;
import net.sourceforge.czt.typecheck.z.impl.UnknownType;
import net.sourceforge.czt.typecheck.z.util.GlobalDefs;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.Type2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParaChecker
extends Checker
implements ChannelParaVisitor,
ChannelSetParaVisitor,
ProcessParaVisitor,
ActionParaVisitor,
NameSetParaVisitor {
    protected net.sourceforge.czt.typecheck.z.ParaChecker zParaChecker_;

    public ParaChecker(TypeChecker typeChecker) {
        super(typeChecker);
        this.zParaChecker_ = new net.sourceforge.czt.typecheck.z.ParaChecker(typeChecker);
    }

    @Override
    public Object visitTerm(Term term) {
        return term.accept((Visitor)this.zParaChecker_);
    }

    public Object visitChannelPara(ChannelPara term) {
        ArrayList allPairs = new ArrayList();
        ListTerm chanDecls = term.getChannelDecl();
        for (ChannelDecl chanDecl : chanDecls) {
            List pairs = (List)chanDecl.accept((Visitor)this.declChecker());
            allPairs.addAll(pairs);
        }
        Signature signature = this.factory().createSignature(allPairs);
        this.addSignatureAnn((TermA)term, signature);
        return signature;
    }

    public Object visitChannelSetPara(ChannelSetPara term) {
        ArrayList<NameTypePair> pairs = new ArrayList<NameTypePair>();
        DeclName name = term.getDeclName();
        Type2 type = (Type2)term.getChannelSet().accept((Visitor)this.exprChecker());
        if (!this.addChannelSet(name)) {
            Object[] params = new Object[]{name.getWord()};
            this.error((TermA)term, ErrorMessage.REDECLARED_CHANSET_NAME, params);
        }
        NameTypePair pair = this.factory().createNameTypePair(name, (Type)type);
        pairs.add(pair);
        Signature signature = this.factory().createSignature(pairs);
        this.addSignatureAnn((TermA)term, signature);
        return signature;
    }

    public Object visitProcessPara(ProcessPara term) {
        Object[] params;
        ArrayList<NameTypePair> allPairs = new ArrayList<NameTypePair>();
        DeclName nameProc = term.getDeclName();
        ListTerm genParams = term.getGenFormals();
        CircusProcess circProc = term.getCircusProcess();
        Type type = this.sectTypeEnv().getType(this.factory().createRefName(nameProc));
        if (type != null && !(type instanceof UnknownType)) {
            params = new Object[]{nameProc.getWord()};
            this.error((TermA)term, ErrorMessage.REDECLARED_PROCESS_NAME, params);
        }
        this.setCurrentProcess(nameProc);
        this.setCurrentGenParams((List)genParams);
        if (!genParams.isEmpty()) {
            if (!this.addGenProcess(nameProc, (List<DeclName>)genParams)) {
                params = new Object[]{nameProc.getWord()};
                this.error((TermA)term, ErrorMessage.REDECLARED_PROCESS_NAME, params);
            }
        } else if (!this.addProcess(nameProc)) {
            params = new Object[]{nameProc.getWord()};
            this.error((TermA)term, ErrorMessage.REDECLARED_PROCESS_NAME, params);
        }
        this.localCircTypeEnv().enterScope();
        this.typeEnv().enterScope();
        this.addGenParamTypes((List<DeclName>)genParams);
        ProcessSignature sigProc = (ProcessSignature)circProc.accept((Visitor)this.processChecker());
        ProcessSignature signature = this.cloneProcessSignature(sigProc);
        signature.setProcessName(nameProc);
        List<NameTypePair> usedChans = this.localCircTypeEnv().getUsedChans();
        this.addImplicitChans(usedChans);
        this.getProcessInfo(nameProc).setUsedChans(usedChans);
        this.typeEnv().exitScope();
        this.localCircTypeEnv().exitScope();
        ProcessType procType = this.factory().createProcessType();
        procType.setProcessSignature(signature);
        NameTypePair pair = this.factory().createNameTypePair(nameProc, (Type)procType);
        allPairs.add(pair);
        Signature sig = this.factory().createSignature(allPairs);
        this.addSignatureAnn((TermA)term, sig);
        return sig;
    }

    public Object visitActionPara(ActionPara term) {
        Object[] params;
        ArrayList<NameTypePair> allPairs = new ArrayList<NameTypePair>();
        DeclName actionName = term.getDeclName();
        CircusAction action = term.getCircusAction();
        if (!this.isNewDef(actionName)) {
            params = new Object[]{this.currentProcess().getWord(), actionName.getWord()};
            this.error((TermA)term, ErrorMessage.REDECLARED_DEF, params);
        }
        this.setCurrentAction(actionName);
        if (!this.localCircTypeEnv().addAction(actionName)) {
            params = new Object[]{actionName.getWord(), this.currentProcess().getWord()};
            this.error((TermA)term, ErrorMessage.REDECLARED_ACTION_NAME, params);
        }
        this.typeEnv().enterScope();
        ActionSignature actionSig = (ActionSignature)action.accept((Visitor)this.actionChecker());
        ActionSignature signature = this.cloneActionSignature(actionSig);
        signature.setActionName(actionName);
        this.typeEnv().exitScope();
        ActionType actionType = this.factory().createActionType();
        actionType.setActionSignature(signature);
        NameTypePair pair = this.factory().createNameTypePair(actionName, (Type)actionType);
        allPairs.add(pair);
        this.typeEnv().add(allPairs);
        this.localCircTypeEnv().setActionType(actionName, actionType);
        Signature sig = this.factory().createSignature(allPairs);
        this.addSignatureAnn((TermA)term, sig);
        this.setCurrentAction(null);
        return sig;
    }

    public Object visitNameSetPara(NameSetPara term) {
        ArrayList<NameTypePair> pairs = new ArrayList<NameTypePair>();
        DeclName name = term.getDeclName();
        Type2 type = (Type2)term.getNameSet().accept((Visitor)this.exprChecker());
        if (!this.localCircTypeEnv().addNameSet(name)) {
            Object[] params = new Object[]{name.getWord()};
            this.error((TermA)term, ErrorMessage.REDECLARED_NAMESET_NAME, params);
        }
        NameTypePair pair = this.factory().createNameTypePair(name, (Type)type);
        pairs.add(pair);
        if (!this.isNewDef(name)) {
            Object[] params = new Object[]{this.currentProcess().getWord(), name.getWord()};
            this.error((TermA)term, ErrorMessage.REDECLARED_DEF, params);
        }
        this.typeEnv().add(pair);
        Signature signature = this.factory().createSignature(pairs);
        this.addSignatureAnn((TermA)term, signature);
        return signature;
    }

    private void addImplicitChans(List<NameTypePair> chans) {
        for (NameTypePair chan : chans) {
            DeclName chanName = chan.getName();
            Type chanType = chan.getType();
            Type type = this.sectTypeEnv().getType(this.factory().createRefName(chanName));
            if (!this.sectTypeEnv().add(chanName, chanType)) {
                Object[] params;
                if (this.unify(GlobalDefs.unwrapType(type), GlobalDefs.unwrapType(chanType)) != GlobalDefs.SUCC) {
                    if (this.isGenericChannel(chanName)) continue;
                    params = new Object[]{this.currentProcess().getWord(), chanName.getWord()};
                    this.error((TermA)chanName, ErrorMessage.REDECLARED_GLOBAL_NAME_WITH_DIFF_TYPE, params);
                    break;
                }
                if (this.isChannel(chanName)) continue;
                params = new Object[]{chanName.getWord()};
                this.error((TermA)chanName, ErrorMessage.REDECLARED_GLOBAL_NAME, params);
                break;
            }
            List<DeclName> genericImplicitChans = this.localCircTypeEnv().getGenericImplicitChans();
            if (genericImplicitChans.contains(chanName)) {
                this.addGenChannel(chanName, chanType, null);
                continue;
            }
            this.addChannel(chanName, chanType);
        }
    }
}

