/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.circus;

import java.util.ArrayList;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.circus.ast.ApplChannelSet;
import net.sourceforge.czt.circus.ast.ApplNameSet;
import net.sourceforge.czt.circus.ast.BasicChannelSet;
import net.sourceforge.czt.circus.ast.BasicNameSet;
import net.sourceforge.czt.circus.ast.RefChannelSet;
import net.sourceforge.czt.circus.ast.RefNameSet;
import net.sourceforge.czt.circus.visitor.ApplChannelSetVisitor;
import net.sourceforge.czt.circus.visitor.ApplNameSetVisitor;
import net.sourceforge.czt.circus.visitor.BasicChannelSetVisitor;
import net.sourceforge.czt.circus.visitor.BasicNameSetVisitor;
import net.sourceforge.czt.circus.visitor.RefChannelSetVisitor;
import net.sourceforge.czt.circus.visitor.RefNameSetVisitor;
import net.sourceforge.czt.circustools.ast.ChanSetType;
import net.sourceforge.czt.circustools.ast.NameSetType;
import net.sourceforge.czt.typecheck.circus.Checker;
import net.sourceforge.czt.typecheck.circus.ErrorMessage;
import net.sourceforge.czt.typecheck.circus.TypeChecker;
import net.sourceforge.czt.typecheck.z.util.GlobalDefs;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.Type;

public class ExprChecker
extends Checker
implements ApplChannelSetVisitor,
RefChannelSetVisitor,
BasicChannelSetVisitor,
ApplNameSetVisitor,
RefNameSetVisitor,
BasicNameSetVisitor {
    protected net.sourceforge.czt.typecheck.z.ExprChecker zExprChecker_;

    public ExprChecker(TypeChecker typeChecker) {
        super(typeChecker);
        this.zExprChecker_ = new net.sourceforge.czt.typecheck.z.ExprChecker(typeChecker);
    }

    public Object visitTerm(Term term) {
        return term.accept((Visitor)this.zExprChecker_);
    }

    public Object visitApplChannelSet(ApplChannelSet term) {
        ArrayList<NameTypePair> allPairs = new ArrayList<NameTypePair>();
        TupleExpr tupleExpr = (TupleExpr)((ApplExpr)term.getExpr()).getRightExpr();
        ListTerm exprs = tupleExpr.getExpr();
        RefChannelSet exprChanSet = null;
        for (Expr expr : exprs) {
            if (expr instanceof RefExpr) {
                exprChanSet = this.factory().createRefChannelSet(((RefExpr)expr).getRefName());
            } else if (expr instanceof SetExpr) {
                ListTerm refExprs = ((SetExpr)expr).getExpr();
                ListTerm newExprs = GlobalDefs.listTerm();
                for (RefExpr rexpr : refExprs) {
                    if (!(rexpr instanceof RefExpr)) {
                        throw new UnsupportedOperationException("Circus typechecker only supports simple set operators for application expressions of channel sets.");
                    }
                    RefExpr refExpr = rexpr;
                    newExprs.add((Object)refExpr.getRefName());
                }
                exprChanSet = this.factory().createBasicChannelSet(newExprs);
            } else {
                exprChanSet = this.factory().createApplChannelSet(expr);
            }
            Signature sig = ((ChanSetType)exprChanSet.accept((Visitor)this.exprChecker())).getChannels();
            ListTerm pairs = sig.getNameTypePair();
            for (NameTypePair pair : pairs) {
                if (allPairs.contains(pair)) continue;
                allPairs.add(pair);
            }
        }
        Signature channelsSig = this.factory().createSignature(allPairs);
        ChanSetType type = this.factory().createChanSetType(channelsSig);
        this.addTypeAnn((TermA)term, (Type)type);
        return type;
    }

    public Object visitRefChannelSet(RefChannelSet term) {
        RefName chansetRef = term.getRefName();
        Signature channelsSig = this.factory().createSignature(new ArrayList());
        ChanSetType type = this.factory().createChanSetType(channelsSig);
        DeclName chansetDecl = this.factory().createDeclName(chansetRef.getWord(), null, null);
        if (!this.isChannelSet(chansetDecl)) {
            Object[] params = new Object[]{chansetRef.getWord()};
            this.error((TermA)term, ErrorMessage.IS_NOT_CHANSET_NAME, params);
        } else {
            type = (ChanSetType)this.sectTypeEnv().getType(chansetRef);
        }
        this.addTypeAnn((TermA)term, (Type)type);
        return type;
    }

    public Object visitBasicChannelSet(BasicChannelSet term) {
        ListTerm chanDecls = term.getRefName();
        ArrayList<NameTypePair> pairs = new ArrayList<NameTypePair>();
        for (RefName chanDecl : chanDecls) {
            DeclName decl = this.factory().createDeclName(chanDecl);
            if (!this.isChannel(decl)) {
                Object[] params = new Object[]{chanDecl.getDecl().getWord()};
                this.error((TermA)term, ErrorMessage.IS_NOT_CHANNEL_IN_CHANSET, params);
                continue;
            }
            Type typeChan = this.getChannelType(decl);
            NameTypePair pair = this.factory().createNameTypePair(decl, typeChan);
            pairs.add(pair);
        }
        Signature channelsSig = this.factory().createSignature(pairs);
        ChanSetType type = this.factory().createChanSetType(channelsSig);
        this.addTypeAnn((TermA)term, (Type)type);
        return type;
    }

    public Object visitApplNameSet(ApplNameSet term) {
        ArrayList<NameTypePair> allPairs = new ArrayList<NameTypePair>();
        TupleExpr tupleExpr = (TupleExpr)((ApplExpr)term.getExpr()).getRightExpr();
        ListTerm exprs = tupleExpr.getExpr();
        RefNameSet exprNameSet = null;
        for (Expr expr : exprs) {
            if (expr instanceof RefExpr) {
                exprNameSet = this.factory().createRefNameSet(((RefExpr)expr).getRefName());
            } else if (expr instanceof SetExpr) {
                ListTerm refExprs = ((SetExpr)expr).getExpr();
                ListTerm newNames = GlobalDefs.listTerm();
                for (RefExpr rexpr : refExprs) {
                    if (!(rexpr instanceof RefExpr)) {
                        throw new UnsupportedOperationException("Circus typechecker only supports simple set operators for application expressions of name sets.");
                    }
                    RefExpr refExpr = rexpr;
                    newNames.add((Object)refExpr.getRefName());
                }
                exprNameSet = this.factory().createBasicNameSet(newNames);
            } else {
                exprNameSet = this.factory().createApplNameSet(expr);
            }
            Signature sig = ((NameSetType)exprNameSet.accept((Visitor)this.exprChecker())).getNames();
            ListTerm pairs = sig.getNameTypePair();
            for (NameTypePair pair : pairs) {
                if (allPairs.contains(pair)) continue;
                allPairs.add(pair);
            }
        }
        Signature namesSig = this.factory().createSignature(allPairs);
        NameSetType type = this.factory().createNameSetType(namesSig);
        this.addTypeAnn((TermA)term, (Type)type);
        return type;
    }

    public Object visitRefNameSet(RefNameSet term) {
        RefName namesetRef = term.getRefName();
        NameSetType type = this.factory().createNameSetType();
        DeclName name = this.factory().createDeclName(namesetRef);
        if (!this.localCircTypeEnv().isNameSet(name)) {
            Object[] params = new Object[]{name.getWord()};
            this.error((TermA)term, ErrorMessage.IS_NOT_NAMESET_NAME, params);
        } else {
            type = GlobalDefs.unwrapType(this.typeEnv().getType(namesetRef));
        }
        this.addTypeAnn((TermA)term, (Type)type);
        return type;
    }

    public Object visitBasicNameSet(BasicNameSet term) {
        ListTerm nameDecls = term.getRefName();
        NameSetType result = this.factory().createNameSetType();
        ArrayList<NameTypePair> pairs = new ArrayList<NameTypePair>();
        for (RefName nameDecl : nameDecls) {
            DeclName name = nameDecl.getDecl();
            if (this.isLovalVar(nameDecl)) {
                Type type = this.typeEnv().getType(nameDecl);
                NameTypePair pair = this.factory().createNameTypePair(name, type);
                pairs.add(pair);
                continue;
            }
            Object[] params = new Object[]{this.currentProcess().getWord(), name.getWord()};
            this.error((TermA)term, ErrorMessage.IS_NOT_LOCAL_VAR_NAME_IN_NAMESET, params);
            break;
        }
        Signature namesSig = this.factory().createSignature(pairs);
        NameSetType type = this.factory().createNameSetType(namesSig);
        this.addTypeAnn((TermA)term, (Type)type);
        return type;
    }
}

